/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.geo;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.sf.jcommon.geo.Country;
import net.sf.jcommon.geo.Iban;

public class IbanValidator
implements ConstraintValidator<Iban, String> {
    private static final long MODULUS = 97L;
    private boolean ignoreWhitespace = true;
    private static Map<String, Pattern> iso2IbanPattern = new HashMap<String, Pattern>();

    public void initialize(Iban constraintAnnotation) {
        this.ignoreWhitespace = constraintAnnotation.ignoreWhitespace();
    }

    public boolean isValid(String iban, ConstraintValidatorContext context) {
        if (iban == null || iban.length() < 11) {
            this.setMessage(context, "length");
            return false;
        }
        String reformattedCode = String.valueOf(iban.substring(4)) + iban.substring(0, 4);
        long total = 0L;
        long p10 = 1L;
        int i = reformattedCode.length() - 1;
        while (i >= 0) {
            char ch = reformattedCode.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!this.ignoreWhitespace) {
                    this.setMessage(context, "pattern");
                    return false;
                }
            } else {
                int charValue;
                int n = charValue = ch >= '0' && ch <= '9' ? ch - 48 : ch - 65 + 10;
                if (charValue < 0 || charValue > 35) {
                    this.setMessage(context, "pattern");
                    return false;
                }
                total = ((long)charValue * p10 % 97L + total) % 97L;
                p10 = p10 * ((long)(charValue > 9 ? 100 : 10) % 97L) % 97L;
            }
            --i;
        }
        if (total % 97L != 1L) {
            this.setMessage(context, "code");
            return false;
        }
        Pattern ibanPattern = this.getIbanPattern(iban);
        if (ibanPattern == null) {
            this.setMessage(context, "country");
            return false;
        }
        if (!ibanPattern.matcher(iban).matches()) {
            this.setMessage(context, "pattern");
            return false;
        }
        return true;
    }

    private Pattern getIbanPattern(String iban) {
        String iso2 = iban.substring(0, 2);
        Pattern ibanPattern = iso2IbanPattern.get(iso2);
        if (ibanPattern == null) {
            Country c = Country.findByIso(iso2);
            if (c == null) {
                return null;
            }
            ibanPattern = IbanValidator.compile(c);
            iso2IbanPattern.put(iso2, ibanPattern);
        }
        return null;
    }

    public static Pattern compile(Country c) {
        return IbanValidator.compile(c.getIBAN(), c.getBBAN(), c.getIBANCheckDigits());
    }

    public static Pattern compile(String iban, String bban, int ibanCheckDigits) {
        if (iban == null || iban.length() < 2 || bban == null) {
            return null;
        }
        return Pattern.compile(String.valueOf(iban.substring(0, 2)) + (ibanCheckDigits <= 0 ? "..\\s?" : String.valueOf(ibanCheckDigits < 10 ? "0" : "") + ibanCheckDigits) + IbanValidator.toRegex(bban));
    }

    private static String toRegex(String bban) {
        if (bban == null) {
            return null;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = bban.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            String g = Country.BbanLetterCodes.valueOf(group.substring(group.length() - 1)).getRegex();
            int x = Integer.parseInt(group.substring(0, group.length() - 1));
            while (x > 0) {
                sb.append(g);
                if (++i % 4 == 0) {
                    sb.append("\\s?");
                }
                --x;
            }
            ++n2;
        }
        if (i % 4 == 0) {
            sb.delete(sb.length() - 3, sb.length());
        }
        return sb.toString();
    }

    private void setMessage(ConstraintValidatorContext context, String message) {
        if (context == null) {
            return;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate("iban.invalid." + message);
    }
}

