/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.geo;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.sf.jcommon.geo.Cnp;

public class CnpValidator
implements ConstraintValidator<Cnp, String> {
    public static final int LENGTH = 13;
    private static final DateFormat CNP_DATE_FORMAT = new SimpleDateFormat("yyMMdd");
    private static int[] CONTROL_VALUES = new int[]{2, 7, 9, 1, 4, 6, 3, 5, 8, 2, 7, 9};
    private static int[] YEAR_OFFSET;
    private static Random RANDOM;

    static {
        int[] nArray = new int[7];
        nArray[1] = 1900;
        nArray[2] = 1900;
        nArray[3] = 1800;
        nArray[4] = 1800;
        nArray[5] = 2000;
        nArray[6] = 2000;
        YEAR_OFFSET = nArray;
        RANDOM = new Random();
    }

    private static int[] getDigits(String cnp) {
        int[] digits = new int[13];
        int i = 0;
        while (i < 13) {
            char c = cnp.charAt(i);
            if (!Character.isDigit(c)) {
                return null;
            }
            digits[i] = (byte)Character.digit(c, 10);
            ++i;
        }
        return digits;
    }

    private static int getControlSum(int[] twelveDigits) {
        int k = 0;
        int i = 0;
        while (i < 12) {
            k += CONTROL_VALUES[i] * twelveDigits[i];
            ++i;
        }
        if ((k %= 11) == 10) {
            k = 1;
        }
        return k;
    }

    public static boolean validateBirthdate(String cnp, Date birthdate) {
        return cnp.length() > 6 && cnp.substring(1, 7).equals(CNP_DATE_FORMAT.format(birthdate));
    }

    public static boolean validateGender(String cnp, boolean male, Date birthdate) {
        int g2;
        if (cnp == null || cnp.length() < 1 || !Character.isDigit(cnp.charAt(0))) {
            return false;
        }
        int g1 = Character.digit(cnp.charAt(0), 10);
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(birthdate);
        int n = c.get(1) < 2000 ? (male ? 1 : 2) : (g2 = male ? 5 : 6);
        return g1 == g2;
    }

    public static String create(boolean male, Date birthdate, int regionId, int birthRegisterNo) {
        StringBuffer result = new StringBuffer("0000000000000");
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(birthdate);
        if (c.get(1) < 1900) {
            result.setCharAt(0, male ? (char)'3' : '4');
        } else if (c.get(1) < 2000) {
            result.setCharAt(0, male ? (char)'1' : '2');
        } else {
            result.setCharAt(0, male ? (char)'5' : '6');
        }
        result.replace(1, 7, CNP_DATE_FORMAT.format(birthdate));
        result.replace(7, 9, new Integer(Math.abs(regionId) % 100).toString());
        result.replace(9, 12, new Integer(Math.abs(birthRegisterNo) % 1000).toString());
        int k = CnpValidator.getControlSum(CnpValidator.getDigits(result.toString()));
        result.replace(12, 13, new Integer(k).toString());
        return result.toString();
    }

    public static String createRandom(boolean male, Date birthdate) {
        return CnpValidator.createRandom(male, birthdate, RANDOM);
    }

    public static String createRandom(boolean male, Date birthdate, Random random) {
        int departmentId = CnpValidator.randomDigit(true, random) * 10 + CnpValidator.randomDigit(false, random);
        int orderId = CnpValidator.randomDigit(true, random) * 100 + CnpValidator.randomDigit(false, random) * 10 + CnpValidator.randomDigit(false, random);
        return CnpValidator.create(male, birthdate, departmentId, orderId);
    }

    private static int randomDigit(boolean nonZero, Random random) {
        return nonZero ? random.nextInt(9) + 1 : random.nextInt(10);
    }

    public void initialize(Cnp constraintAnnotation) {
    }

    public boolean isValid(String cnp, ConstraintValidatorContext context) {
        if (cnp == null) {
            this.setMessage(context, "pattern");
            return false;
        }
        if (cnp.length() != 13) {
            this.setMessage(context, "length");
            return false;
        }
        int[] cnpDigits = CnpValidator.getDigits(cnp);
        if (cnpDigits == null) {
            this.setMessage(context, "pattern");
            return false;
        }
        if (cnpDigits[12] != CnpValidator.getControlSum(cnpDigits)) {
            this.setMessage(context, "controlSum");
            return false;
        }
        int month = cnpDigits[3] * 10 + cnpDigits[4];
        if (month < 1 && month > 12) {
            this.setMessage(context, "month");
            return false;
        }
        int dayOfMonth = cnpDigits[5] * 10 + cnpDigits[6];
        if (dayOfMonth < 1) {
            this.setMessage(context, "dayOfMonth");
            return false;
        }
        int year = YEAR_OFFSET[cnpDigits[0]] + cnpDigits[1] * 10 + cnpDigits[2];
        int maxDayOfMonth = new GregorianCalendar(year, month, dayOfMonth).getActualMaximum(5);
        if (dayOfMonth > maxDayOfMonth) {
            this.setMessage(context, "dayOfMonth");
            return false;
        }
        return true;
    }

    private void setMessage(ConstraintValidatorContext context, String message) {
        if (context == null) {
            return;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate("cnp.invalid." + message);
    }
}

