/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.collect;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.sf.jcommon.collect.CollectionEvent;
import net.sf.jcommon.collect.ListEvent;
import net.sf.jcommon.collect.ObservableCollection;

public class ObservableList<E>
extends ObservableCollection<E>
implements List<E> {
    private List<E> decorated;

    public ObservableList(List<E> decorated) {
        super(decorated);
        this.decorated = decorated;
    }

    @Override
    public void add(int location, E elem) {
        ListEvent<E> evt = new ListEvent<E>(this, elem, location, CollectionEvent.Operation.ADD);
        this.firePreEvent(evt);
        this.decorated.add(elem);
        this.firePostEvent(evt);
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> c) {
        CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)this, (CollectionEvent.Operation)((Object)c), CollectionEvent.Operation.ADD);
        this.firePreEvent(evt);
        boolean retval = this.decorated.addAll(location, c);
        if (retval) {
            this.firePostEvent(evt);
        }
        return retval;
    }

    @Override
    public E get(int location) {
        return this.decorated.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.decorated.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.decorated.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ObservableListIterator(this.decorated.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new ObservableListIterator(this.decorated.listIterator(location));
    }

    @Override
    public E remove(int location) {
        E elem = this.get(location);
        ListEvent<E> evt = new ListEvent<E>(this, elem, location, CollectionEvent.Operation.REMOVE);
        this.firePreEvent(evt);
        E retval = this.decorated.remove(location);
        this.firePostEvent(evt);
        return retval;
    }

    @Override
    public E set(int location, E elem) {
        ListEvent<E> evt = new ListEvent<E>(this, this.decorated.get(location), elem, location);
        this.firePreEvent(evt);
        E retval = this.decorated.set(location, elem);
        this.firePostEvent(evt);
        return retval;
    }

    @Override
    public List<E> subList(int start, int end) {
        return this.decorated.subList(start, end);
    }

    protected class ObservableListIterator
    extends ObservableCollection.ObservableIterator
    implements ListIterator<E> {
        private ListIterator<E> decorated;
        private E current;
        private int currentIndex;

        public ObservableListIterator(ListIterator<E> decorated) {
            super(decorated);
            this.currentIndex = -1;
            this.decorated = decorated;
        }

        @Override
        public void add(E elem) {
            ListEvent evt = new ListEvent(ObservableList.this, this.current, this.currentIndex, CollectionEvent.Operation.ADD);
            ObservableList.this.firePreEvent(evt);
            this.decorated.add(elem);
            ObservableList.this.firePostEvent(evt);
        }

        @Override
        public boolean hasPrevious() {
            return this.decorated.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.decorated.nextIndex();
        }

        @Override
        public E next() {
            ++this.currentIndex;
            return super.next();
        }

        @Override
        public E previous() {
            --this.currentIndex;
            this.current = this.decorated.previous();
            return this.current;
        }

        @Override
        public int previousIndex() {
            return this.decorated.previousIndex();
        }

        @Override
        public void set(E elem) {
            ListEvent evt = new ListEvent(ObservableList.this, this.current, this.currentIndex, CollectionEvent.Operation.UPDATE);
            ObservableList.this.firePreEvent(evt);
            this.decorated.add(elem);
            ObservableList.this.firePostEvent(evt);
        }
    }
}

