/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.collect;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.jcommon.collect.CollectionEvent;
import net.sf.jcommon.collect.CollectionListener;

public class ObservableCollection<E>
extends ForwardingCollection<E> {
    private Collection<E> decorated;
    private Collection<CollectionListener<E>> listeners = new ArrayList<CollectionListener<E>>();

    public ObservableCollection(Collection<E> decorated) {
        this.decorated = decorated;
    }

    protected Collection<E> delegate() {
        return this.decorated;
    }

    protected void firePreEvent(CollectionEvent<E> evt) {
        for (CollectionListener<E> listener : this.listeners) {
            listener.pre(evt);
        }
    }

    protected void firePostEvent(CollectionEvent<E> evt) {
        for (CollectionListener<E> listener : this.listeners) {
            listener.post(evt);
        }
    }

    public void addCollectionListener(CollectionListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeCollectionListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    public boolean add(E e) {
        CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)((Object)this), (CollectionEvent.Operation)((Object)e), CollectionEvent.Operation.ADD);
        this.firePreEvent(evt);
        if (this.delegate().add(e)) {
            this.firePostEvent(evt);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<? extends E> c) {
        CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)((Object)this), (CollectionEvent.Operation)((Object)c), CollectionEvent.Operation.ADD);
        this.firePreEvent(evt);
        if (this.delegate().addAll(c)) {
            this.firePostEvent(evt);
            return true;
        }
        return false;
    }

    public void clear() {
        CollectionEvent evt = new CollectionEvent(this, CollectionEvent.Operation.CLEAR);
        this.firePreEvent(evt);
        this.delegate().clear();
        this.firePostEvent(evt);
    }

    public Iterator<E> iterator() {
        return new ObservableIterator(this.delegate().iterator());
    }

    public boolean remove(Object e) {
        CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)((Object)this), (CollectionEvent.Operation)((Object)e), CollectionEvent.Operation.REMOVE);
        this.firePreEvent(evt);
        boolean retval = this.delegate().remove(e);
        if (retval) {
            this.firePostEvent(evt);
        }
        return retval;
    }

    public boolean removeAll(Collection<?> c) {
        CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)((Object)this), (CollectionEvent.Operation)((Object)c), CollectionEvent.Operation.REMOVE);
        this.firePreEvent(evt);
        boolean retval = this.delegate().removeAll(c);
        if (retval) {
            this.firePostEvent(evt);
        }
        return retval;
    }

    public boolean retainAll(Collection<?> c) {
        HashSet<E> toRemove = new HashSet<E>();
        for (E e : this.delegate()) {
            if (c.contains(e)) continue;
            toRemove.add(e);
        }
        CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)((Object)this), (CollectionEvent.Operation)((Object)toRemove), CollectionEvent.Operation.REMOVE);
        this.firePreEvent(evt);
        boolean retval = this.delegate().retainAll(c);
        if (retval) {
            this.firePostEvent(evt);
        }
        return retval;
    }

    protected class ObservableIterator
    extends ForwardingIterator<E> {
        private Iterator<E> decorated;
        protected E current;

        public ObservableIterator(Iterator<E> decorated) {
            this.decorated = decorated;
        }

        protected Iterator<E> delegate() {
            return this.decorated;
        }

        public E next() {
            this.current = this.delegate().next();
            return this.current;
        }

        public void remove() {
            CollectionEvent<CollectionEvent.Operation> evt = new CollectionEvent<CollectionEvent.Operation>((Collection<CollectionEvent.Operation>)((Object)ObservableCollection.this), (CollectionEvent.Operation)((Object)this.current), CollectionEvent.Operation.REMOVE);
            ObservableCollection.this.firePreEvent(evt);
            this.delegate().remove();
            ObservableCollection.this.firePostEvent(evt);
        }
    }
}

