/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.collect;

import java.util.Collection;
import java.util.TreeSet;
import net.sf.jcommon.collect.CollectionEvent;
import net.sf.jcommon.collect.ObservableList;

public class ListEvent<E>
extends CollectionEvent<E> {
    private int index;
    private Collection<Integer> indices = new TreeSet<Integer>();

    public ListEvent(Collection<E> source, CollectionEvent.Operation operation) {
        super(source, operation);
        this.index = -1;
    }

    public ListEvent(Collection<E> source, E element, int index, CollectionEvent.Operation operation) {
        super(source, element, operation);
        this.index = index;
        this.indices.add(index);
    }

    public ListEvent(Collection<E> source, Collection<? extends E> elements, Collection<Integer> indices, CollectionEvent.Operation operation) {
        super(source, elements, operation);
        this.indices.addAll(indices);
        if (this.indices.size() > 0) {
            this.index = this.indices.iterator().next();
        }
    }

    public ListEvent(ObservableList<E> source, E oldElement, E newElement, int location) {
        super(source, oldElement, newElement);
        this.index = location;
        this.indices.add(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public Collection<Integer> getIndices() {
        return this.indices;
    }
}

