/*
 * Decompiled with CFR 0.152.
 */
package tcu.client;

import java.util.ArrayList;
import myproc.ReadExcelData;
import myproc.Utils;
import org.apache.log4j.Logger;

public class TCUICD {
    private final Logger logger = Logger.getLogger(TCUICD.class);
    public String excelFileName;
    public int portNumber;
    public String serverName;
    public String opcuaURL;
    private ReadExcelData readExcelData = null;
    public ArrayList<String> get_ACSName_List = new ArrayList();
    public ArrayList<String> get_NodeName_List = new ArrayList();
    public ArrayList<String> get_DataType_List = new ArrayList();
    public ArrayList<Integer> get_IsArray_List = new ArrayList();
    public ArrayList<String> get_CmdOrModeValue_List = new ArrayList();
    public ArrayList<String> get_DefaultValue_List = new ArrayList();
    public ArrayList<String> get_Unit_List = new ArrayList();
    public ArrayList<String> get_Description_List = new ArrayList();
    public ArrayList<String> set_ACSName_List = new ArrayList();
    public ArrayList<String> set_NodeName_List = new ArrayList();
    public ArrayList<String> set_DataType_List = new ArrayList();
    public ArrayList<Integer> set_IsArray_List = new ArrayList();
    public ArrayList<String> set_CmdOrModeValue_List = new ArrayList();
    public ArrayList<String> set_DefaultValue_List = new ArrayList();
    public ArrayList<String> set_Unit_List = new ArrayList();
    public ArrayList<String> set_Description_List = new ArrayList();
    public ArrayList<String> cmd_ACSName_List = new ArrayList();
    public ArrayList<String> cmd_NodeName_List = new ArrayList();
    public ArrayList<String> cmd_DataType_List = new ArrayList();
    public ArrayList<Integer> cmd_IsArray_List = new ArrayList();
    public ArrayList<String> cmd_CmdOrModeValue_List = new ArrayList();
    public ArrayList<String> cmd_DefaultValue_List = new ArrayList();
    public ArrayList<String> cmd_Description_List = new ArrayList();
    public ArrayList<String> mode_ACSName_List = new ArrayList();
    public ArrayList<String> mode_NodeName_List = new ArrayList();
    public ArrayList<String> mode_DataType_List = new ArrayList();
    public ArrayList<Integer> mode_IsArray_List = new ArrayList();
    public ArrayList<String> mode_CmdOrModeValue_List = new ArrayList();
    public ArrayList<String> mode_DefaultValue_List = new ArrayList();
    public ArrayList<String> mode_Description_List = new ArrayList();

    public TCUICD() {
        try {
            this.readExcelData = new ReadExcelData("./conf/" + Utils.tcuICDFileName);
            this.ReadExcelServerTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TCUICD(String excelFileName) {
        this.excelFileName = excelFileName;
        try {
            this.readExcelData = new ReadExcelData(excelFileName);
            this.ReadExcelServerTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        TCUICD pmcICD = new TCUICD();
        pmcICD.showData();
    }

    public void showData() {
        try {
            System.out.println("\n----------------------------------------------------------------------------------------------------------------");
            System.out.printf("%-3s%-3s%-37s%-33s%-13s%-13s%-12s\n", "  #", "", "ACS Name", "Node Name", "DataType", "Description", "Is Array", "Array Length");
            System.out.println("----------------------------------------------------------------------------------------------------------------");
            int ix = 0;
            while (ix < this.get_ACSName_List.size()) {
                System.out.printf("%3d%-3s%-45s%-50s%-12s%-50s%-13s%-50s\n", ix, "", this.get_ACSName_List.get(ix), this.get_NodeName_List.get(ix), this.get_DataType_List.get(ix), this.get_Description_List.get(ix), "  ", this.get_IsArray_List.get(ix), this.get_DefaultValue_List.get(ix));
                ++ix;
            }
            ix = 0;
            while (ix < this.set_ACSName_List.size()) {
                System.out.printf("%3d%-3s%-37s%-36s%-12s%-14s%-13s%-50s\n", ix, "", this.set_ACSName_List.get(ix), this.set_NodeName_List.get(ix), this.set_DataType_List.get(ix), this.set_Description_List.get(ix), "  ", this.set_IsArray_List.get(ix), this.set_DefaultValue_List.get(ix));
                ++ix;
            }
            ix = 0;
            while (ix < this.cmd_ACSName_List.size()) {
                System.out.printf("%3d%-3s%-37s%-36s%-12s%-14s%-13s%-50s\n", ix, "", this.cmd_ACSName_List.get(ix), this.cmd_NodeName_List.get(ix), this.cmd_DataType_List.get(ix), this.cmd_Description_List.get(ix), "  ", this.cmd_IsArray_List.get(ix), this.cmd_CmdOrModeValue_List.get(ix));
                ++ix;
            }
            ix = 0;
            while (ix < this.mode_ACSName_List.size()) {
                System.out.printf("%3d%-3s%-37s%-36s%-12s%-14s%-13s%-50s\n", ix, "", this.mode_ACSName_List.get(ix), this.mode_NodeName_List.get(ix), this.mode_DataType_List.get(ix), this.mode_Description_List.get(ix), "  ", this.mode_IsArray_List.get(ix), this.mode_CmdOrModeValue_List.get(ix));
                ++ix;
            }
        }
        catch (Exception e) {
            System.out.println(">>>>>>>>>>" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void ReadExcelServerTable() throws Exception {
        int sheet = 0;
        int row = 0;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        String[] cellsValue = this.readExcelData.getArrayString(sheet, row, nArray);
        row = !this.readExcelData.isNewICDFormat ? 2 : 1;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        cellsValue = this.readExcelData.getArrayString(sheet, row, nArray2);
        if (cellsValue[3] != null) {
            this.opcuaURL = cellsValue[3];
            String sVal = cellsValue[3].substring(cellsValue[3].lastIndexOf(":") + 1).trim();
            sVal = sVal.substring(0, sVal.indexOf("/")).trim();
            this.portNumber = Integer.parseInt(TCUICD.ceckNumericString(sVal));
            this.serverName = cellsValue[3].substring(cellsValue[3].lastIndexOf("/") + 1).trim();
        }
        int descriptionCol = 21;
        if (!this.readExcelData.isNewICDFormat) {
            descriptionCol = 19;
        }
        sheet = 1;
        int[] nArray3 = new int[7];
        nArray3[1] = 4;
        nArray3[2] = 5;
        nArray3[3] = 6;
        nArray3[4] = 8;
        nArray3[5] = 13;
        nArray3[6] = descriptionCol;
        int[] columIntArray = nArray3;
        int noGetRow = this.readExcelData.getNoOfRow(sheet);
        String dataType = "";
        int iGet = 1;
        while (iGet <= noGetRow) {
            String[] cellValue = this.readExcelData.getArrayString(sheet, iGet, columIntArray);
            if (cellValue[0] != "$$" | cellValue[0] != "") {
                this.get_ACSName_List.add(cellValue[0]);
                this.get_NodeName_List.add(cellValue[1]);
                dataType = cellValue[2];
                if (dataType.contains("[")) {
                    this.get_DataType_List.add(dataType.substring(0, dataType.indexOf("[")));
                    this.get_IsArray_List.add(Integer.parseInt(dataType.substring(dataType.indexOf("[") + 1, dataType.indexOf("]"))));
                } else {
                    this.get_DataType_List.add(dataType);
                    this.get_IsArray_List.add(0);
                }
                this.get_CmdOrModeValue_List.add(cellValue[3]);
                this.get_DefaultValue_List.add(cellValue[4]);
                this.get_Unit_List.add(cellValue[5]);
                this.get_Description_List.add(cellValue[6]);
            }
            ++iGet;
        }
        descriptionCol = 22;
        if (!this.readExcelData.isNewICDFormat) {
            descriptionCol = 20;
        }
        sheet = 2;
        int[] nArray4 = new int[7];
        nArray4[1] = 4;
        nArray4[2] = 5;
        nArray4[3] = 6;
        nArray4[4] = 8;
        nArray4[5] = 13;
        nArray4[6] = descriptionCol;
        columIntArray = nArray4;
        int noSetRow = this.readExcelData.getNoOfRow(sheet);
        int iSet = 1;
        while (iSet <= noSetRow) {
            String[] cellValue = this.readExcelData.getArrayString(sheet, iSet, columIntArray);
            if (cellValue[0] != "$$") {
                this.set_ACSName_List.add(cellValue[0]);
                this.set_NodeName_List.add(cellValue[1]);
                dataType = cellValue[2];
                if (dataType.contains("[")) {
                    this.set_DataType_List.add(dataType.substring(0, dataType.indexOf("[")));
                    this.set_IsArray_List.add(Integer.parseInt(dataType.substring(dataType.indexOf("[") + 1, dataType.indexOf("]"))));
                } else {
                    this.set_DataType_List.add(dataType);
                    this.set_IsArray_List.add(0);
                }
                this.set_CmdOrModeValue_List.add(cellValue[3]);
                this.set_DefaultValue_List.add(cellValue[4]);
                this.set_Unit_List.add(cellValue[5]);
                this.set_Description_List.add(cellValue[6]);
            }
            ++iSet;
        }
        sheet = 3;
        if (this.readExcelData.getSheetName(3).toString().contains("MODE")) {
            sheet = 4;
        }
        int noCmdRow = this.readExcelData.getNoOfRow(sheet);
        int iCmd = 1;
        while (iCmd <= noCmdRow) {
            String[] cellValue = this.readExcelData.getArrayString(sheet, iCmd, columIntArray);
            if (cellValue[0] != "$$") {
                this.cmd_ACSName_List.add(cellValue[0]);
                this.cmd_NodeName_List.add(cellValue[1]);
                dataType = cellValue[2];
                if (dataType.contains("[")) {
                    this.cmd_DataType_List.add(dataType.substring(0, dataType.indexOf("[")));
                    this.cmd_IsArray_List.add(Integer.parseInt(dataType.substring(dataType.indexOf("[") + 1, dataType.indexOf("]"))));
                } else {
                    this.cmd_DataType_List.add(dataType);
                    this.cmd_IsArray_List.add(0);
                }
                this.cmd_CmdOrModeValue_List.add(cellValue[3]);
                this.cmd_DefaultValue_List.add(cellValue[4]);
                this.cmd_Description_List.add(cellValue[6]);
            }
            ++iCmd;
        }
        sheet = 4;
        if (this.readExcelData.getSheetName(4).toString().contains("CMD")) {
            sheet = 3;
        }
        int noModeRow = this.readExcelData.getNoOfRow(sheet);
        int iMode = 1;
        while (iMode <= noModeRow) {
            String[] cellValue = this.readExcelData.getArrayString(sheet, iMode, columIntArray);
            if (cellValue[0] != "$$") {
                this.mode_ACSName_List.add(cellValue[0]);
                this.mode_NodeName_List.add(cellValue[1]);
                dataType = cellValue[2];
                if (dataType.contains("[")) {
                    this.mode_DataType_List.add(dataType.substring(0, dataType.indexOf("[")));
                    this.mode_IsArray_List.add(Integer.parseInt(dataType.substring(dataType.indexOf("[") + 1, dataType.indexOf("]"))));
                } else {
                    this.mode_DataType_List.add(dataType);
                    this.mode_IsArray_List.add(0);
                }
                this.mode_CmdOrModeValue_List.add(cellValue[3]);
                this.mode_DefaultValue_List.add(cellValue[4]);
                this.mode_Description_List.add(cellValue[6]);
            }
            ++iMode;
        }
    }

    public static String ceckNumericString(String str) {
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '-' && c != '+' && c != '.' && c != 'E' && c != 'e' && !Character.isDigit(c)) {
                return "62650";
            }
            ++n2;
        }
        if (str.length() == 0) {
            return "62650";
        }
        return str;
    }
}

