/*
 * Decompiled with CFR 0.152.
 */
package tcu.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import gui.AIV_GUI;
import gui.DataInputForm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import myproc.Utils;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;
import tcu.client.TCUICD;
import tcu.client.TCUOpcuaClient;

public class TCUGui
extends JFrame {
    public String frameTitle = "TCUGUI - PBr-0.5-1022  -  on ASTRI" + Utils.telescopeNumber;
    JLabel ledLabel = new JLabel("\u2022");
    public JLabel ImageMirrorLabel = new JLabel("");
    public static JLabel selectedLabel = new JLabel("---");
    private JScrollPane treeScrollPane = new JScrollPane();
    public static TCUICD tcuICD = new TCUICD();
    public static TCUOpcuaClient tcuOpcuaClient = new TCUOpcuaClient();
    public JTree nodeTree = new JTree();
    public static JTextArea GETInfoTextArea = new JTextArea();
    public int motorIndex = -1;
    public int mirrorIndex = -1;
    public DataInputForm ocDataInputForm = new DataInputForm("OC");
    public static JCheckBox getTelemetryEnableCheckBox = new JCheckBox("EnableGetTelemetry");
    public static boolean showMirrorCircleFlag = false;
    private Thread showMirrorReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    int Yc;
                    int Xc;
                    Graphics2D g2;
                    while (true) {
                        if (!showMirrorCircleFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showMirrorCircleFlag = false;
                        g2 = (Graphics2D)TCUGui.this.ImageMirrorLabel.getGraphics();
                        Xc = Utils.mirror1Center[TCUGui.this.mirrorIndex][0];
                        Yc = Utils.mirror1Center[TCUGui.this.mirrorIndex][1];
                        g2.setStroke(new BasicStroke(2.0f));
                        if (Xc >= 0 & Yc >= 0) break;
                    }
                    g2.setColor(Color.yellow);
                    g2.draw(new Ellipse2D.Double(Xc - 47, Yc - 47, 94.0, 94.0));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    public static boolean showMotorCircleFlag = false;
    private Thread showMotorReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    int Yc;
                    int Xc;
                    Graphics2D g2;
                    while (true) {
                        if (!showMotorCircleFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showMotorCircleFlag = false;
                        GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
                        g2 = (Graphics2D)TCUGui.this.ImageMirrorLabel.getGraphics();
                        Xc = Utils.motor1Center[TCUGui.this.motorIndex][0];
                        Yc = Utils.motor1Center[TCUGui.this.motorIndex][1];
                        g2.setStroke(new BasicStroke(2.0f));
                        if (Xc >= 0 & Yc >= 0) break;
                    }
                    g2.setColor(Color.white);
                    g2.draw(new Ellipse2D.Double(Xc - 14, Yc - 14, 28.0, 28.0));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    private Thread heartBeatThread = new Thread(){

        @Override
        public synchronized void run() {
            int oldValue = TCUGui.tcuOpcuaClient.heartbeat;
            while (true) {
                try {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (oldValue != TCUGui.tcuOpcuaClient.heartbeat) {
                            oldValue = TCUGui.tcuOpcuaClient.heartbeat;
                            if (TCUGui.this.ledLabel.getForeground() == Color.gray) {
                                TCUGui.this.ledLabel.setForeground(Color.green);
                                continue;
                            }
                            TCUGui.this.ledLabel.setForeground(Color.gray);
                            continue;
                        }
                        TCUGui.this.ledLabel.setForeground(Color.red);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.getProperties();
                    AIV_GUI.consolle.setVisible(true);
                    TCUGui window = new TCUGui();
                    window.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public TCUGui() throws Exception {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("M2");
        fileMenu.add(mntmNewMenuItem_1);
        JMenuItem mntmNewMenuItem = new JMenuItem("Exit");
        fileMenu.add(mntmNewMenuItem);
        JMenu opcuaMenu = new JMenu("Opc-UA");
        menuBar.add(opcuaMenu);
        JMenuItem mntmNewMenuItem_2 = new JMenuItem("CheckNodes");
        mntmNewMenuItem_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tcuOpcuaClient.ceckAllNodes();
            }
        });
        opcuaMenu.add(mntmNewMenuItem_2);
        Component horizontalStrut = Box.createHorizontalStrut(624);
        menuBar.add(horizontalStrut);
        this.ledLabel.setAlignmentX(1.0f);
        this.ledLabel.setHorizontalAlignment(0);
        this.ledLabel.setToolTipText("heartBeat");
        this.ledLabel.setSize(new Dimension(15, 6));
        this.ledLabel.setPreferredSize(new Dimension(20, 8));
        this.ledLabel.setHorizontalTextPosition(0);
        this.ledLabel.setForeground(Color.RED);
        this.ledLabel.setFont(new Font("Tahoma", 1, 27));
        menuBar.add(this.ledLabel);
        tcuOpcuaClient.startClient("opc.tcp://10.10.1.56:4840");
        this.initialize();
    }

    private void initialize() throws Exception {
        this.showMotorReferenceThread.start();
        this.showMirrorReferenceThread.start();
        this.heartBeatThread.start();
        this.setBounds(100, 100, 944, 679);
        this.setLayout(null);
        this.setTitle("OpticalCamera MirrorGUI - PBr-0.5-0222");
        this.treeScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, Integer.MAX_VALUE));
        this.treeScrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 10));
        this.treeScrollPane.setBounds(8, 5, 168, 217);
        this.add(this.treeScrollPane);
        this.ImageMirrorLabel.setCursor(Cursor.getPredefinedCursor(1));
        this.ImageMirrorLabel.setBorder(new LineBorder(Color.BLUE, 2));
        this.ImageMirrorLabel.setToolTipText("TCU schema");
        this.ImageMirrorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point x = TCUGui.this.ImageMirrorLabel.getMousePosition();
                try {
                    int ix = 0;
                    while (ix < Utils.mirror1Center.length) {
                        if (x.x > Utils.mirror1Center[ix][0] - 10 & x.x < Utils.mirror1Center[ix][0] + 10 & (x.y > Utils.mirror1Center[ix][1] - 10 & x.y < Utils.mirror1Center[ix][1] + 10)) {
                            TCUGui.this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m1ab.jpg"));
                            selectedLabel.setBackground(Color.blue);
                            selectedLabel.setForeground(Color.yellow);
                            selectedLabel.setText("Mirror_" + (ix + 1));
                            TCUGui.this.mirrorIndex = ix;
                            showMirrorCircleFlag = true;
                            break;
                        }
                        ++ix;
                    }
                    ix = 0;
                    while (ix < Utils.motor1Center.length) {
                        if (x.x > Utils.motor1Center[ix][0] - 10 & x.x < Utils.motor1Center[ix][0] + 10 & (x.y > Utils.motor1Center[ix][1] - 10 & x.y < Utils.motor1Center[ix][1] + 10)) {
                            TCUGui.this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m1ab.jpg"));
                            selectedLabel.setBackground(Color.blue);
                            selectedLabel.setForeground(Color.white);
                            selectedLabel.setText("Motor_" + (ix + 1));
                            TCUGui.this.motorIndex = ix;
                            showMotorCircleFlag = true;
                            break;
                        }
                        ++ix;
                    }
                }
                catch (NullPointerException e1) {
                    System.out.println("errore loop ");
                }
            }
        });
        this.ImageMirrorLabel.setForeground(Color.YELLOW);
        this.ImageMirrorLabel.setBackground(Color.GRAY);
        this.ImageMirrorLabel.setBounds(337, 5, 475, 482);
        this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m1ab.jpg"));
        this.ImageMirrorLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point x = TCUGui.this.ImageMirrorLabel.getMousePosition();
            }
        });
        this.add(this.ImageMirrorLabel);
        this.implementsTelescopeButtons();
        this.treeSetModel();
    }

    private void implementsTelescopeButtons() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.ORANGE);
        panel.setBounds(843, 5, 75, 212);
        this.add(panel);
        final JRadioButton rdbtnTel_0 = new JRadioButton("Tel_1");
        rdbtnTel_0.setSelected(true);
        rdbtnTel_0.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_0.setHorizontalAlignment(2);
        rdbtnTel_0.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_0);
        final JRadioButton rdbtnTel_1 = new JRadioButton("Tel_2 ");
        rdbtnTel_1.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_1.setHorizontalAlignment(2);
        rdbtnTel_1.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_1);
        final JRadioButton rdbtnTel_2 = new JRadioButton("Tel_3");
        rdbtnTel_2.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_2.setHorizontalAlignment(2);
        rdbtnTel_2.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_2);
        final JRadioButton rdbtnTel_3 = new JRadioButton("Tel_4 ");
        rdbtnTel_3.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_3.setHorizontalAlignment(2);
        rdbtnTel_3.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_3);
        final JRadioButton rdbtnTel_4 = new JRadioButton("Tel_5 ");
        rdbtnTel_4.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_4.setHorizontalAlignment(2);
        rdbtnTel_4.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_4);
        final JRadioButton rdbtnTel_5 = new JRadioButton("Tel_6 ");
        rdbtnTel_5.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_5.setHorizontalAlignment(2);
        rdbtnTel_5.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_5);
        final JRadioButton rdbtnTel_6 = new JRadioButton("Tel_7 ");
        rdbtnTel_6.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_6.setHorizontalAlignment(2);
        rdbtnTel_6.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_6);
        final JRadioButton rdbtnTel_7 = new JRadioButton("Tel_8 ");
        rdbtnTel_7.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_7.setHorizontalAlignment(2);
        rdbtnTel_7.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_7);
        final JRadioButton rdbtnTel_8 = new JRadioButton("Tel_9 ");
        rdbtnTel_8.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_8.setHorizontalAlignment(2);
        rdbtnTel_8.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_8);
        ButtonGroup Telescopegroup = new ButtonGroup();
        Telescopegroup.add(rdbtnTel_0);
        Telescopegroup.add(rdbtnTel_1);
        Telescopegroup.add(rdbtnTel_2);
        Telescopegroup.add(rdbtnTel_3);
        Telescopegroup.add(rdbtnTel_4);
        Telescopegroup.add(rdbtnTel_5);
        Telescopegroup.add(rdbtnTel_6);
        Telescopegroup.add(rdbtnTel_7);
        Telescopegroup.add(rdbtnTel_8);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(8, 247, 244, 240);
        scrollPane_1.setToolTipText("GET values");
        scrollPane_1.setVerticalScrollBarPolicy(22);
        scrollPane_1.setHorizontalScrollBarPolicy(32);
        scrollPane_1.getVerticalScrollBar().setPreferredSize(new Dimension(8, Integer.MAX_VALUE));
        scrollPane_1.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 8));
        this.add(scrollPane_1);
        scrollPane_1.getVerticalScrollBar().setPreferredSize(new Dimension(10, Integer.MAX_VALUE));
        scrollPane_1.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 10));
        scrollPane_1.setViewportView(GETInfoTextArea);
        GETInfoTextArea.setToolTipText("values");
        GETInfoTextArea.setText(">");
        GETInfoTextArea.setForeground(new Color(0, 0, 128));
        GETInfoTextArea.setFont(new Font("SansSerif", 0, 10));
        GETInfoTextArea.setEditable(false);
        GETInfoTextArea.setBackground(new Color(230, 230, 250));
        GETInfoTextArea.setAlignmentY(0.0f);
        GETInfoTextArea.setAlignmentX(0.0f);
        selectedLabel.setOpaque(true);
        selectedLabel.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
        selectedLabel.setBounds(new Rectangle(0, 0, 1, 1));
        selectedLabel.setForeground(Color.YELLOW);
        selectedLabel.setHorizontalAlignment(0);
        selectedLabel.setBackground(Color.BLUE);
        selectedLabel.setFont(new Font("SansSerif", 1, 14));
        selectedLabel.setBounds(590, 499, 71, 21);
        this.add(selectedLabel);
        getTelemetryEnableCheckBox.setBounds(8, 226, 158, 18);
        this.add(getTelemetryEnableCheckBox);
        rdbtnTel_0.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_0.isSelected()) {
                    TCUGui.this.setTelescope(1);
                }
            }
        });
        rdbtnTel_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_1.isSelected()) {
                    TCUGui.this.setTelescope(2);
                }
            }
        });
        rdbtnTel_2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_2.isSelected()) {
                    TCUGui.this.setTelescope(3);
                }
            }
        });
        rdbtnTel_3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_3.isSelected()) {
                    TCUGui.this.setTelescope(4);
                }
            }
        });
        rdbtnTel_4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_4.isSelected()) {
                    TCUGui.this.setTelescope(5);
                }
            }
        });
        rdbtnTel_5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_5.isSelected()) {
                    TCUGui.this.setTelescope(6);
                }
            }
        });
        rdbtnTel_6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_6.isSelected()) {
                    TCUGui.this.setTelescope(7);
                }
            }
        });
        rdbtnTel_7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_7.isSelected()) {
                    TCUGui.this.setTelescope(8);
                }
            }
        });
        rdbtnTel_8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_8.isSelected()) {
                    TCUGui.this.setTelescope(9);
                }
            }
        });
    }

    public void setTelescope(int index) {
        System.out.println("Hai selezionato il telescopio " + index);
    }

    private void treeSetModel() {
        this.nodeTree.setForeground(Color.WHITE);
        this.nodeTree.setBackground(Color.LIGHT_GRAY);
        this.treeScrollPane.setViewportView(this.nodeTree);
        this.nodeTree.setFont(new Font("Tahoma", 0, 10));
        this.nodeTree.setToolTipText("This is my NodeTree  ;)");
        this.nodeTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath tp = TCUGui.this.nodeTree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp.getPath().length == 3) {
                    TCUGui.this.jtreeToOpcua(tp.getPath()[1].toString(), tp.getPath()[2].toString());
                }
            }
        });
        this.nodeTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("OPCUA_node_list"){
            {
                DefaultMutableTreeNode node_get = new DefaultMutableTreeNode("GetList");
                int g = 0;
                while (g < TCUGui.tcuICD.get_ACSName_List.size()) {
                    node_get.add(new DefaultMutableTreeNode(TCUGui.tcuICD.get_ACSName_List.get(g)));
                    ++g;
                }
                this.add(node_get);
                DefaultMutableTreeNode node_set = new DefaultMutableTreeNode("SetList");
                int g2 = 0;
                while (g2 < TCUGui.tcuICD.set_ACSName_List.size()) {
                    node_set.add(new DefaultMutableTreeNode(TCUGui.tcuICD.set_ACSName_List.get(g2)));
                    ++g2;
                }
                this.add(node_set);
                DefaultMutableTreeNode node_cmd = new DefaultMutableTreeNode("CmdList");
                int g3 = 0;
                while (g3 < TCUGui.tcuICD.cmd_ACSName_List.size()) {
                    node_cmd.add(new DefaultMutableTreeNode(TCUGui.tcuICD.cmd_ACSName_List.get(g3)));
                    ++g3;
                }
                this.add(node_cmd);
                DefaultMutableTreeNode node_mode = new DefaultMutableTreeNode("ModeList");
                int g4 = 0;
                while (g4 < TCUGui.tcuICD.mode_ACSName_List.size()) {
                    node_mode.add(new DefaultMutableTreeNode(TCUGui.tcuICD.mode_ACSName_List.get(g4)));
                    ++g4;
                }
                this.add(node_mode);
            }
        }));
    }

    private void jtreeToOpcua(String nodeList, String acsName) {
        if (!TCUGui.tcuOpcuaClient.client.isConnected()) {
            AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText(" OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
            return;
        }
        String nodeName = "";
        try {
            switch (nodeList) {
                case "GetList": {
                    int ix = 0;
                    while (ix < TCUGui.tcuICD.get_ACSName_List.size()) {
                        if (acsName == TCUGui.tcuICD.get_ACSName_List.get(ix)) {
                            nodeName = TCUGui.tcuICD.get_NodeName_List.get(ix);
                            GETInfoTextArea.getDocument().remove(0, GETInfoTextArea.getDocument().getLength());
                            GETInfoTextArea.append("> " + nodeName + ": " + TCUGui.getOPCUAdata(nodeName) + "\n");
                            GETInfoTextArea.append("> ACSName: " + acsName + "\n> Default Value =" + TCUGui.tcuICD.set_DefaultValue_List.get(ix) + "\n");
                            GETInfoTextArea.append("> DataType: " + TCUGui.tcuICD.set_DataType_List.get(ix) + "\n");
                            GETInfoTextArea.append("> Description: " + TCUGui.tcuICD.get_Description_List.get(ix) + " \n");
                        }
                        ++ix;
                    }
                    break;
                }
                case "SetList": {
                    int ix = 0;
                    while (ix < TCUGui.tcuICD.set_ACSName_List.size()) {
                        if (acsName == TCUGui.tcuICD.set_ACSName_List.get(ix)) {
                            nodeName = TCUGui.tcuICD.set_NodeName_List.get(ix);
                            DataInputForm.frmDatainputform.setVisible(true);
                            DataInputForm.frmDatainputform.setTitle("Mirror 1&2... SET");
                            DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + TCUGui.tcuICD.set_DefaultValue_List.get(ix) + "]");
                            DataInputForm.opcuaNameLabel.setText(String.valueOf(TCUGui.tcuICD.set_NodeName_List.get(ix)) + " [" + TCUGui.tcuICD.set_DataType_List.get(ix) + "]");
                            DataInputForm.enterDataValueField.setToolTipText(TCUGui.tcuICD.set_Description_List.get(ix));
                            DataInputForm.enterDataValueField.setText(TCUGui.getOPCUAdata(nodeName));
                            AIV_GUI.writeOnInfoText("Description: " + TCUGui.tcuICD.set_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                            DataInputForm.enterDataValueField.setForeground(Color.BLACK);
                        }
                        ++ix;
                    }
                    break;
                }
                case "CmdList": {
                    int ix = 0;
                    while (ix < TCUGui.tcuICD.cmd_ACSName_List.size()) {
                        if (acsName == TCUGui.tcuICD.cmd_ACSName_List.get(ix)) {
                            nodeName = TCUGui.tcuICD.cmd_NodeName_List.get(ix);
                            DataInputForm.frmDatainputform.setVisible(true);
                            DataInputForm.frmDatainputform.setTitle("\"Mirror 1&2... CMD");
                            DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + TCUGui.tcuICD.cmd_DefaultValue_List.get(ix) + "]");
                            DataInputForm.opcuaNameLabel.setText(String.valueOf(TCUGui.tcuICD.cmd_NodeName_List.get(ix)) + " [" + TCUGui.tcuICD.cmd_DataType_List.get(ix) + "]");
                            DataInputForm.enterDataValueField.setToolTipText(TCUGui.tcuICD.cmd_Description_List.get(ix));
                            DataInputForm.enterDataValueField.setText(TCUGui.tcuICD.cmd_CmdOrModeValue_List.get(ix));
                            DataInputForm.enterDataValueField.setForeground(Color.RED);
                            TCUGui.getOPCUAdata(nodeName);
                            AIV_GUI.writeOnInfoText("Description: " + TCUGui.tcuICD.cmd_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        }
                        ++ix;
                    }
                    break;
                }
                case "ModeList": {
                    int ix = 0;
                    while (ix < TCUGui.tcuICD.mode_ACSName_List.size()) {
                        if (acsName == TCUGui.tcuICD.mode_ACSName_List.get(ix)) {
                            nodeName = TCUGui.tcuICD.mode_NodeName_List.get(ix);
                            DataInputForm.frmDatainputform.setVisible(true);
                            DataInputForm.frmDatainputform.setTitle("\"Mirror 1&2... MODE");
                            DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + TCUGui.tcuICD.mode_DefaultValue_List.get(ix) + "]");
                            DataInputForm.opcuaNameLabel.setText(String.valueOf(TCUGui.tcuICD.mode_NodeName_List.get(ix)) + " [" + TCUGui.tcuICD.mode_DataType_List.get(ix) + "]");
                            DataInputForm.enterDataValueField.setToolTipText(TCUGui.tcuICD.mode_Description_List.get(ix));
                            DataInputForm.enterDataValueField.setText(TCUGui.tcuICD.mode_CmdOrModeValue_List.get(ix));
                            DataInputForm.enterDataValueField.setForeground(Color.DARK_GRAY);
                            TCUGui.getOPCUAdata(nodeName);
                            AIV_GUI.writeOnInfoText("Description: " + TCUGui.tcuICD.mode_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        }
                        ++ix;
                    }
                    break;
                }
                default: {
                    AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
                    AIV_GUI.writeOnInfoText(" acsCommand not valid: " + acsName + "\n", Color.RED, true, false, true, true, 12);
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ocSetValueToOpcuaServer() {
        String nodeType;
        String nodeName;
        block9: {
            String setVal = DataInputForm.acsNameLabel.getText();
            setVal = setVal.substring(0, setVal.indexOf(")")).trim();
            int opcIndex = Integer.parseInt(setVal);
            nodeName = "";
            nodeType = "";
            try {
                if (DataInputForm.frmDatainputform.getTitle().contains("SET")) {
                    nodeName = TCUGui.tcuICD.set_NodeName_List.get(opcIndex);
                    nodeType = TCUGui.tcuICD.set_DataType_List.get(opcIndex);
                    break block9;
                }
                if (DataInputForm.frmDatainputform.getTitle().contains("CMD")) {
                    nodeName = TCUGui.tcuICD.cmd_NodeName_List.get(opcIndex);
                    nodeType = TCUGui.tcuICD.cmd_DataType_List.get(opcIndex);
                    break block9;
                }
                if (DataInputForm.frmDatainputform.getTitle().contains("MODE")) {
                    nodeName = TCUGui.tcuICD.mode_NodeName_List.get(opcIndex);
                    nodeType = TCUGui.tcuICD.mode_DataType_List.get(opcIndex);
                    break block9;
                }
                AIV_GUI.writeOnInfoText("WRONG data...", Color.RED, true, false, false, false, 15);
                AIV_GUI.inserIconOnInfoText(20, Utils.thinkImageIcon);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String browserName = nodeName.substring(nodeName.lastIndexOf("=") + 1);
        String val = DataInputForm.enterDataValueField.getText().trim();
        try {
            TCUGui.tcuOpcuaClient.client.writeValue(new NodeId(2, browserName), AIV_GUI.opcuaUtils.setInitValue(nodeType, val));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        TCUGui.getOPCUAdata(nodeName);
        DataInputForm.frmDatainputform.setVisible(false);
    }

    public static String getOPCUAdata(String nodeName) {
        DataValue datValue = null;
        if (nodeName.contains("ns=")) {
            datValue = tcuOpcuaClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
                return datValue.getValue().getValue().toString();
            }
            AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            return "";
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText(" nodeName not valid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
        return "";
    }

    public void drawMotorCircleOnImage(int mtrIndex) {
        Graphics2D g2 = (Graphics2D)this.ImageMirrorLabel.getGraphics();
        int Xc = Utils.motor1Center[mtrIndex][0];
        int Yc = Utils.motor1Center[mtrIndex][1];
        g2.setStroke(new BasicStroke(2.0f));
        if (Xc >= 0 & Yc >= 0) {
            g2.setColor(Color.white);
            g2.draw(new Ellipse2D.Double(Xc - 12, Yc - 12, 24.0, 24.0));
        }
    }

    public void drawMirrorCircleOnImage(int mrrIndex) {
        GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
        Graphics2D g2 = (Graphics2D)this.ImageMirrorLabel.getGraphics();
        int Xc = Utils.mirror1Center[mrrIndex][0];
        int Yc = Utils.mirror1Center[mrrIndex][1];
        g2.setStroke(new BasicStroke(2.0f));
        if (Xc >= 0 & Yc >= 0) {
            g2.setColor(Color.yellow);
            g2.draw(new Ellipse2D.Double(Xc - 45, Yc - 45, 90.0, 90.0));
        }
    }
}

