/*
 * Decompiled with CFR 0.152.
 */
package sqm.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import gui.AIV_GUI;
import gui.DataInputForm;
import gui.HistoryPlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import myproc.ErrorForm;
import myproc.Utils;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;
import sqm.client.SQM_OpcuaClient;

public class SQMGUI
extends JFrame {
    public JComboBox deviceComboBox = new JComboBox();
    public static SQM_OpcuaClient sqm_WorkClient;
    public SQM_OpcuaClient sqm1_OpcuaClient = new SQM_OpcuaClient();
    public SQM_OpcuaClient sqm2_OpcuaClient = new SQM_OpcuaClient();
    public SQM_OpcuaClient sqm3_OpcuaClient = new SQM_OpcuaClient();
    public int sqmIndex = 0;
    public ErrorForm errorForm;
    public static DataInputForm sqmDataInputForm;
    public static HistoryPlot historyPlot;
    public JCheckBox historyCheckBox = new JCheckBox("PlotHistory");
    public JTree tree = new JTree();
    public JButton exitButton = new JButton("END");
    public static JLabel ledLabel;
    public JComboBox historyComboBox = new JComboBox();
    public static JMenuItem hideNewMenuItem;
    public JLabel errorNoLabel = new JLabel("ErrNo=");
    private Thread heartBeatThread = new Thread(){

        @Override
        public synchronized void run() {
            int oldValue = SQMGUI.sqm_WorkClient.heartbeat;
            while (true) {
                try {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (oldValue != SQMGUI.sqm_WorkClient.heartbeat) {
                            oldValue = SQMGUI.sqm_WorkClient.heartbeat;
                            if (ledLabel.getForeground() == Color.gray) {
                                ledLabel.setForeground(Color.green);
                            } else {
                                ledLabel.setForeground(Color.gray);
                            }
                        } else {
                            ledLabel.setForeground(Color.red);
                        }
                        SQMGUI.this.textField_0.setText(SQMGUI.sqm_WorkClient.sqmValue);
                        SQMGUI.this.textField_1.setText(SQMGUI.sqm_WorkClient.sqmRawValue);
                        SQMGUI.this.textField_2.setText(SQMGUI.sqm_WorkClient.sqmFreq);
                        SQMGUI.this.textField_3.setText(SQMGUI.sqm_WorkClient.sqmPeriodCount);
                        SQMGUI.this.textField_4.setText(SQMGUI.sqm_WorkClient.sqmPeriod);
                        SQMGUI.this.textField_5.setText(SQMGUI.sqm_WorkClient.sqmTemp);
                        SQMGUI.this.extraWindField.setText(SQMGUI.sqm_WorkClient.sqmValue);
                        SQMGUI.this.extraGustField.setText(SQMGUI.sqm_WorkClient.sqmTemp);
                        SQMGUI.this.errorNoLabel.setText("ErrNo= " + Integer.toString(SQMGUI.sqm_WorkClient.errorNumber));
                        SQMGUI.this.textFieldTime.setText("Last: " + SQMGUI.sqm_WorkClient.isoStamp);
                    }
                }
                catch (Exception e) {
                    SQMGUI.this.textField_0.setText("--");
                    SQMGUI.this.textField_1.setText("--");
                    SQMGUI.this.textField_2.setText("--");
                    SQMGUI.this.textField_3.setText("--");
                    SQMGUI.this.textField_4.setText("--");
                    SQMGUI.this.textField_5.setText("--");
                    SQMGUI.this.textFieldTime.setText("--");
                    SQMGUI.this.errorNoLabel.setText("ErrNo= --");
                    SQMGUI.this.extraWindField.setText("--");
                    SQMGUI.this.extraGustField.setText("--");
                    continue;
                }
                break;
            }
        }
    };
    private JTextField textField_0;
    private JTextField textField_1;
    private JTextField textField_2;
    private JTextField textField_3;
    private JTextField textField_4;
    private JTextField textField_5;
    private JTextField extraWindField;
    private JTextField extraGustField;
    private JTextField textFieldTime;

    static {
        sqmDataInputForm = new DataInputForm("WS");
        historyPlot = new HistoryPlot();
        ledLabel = new JLabel("\u2022");
        hideNewMenuItem = new JMenuItem("Hide");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.getProperties();
                    AIV_GUI.consolle.setVisible(true);
                    SQMGUI window = new SQMGUI("SQM");
                    window.setVisible(true);
                    window.exitButton.setVisible(true);
                    hideNewMenuItem.setEnabled(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SQMGUI(String devCode) {
        this.getContentPane().setBackground(UIManager.getColor("Button.shadow"));
        this.setTitle("SQMGUI - v1.0.0 - PBr161222 for ASTRI-MiniArray Project ");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("./conf/sqm.jpg"));
        this.sqm1_OpcuaClient.startClient(Utils.sqm1URL);
        this.sqm2_OpcuaClient.startClient(Utils.sqm2URL);
        this.sqm3_OpcuaClient.startClient(Utils.sqm3URL);
        sqm_WorkClient = this.sqm1_OpcuaClient;
        this.errorForm = new ErrorForm("SQM", "sqm_error_index", "sqm_error_info", "sqm_error_reset", 2, SQMGUI.sqm_WorkClient.client, "sqm_error_information", "sqm_error_number");
        this.heartBeatThread.start();
        this.setResizable(false);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu wsNewMenu = new JMenu("File");
        wsNewMenu.setFont(new Font("Segoe UI", 1, 12));
        menuBar.add(wsNewMenu);
        hideNewMenuItem.setFont(new Font("Segoe UI", 1, 12));
        hideNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQMGUI.this.setVisible(false);
            }
        });
        wsNewMenu.add(hideNewMenuItem);
        JMenuItem mntmNewMenuItem = new JMenuItem("Consolle");
        mntmNewMenuItem.setFont(new Font("Segoe UI", 1, 12));
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    AIV_GUI.consolle.setVisible(true);
                }
            }
        });
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("ErrorForm");
        mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQMGUI.this.errorForm.setVisible(true);
            }
        });
        mntmNewMenuItem_1.setFont(new Font("Segoe UI", 1, 12));
        wsNewMenu.add(mntmNewMenuItem_1);
        wsNewMenu.add(mntmNewMenuItem);
        JLabel deviceNameLabel_1 = new JLabel("  Set --> ");
        deviceNameLabel_1.setHorizontalAlignment(0);
        deviceNameLabel_1.setForeground(Color.BLUE);
        deviceNameLabel_1.setFont(new Font("Tahoma", 1, 14));
        menuBar.add(deviceNameLabel_1);
        this.deviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int indx;
                SQMGUI.this.sqmIndex = indx = SQMGUI.this.deviceComboBox.getSelectedIndex();
                sqm_WorkClient = indx == 0 ? SQMGUI.this.sqm1_OpcuaClient : (indx == 1 ? SQMGUI.this.sqm2_OpcuaClient : SQMGUI.this.sqm3_OpcuaClient);
                SQMGUI.this.errorForm.dispose();
                SQMGUI.this.errorForm = new ErrorForm("SQM" + (indx + 1), "sqm_error_index", "sqm_error_info", "sqm_error_reset", 2, SQMGUI.sqm_WorkClient.client, "sqm_error_information", "sqm_error_number");
            }
        });
        this.deviceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\u2022 SQM1 on ASTRI1", "\u2022 SQM2 on ASTRIx..", "\u2022 SQM3 to ZENITH"}));
        this.deviceComboBox.setSelectedIndex(0);
        this.deviceComboBox.setInheritsPopupMenu(true);
        this.deviceComboBox.setFont(new Font("Tahoma", 1, 14));
        this.deviceComboBox.setBackground(Color.YELLOW);
        menuBar.add(this.deviceComboBox);
        Component horizontalStrut_1 = Box.createHorizontalStrut(6);
        menuBar.add(horizontalStrut_1);
        this.textFieldTime = new JTextField();
        this.textFieldTime.setToolTipText("last update");
        this.textFieldTime.setAutoscrolls(false);
        this.textFieldTime.setText("---");
        this.textFieldTime.setHorizontalAlignment(0);
        this.textFieldTime.setFont(new Font("Tahoma", 1, 12));
        this.textFieldTime.setColumns(10);
        this.textFieldTime.setBackground(new Color(255, 255, 230));
        menuBar.add(this.textFieldTime);
        ledLabel.setVerticalAlignment(3);
        ledLabel.setToolTipText("heartBeat");
        ledLabel.setSize(new Dimension(15, 2));
        ledLabel.setPreferredSize(new Dimension(20, 4));
        ledLabel.setHorizontalTextPosition(0);
        ledLabel.setHorizontalAlignment(0);
        ledLabel.setForeground(Color.RED);
        ledLabel.setFont(new Font("Tahoma", 1, 25));
        menuBar.add(ledLabel);
        this.getContentPane().setLayout(null);
        this.treeSetModel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(10, 0, 187, 276);
        this.getContentPane().add(scrollPane);
        scrollPane.setViewportView(this.tree);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath tp = SQMGUI.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp.getPath().length == 3) {
                    SQMGUI.this.jtreeToOpcua(tp.getPath()[1].toString(), tp.getPath()[2].toString());
                }
            }
        });
        this.tree.setToolTipText("this is my tree...");
        this.tree.setScrollsOnExpand(false);
        this.tree.setName("WStree");
        this.tree.setForeground(Color.LIGHT_GRAY);
        this.tree.setFont(new Font("SansSerif", 0, 10));
        this.tree.setBackground(new Color(255, 255, 204));
        this.historyCheckBox.setFont(new Font("SansSerif", 1, 12));
        this.historyCheckBox.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.historyCheckBox.setBackground(new Color(255, 255, 204));
        this.historyCheckBox.setAlignmentX(0.5f);
        this.historyCheckBox.setBounds(10, 288, 89, 20);
        this.getContentPane().add(this.historyCheckBox);
        this.exitButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.exitButton.setToolTipText("End");
        this.exitButton.setBounds(447, 263, 74, 36);
        this.exitButton.setVisible(false);
        this.getContentPane().add(this.exitButton);
        this.exitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        this.exitButton.setForeground(Color.BLUE);
        this.exitButton.setFont(new Font("Tahoma", 1, 12));
        this.exitButton.setBackground(Color.LIGHT_GRAY);
        String[] hStr = new String[25];
        int ix = 0;
        while (ix <= 24) {
            hStr[ix] = "-" + String.valueOf(ix) + "Hr";
            ++ix;
        }
        this.historyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQMGUI.sqm_WorkClient.historyIndex = SQMGUI.this.historyComboBox.getSelectedIndex();
            }
        });
        this.historyComboBox.setModel(new DefaultComboBoxModel<String>(hStr));
        this.historyComboBox.setSelectedIndex(1);
        this.historyComboBox.setBackground(Color.ORANGE);
        this.historyComboBox.setBounds(109, 287, 88, 24);
        this.getContentPane().add(this.historyComboBox);
        JLabel deviceNameLabel = new JLabel("Value [magn]:");
        deviceNameLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel.setHorizontalAlignment(2);
        deviceNameLabel.setForeground(Color.BLUE);
        deviceNameLabel.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel.setBounds(207, 11, 104, 25);
        this.getContentPane().add(deviceNameLabel);
        this.textField_0 = new JTextField();
        this.textField_0.setText("---");
        this.textField_0.setHorizontalAlignment(0);
        this.textField_0.setFont(new Font("Tahoma", 1, 14));
        this.textField_0.setColumns(10);
        this.textField_0.setBackground(new Color(255, 255, 230));
        this.textField_0.setBounds(321, 11, 70, 25);
        this.getContentPane().add(this.textField_0);
        JLabel deviceNameLabel_2 = new JLabel("RawVal.[magn]:");
        deviceNameLabel_2.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_2.setHorizontalAlignment(2);
        deviceNameLabel_2.setForeground(Color.BLUE);
        deviceNameLabel_2.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_2.setBounds(207, 35, 104, 25);
        this.getContentPane().add(deviceNameLabel_2);
        this.textField_1 = new JTextField();
        this.textField_1.setText("---");
        this.textField_1.setHorizontalAlignment(0);
        this.textField_1.setFont(new Font("Tahoma", 1, 14));
        this.textField_1.setColumns(10);
        this.textField_1.setBackground(new Color(255, 255, 230));
        this.textField_1.setBounds(321, 35, 70, 25);
        this.getContentPane().add(this.textField_1);
        JLabel deviceNameLabel_3 = new JLabel("Freq. [Hz]:");
        deviceNameLabel_3.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_3.setHorizontalAlignment(2);
        deviceNameLabel_3.setForeground(Color.BLUE);
        deviceNameLabel_3.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_3.setBounds(207, 60, 104, 25);
        this.getContentPane().add(deviceNameLabel_3);
        this.textField_2 = new JTextField();
        this.textField_2.setText("---");
        this.textField_2.setHorizontalAlignment(0);
        this.textField_2.setFont(new Font("Tahoma", 1, 14));
        this.textField_2.setColumns(10);
        this.textField_2.setBackground(new Color(255, 255, 230));
        this.textField_2.setBounds(321, 60, 70, 25);
        this.getContentPane().add(this.textField_2);
        JLabel deviceNameLabel_4 = new JLabel("PeriodCounts:");
        deviceNameLabel_4.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_4.setHorizontalAlignment(2);
        deviceNameLabel_4.setForeground(Color.BLUE);
        deviceNameLabel_4.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_4.setBounds(207, 84, 104, 25);
        this.getContentPane().add(deviceNameLabel_4);
        this.textField_3 = new JTextField();
        this.textField_3.setText("---");
        this.textField_3.setHorizontalAlignment(0);
        this.textField_3.setFont(new Font("Tahoma", 1, 14));
        this.textField_3.setColumns(10);
        this.textField_3.setBackground(new Color(255, 255, 230));
        this.textField_3.setBounds(321, 84, 70, 25);
        this.getContentPane().add(this.textField_3);
        JLabel deviceNameLabel_5 = new JLabel("Period [sec]:");
        deviceNameLabel_5.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_5.setHorizontalAlignment(2);
        deviceNameLabel_5.setForeground(Color.BLUE);
        deviceNameLabel_5.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_5.setBounds(207, 109, 104, 25);
        this.getContentPane().add(deviceNameLabel_5);
        this.textField_4 = new JTextField();
        this.textField_4.setText("---");
        this.textField_4.setHorizontalAlignment(0);
        this.textField_4.setFont(new Font("Tahoma", 1, 14));
        this.textField_4.setColumns(10);
        this.textField_4.setBackground(new Color(255, 255, 230));
        this.textField_4.setBounds(321, 109, 70, 25);
        this.getContentPane().add(this.textField_4);
        JLabel deviceNameLabel_6 = new JLabel("Temp. [\u00b0C]:");
        deviceNameLabel_6.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_6.setHorizontalAlignment(2);
        deviceNameLabel_6.setForeground(Color.BLUE);
        deviceNameLabel_6.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_6.setBounds(207, 134, 104, 25);
        this.getContentPane().add(deviceNameLabel_6);
        this.textField_5 = new JTextField();
        this.textField_5.setText("---");
        this.textField_5.setHorizontalAlignment(0);
        this.textField_5.setFont(new Font("Tahoma", 1, 14));
        this.textField_5.setColumns(10);
        this.textField_5.setBackground(new Color(255, 255, 230));
        this.textField_5.setBounds(321, 134, 70, 25);
        this.getContentPane().add(this.textField_5);
        this.errorModel();
        this.initialize();
    }

    private void initialize() {
        this.setBounds(100, 100, 560, 382);
        this.setDefaultCloseOperation(0);
    }

    private void jtreeToOpcua(String nodeList, String acsName) {
        if (!SQMGUI.sqm_WorkClient.client.isConnected()) {
            AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText(" WS OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
            return;
        }
        String nodeName = "";
        String unitString = "unit";
        switch (nodeList) {
            case "GetList": {
                int ix = 0;
                while (ix < SQMGUI.sqm_WorkClient.sqmICD.get_ACSName_List.size()) {
                    if (acsName.equals(SQMGUI.sqm_WorkClient.sqmICD.get_ACSName_List.get(ix).trim())) {
                        nodeName = SQMGUI.sqm_WorkClient.sqmICD.get_NodeName_List.get(ix);
                        unitString = SQMGUI.sqm_WorkClient.sqmICD.get_Unit_List.get(ix);
                        SQMGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + SQMGUI.sqm_WorkClient.sqmICD.get_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                if (!this.historyCheckBox.isSelected()) break;
                SQMGUI.showHistoryPlot(nodeName, acsName, unitString);
                break;
            }
            case "SetList": {
                int ix = 0;
                while (ix < SQMGUI.sqm_WorkClient.sqmICD.set_ACSName_List.size()) {
                    if (acsName.equals(SQMGUI.sqm_WorkClient.sqmICD.set_ACSName_List.get(ix))) {
                        nodeName = SQMGUI.sqm_WorkClient.sqmICD.set_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... SET");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + SQMGUI.sqm_WorkClient.sqmICD.set_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(SQMGUI.sqm_WorkClient.sqmICD.set_NodeName_List.get(ix)) + " [" + SQMGUI.sqm_WorkClient.sqmICD.set_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(SQMGUI.sqm_WorkClient.sqmICD.set_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(SQMGUI.getOPCUAdata(nodeName));
                        AIV_GUI.writeOnInfoText("Description: " + SQMGUI.sqm_WorkClient.sqmICD.set_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        DataInputForm.enterDataValueField.setForeground(Color.BLACK);
                    }
                    ++ix;
                }
                break;
            }
            case "CmdList": {
                int ix = 0;
                while (ix < SQMGUI.sqm_WorkClient.sqmICD.cmd_ACSName_List.size()) {
                    if (acsName.equals(SQMGUI.sqm_WorkClient.sqmICD.cmd_ACSName_List.get(ix))) {
                        nodeName = SQMGUI.sqm_WorkClient.sqmICD.cmd_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... CMD");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + SQMGUI.sqm_WorkClient.sqmICD.cmd_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(SQMGUI.sqm_WorkClient.sqmICD.cmd_NodeName_List.get(ix)) + " [" + SQMGUI.sqm_WorkClient.sqmICD.cmd_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(SQMGUI.sqm_WorkClient.sqmICD.cmd_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(SQMGUI.sqm_WorkClient.sqmICD.cmd_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.RED);
                        SQMGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + SQMGUI.sqm_WorkClient.sqmICD.cmd_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            case "ModeList": {
                int ix = 0;
                while (ix < SQMGUI.sqm_WorkClient.sqmICD.mode_ACSName_List.size()) {
                    if (acsName.equals(SQMGUI.sqm_WorkClient.sqmICD.mode_ACSName_List.get(ix))) {
                        nodeName = SQMGUI.sqm_WorkClient.sqmICD.mode_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... MODE");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + SQMGUI.sqm_WorkClient.sqmICD.mode_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(SQMGUI.sqm_WorkClient.sqmICD.mode_NodeName_List.get(ix)) + " [" + SQMGUI.sqm_WorkClient.sqmICD.mode_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(SQMGUI.sqm_WorkClient.sqmICD.mode_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(SQMGUI.sqm_WorkClient.sqmICD.mode_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.DARK_GRAY);
                        SQMGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + SQMGUI.sqm_WorkClient.sqmICD.mode_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            default: {
                AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
                AIV_GUI.writeOnInfoText(" acsCommand not valid: " + acsName + "\n", Color.RED, true, false, true, true, 12);
                return;
            }
        }
    }

    public static String getOPCUAdata(String nodeName) {
        DataValue datValue = null;
        if (nodeName.contains("ns=")) {
            datValue = sqm_WorkClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= " + datValue.getValue().getValue().toString() + " \n", Color.blue, true, false, false, true, 12);
                return datValue.getValue().getValue().toString();
            }
            AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            return "";
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText(" nodeName not valid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
        return "";
    }

    public static void showHistoryPlot(String nodeName, String acsName, String unitString) {
        DataValue[] dValue = null;
        try {
            dValue = sqm_WorkClient.readHistory(nodeName);
            if (dValue != null) {
                SQMGUI.historyPlot.unitString = unitString;
                SQMGUI.historyPlot.chart.getXYPlot().getDomainAxis().setLabel("time");
                SQMGUI.historyPlot.chart.getXYPlot().getRangeAxis().setLabel(unitString);
                SQMGUI.historyPlot.timeSeries.clear();
                SQMGUI.historyPlot.timeSeries.setKey((Comparable)((Object)("opcuaNode: " + nodeName)));
                SQMGUI.historyPlot.chart.setTitle(acsName);
                int ix = 0;
                while (ix < dValue.length) {
                    SQMGUI.historyPlot.timeSeries.add((RegularTimePeriod)new Millisecond(dValue[ix].getSourceTimestamp().getUtcCalendar().getTime()), dValue[ix].getValue().doubleValue());
                    ++ix;
                }
                historyPlot.setVisible(true);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void jtreeGetEditedText(String nodeName) throws BadLocationException {
        DataValue datValue = null;
        AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " get new value and press Return:: ");
        AIV_GUI.infoText.getDocument().getText(0, AIV_GUI.infoText.getDocument().getLength());
        if (nodeName.contains("ns=")) {
            datValue = sqm_WorkClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
            } else {
                AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            }
            return;
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText("nodeName not vallid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
    }

    public void errorModel() {
        JLabel deviceNameLabel_5 = new JLabel("SQM_Value");
        deviceNameLabel_5.setHorizontalAlignment(0);
        deviceNameLabel_5.setForeground(Color.BLUE);
        deviceNameLabel_5.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_5.setBounds(426, 53, 104, 25);
        this.getContentPane().add(deviceNameLabel_5);
        this.extraWindField = new JTextField();
        this.extraWindField.setForeground(Color.BLUE);
        this.extraWindField.setText("000,0");
        this.extraWindField.setHorizontalAlignment(0);
        this.extraWindField.setFont(new Font("Tahoma", 1, 28));
        this.extraWindField.setColumns(10);
        this.extraWindField.setBackground(new Color(255, 255, 230));
        this.extraWindField.setBounds(426, 78, 104, 49);
        this.getContentPane().add(this.extraWindField);
        this.extraGustField = new JTextField();
        this.extraGustField.setForeground(new Color(178, 34, 34));
        this.extraGustField.setText("000.0");
        this.extraGustField.setHorizontalAlignment(0);
        this.extraGustField.setFont(new Font("Tahoma", 1, 28));
        this.extraGustField.setColumns(10);
        this.extraGustField.setBackground(new Color(255, 255, 230));
        this.extraGustField.setBounds(426, 159, 104, 49);
        this.getContentPane().add(this.extraGustField);
        JLabel deviceNameLabel_5_1 = new JLabel("SQM_Temp.");
        deviceNameLabel_5_1.setHorizontalAlignment(0);
        deviceNameLabel_5_1.setForeground(new Color(178, 34, 34));
        deviceNameLabel_5_1.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_5_1.setBounds(426, 133, 104, 25);
        this.getContentPane().add(deviceNameLabel_5_1);
        JButton btnReconnect = new JButton("Reconnect");
        btnReconnect.setBorder(new BevelBorder(0, null, null, null, null));
        btnReconnect.setBounds(228, 263, 115, 36);
        this.getContentPane().add(btnReconnect);
        btnReconnect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                sqm_WorkClient.stopClient();
                Utils.getProperties();
                if (SQMGUI.this.sqmIndex == 0) {
                    SQMGUI.this.sqm1_OpcuaClient = new SQM_OpcuaClient();
                    SQMGUI.this.sqm1_OpcuaClient.startClient(Utils.sqm1URL);
                    sqm_WorkClient = SQMGUI.this.sqm1_OpcuaClient;
                } else if (SQMGUI.this.sqmIndex == 1) {
                    SQMGUI.this.sqm2_OpcuaClient = new SQM_OpcuaClient();
                    SQMGUI.this.sqm2_OpcuaClient.startClient(Utils.sqm2URL);
                    sqm_WorkClient = SQMGUI.this.sqm2_OpcuaClient;
                } else if (SQMGUI.this.sqmIndex == 2) {
                    SQMGUI.this.sqm3_OpcuaClient = new SQM_OpcuaClient();
                    SQMGUI.this.sqm3_OpcuaClient.startClient(Utils.sqm3URL);
                    sqm_WorkClient = SQMGUI.this.sqm3_OpcuaClient;
                }
            }
        });
        btnReconnect.setToolTipText("Connect to OPCUA Server & reload properties");
        btnReconnect.setForeground(Color.LIGHT_GRAY);
        btnReconnect.setFont(new Font("Tahoma", 1, 12));
        btnReconnect.setBackground(Color.BLUE);
        this.errorNoLabel.setForeground(new Color(220, 20, 60));
        this.errorNoLabel.setBorder(new LineBorder(new Color(255, 0, 0), 1, true));
        this.errorNoLabel.setBounds(436, 11, 85, 20);
        this.getContentPane().add(this.errorNoLabel);
    }

    public static void sqmSetValueToOpcuaServer() {
        String setVal = DataInputForm.acsNameLabel.getText();
        setVal = setVal.substring(0, setVal.indexOf(")")).trim();
        int opcIndex = Integer.parseInt(setVal);
        String nodeName = "";
        String nodeType = "";
        if (DataInputForm.frmDatainputform.getTitle().contains("SET")) {
            nodeName = SQMGUI.sqm_WorkClient.sqmICD.set_NodeName_List.get(opcIndex);
            nodeType = SQMGUI.sqm_WorkClient.sqmICD.set_DataType_List.get(opcIndex);
        } else if (DataInputForm.frmDatainputform.getTitle().contains("CMD")) {
            nodeName = SQMGUI.sqm_WorkClient.sqmICD.cmd_NodeName_List.get(opcIndex);
            nodeType = SQMGUI.sqm_WorkClient.sqmICD.cmd_DataType_List.get(opcIndex);
        } else if (DataInputForm.frmDatainputform.getTitle().contains("MODE")) {
            nodeName = SQMGUI.sqm_WorkClient.sqmICD.mode_NodeName_List.get(opcIndex);
            nodeType = SQMGUI.sqm_WorkClient.sqmICD.mode_DataType_List.get(opcIndex);
        } else {
            System.out.println("WRONG data...");
            return;
        }
        String browserName = nodeName.substring(nodeName.lastIndexOf("=") + 1);
        String val = DataInputForm.enterDataValueField.getText().trim();
        try {
            SQMGUI.sqm_WorkClient.client.writeValue(new NodeId(2, browserName), AIV_GUI.opcuaUtils.setInitValue(nodeType, val));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        SQMGUI.getOPCUAdata(nodeName);
        DataInputForm.frmDatainputform.setVisible(false);
    }

    public void treeSetModel() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("OPCUA_node_list"){
            {
                DefaultMutableTreeNode node_get = new DefaultMutableTreeNode("GetList");
                int g = 0;
                while (g < SQMGUI.sqm_WorkClient.sqmICD.get_ACSName_List.size()) {
                    node_get.add(new DefaultMutableTreeNode(SQMGUI.sqm_WorkClient.sqmICD.get_ACSName_List.get(g)));
                    ++g;
                }
                super.add(node_get);
                DefaultMutableTreeNode node_set = new DefaultMutableTreeNode("SetList");
                int g2 = 0;
                while (g2 < SQMGUI.sqm_WorkClient.sqmICD.set_ACSName_List.size()) {
                    node_set.add(new DefaultMutableTreeNode(SQMGUI.sqm_WorkClient.sqmICD.set_ACSName_List.get(g2)));
                    ++g2;
                }
                super.add(node_set);
                DefaultMutableTreeNode node_cmd = new DefaultMutableTreeNode("CmdList");
                int g3 = 0;
                while (g3 < SQMGUI.sqm_WorkClient.sqmICD.cmd_ACSName_List.size()) {
                    node_cmd.add(new DefaultMutableTreeNode(SQMGUI.sqm_WorkClient.sqmICD.cmd_ACSName_List.get(g3)));
                    ++g3;
                }
                super.add(node_cmd);
                DefaultMutableTreeNode node_mode = new DefaultMutableTreeNode("ModeList");
                int g4 = 0;
                while (g4 < SQMGUI.sqm_WorkClient.sqmICD.mode_ACSName_List.size()) {
                    node_mode.add(new DefaultMutableTreeNode(SQMGUI.sqm_WorkClient.sqmICD.mode_ACSName_List.get(g4)));
                    ++g4;
                }
                super.add(node_mode);
            }
        }));
    }
}

