/*
 * Decompiled with CFR 0.152.
 */
package pmc.client;

import client.DataPoint;
import client.OpcuaUtils;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;
import gui.AIV_GUI;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.text.BadLocationException;
import myproc.GetFile;
import myproc.Utils;
import org.jfree.data.xy.XYSeries;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.tcp.io.TcpConnection;
import pmc.client.PMCGUI;

public class PMCOpcuaClient {
    public XYSeries raErrorSeries = new XYSeries((Comparable)((Object)"RA_error"));
    public XYSeries decErrorSeries = new XYSeries((Comparable)((Object)"DEC_error"));
    public XYSeries azErrorSeries = new XYSeries((Comparable)((Object)"AZ_error"));
    public XYSeries elErrorSeries = new XYSeries((Comparable)((Object)"EL_error"));
    public UaClient client;
    public int errorNumber = 0;
    public String get_fname = "";
    public String get_dirpath = "";
    private Subscription subscription;
    private String devAcronym = "PMC>";
    private List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    public NodeId nodeId;
    OpcuaUtils opcuaUtils = new OpcuaUtils();
    public int[] crossReference1 = new int[]{-1, -1};
    public int[] crossReference2 = new int[]{-1, -1};
    public int[] areaReference = new int[]{-1, -1, -1, -1};
    private MonitoredDataItemListener dataChangeListener = new MonitoredDataItemListener(){

        public void onDataChange(MonitoredDataItem sender, DataValue prevValue, DataValue val) {
            block32: {
                String name = sender.getNodeId().getValue().toString();
                if (!val.getStatusCode().isNotBad()) break block32;
                switch (name) {
                    case "pmc_raerr": {
                        if (val.getValue().doubleValue() == -99.9) break;
                        PMCOpcuaClient.this.raErrorSeries.add((double)PMCOpcuaClient.this.raErrorSeries.getItemCount(), val.getValue().doubleValue());
                        PMCGUI.combinedCooErrorPlots.raErrorSeries.add((double)(PMCOpcuaClient.this.raErrorSeries.getItemCount() - 1), val.getValue().doubleValue());
                        break;
                    }
                    case "pmc_decerr": {
                        if (val.getValue().doubleValue() == -99.9) break;
                        PMCOpcuaClient.this.decErrorSeries.add((double)PMCOpcuaClient.this.decErrorSeries.getItemCount(), val.getValue().doubleValue());
                        PMCGUI.combinedCooErrorPlots.decErrorSeries.add((double)(PMCOpcuaClient.this.decErrorSeries.getItemCount() - 1), val.getValue().doubleValue());
                        break;
                    }
                    case "pmc_azerr": {
                        if (val.getValue().doubleValue() == -99.9) break;
                        PMCOpcuaClient.this.azErrorSeries.add((double)PMCOpcuaClient.this.azErrorSeries.getItemCount(), val.getValue().doubleValue());
                        PMCGUI.combinedCooErrorPlots.azErrorSeries.add((double)(PMCOpcuaClient.this.azErrorSeries.getItemCount() - 1), val.getValue().doubleValue());
                        break;
                    }
                    case "pmc_alterr": {
                        if (val.getValue().doubleValue() != -99.9) {
                            PMCOpcuaClient.this.elErrorSeries.add((double)PMCOpcuaClient.this.elErrorSeries.getItemCount(), val.getValue().doubleValue());
                            PMCGUI.combinedCooErrorPlots.elErrorSeries.add((double)(PMCOpcuaClient.this.elErrorSeries.getItemCount() - 1), val.getValue().doubleValue());
                        }
                    }
                    case "pmc_isotstamp": {
                        PMCOpcuaClient.this.writeOnTextInfo();
                        break;
                    }
                    case "pmc_get_dirpath": {
                        PMCOpcuaClient.this.get_dirpath = val.getValue().getValue().toString();
                        AIV_GUI.writeOnInfoText("\n" + PMCOpcuaClient.this.get_dirpath + PMCOpcuaClient.this.get_fname);
                        break;
                    }
                    case "pmc_get_fname": {
                        PMCOpcuaClient.this.get_fname = val.getValue().getValue().toString();
                        PMCGUI.textImageName.setText(String.valueOf(PMCOpcuaClient.this.get_dirpath) + PMCOpcuaClient.this.get_fname);
                        AIV_GUI.writeOnInfoText("\n" + PMCOpcuaClient.this.get_dirpath + PMCOpcuaClient.this.get_fname);
                        if (!(AIV_GUI.pmcGUI.autoDetectCheckItem.isSelected() & !PMCOpcuaClient.this.get_fname.contains("NULL"))) break;
                        AIV_GUI.pmcGUI.getLastImageThreadFlag = true;
                        break;
                    }
                    case "pmc_error_number": {
                        PMCOpcuaClient.this.errorNumber = val.getValue().toNumber().intValue();
                        AIV_GUI.pmcGUI.errorNoLabel.setText("ErrorNo=" + val.getValue().getValue().toString());
                        break;
                    }
                    case "heartbeat": {
                        AIV_GUI.pmcGUI.heartbeatLabel.setText(val.getValue().getValue().toString());
                        break;
                    }
                }
            }
        }
    };
    private SubscriptionAliveListener subscriptionAliveListener = new SubscriptionAliveListener(){

        public void onAlive(Subscription s) {
            System.out.println(String.valueOf(PMCOpcuaClient.this.devAcronym) + String.format("Subscription alive: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }

        public void onTimeout(Subscription s) {
            System.out.println(String.valueOf(PMCOpcuaClient.this.devAcronym) + String.format("Subscription timeout: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }

        public void onAfterCreate(Subscription s) {
            System.out.println(String.valueOf(PMCOpcuaClient.this.devAcronym) + String.format("Subscription created: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }
    };
    private SubscriptionNotificationListener subscriptionListener = new SubscriptionNotificationListener(){

        public void onDataChange(Subscription subscription, MonitoredDataItem item, DataValue newValue) {
        }

        public void onError(Subscription subscription, Object notification, Exception exception) {
            System.out.println(String.valueOf(PMCOpcuaClient.this.devAcronym) + exception.getMessage());
        }

        public void onEvent(Subscription subscription, MonitoredEventItem item, Variant[] eventFields) {
            System.out.println(String.valueOf(PMCOpcuaClient.this.devAcronym) + String.format("Subscription value received: item = %tc, value = %tc", item.getNodeId(), eventFields));
        }

        public void onNotificationData(Subscription subscription, NotificationData notification) {
        }

        public void onStatusChange(Subscription subscription, StatusCode oldStatus, StatusCode newStatus, DiagnosticInfo diagnosticInfo) {
        }

        public void onBufferOverflow(Subscription arg0, UnsignedInteger arg1, ExtensionObject[] arg2) {
        }

        public long onMissingData(UnsignedInteger arg0, long arg1, long arg2, StatusCode arg3) {
            return 0L;
        }
    };
    private String sourceTime = this.getSourceTimestamp("");
    private GetFile getFile;
    public Thread autoDetectThread = new Thread(){

        @Override
        public synchronized void run() {
            String sT = PMCOpcuaClient.this.sourceTime;
            while (true) {
                if (!AIV_GUI.pmcGUI.autoDetectCheckItem.isSelected()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (PMCOpcuaClient.this.client.isConnected()) {
                    sT = PMCOpcuaClient.this.getSourceTimestamp("ns=2;s=pmc_get_fname");
                    if (sT == PMCOpcuaClient.this.sourceTime) continue;
                    try {
                        sT = PMCOpcuaClient.this.sourceTime;
                        PMCOpcuaClient.this.client.writeValue(new NodeId(2, "pmc_sendimage"), (Object)1);
                        PMCOpcuaClient.this.getFile = new GetFile();
                        if (PMCOpcuaClient.this.getFile.receiveFile()) {
                            AIV_GUI.writeOnInfoText("\n file transfer success.. " + sT + "\n", Color.blue, true, false, false, false, 15);
                            continue;
                        }
                        AIV_GUI.writeOnInfoText("\n file transfer ERROR..\n", Color.red, true, false, false, true, 15);
                    }
                    catch (ServiceException | StatusException | IOException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    };
    public int serverStatus = -1;
    public Thread getServerStatusThread = new Thread(){

        @Override
        public synchronized void run() {
            block9: while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (PMCOpcuaClient.this.client.isConnected()) {
                    PMCOpcuaClient.this.setServerStatus(PMCOpcuaClient.this.getDataValue("ns=2;s=pmc_status").getValue().intValue());
                } else {
                    PMCOpcuaClient.this.setServerStatus(-1);
                }
                if (!(PMCGUI.showAllImages != null & Utils.telescopeNumber < 1)) continue;
                switch (PMCOpcuaClient.this.getServerStatus()) {
                    case 0: {
                        PMCGUI.showAllImages.ledLabel[Utils.telescopeNumber - 1].setForeground(Color.lightGray);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setForeground(Color.lightGray);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setText("OnLine");
                        continue block9;
                    }
                    case 1: {
                        PMCGUI.showAllImages.ledLabel[Utils.telescopeNumber - 1].setForeground(Color.cyan);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setForeground(Color.cyan);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setText("StandBy");
                        continue block9;
                    }
                    case 2: {
                        PMCGUI.showAllImages.ledLabel[Utils.telescopeNumber - 1].setForeground(Color.green);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setForeground(Color.green);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setText("OnLine");
                        continue block9;
                    }
                    case 3: {
                        PMCGUI.showAllImages.ledLabel[Utils.telescopeNumber - 1].setForeground(Color.pink);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setForeground(Color.pink);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setText("Busy");
                        continue block9;
                    }
                    case 7: {
                        PMCGUI.showAllImages.ledLabel[Utils.telescopeNumber - 1].setForeground(Color.red);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setForeground(Color.red);
                        PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setText("Fault");
                        continue block9;
                    }
                }
                PMCGUI.showAllImages.ledLabel[Utils.telescopeNumber - 1].setForeground(Color.black);
                PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setForeground(Color.black);
                PMCGUI.showAllImages.statusLabel[Utils.telescopeNumber - 1].setText("NotConnectd");
            }
        }
    };
    public boolean deviceLinkStatus = false;
    public Thread getDeviceLinkStatusThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (PMCOpcuaClient.this.client.isConnected()) {
                    PMCOpcuaClient.this.setDeviceLinkStatus(PMCOpcuaClient.this.getDataValue("ns=2;s=pmc_get_is_reachable").getValue().booleanValue());
                } else {
                    PMCOpcuaClient.this.setDeviceLinkStatus(false);
                }
                if (!(PMCGUI.showAllImages != null & Utils.telescopeNumber < 1)) continue;
                if (PMCOpcuaClient.this.getDeviceLinkStatus()) {
                    PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setForeground(Color.green);
                    PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setBackground(Color.white);
                    PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setText("Reachable");
                    PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setSelected(true);
                    continue;
                }
                PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setForeground(Color.red);
                PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setText("UnRachable");
                PMCGUI.showAllImages.activateboxCk[Utils.telescopeNumber - 1].setSelected(false);
            }
        }
    };

    public void getReferenceFromProps() {
        if (Utils.telescopeNumber < 1) {
            return;
        }
        Utils.getProperties();
        this.areaReference = Arrays.stream(Utils.prop.getProperty("areaReference_" + String.valueOf(Utils.telescopeNumber)).split(",")).mapToInt(Integer::parseInt).toArray();
        this.crossReference1 = Arrays.stream(Utils.prop.getProperty("crossReference1_" + String.valueOf(Utils.telescopeNumber)).split(",")).mapToInt(Integer::parseInt).toArray();
        this.crossReference2 = Arrays.stream(Utils.prop.getProperty("crossReference2_" + String.valueOf(Utils.telescopeNumber)).split(",")).mapToInt(Integer::parseInt).toArray();
    }

    public void setServerIndex(int serverIndex) {
        this.devAcronym = "PMC" + String.valueOf(serverIndex) + ">";
    }

    public boolean startClient(String clnt, int index) {
        this.setServerIndex(index);
        this.getReferenceFromProps();
        this.getServerStatusThread.start();
        this.getDeviceLinkStatusThread.start();
        return this.startClient(clnt);
    }

    public boolean startClient(String clnt) {
        try {
            this.client = new UaClient(clnt);
            TcpConnection.setReceiveBufferSize((int)1000000);
            TcpConnection.setSendBufferSize((int)1000000);
            this.client.getEndpointConfiguration().setMaxArrayLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxByteStringLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxMessageSize(Integer.valueOf(768000000));
            this.client.getEndpointConfiguration().setMaxStringLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxBufferSize(Integer.valueOf(120000000));
            this.client.setSecurityMode(SecurityMode.NONE);
            this.client.setSessionTimeout(5000.0);
            this.client.setAutoReconnect(true);
            this.client.setStatusCheckTimeout(1000L);
            this.client.setTimeout(1000L);
            this.client.setSessionTimeout(3000L, TimeUnit.MILLISECONDS);
            this.client.getEndpointConfiguration().setOperationTimeout(Integer.valueOf(3000));
            this.createSubscription();
            this.client.connect();
            this.CreateDataPoints();
            this.activateMonitoringAll();
        }
        catch (ServiceException | StatusException | AddressSpaceException | URISyntaxException e) {
            System.out.println(" Opcua Client error: " + e.getMessage());
        }
        return false;
    }

    public Object readValue(int ns, String browserName) {
        this.nodeId = new NodeId(ns, browserName);
        Object value = null;
        try {
            value = this.client.readValue(this.nodeId).getValue().getValue();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public DataValue getDataValue(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        DataValue dataValue = null;
        try {
            dataValue = this.client.readValue(this.nodeId);
        }
        catch (ServiceException | StatusException e) {
            System.out.println("Error on node " + nodeName + " >>" + e.getMessage());
        }
        return dataValue;
    }

    private int CreateDataPoints1() throws ServiceException, AddressSpaceException {
        this.dataPointList.add(new DataPoint(this.client, new NodeId(2, "pmc_raerr")));
        this.dataPointList.add(new DataPoint(this.client, new NodeId(2, "pmc_decerr")));
        this.dataPointList.add(new DataPoint(this.client, new NodeId(2, "pmc_azerr")));
        this.dataPointList.add(new DataPoint(this.client, new NodeId(2, "pmc_alterr")));
        this.dataPointList.add(new DataPoint(this.client, new NodeId(2, "pmc_isotstamp")));
        return this.dataPointList.size();
    }

    private int CreateDataPoints() throws ServiceException, AddressSpaceException {
        int ix = 0;
        while (ix < PMCGUI.pmcICD.get_NodeName_List.size()) {
            this.dataPointList.add(new DataPoint(this.client, this.getNodeId(PMCGUI.pmcICD.get_NodeName_List.get(ix))));
            System.out.println(String.valueOf(ix) + ") CreateDataPoints dataPointList = " + PMCGUI.pmcICD.get_NodeName_List.get(ix));
            ++ix;
        }
        System.out.println("CreateDataPoints size = " + this.dataPointList.size());
        return this.dataPointList.size();
    }

    private void activateMonitoringAll() throws ServiceException, StatusException {
        int nItem = -1;
        for (DataPoint item : this.dataPointList) {
            try {
                ++nItem;
                this.addMonitoredDataPoint(item.getMonitorItem(this.dataChangeListener));
            }
            catch (ServiceException | StatusException e) {
                System.out.println("Error on activateMonitoringAll itemNo= " + nItem + "   " + item.toString() + " >>" + e.getMessage());
            }
        }
        this.startMonitoring();
    }

    public void clearErrorSeries() {
        this.raErrorSeries.clear();
        this.decErrorSeries.clear();
        this.azErrorSeries.clear();
        this.elErrorSeries.clear();
    }

    public void copyErrorXYSeries() {
        PMCGUI.combinedCooErrorPlots.raErrorSeries.clear();
        int ix = 0;
        while (ix < this.raErrorSeries.getItemCount()) {
            PMCGUI.combinedCooErrorPlots.raErrorSeries.add(this.raErrorSeries.getDataItem(ix));
            ++ix;
        }
        PMCGUI.combinedCooErrorPlots.decErrorSeries.clear();
        ix = 0;
        while (ix < this.decErrorSeries.getItemCount()) {
            PMCGUI.combinedCooErrorPlots.decErrorSeries.add(this.decErrorSeries.getDataItem(ix));
            ++ix;
        }
        PMCGUI.combinedCooErrorPlots.azErrorSeries.clear();
        ix = 0;
        while (ix < this.azErrorSeries.getItemCount()) {
            PMCGUI.combinedCooErrorPlots.azErrorSeries.add(this.azErrorSeries.getDataItem(ix));
            ++ix;
        }
        PMCGUI.combinedCooErrorPlots.elErrorSeries.clear();
        ix = 0;
        while (ix < this.elErrorSeries.getItemCount()) {
            PMCGUI.combinedCooErrorPlots.elErrorSeries.add(this.elErrorSeries.getDataItem(ix));
            ++ix;
        }
    }

    public String getServerTimestamp(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        String value = null;
        try {
            value = this.client.readValue(this.nodeId).getServerTimestamp().toString();
        }
        catch (ServiceException | StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void writeOnTextInfo() {
        String txt = "";
        try {
            PMCGUI.infoTextArea.getDocument().remove(0, PMCGUI.infoTextArea.getDocument().getLength());
            PMCGUI.infoTextArea.append(">" + this.client.readValue(new NodeId(2, "pmc_isotstamp")).getValue().getValue().toString() + "\n");
            PMCGUI.infoTextArea.append("Astmetry:" + this.client.readValue(new NodeId(2, "pmc_astrometry_on_off")).getValue().getValue().toString() + "\n");
            PMCGUI.infoTextArea.append("ImgName:" + this.client.readValue(new NodeId(2, "pmc_get_fname")).getValue().getValue().toString() + "\n");
            PMCGUI.infoTextArea.append("ImgPath:" + this.client.readValue(new NodeId(2, "pmc_get_dirpath")).getValue().getValue().toString() + "\n");
            int ix = 0;
            while (ix < PMCGUI.pmcICD.get_NodeName_List.size()) {
                try {
                    txt = PMCGUI.pmcICD.get_NodeName_List.get(ix);
                    txt = txt.substring(txt.lastIndexOf("=") + 1).trim();
                    if (txt.contains("pmc_")) {
                        txt = txt.substring(txt.lastIndexOf("pmc_") + 4).trim();
                    }
                    if (txt.contains("get_")) {
                        txt = txt.substring(txt.lastIndexOf("get_") + 4).trim();
                    }
                    if (txt.length() > 10) {
                        txt = txt.substring(0, 9);
                    }
                    txt = String.valueOf(txt) + "=";
                    txt = String.valueOf(txt) + this.getDataValue(PMCGUI.pmcICD.get_NodeName_List.get(ix)).getValue().getValue().toString() + "\n";
                    PMCGUI.infoTextArea.append(txt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++ix;
            }
        }
        catch (ServiceException | StatusException | BadLocationException e) {
            System.out.println("infoTextArea Error: " + e.getMessage());
            PMCGUI.infoTextArea.setText("Error..");
        }
    }

    public String getSourceTimestamp(String nodeName) {
        if (nodeName == null | nodeName == "") {
            return "";
        }
        this.nodeId = this.getNodeId(nodeName);
        String value = "";
        try {
            value = this.client.readValue(this.nodeId).getSourceTimestamp().toString();
        }
        catch (ServiceException | StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getNodeType(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        UaType dataType = null;
        String value = null;
        try {
            UaVariable valiable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
            dataType = valiable.getDataType();
            NodeId dataTypeId = valiable.getDataTypeId();
            dataType = this.client.getAddressSpace().getType(dataTypeId);
            value = dataType.getDisplayName().getText();
        }
        catch (AddressSpaceException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void test() throws ServiceException, AddressSpaceException, Exception {
        this.startClient("opc.tcp://localhost:52620/OPCUA/AMA_WS1_Server");
        UaNode node = this.client.getAddressSpace().getNode(this.nodeId);
        if (node != null) {
            System.out.println(node.getNodeClass().toString());
            System.out.println(this.client.readValue(this.nodeId).getValue().getValue());
            System.out.println(this.client.readValue(this.nodeId).getValue().isArray());
        } else {
            System.out.println("node is null");
        }
    }

    public static void main(String[] args) throws Exception {
        PMCOpcuaClient questo = new PMCOpcuaClient();
        questo.startClient("opc.tcp://127.0.0.1:62650/OPCUA/AMA_PMC_Server");
    }

    public void main1(String[] args) throws Exception {
        this.test();
        System.out.println(">>>>>>" + this.readValue(2, "Int32Array"));
        UaVariable variable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
        if (variable != null) {
            NodeId nId = variable.getDataTypeId();
            boolean isArray = variable.getValue().getValue().isArray();
            System.out.println(String.valueOf(nId.getValue().toString()) + "   " + this.opcuaUtils.getTypeIdString(nId) + "  array? " + isArray);
            System.out.println(this.client.readValue(this.nodeId).getValue().getArrayDimensions()[0]);
            System.out.println(variable.getValue().getValue().toString());
            System.out.println("getSourceTimestamp: " + variable.getValue().getSourceTimestamp().toString());
            System.out.println("getSourcePicoseconds: " + variable.getValue().getSourcePicoseconds().toString());
            System.out.println("getServerTimestamp: " + variable.getValue().getServerTimestamp().toString());
            System.out.println("getServerPicoseconds: " + variable.getValue().getServerPicoseconds().toString());
        } else {
            System.out.println("variable is null");
        }
        this.client.writeValue(this.nodeId, (Object)255);
        this.client.writeValue(new NodeId(2, "tstint16"), (Object)255);
        this.client.writeValue(new NodeId(2, "tstint32"), (Object)65255);
        this.client.writeValue(new NodeId(2, "tstint64"), (Object)255L);
        this.client.writeValue(new NodeId(2, "tstbyte"), (Object)new UnsignedByte(222));
        this.client.writeValue(new NodeId(2, "tstsbyte"), (Object)-123);
        byte[] pippo = new byte[]{-128, -100, 5, 127, 127};
        this.client.writeValue(new NodeId(2, "tstbytestring"), (Object)pippo);
        this.client.writeValue(new NodeId(2, "tstuint16"), (Object)UnsignedShort.valueOf((int)2346));
        this.client.writeValue(new NodeId(2, "tstuint32"), (Object)UnsignedInteger.valueOf((long)2346L));
        this.client.writeValue(new NodeId(2, "tstuint64"), (Object)UnsignedLong.valueOf((long)2346L));
        this.client.writeValue(new NodeId(2, "tststring"), (Object)"pippo");
        this.client.writeValue(new NodeId(2, "tstdouble"), (Object)2346.0);
        this.client.writeValue(new NodeId(2, "tstfloat"), (Object)Float.valueOf(2346.0f));
        DataValue value = this.client.readValue(Identifiers.Server_ServerStatus_State);
        System.out.println(value);
    }

    protected void initialize(UaClient client) throws SecureIdentityException, IOException, UnknownHostException {
        ApplicationDescription appDescription = new ApplicationDescription();
        appDescription.setApplicationName(new LocalizedText("PMC_OpcuaClient", Locale.ENGLISH));
        appDescription.setApplicationUri("urn:localhost:UA:PMC_OpcuaClient");
        appDescription.setProductUri("urn:ASTRI-MiniArray.com:UA:PMC_OpcuaClient");
        appDescription.setApplicationType(ApplicationType.Client);
        ApplicationIdentity identity = new ApplicationIdentity();
        identity.setApplicationDescription(appDescription);
        client.setApplicationIdentity(identity);
    }

    public void stopClient() {
        try {
            this.client.removeSubscription(this.subscription);
            this.stopMonitoring();
            System.out.println("\nWS_OpcuaClient STOPPED!!");
        }
        catch (ServiceException | StatusException e) {
            System.out.println("ERROR stopClient: " + e.getMessage());
        }
        this.client.disconnect();
    }

    public NodeId getNodeId(String nId) {
        int idx;
        int ns = 0;
        String nodeName = nId;
        String displayedName = null;
        if (nodeName.contains("=") & nodeName.contains(";") && nodeName.indexOf("=", (idx = nodeName.indexOf("=", 0)) + 1) > 0) {
            ns = Integer.parseInt(nodeName.substring(nodeName.indexOf("=") + 1, nodeName.indexOf(";")).trim());
            displayedName = nodeName.substring(nodeName.lastIndexOf("=") + 1).trim();
            if (ns <= 0) {
                return null;
            }
            if (displayedName == null || displayedName.isEmpty()) {
                return null;
            }
        }
        return new NodeId(ns, displayedName);
    }

    private void createSubscription() throws ServiceException, StatusException {
        if (this.subscription == null) {
            this.subscription = new Subscription();
            this.subscription.setPublishingInterval(1000.0);
            this.subscription.addAliveListener(this.subscriptionAliveListener);
            this.subscription.addNotificationListener(this.subscriptionListener);
            this.subscription.setLifetimeCount(60L);
            this.subscription.setMaxKeepAliveCount(20L);
            this.subscription.setMaxNotificationsPerPublish(0L);
            this.subscription.setPriority(0);
        }
        if (!this.client.hasSubscription(this.subscription.getSubscriptionId())) {
            this.client.addSubscription(this.subscription);
        }
    }

    protected UnsignedInteger addMonitoredDataPoint(MonitoredDataItem item) throws ServiceException, StatusException {
        if (this.client.hasSubscription(this.subscription.getSubscriptionId())) {
            this.subscription.addItem((MonitoredItem)item);
            UnsignedInteger monId = item.getMonitoredItemId();
            return monId;
        }
        return null;
    }

    protected void startMonitoring() throws ServiceException, StatusException {
        this.subscription.setPublishingEnabled(true);
    }

    protected void stopMonitoring() throws ServiceException, StatusException {
        try {
            this.subscription.setPublishingEnabled(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public boolean getDeviceLinkStatus() {
        return this.deviceLinkStatus;
    }

    public void setDeviceLinkStatus(boolean deviceLinkStatus) {
        this.deviceLinkStatus = deviceLinkStatus;
    }

    public void readFile(File localFile, FileTypeImpl fileType) throws ServiceException, StatusException, IOException, AddressSpaceException {
        NodeId fNode = new NodeId(4, ".\\conf\\newImageTest2.fits");
        UaNode f1 = this.client.getAddressSpace().getNode(fNode);
        System.out.println(">>" + f1.getNodeId().toString());
        fileType = new FileTypeImpl(this.client.getAddressSpace(), fNode, null, null);
        DataValue f2 = this.getDataValue("ns=4;s=.\\conf\\newImageTest2.fits");
        fileType.getSize().longValue();
        localFile = new File("./conf/test.test");
        System.out.println("readFile: {" + fileType.getBrowseName() + "} local={" + localFile + "}");
        long size = 12588480L;
        DateTime timestamp = fileType.getTimestamp();
        UnsignedInteger fileHandle = fileType.open(new FileTypeOpenMode[]{FileTypeOpenMode.Read});
        FileOutputStream fos = new FileOutputStream(localFile, false);
        try {
            int actualBlockSize = this.client.getEndpointConfiguration().getMaxByteStringLength() / 2;
            byte[] buff = new byte[actualBlockSize];
            long p = 0L;
            while (p < size) {
                fos.write(buff);
                p += (long)actualBlockSize;
            }
        }
        finally {
            fos.close();
            fileType.close(fileHandle);
        }
        localFile.setLastModified(timestamp.getTimeInMillis());
    }

    public DataValue[] readHistory(String nodeName) throws ServiceException, StatusException, AddressSpaceException {
        this.nodeId = this.getNodeId(nodeName);
        UaNode node = this.client.getAddressSpace().getNode(this.nodeId);
        DataValue[] values = null;
        if (node instanceof UaVariable) {
            UaVariable variable = (UaVariable)node;
            if (!variable.getHistorizing().booleanValue()) {
                AIV_GUI.writeOnInfoText("\n The variable " + variable.getBrowseName() + " does not have history");
                return null;
            }
            int action = 0;
            try {
                DateTime endTime = DateTime.currentTime();
                DateTime startTime = new DateTime((endTime.getMilliSeconds() - 3600000L) * 10000L);
                switch (action) {
                    case 0: {
                        values = this.client.historyReadRaw(this.nodeId, startTime, endTime, UnsignedInteger.ONE, Boolean.valueOf(true), null, TimestampsToReturn.Source);
                        if (values != null) {
                            AIV_GUI.writeOnInfoText("\n History of variable " + variable.getBrowseName() + " between " + startTime + " and " + endTime + " found:" + values.length + " values");
                            break;
                        }
                        AIV_GUI.writeOnInfoText("\n History of variable " + variable.getBrowseName() + " between " + startTime + " and " + endTime + " NO values found");
                        break;
                    }
                    case 1: {
                        System.out.println("at " + startTime + " and " + endTime);
                        DateTime[] reqTimes = new DateTime[]{startTime, endTime};
                        values = this.client.historyReadAtTimes(this.nodeId, reqTimes, null, TimestampsToReturn.Source);
                        break;
                    }
                    case 2: {
                        System.out.println("at " + startTime + " and " + endTime);
                        values = this.client.historyReadProcessed(this.nodeId, startTime, endTime, Double.valueOf(60000.0), Identifiers.AggregateFunction_Average, null, null, TimestampsToReturn.Source);
                    }
                }
                double[] dbl = new double[values.length];
                int ix = 0;
                while (ix < values.length) {
                    dbl[ix] = values[ix].getValue().doubleValue();
                    ++ix;
                }
            }
            catch (Exception e) {
                System.out.println("readHistory error: " + e.getMessage());
            }
        } else {
            AIV_GUI.writeOnInfoText("\n History is only available for object and variable nodes. The current node is a " + node.getNodeClass() + ".");
        }
        return values;
    }
}

