/*
 * Decompiled with CFR 0.152.
 */
package pmc.client;

import client.OpcuaUtils;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.ServerListException;
import gui.AIV_GUI;
import gui.CombinedCooErrorPlots;
import gui.CombinedCooPlotsCentroidAndMaxValue;
import gui.CombinedLineColumnPlots;
import gui.DataInputForm;
import gui.HistoryPlot;
import gui.OpcuaNodesGrid;
import gui.ShowAllimages;
import gui.ShowFullImage;
import gui.XYPointDispersion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import myproc.ErrorForm;
import myproc.GetFile;
import myproc.NomTamFits;
import myproc.Utils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;
import pmc.client.PMCICD;
import pmc.client.PMCOpcuaClient;

public class PMCGUI {
    public static ShowFullImage showFullImage = new ShowFullImage("PMC show image for ASTRI-MiniArray project");
    public JFrame frmPmcGui;
    public static int infoTextLineNumbers;
    public JLabel LabelCoordinate = new JLabel("---");
    public static JRadioButton ds9RadioButton;
    public static NomTamFits nomTamFits;
    public static JLabel lblZfact;
    public XYPointDispersion xyPointDispersion = new XYPointDispersion();
    public CombinedCooPlotsCentroidAndMaxValue combinedCooPlotsCentroidAndMaxValue = new CombinedCooPlotsCentroidAndMaxValue("");
    public static CombinedCooErrorPlots combinedCooErrorPlots;
    public static CombinedLineColumnPlots combinedLineColumnPlots;
    public static HistoryPlot historyPlot;
    public static Scrollbar minVal_scrollbar;
    public static Scrollbar maxVal_scrollbar;
    private JScrollPane scrollPane = new JScrollPane();
    public static JTextField textImageName;
    public static JFileChooser fileChooser;
    public static DataInputForm pmcDataInputForm;
    public static JLabel zStrechLabel;
    public static PMCOpcuaClient workOpcuaClient;
    static OpcuaUtils opcuaUtils;
    public static PMCICD pmcICD;
    public ErrorForm errorForm;
    private JTree tree;
    private JMenuItem loadEConnExcelMenuItem = new JMenuItem("Load&Connect");
    public JMenuItem exitMenuItem = new JMenuItem("Exit");
    private JMenuItem loadFitsMenuItem = new JMenuItem("LoadFits");
    JLabel tazLabel = new JLabel("");
    public OpcuaNodesGrid opcuaNodesGrid;
    public OpcuaNodesGrid discoveryNodeGrid;
    public static ShowAllimages showAllImages;
    private GetFile getFile;
    public static JCheckBox cross1CheckBox;
    public static JCheckBox cross2CheckBox;
    public static JButton saveReferenceButton;
    public static int[] crossReference1;
    public static int[] crossReference2;
    public static int[] areaReference;
    public static int[] plotMouseCoo;
    public ArrayList<int[]> centroidArray = new ArrayList();
    public ArrayList<int[]> maxValueArray = new ArrayList();
    public JTextField tExposureField = new JTextField();
    public JCheckBox lineColumnPlotsCheckBox = new JCheckBox("PlotsLine&Column");
    public static JComboBox zoomFactorComboBox;
    public static JTextArea infoTextArea;
    JLabel astriLabel = new JLabel("ASTRI_");
    Thread threadEnd = new Thread(() -> {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                    System.exit(0);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    });
    public static boolean showCrossReferenceFlag;
    private Thread showCrossReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (!showCrossReferenceFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showCrossReferenceFlag = false;
                        Graphics2D g2 = (Graphics2D)imageLabel.getGraphics();
                        if (g2 == null) {
                            return;
                        }
                        int Xc = crossReference1[0];
                        int Yc = crossReference1[1];
                        g2.setStroke(new BasicStroke(2.0f));
                        if (Xc >= 0 & Yc >= 0) {
                            g2.setColor(Color.yellow);
                            g2.draw(new Line2D.Double(Xc, Yc - 10, Xc, Yc + 10));
                            g2.draw(new Line2D.Double(Xc - 10, Yc, Xc + 10, Yc));
                        }
                        if ((Xc = crossReference2[0]) >= 0 & (Yc = crossReference2[1]) >= 0) {
                            g2.setColor(Color.green);
                            g2.draw(new Line2D.Double(Xc, Yc - 10, Xc, Yc + 10));
                            g2.draw(new Line2D.Double(Xc - 10, Yc, Xc + 10, Yc));
                        }
                        Xc = areaReference[0];
                        Yc = areaReference[1];
                        int Xc1 = areaReference[2];
                        int Yc1 = areaReference[3];
                        if (Xc >= 0 & Xc1 >= 0) {
                            int[] centroid;
                            g2.setColor(Color.magenta);
                            int change = 0;
                            if (Xc1 < Xc) {
                                change = Xc;
                                Xc = Xc1;
                                Xc1 = change;
                            }
                            if (Yc1 < Yc) {
                                change = Yc;
                                Yc = Yc1;
                                Yc1 = change;
                            }
                            int width = Xc1 - Xc;
                            int height = Yc1 - Yc;
                            g2.draw(new RoundRectangle2D.Double(Xc, Yc, width, height, 5.0, 5.0));
                            if (PMCGUI.this.centroidCheckItem.getState()) {
                                centroid = nomTamFits.getCentroid(Xc, Xc1, Yc, Yc1);
                            } else {
                                centroid = nomTamFits.getMaxValue(Xc, Xc1, Yc, Yc1);
                                AIV_GUI.writeOnInfoText("MaxValue = " + centroid[2] + "\n");
                            }
                            if (centroid[0] >= 0 & centroid[1] >= 0) {
                                AIV_GUI.writeOnInfoText("Centroid Coo Xcm= " + centroid[0] + "Ycm= " + centroid[1] + "\n");
                                g2.draw(new Line2D.Double(centroid[0], centroid[1] - 10, centroid[0], centroid[1] + 10));
                                g2.draw(new Line2D.Double(centroid[0] - 10, centroid[1], centroid[0] + 10, centroid[1]));
                            }
                            g2.setColor(Color.white);
                            if (centroid[0] >= 0 & centroid[1] >= 0) {
                                if (PMCGUI.this.centroidArray.size() == 0) {
                                    PMCGUI.this.centroidArray.add(nomTamFits.getCentroid(Xc, Xc1, Yc, Yc1));
                                    XYPointDispersion.centroidSeries.add((double)PMCGUI.this.centroidArray.get(0)[0], (double)PMCGUI.this.centroidArray.get(0)[1]);
                                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xCentroidSeries.add(0.0, (double)PMCGUI.this.centroidArray.get(0)[0]);
                                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yCentroidSeries.add(0.0, (double)PMCGUI.this.centroidArray.get(0)[1]);
                                    PMCGUI.this.maxValueArray.add(nomTamFits.getMaxValue(Xc, Xc1, Yc, Yc1));
                                    XYPointDispersion.maxValueSeries.add((double)PMCGUI.this.maxValueArray.get(0)[0], (double)PMCGUI.this.maxValueArray.get(0)[1]);
                                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xMaxValueSeries.add(0.0, (double)PMCGUI.this.maxValueArray.get(0)[0]);
                                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yMaxValueSeries.add(0.0, (double)PMCGUI.this.maxValueArray.get(0)[1]);
                                } else {
                                    int ix;
                                    int[] i1;
                                    if (PMCGUI.this.centroidCheckItem.getState() & PMCGUI.this.centroidArray.get(PMCGUI.this.centroidArray.size() - 1)[0] != centroid[0] & PMCGUI.this.centroidArray.get(PMCGUI.this.centroidArray.size() - 1)[1] != centroid[1]) {
                                        PMCGUI.this.centroidArray.add(centroid);
                                        XYPointDispersion.centroidSeries.add((double)centroid[0], (double)centroid[1]);
                                        i1 = nomTamFits.getMaxValue(Xc, Xc1, Yc, Yc1);
                                        PMCGUI.this.maxValueArray.add(i1);
                                        XYPointDispersion.maxValueSeries.add((double)i1[0], (double)i1[1]);
                                        ix = 0;
                                        while (ix < PMCGUI.this.centroidArray.size() - 1) {
                                            g2.draw(new Line2D.Double(centroid[0], centroid[1] - 5, centroid[0], centroid[1] + 5));
                                            g2.draw(new Line2D.Double(centroid[0] - 5, centroid[1], centroid[0] + 5, centroid[1]));
                                            ++ix;
                                        }
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xCentroidSeries.add((double)(PMCGUI.this.centroidArray.size() + 1), (double)centroid[0]);
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yCentroidSeries.add((double)(PMCGUI.this.centroidArray.size() + 1), (double)centroid[1]);
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xMaxValueSeries.add((double)(PMCGUI.this.maxValueArray.size() + 1), (double)i1[0]);
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yMaxValueSeries.add((double)(PMCGUI.this.maxValueArray.size() + 1), (double)i1[1]);
                                    }
                                    if (PMCGUI.this.maxValueCheckItem.getState() & PMCGUI.this.maxValueArray.get(PMCGUI.this.maxValueArray.size() - 1)[0] != centroid[0] & PMCGUI.this.maxValueArray.get(PMCGUI.this.maxValueArray.size() - 1)[1] != centroid[1]) {
                                        PMCGUI.this.maxValueArray.add(centroid);
                                        XYPointDispersion.maxValueSeries.add((double)centroid[0], (double)centroid[1]);
                                        i1 = nomTamFits.getCentroid(Xc, Xc1, Yc, Yc1);
                                        PMCGUI.this.centroidArray.add(i1);
                                        XYPointDispersion.centroidSeries.add((double)i1[0], (double)i1[1]);
                                        ix = 0;
                                        while (ix < PMCGUI.this.maxValueArray.size() - 1) {
                                            g2.draw(new Line2D.Double(centroid[0], centroid[1] - 5, centroid[0], centroid[1] + 5));
                                            g2.draw(new Line2D.Double(centroid[0] - 5, centroid[1], centroid[0] + 5, centroid[1]));
                                            ++ix;
                                        }
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xMaxValueSeries.add((double)(PMCGUI.this.maxValueArray.size() + 1), (double)centroid[0]);
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yMaxValueSeries.add((double)(PMCGUI.this.maxValueArray.size() + 1), (double)centroid[1]);
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xCentroidSeries.add((double)(PMCGUI.this.centroidArray.size() + 1), (double)i1[0]);
                                        PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yCentroidSeries.add((double)(PMCGUI.this.centroidArray.size() + 1), (double)i1[1]);
                                    }
                                }
                            }
                        }
                        if (!PMCGUI.this.lineColumnPlotsCheckBox.isSelected()) continue;
                        g2.setStroke(new BasicStroke(1.0f));
                        Xc = plotMouseCoo[0];
                        if (!(Xc != -1 & (Yc = plotMouseCoo[1]) != -1)) continue;
                        g2.setColor(Color.WHITE);
                        g2.draw(new Line2D.Double(0.0, Yc, imageLabel.getWidth(), Yc));
                        g2.draw(new Line2D.Double(Xc, 0.0, Xc, imageLabel.getHeight()));
                    }
                }
                catch (Exception e) {
                    AIV_GUI.writeOnInfoText("Thread showCrossReferenceThread: " + e.getMessage() + "\n");
                    continue;
                }
                break;
            }
        }
    };
    public static boolean opcuaStartReadThread;
    public static int opcuaShowNodeTypeOnGrid;
    private Thread opcuaNodeThread = new Thread(){

        @Override
        public synchronized void run() {
            int showCmdValue = opcuaShowNodeTypeOnGrid;
            while (true) {
                try {
                    while (true) {
                        if (!opcuaStartReadThread) {
                            Thread.sleep(300L);
                            continue;
                        }
                        opcuaStartReadThread = false;
                        String[] colNames = new String[]{"opcua-NodeName", "ACS name", "Value", "nodeType", "description", "ServerTStamp", "SourceTStamp", "StatusCode"};
                        AIV_GUI.writeOnInfoText("\n reading nodes...  ");
                        DataValue datValue = null;
                        Object[][] dataTable = null;
                        int noOfNodes = 0;
                        switch (opcuaShowNodeTypeOnGrid) {
                            case 1: {
                                dataTable = new Object[PMCGUI.pmcICD.get_NodeName_List.size()][colNames.length];
                                noOfNodes = PMCGUI.pmcICD.get_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = workOpcuaClient.getDataValue(PMCGUI.pmcICD.get_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = PMCGUI.pmcICD.get_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.get_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = workOpcuaClient.getNodeType(PMCGUI.pmcICD.get_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = PMCGUI.pmcICD.get_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = PMCGUI.pmcICD.get_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.get_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = PMCGUI.pmcICD.get_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + PMCGUI.pmcICD.get_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 2: {
                                dataTable = new Object[PMCGUI.pmcICD.set_NodeName_List.size()][colNames.length];
                                noOfNodes = PMCGUI.pmcICD.set_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = workOpcuaClient.getDataValue(PMCGUI.pmcICD.set_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = PMCGUI.pmcICD.set_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.set_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = workOpcuaClient.getNodeType(PMCGUI.pmcICD.set_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = PMCGUI.pmcICD.set_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = PMCGUI.pmcICD.set_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.set_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = PMCGUI.pmcICD.set_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + PMCGUI.pmcICD.set_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 3: {
                                dataTable = new Object[PMCGUI.pmcICD.cmd_NodeName_List.size()][colNames.length];
                                noOfNodes = PMCGUI.pmcICD.cmd_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = workOpcuaClient.getDataValue(PMCGUI.pmcICD.cmd_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = PMCGUI.pmcICD.cmd_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.cmd_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = workOpcuaClient.getNodeType(PMCGUI.pmcICD.cmd_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = PMCGUI.pmcICD.cmd_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = PMCGUI.pmcICD.cmd_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.cmd_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = PMCGUI.pmcICD.cmd_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + PMCGUI.pmcICD.cmd_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 4: {
                                dataTable = new Object[PMCGUI.pmcICD.mode_NodeName_List.size()][colNames.length];
                                noOfNodes = PMCGUI.pmcICD.mode_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = workOpcuaClient.getDataValue(PMCGUI.pmcICD.mode_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = PMCGUI.pmcICD.mode_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.mode_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = workOpcuaClient.getNodeType(PMCGUI.pmcICD.mode_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = PMCGUI.pmcICD.mode_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = PMCGUI.pmcICD.mode_NodeName_List.get(ii);
                                        dataTable[ii][1] = PMCGUI.pmcICD.mode_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = PMCGUI.pmcICD.mode_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + PMCGUI.pmcICD.mode_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                        }
                        if (PMCGUI.this.opcuaNodesGrid == null) {
                            PMCGUI.this.opcuaNodesGrid = new OpcuaNodesGrid(colNames, dataTable, "server", PMCGUI.workOpcuaClient.client);
                        } else if (showCmdValue != opcuaShowNodeTypeOnGrid) {
                            showCmdValue = opcuaShowNodeTypeOnGrid;
                            PMCGUI.this.opcuaNodesGrid.setUpTableData(dataTable);
                        }
                        int idx = 0;
                        while (idx < noOfNodes) {
                            PMCGUI.this.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][2], idx, 2);
                            PMCGUI.this.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][5], idx, 5);
                            PMCGUI.this.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][6], idx, 6);
                            PMCGUI.this.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][7], idx, 7);
                            ++idx;
                        }
                        PMCGUI.this.opcuaNodesGrid.nodeTable.repaint();
                        PMCGUI.this.opcuaNodesGrid.frame.setVisible(true);
                    }
                }
                catch (InterruptedException e) {
                    AIV_GUI.writeOnInfoText("Exception: error reading opcua node:" + e.getMessage());
                    continue;
                }
                break;
            }
        }
    };
    public static boolean discoveryStartReadThread;
    private Thread discoveryNodeThread = new Thread(){

        @Override
        public synchronized void run() {
            String[] colNames = new String[]{" N.", " Name ", " Type ", " Product ", "ApplicationUri", "    Url     "};
            Object[][] dataTable = null;
            while (true) {
                try {
                    while (!discoveryStartReadThread) {
                        Thread.sleep(300L);
                    }
                    discoveryStartReadThread = false;
                    dataTable = Utils.getDiscoverTable(Utils.discoveryServerUrl);
                    if (PMCGUI.this.discoveryNodeGrid == null) {
                        PMCGUI.this.discoveryNodeGrid = new OpcuaNodesGrid(colNames, dataTable, "discovery", null);
                    } else {
                        int idx = 0;
                        while (idx < dataTable.length) {
                            PMCGUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][1], idx, 1);
                            PMCGUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][2], idx, 2);
                            PMCGUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][3], idx, 3);
                            PMCGUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][4], idx, 4);
                            PMCGUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][5], idx, 5);
                            ++idx;
                        }
                    }
                }
                catch (ServerListException | InterruptedException e) {
                    AIV_GUI.writeOnInfoText("Exception: error reading discovery server nodes:" + e.getMessage());
                }
                PMCGUI.this.discoveryNodeGrid.nodeTable.repaint();
                PMCGUI.this.discoveryNodeGrid.frame.setVisible(true);
            }
        }
    };
    private final JMenu icdMenu = new JMenu("ICD");
    private final JMenuItem showNodesMenuItem = new JMenuItem("ShowAllNode");
    private final JMenuItem viewAllMenuItem = new JMenuItem("ViewAllDevices");
    private ButtonGroup pmcRadioGroup = new ButtonGroup();
    public final JCheckBox historyCheckBox = new JCheckBox("PlotNodeHistory");
    public static JLabel imageLabel;
    private static Logger logger;
    private final JCheckBox areaCheckBox = new JCheckBox("Area");
    private final JLabel ledLabel0 = new JLabel("\u2022");
    private final JLabel statusLabel0 = new JLabel("Not connected");
    public Thread getWorkServerStatusThread = new Thread(){

        @Override
        public synchronized void run() {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            block11: while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!PMCGUI.workOpcuaClient.client.isConnected()) continue;
                switch (workOpcuaClient.getDataValue("ns=2;s=pmc_status").getValue().intValue()) {
                    case 0: {
                        PMCGUI.this.ledLabel0.setForeground(new Color(125, 255, 125));
                        PMCGUI.this.statusLabel0.setForeground(new Color(125, 255, 125));
                        PMCGUI.this.statusLabel0.setText("OnLine");
                        continue block11;
                    }
                    case 1: {
                        PMCGUI.this.ledLabel0.setForeground(Color.yellow);
                        PMCGUI.this.statusLabel0.setForeground(Color.yellow);
                        PMCGUI.this.statusLabel0.setText("StandBy");
                        continue block11;
                    }
                    case 2: {
                        PMCGUI.this.ledLabel0.setForeground(Color.green);
                        PMCGUI.this.statusLabel0.setForeground(Color.green);
                        PMCGUI.this.statusLabel0.setText("OnLine");
                        continue block11;
                    }
                    case 3: {
                        PMCGUI.this.ledLabel0.setForeground(Color.pink);
                        PMCGUI.this.statusLabel0.setForeground(Color.pink);
                        PMCGUI.this.statusLabel0.setText("Busy");
                        continue block11;
                    }
                    case 7: {
                        PMCGUI.this.ledLabel0.setForeground(Color.red);
                        PMCGUI.this.statusLabel0.setForeground(Color.red);
                        PMCGUI.this.statusLabel0.setText("Fault");
                        continue block11;
                    }
                }
                PMCGUI.this.ledLabel0.setForeground(Color.black);
                PMCGUI.this.statusLabel0.setForeground(Color.black);
                PMCGUI.this.statusLabel0.setText("NotConnectd");
            }
        }
    };
    public boolean getLastImageThreadFlag = false;
    public String imageNameToGet = "";
    public Thread getLastImageThread = new Thread(){

        @Override
        public synchronized void run() {
            block4: while (true) {
                try {
                    boolean gf;
                    while (!PMCGUI.this.getLastImageThreadFlag) {
                        try {
                            Thread.sleep(500L);
                            continue block4;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AIV_GUI.writeOnInfoText("\n GetLastImage button pressed");
                    if (!PMCGUI.workOpcuaClient.client.isConnected()) {
                        AIV_GUI.writeOnInfoText(" OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
                        AIV_GUI.inserIconOnInfoText(15, Utils.badImageIcon);
                        return;
                    }
                    PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_clientportnumber"), (Object)9999);
                    PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_workimage"), (Object)PMCGUI.this.imageNameToGet);
                    PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_sendimage"), (Object)1);
                    PMCGUI.this.getFile = new GetFile();
                    String addr = clientAddres;
                    if (addr == null | addr == "") {
                        addr = "127.0.0.1";
                    }
                    if (gf = PMCGUI.this.getFile.receiveFile(addr, 9999, "./conf/")) {
                        AIV_GUI.writeOnInfoText("\n file transfer success..\n", Color.blue, true, false, false, false, 15);
                        nomTamFits.setNewFitsImage("./conf/image_" + Utils.telescopeNumber + ".fits");
                        showCrossReferenceFlag = true;
                    } else {
                        AIV_GUI.writeOnInfoText("\n file transfer ERROR..\n", Color.red, true, false, false, true, 15);
                    }
                }
                catch (ServiceException | StatusException | IOException e1) {
                    AIV_GUI.writeOnInfoText("\n file transfer ERROR.." + e1.getMessage() + "\n", Color.red, true, false, false, true, 15);
                }
                PMCGUI.this.getLastImageThreadFlag = false;
            }
        }
    };
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JCheckBoxMenuItem maxValueCheckItem = new JCheckBoxMenuItem("MaxValue");
    private final JCheckBoxMenuItem centroidCheckItem = new JCheckBoxMenuItem("Centroid");
    private final JPopupMenu popupImageMenu = new JPopupMenu();
    private final JScrollPane scrollPane_1 = new JScrollPane();
    private final JMenuItem consolleMenuItem = new JMenuItem("Consolle");
    public static String clientAddres;
    private JTextField delayTimeTextField;
    private JCheckBox doAstrometrychckbx = new JCheckBox("DoAstrometry");
    private JCheckBox doFitsCheckBox = new JCheckBox("DoFits");
    private JCheckBox doPngCheckBox = new JCheckBox("DoPNG");
    private JCheckBox continousCheckBox = new JCheckBox("Continous");
    public JCheckBox autoDetectCheckItem = new JCheckBox("AutoLoadImg");
    public JLabel errorNoLabel = new JLabel("ErrorNo=");
    private final JPanel contPanel = new JPanel();
    public JLabel heartbeatLabel = new JLabel(" 0 ");

    static {
        ds9RadioButton = new JRadioButton("DS9");
        nomTamFits = new NomTamFits(null);
        lblZfact = new JLabel("Zfact: " + PMCGUI.nomTamFits.xFactor + " * " + PMCGUI.nomTamFits.yFactor);
        combinedCooErrorPlots = new CombinedCooErrorPlots("Errors Plot");
        combinedLineColumnPlots = new CombinedLineColumnPlots("Plots Line & Column");
        historyPlot = new HistoryPlot();
        minVal_scrollbar = new Scrollbar();
        maxVal_scrollbar = new Scrollbar();
        fileChooser = new JFileChooser();
        pmcDataInputForm = new DataInputForm("PMC");
        zStrechLabel = new JLabel("zStrech:");
        workOpcuaClient = new PMCOpcuaClient();
        opcuaUtils = new OpcuaUtils();
        showAllImages = new ShowAllimages();
        cross1CheckBox = new JCheckBox("Ref1");
        cross2CheckBox = new JCheckBox("Ref2");
        saveReferenceButton = new JButton("Save");
        crossReference1 = new int[]{-1, -1};
        crossReference2 = new int[]{-1, -1};
        areaReference = new int[]{-1, -1, -1, -1};
        plotMouseCoo = new int[]{-1, -1};
        zoomFactorComboBox = new JComboBox();
        infoTextArea = new JTextArea();
        showCrossReferenceFlag = false;
        opcuaStartReadThread = false;
        opcuaShowNodeTypeOnGrid = 1;
        discoveryStartReadThread = false;
        imageLabel = new JLabel("");
        logger = Logger.getLogger(PMCGUI.class);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AIV_GUI.consolle.setVisible(true);
                    PMCGUI window = new PMCGUI();
                    window.frmPmcGui.setVisible(true);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
    }

    public void setOpcuaStartReadThread(boolean opcuaStartReadThread) {
        PMCGUI.opcuaStartReadThread = opcuaStartReadThread;
    }

    public PMCGUI() throws Exception {
        try {
            PropertyConfigurator.configure((String)"./conf/log4j.properties");
        }
        catch (Exception FileNotFoundException2) {
            System.out.println("file log4j.properties not found..." + FileNotFoundException2.getMessage());
        }
        Utils.getProperties();
        Utils.getWorkReference();
        this.startClient();
        this.opcuaNodeThread.start();
        this.discoveryNodeThread.start();
        this.showCrossReferenceThread.start();
        this.getWorkServerStatusThread.start();
        this.getLastImageThread.start();
        this.errorForm = new ErrorForm("PMC" + String.valueOf(Utils.telescopeNumber), "pmc_error_index", "pmc_error_info", "pmc_error_reset", 2, PMCGUI.workOpcuaClient.client, "pmc_error_information", "pmc_error_number");
        this.initialize();
    }

    public void startClient() {
        try {
            pmcICD = new PMCICD();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        clientAddres = Utils.pmcURLs[Utils.telescopeNumber - 1].substring(Utils.pmcURLs[Utils.telescopeNumber - 1].indexOf("//") + 2, Utils.pmcURLs[Utils.telescopeNumber - 1].lastIndexOf(":"));
        workOpcuaClient.startClient(Utils.pmcURLs[Utils.telescopeNumber - 1]);
        AIV_GUI.writeOnInfoText("\n");
        if (PMCGUI.workOpcuaClient.client.isConnected()) {
            AIV_GUI.writeOnInfoText("OPCUA server is connected", Color.BLACK, true, false, false, false, 12);
            AIV_GUI.inserIconOnInfoText(20, Utils.happyImageIcon);
            AIV_GUI.writeOnInfoText("\n");
        } else {
            AIV_GUI.writeOnInfoText("OPCUA server is NOT connected", Color.red, true, false, true, true, 15);
            AIV_GUI.inserIconOnInfoText(20, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText("\n");
        }
    }

    private void initialize() throws Exception {
        this.frmPmcGui = new JFrame();
        this.frmPmcGui.getContentPane().setFont(new Font("SansSerif", 1, 10));
        this.frmPmcGui.setFont(new Font("Dialog", 1, 11));
        this.frmPmcGui.getContentPane().setBounds(new Rectangle(0, 50, 0, 0));
        this.frmPmcGui.getContentPane().setBackground(new Color(245, 222, 179));
        this.frmPmcGui.setIconImage(Toolkit.getDefaultToolkit().getImage("./conf/Camera.jpg"));
        this.frmPmcGui.setResizable(false);
        this.frmPmcGui.setTitle("PMCGUI - v0.9 - PBr110122 for ASTRI-MiniArray Project ");
        this.frmPmcGui.setForeground(new Color(245, 222, 179));
        this.frmPmcGui.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PMCGUI.this.thatsAllFolks();
                PMCGUI.this.setVisible(false);
            }
        });
        this.frmPmcGui.setBounds(100, 100, 982, 694);
        this.frmPmcGui.setDefaultCloseOperation(0);
        this.frmPmcGui.getContentPane().setLayout(null);
        ds9RadioButton.setToolTipText("show image on DS9");
        this.astriLabel.setText("ASTRI_" + Utils.telescopeNumber);
        this.xyPointDispersion.setVisible(false);
        ds9RadioButton.setBounds(126, 358, 63, 21);
        this.frmPmcGui.getContentPane().add(ds9RadioButton);
        this.scrollPane.setBounds(0, 5, 189, 293);
        this.frmPmcGui.getContentPane().add(this.scrollPane);
        this.tree = new JTree();
        this.tree.setScrollsOnExpand(false);
        this.tree.setName("PMCtree");
        this.scrollPane.setViewportView(this.tree);
        this.tree.setBackground(new Color(255, 255, 204));
        this.tree.setFont(new Font("SansSerif", 0, 10));
        this.tree.setForeground(Color.lightGray);
        this.treeSetModel();
        this.tree.setToolTipText("this is my tree...");
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath tp = PMCGUI.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp.getPath().length == 3) {
                    PMCGUI.this.jtreeToOpcua(tp.getPath()[1].toString(), tp.getPath()[2].toString());
                }
            }
        });
        this.LabelCoordinate.setForeground(new Color(0, 0, 0));
        this.LabelCoordinate.setToolTipText("X,Y,Z value");
        this.LabelCoordinate.setHorizontalAlignment(0);
        this.LabelCoordinate.setBackground(new Color(204, 255, 204));
        this.LabelCoordinate.setFont(new Font("Tahoma", 1, 10));
        this.LabelCoordinate.setBounds(788, 528, 170, 14);
        this.frmPmcGui.getContentPane().add(this.LabelCoordinate);
        JButton testButton = new JButton("....");
        testButton.setVisible(false);
        testButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point x = imageLabel.getMousePosition();
                Rectangle box = new Rectangle(200, 200, 20, 20);
                Graphics g = imageLabel.getGraphics();
                g.setColor(Color.red);
                g.drawRect(10, 10, 20, 20);
                g.setColor(Color.blue);
                g.drawLine(0, 0, 200, 300);
                g.drawLine(10, 10, 400, 300);
                Font font = new Font("Serif", 0, 24);
                g.setFont(font);
                GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
                Graphics2D g2 = (Graphics2D)imageLabel.getGraphics();
                int Xc = 100;
                int Yc = 100;
                g.drawString("TutorialsPoint " + Xc + "*" + Yc, 50, 150);
                g2.setColor(Color.white);
                g2.setStroke(new BasicStroke(2.0f));
                g2.draw(new Line2D.Double(Xc, Yc - 10, Xc, Yc + 10));
                g2.setStroke(new BasicStroke(10.0f));
                g2.draw(new Line2D.Double(Xc - 10, Yc, Xc + 10, Yc));
            }
        });
        imageLabel.setHorizontalAlignment(2);
        imageLabel.setBorder(new BevelBorder(1, new Color(64, 64, 64), null, null, null));
        imageLabel.setBackground(Color.GRAY);
        imageLabel.setIconTextGap(0);
        imageLabel.setVerticalTextPosition(1);
        imageLabel.setVerticalAlignment(1);
        imageLabel.setCursor(Cursor.getPredefinedCursor(0));
        imageLabel.setIgnoreRepaint(true);
        imageLabel.setIcon(new ImageIcon("./conf/astriIcon.jpg"));
        imageLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point x = imageLabel.getMousePosition();
                try {
                    PMCGUI.this.LabelCoordinate.setText("x=" + (float)x.x * PMCGUI.nomTamFits.xFactor + " - y=" + (float)x.y * PMCGUI.nomTamFits.yFactor + " - z=" + nomTamFits.getPixelValue((int)((float)x.y * PMCGUI.nomTamFits.yFactor), (int)((float)x.x * PMCGUI.nomTamFits.xFactor)));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point x = imageLabel.getMousePosition();
                AIV_GUI.writeOnInfoText("x=" + (float)x.x * PMCGUI.nomTamFits.xFactor + "  y=" + (float)x.y * PMCGUI.nomTamFits.yFactor + "  z=:" + nomTamFits.getPixelValue((int)((float)x.y * PMCGUI.nomTamFits.yFactor), (int)((float)x.x * PMCGUI.nomTamFits.xFactor)) + "  (" + e.getX() + "-" + e.getY() + ")" + "\n");
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point x = imageLabel.getMousePosition();
                if (cross1CheckBox.isSelected()) {
                    PMCGUI.crossReference1[0] = x.x;
                    PMCGUI.crossReference1[1] = x.y;
                    Utils.saveProperties("crossReference1_0", String.valueOf(String.valueOf(crossReference1[0])) + "," + String.valueOf(crossReference1[1]));
                    cross1CheckBox.setBackground(Color.yellow);
                }
                if (PMCGUI.this.areaCheckBox.isSelected()) {
                    PMCGUI.areaReference[0] = x.x;
                    PMCGUI.areaReference[1] = x.y;
                    PMCGUI.areaReference[2] = -1;
                    PMCGUI.areaReference[3] = -1;
                    PMCGUI.this.centroidArray.clear();
                    PMCGUI.this.maxValueArray.clear();
                    XYPointDispersion.centroidSeries.clear();
                    XYPointDispersion.maxValueSeries.clear();
                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xCentroidSeries.clear();
                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yCentroidSeries.clear();
                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.xMaxValueSeries.clear();
                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.yMaxValueSeries.clear();
                }
                nomTamFits.refreshImage();
                showCrossReferenceFlag = true;
                cross1CheckBox.setSelected(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point x = imageLabel.getMousePosition();
                if (cross2CheckBox.isSelected()) {
                    PMCGUI.crossReference2[0] = x.x;
                    PMCGUI.crossReference2[1] = x.y;
                    Utils.saveProperties("crossReference2_0", String.valueOf(String.valueOf(crossReference2[0])) + "," + String.valueOf(crossReference2[1]));
                    cross2CheckBox.setBackground(Color.green);
                    cross2CheckBox.setSelected(false);
                }
                if (PMCGUI.this.areaCheckBox.isSelected()) {
                    PMCGUI.areaReference[2] = x.x;
                    PMCGUI.areaReference[3] = x.y;
                    Utils.saveProperties("areaReference_0", String.valueOf(String.valueOf(areaReference[0])) + "," + String.valueOf(areaReference[1]) + "," + String.valueOf(areaReference[2]) + "," + String.valueOf(areaReference[3]));
                    PMCGUI.this.areaCheckBox.setBackground(Color.magenta);
                    PMCGUI.this.areaCheckBox.setSelected(false);
                }
                if (PMCGUI.this.lineColumnPlotsCheckBox.isSelected()) {
                    PMCGUI.plotMouseCoo[0] = x.x;
                    PMCGUI.plotMouseCoo[1] = x.y;
                    combinedLineColumnPlots.setVisible(true);
                    int[] line = nomTamFits.getLineValue((int)((float)x.y * PMCGUI.nomTamFits.yFactor), (int)((float)x.x * PMCGUI.nomTamFits.xFactor));
                    int[] col = nomTamFits.getColumnValue((int)((float)x.y * PMCGUI.nomTamFits.yFactor), (int)((float)x.x * PMCGUI.nomTamFits.xFactor));
                    if (line != null && col != null) {
                        PMCGUI.combinedLineColumnPlots.lineSeries.clear();
                        int ix = 0;
                        while (ix < line.length) {
                            PMCGUI.combinedLineColumnPlots.lineSeries.add((double)ix, (double)line[ix]);
                            ++ix;
                        }
                        PMCGUI.combinedLineColumnPlots.columnSeries.clear();
                        ix = 0;
                        while (ix < col.length) {
                            PMCGUI.combinedLineColumnPlots.columnSeries.add((double)ix, (double)col[ix]);
                            ++ix;
                        }
                    }
                }
                nomTamFits.refreshImage();
                showCrossReferenceFlag = true;
            }
        });
        imageLabel.setBounds(191, 5, 768, 512);
        this.frmPmcGui.getContentPane().add(imageLabel);
        PMCGUI.addPopup(imageLabel, this.popupImageMenu);
        JMenuItem mntmNewMenuItem_2 = new JMenuItem("XYPlotDispersion");
        mntmNewMenuItem_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    PMCGUI.this.xyPointDispersion.setVisible(true);
                }
            }
        });
        this.popupImageMenu.add(mntmNewMenuItem_2);
        JMenuItem mntmNewMenuItem_3 = new JMenuItem("CombinedCooPlotsCentroidAndMaxValue");
        mntmNewMenuItem_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    PMCGUI.this.combinedCooPlotsCentroidAndMaxValue.setVisible(true);
                }
            }
        });
        this.popupImageMenu.add(mntmNewMenuItem_3);
        JMenuItem mntmNewMenuItem_4 = new JMenuItem("CombinedCooErrorPlots");
        mntmNewMenuItem_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    combinedCooErrorPlots.setVisible(true);
                }
            }
        });
        this.popupImageMenu.add(mntmNewMenuItem_4);
        this.lineColumnPlotsCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PMCGUI.this.lineColumnPlotsCheckBox.isSelected()) {
                    combinedLineColumnPlots.setVisible(true);
                }
            }
        });
        JSeparator separator_2 = new JSeparator();
        this.popupImageMenu.add(separator_2);
        this.popupImageMenu.add(this.lineColumnPlotsCheckBox);
        JMenuItem mntmNewMenuItem_5 = new JMenuItem("ViewFullImage");
        mntmNewMenuItem_5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                showFullImage.setImageP("./conf/image_" + Utils.telescopeNumber + ".fits");
                showFullImage.setVisible(true);
            }
        });
        this.popupImageMenu.add(mntmNewMenuItem_5);
        testButton.setToolTipText("JButton");
        testButton.setHorizontalAlignment(2);
        testButton.setFont(new Font("Tahoma", 1, 12));
        testButton.setBounds(0, 761, 52, 40);
        this.frmPmcGui.getContentPane().add(testButton);
        maxVal_scrollbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                nomTamFits.setNewFitsImage("./conf/image_" + Utils.telescopeNumber + ".fits");
                showCrossReferenceFlag = true;
            }
        });
        maxVal_scrollbar.setBlockIncrement(16);
        maxVal_scrollbar.setFont(new Font("Dialog", 0, 10));
        maxVal_scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                zStrechLabel.setText("zStretch: " + minVal_scrollbar.getValue() + "*" + maxVal_scrollbar.getValue());
            }
        });
        maxVal_scrollbar.setMaximum(Short.MAX_VALUE);
        maxVal_scrollbar.setBackground(Color.BLACK);
        maxVal_scrollbar.setOrientation(0);
        maxVal_scrollbar.setBounds(434, 529, 130, 14);
        this.frmPmcGui.getContentPane().add(maxVal_scrollbar);
        maxVal_scrollbar.setValue(255);
        minVal_scrollbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                nomTamFits.setNewFitsImage("./conf/image_" + Utils.telescopeNumber + ".fits");
                showCrossReferenceFlag = true;
            }
        });
        minVal_scrollbar.setBlockIncrement(16);
        minVal_scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                zStrechLabel.setText("zStretch: " + minVal_scrollbar.getValue() + "*" + maxVal_scrollbar.getValue());
            }
        });
        minVal_scrollbar.setBackground(Color.WHITE);
        minVal_scrollbar.setMaximum(Short.MAX_VALUE);
        minVal_scrollbar.setValue(0);
        minVal_scrollbar.setOrientation(0);
        minVal_scrollbar.setBounds(299, 529, 130, 14);
        this.frmPmcGui.getContentPane().add(minVal_scrollbar);
        final JPanel GetImagePanel = new JPanel();
        GetImagePanel.setBackground(new Color(135, 206, 250));
        GetImagePanel.setBounds(539, 549, 419, 69);
        this.frmPmcGui.getContentPane().add(GetImagePanel);
        GetImagePanel.setLayout(null);
        JButton GetImageButton = new JButton("GetImage");
        GetImageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AIV_GUI.writeOnInfoText("\n GetImage button pressed");
                PMCGUI.this.imageNameToGet = textImageName.getText();
                if (PMCGUI.this.getLastImageThreadFlag) {
                    AIV_GUI.writeOnInfoText("\n PMC GetImage: warning, retry later...");
                    Utils.beep(1);
                } else {
                    PMCGUI.this.getLastImageThreadFlag = true;
                }
            }
        });
        GetImageButton.setFont(new Font("Tahoma", 0, 12));
        GetImageButton.setForeground(new Color(199, 21, 133));
        GetImageButton.setBackground(new Color(176, 224, 230));
        GetImageButton.setBounds(3, 2, 87, 25);
        GetImagePanel.add(GetImageButton);
        textImageName = new JTextField();
        textImageName.setFont(new Font("Tahoma", 1, 9));
        textImageName.setToolTipText("enter image fileName ");
        textImageName.setText("./conf/newImageTest1.fits");
        textImageName.setBounds(3, 35, 411, 23);
        GetImagePanel.add(textImageName);
        textImageName.setColumns(10);
        JButton lastImageButton = new JButton("GetLastImage");
        lastImageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PMCGUI.this.imageNameToGet = "";
                if (PMCGUI.this.getLastImageThreadFlag) {
                    AIV_GUI.writeOnInfoText("\n PMC GetImage: warning, retry later...");
                    Utils.beep(1);
                } else {
                    PMCGUI.this.getLastImageThreadFlag = true;
                }
            }
        });
        lastImageButton.setForeground(new Color(199, 21, 133));
        lastImageButton.setFont(new Font("Tahoma", 0, 12));
        lastImageButton.setBackground(new Color(176, 224, 230));
        lastImageButton.setBounds(305, 2, 109, 25);
        GetImagePanel.add(lastImageButton);
        this.autoDetectCheckItem.setFont(new Font("Tahoma", 0, 10));
        this.autoDetectCheckItem.setSelected(true);
        this.autoDetectCheckItem.setToolTipText("auto download img ");
        this.autoDetectCheckItem.setBounds(143, 4, 97, 23);
        this.autoDetectCheckItem.setBackground(new Color(135, 206, 250));
        GetImagePanel.add(this.autoDetectCheckItem);
        zStrechLabel.setFont(new Font("SansSerif", 0, 9));
        zStrechLabel.setBounds(566, 529, 120, 14);
        this.frmPmcGui.getContentPane().add(zStrechLabel);
        this.inplementPmcRadioButtonGroup();
        JMenuBar menuBar = new JMenuBar();
        this.frmPmcGui.setJMenuBar(menuBar);
        Image newimg = Utils.tazImage.getImage().getScaledInstance(20, 20, 4);
        this.tazLabel.setIcon(new ImageIcon(newimg));
        menuBar.add(this.tazLabel);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    PMCGUI.this.thatsAllFolks();
                    PMCGUI.this.threadEnd.start();
                }
            }
        });
        JMenuItem connectMenuItem = new JMenuItem("ReConnect");
        fileMenu.add(connectMenuItem);
        connectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    workOpcuaClient.stopClient();
                    Utils.getProperties();
                    Utils.getWorkReference();
                    workOpcuaClient = new PMCOpcuaClient();
                    PMCGUI.this.startClient();
                }
            }
        });
        JMenuItem errorFormMenuItem = new JMenuItem("ErrorForm");
        errorFormMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMCGUI.this.errorForm.setVisible(true);
            }
        });
        fileMenu.add(errorFormMenuItem);
        JSeparator separator = new JSeparator();
        fileMenu.add(separator);
        JSeparator separator_1 = new JSeparator();
        fileMenu.add(separator_1);
        this.viewAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    showAllImages.setVisible(true);
                }
            }
        });
        fileMenu.add(this.viewAllMenuItem);
        this.consolleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    AIV_GUI.consolle.setVisible(true);
                }
            }
        });
        fileMenu.add(this.consolleMenuItem);
        this.exitMenuItem.setActionCommand("Exit");
        fileMenu.add(this.exitMenuItem);
        JMenu mnNewMenu = new JMenu("Fits");
        menuBar.add(mnNewMenu);
        mnNewMenu.add(this.loadFitsMenuItem);
        JMenuItem showHeaderMenuItem = new JMenuItem("ShowHeader");
        showHeaderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    nomTamFits.showHeader();
                }
            }
        });
        mnNewMenu.add(showHeaderMenuItem);
        menuBar.add(this.icdMenu);
        this.showNodesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PMCGUI.workOpcuaClient.client.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                opcuaStartReadThread = true;
            }
        });
        JMenuItem loadNewMenuItem = new JMenuItem("Load");
        loadNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    try {
                        fileChooser.setCurrentDirectory(new File(new File("./conf").getCanonicalPath()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel file", "xlsx", "xls");
                    fileChooser.setFileFilter(filter);
                    fileChooser.setMultiSelectionEnabled(false);
                    int result = fileChooser.showOpenDialog(GetImagePanel);
                    if (result == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        AIV_GUI.writeOnInfoText("Selected file: " + selectedFile.getAbsolutePath() + "\n");
                        try {
                            PMCICD icd;
                            pmcICD = icd = new PMCICD(selectedFile.getAbsolutePath());
                            PMCGUI.this.treeSetModel();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.icdMenu.add(loadNewMenuItem);
        this.icdMenu.add(this.loadEConnExcelMenuItem);
        this.loadEConnExcelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    try {
                        fileChooser.setCurrentDirectory(new File(new File("./conf").getCanonicalPath()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel file", "xlsx", "xls");
                    fileChooser.setFileFilter(filter);
                    fileChooser.setMultiSelectionEnabled(false);
                    int result = fileChooser.showOpenDialog(GetImagePanel);
                    if (result == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        System.out.println("Selected file: " + selectedFile.getAbsolutePath());
                        try {
                            PMCICD icd = new PMCICD(selectedFile.getAbsolutePath());
                            AIV_GUI.writeOnInfoText(" url addres is: " + icd.opcuaURL + "\n");
                            if (icd.opcuaURL != null | icd.opcuaURL != "") {
                                PMCOpcuaClient oClnt = new PMCOpcuaClient();
                                oClnt.startClient(icd.opcuaURL);
                                if (oClnt.client.isConnected()) {
                                    workOpcuaClient = oClnt;
                                    pmcICD = icd;
                                    PMCGUI.this.treeSetModel();
                                } else {
                                    AIV_GUI.writeOnInfoText(">> server at " + icd.opcuaURL + "is not connected sorry\n", Color.red, false, false, false, true, 15);
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("PmcDefaultICD");
        mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (e.getID() == 1001) {
                        PMCGUI.this.startClient();
                        PMCGUI.this.treeSetModel();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        mntmNewMenuItem_1.setActionCommand("");
        this.icdMenu.add(mntmNewMenuItem_1);
        this.icdMenu.add(this.showNodesMenuItem);
        JMenu allSkyMenu = new JMenu("AllSky");
        menuBar.add(allSkyMenu);
        JMenuItem getImageMenuItem = new JMenuItem("GetImage");
        getImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    try {
                        URL where = new URL(Utils.allSkyUrlString);
                        ImageIcon allSkyIcon = new ImageIcon(where);
                        imageLabel.setIcon(allSkyIcon);
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        allSkyMenu.add(getImageMenuItem);
        Component horizontalStrut = Box.createHorizontalStrut(36);
        menuBar.add(horizontalStrut);
        menuBar.add(this.astriLabel);
        this.astriLabel.setFont(new Font("Tahoma", 1, 14));
        this.astriLabel.setForeground(Color.BLUE);
        Component horizontalStrut_1 = Box.createHorizontalStrut(689);
        menuBar.add(horizontalStrut_1);
        this.heartbeatLabel.setHorizontalAlignment(0);
        this.heartbeatLabel.setFont(new Font("Tahoma", 0, 10));
        menuBar.add(this.heartbeatLabel);
        this.loadFitsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Fits file", "fits", "fts");
                    fileChooser.setFileFilter(filter);
                    fileChooser.setMultiSelectionEnabled(false);
                    int result = fileChooser.showOpenDialog(GetImagePanel);
                    if (result == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        System.out.println("Selected file: " + selectedFile.getAbsolutePath());
                        nomTamFits.setNewFitsImage(selectedFile.getAbsolutePath());
                    }
                }
            }
        });
    }

    public void assignNewOpcuaClientToWorkArea(int indx) {
        saveReferenceButton.setEnabled(true);
        workOpcuaClient.copyErrorXYSeries();
        nomTamFits.setNewFitsImage("./conf/image_" + Utils.telescopeNumber + ".fits");
        workOpcuaClient.writeOnTextInfo();
    }

    private void inplementPmcRadioButtonGroup() {
        this.historyCheckBox.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.historyCheckBox.setAlignmentX(0.5f);
        this.historyCheckBox.setBackground(new Color(255, 255, 204));
        this.historyCheckBox.setFont(new Font("SansSerif", 1, 12));
        this.historyCheckBox.setBounds(0, 298, 187, 20);
        this.frmPmcGui.getContentPane().add(this.historyCheckBox);
        lblZfact.setHorizontalAlignment(0);
        lblZfact.setToolTipText("zoom factor");
        lblZfact.setForeground(Color.DARK_GRAY);
        lblZfact.setFont(new Font("SansSerif", 1, 9));
        lblZfact.setBounds(686, 529, 100, 14);
        this.frmPmcGui.getContentPane().add(lblZfact);
        cross1CheckBox.setBackground(Color.LIGHT_GRAY);
        cross1CheckBox.setToolTipText("refery1_on_image");
        cross1CheckBox.setBounds(126, 416, 63, 18);
        this.frmPmcGui.getContentPane().add(cross1CheckBox);
        cross2CheckBox.setBackground(Color.LIGHT_GRAY);
        cross2CheckBox.setToolTipText("refery2_on_image");
        cross2CheckBox.setBounds(126, 433, 63, 18);
        this.frmPmcGui.getContentPane().add(cross2CheckBox);
        JLabel tazLabel_1 = new JLabel("");
        tazLabel_1.setBounds(34, 511, 0, 0);
        this.frmPmcGui.getContentPane().add(tazLabel_1);
        JButton clearReferenceButton = new JButton("Clear");
        clearReferenceButton.setFont(new Font("SansSerif", 1, 10));
        clearReferenceButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (cross1CheckBox.isSelected()) {
                    crossReference1 = new int[]{-1, -1};
                    Utils.saveProperties("crossReference1", "-1,-1");
                    cross1CheckBox.setBackground(Color.LIGHT_GRAY);
                    cross1CheckBox.setSelected(false);
                }
                if (cross2CheckBox.isSelected()) {
                    crossReference2 = new int[]{-1, -1};
                    Utils.saveProperties("crossReference2", "-1,-1");
                    cross2CheckBox.setBackground(Color.LIGHT_GRAY);
                    cross2CheckBox.setSelected(false);
                }
                if (PMCGUI.this.areaCheckBox.isSelected()) {
                    PMCGUI.this.areaCheckBox.setBackground(Color.LIGHT_GRAY);
                    areaReference = new int[]{-1, -1, -1, -1};
                    Utils.saveProperties("areaReference", "-1,-1,-1,-1");
                    PMCGUI.this.areaCheckBox.setSelected(false);
                }
                nomTamFits.refreshImage();
            }
        });
        clearReferenceButton.setToolTipText("clear selected ref");
        clearReferenceButton.setBackground(Color.RED);
        clearReferenceButton.setBounds(126, 398, 63, 18);
        this.frmPmcGui.getContentPane().add(clearReferenceButton);
        this.areaCheckBox.setToolTipText("areaOfInterest_on_image_2");
        this.areaCheckBox.setBackground(Color.LIGHT_GRAY);
        this.areaCheckBox.setBounds(126, 451, 63, 18);
        this.frmPmcGui.getContentPane().add(this.areaCheckBox);
        PMCGUI.addPopup(this.areaCheckBox, this.popupMenu);
        this.centroidCheckItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    PMCGUI.this.maxValueCheckItem.setState(!PMCGUI.this.centroidCheckItem.getState());
                    nomTamFits.refreshImage();
                    showCrossReferenceFlag = true;
                }
            }
        });
        this.centroidCheckItem.setSelected(true);
        this.popupMenu.add(this.centroidCheckItem);
        this.maxValueCheckItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    PMCGUI.this.centroidCheckItem.setState(!PMCGUI.this.maxValueCheckItem.getState());
                    nomTamFits.refreshImage();
                    showCrossReferenceFlag = true;
                }
            }
        });
        this.popupMenu.add(this.maxValueCheckItem);
        this.ledLabel0.setFont(new Font("Tahoma", 1, 32));
        this.ledLabel0.setBounds(16, 549, 24, 34);
        this.frmPmcGui.getContentPane().add(this.ledLabel0);
        this.statusLabel0.setToolTipText("PMC status");
        this.statusLabel0.setFont(new Font("Tahoma", 1, 11));
        this.statusLabel0.setBounds(43, 560, 100, 20);
        this.frmPmcGui.getContentPane().add(this.statusLabel0);
        this.scrollPane_1.setToolTipText("GET values");
        this.scrollPane_1.setVerticalScrollBarPolicy(22);
        this.scrollPane_1.setHorizontalScrollBarPolicy(32);
        this.scrollPane_1.setBounds(6, 325, 115, 205);
        this.scrollPane_1.getVerticalScrollBar().setPreferredSize(new Dimension(10, Integer.MAX_VALUE));
        this.scrollPane_1.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 10));
        this.frmPmcGui.getContentPane().add(this.scrollPane_1);
        infoTextArea.setToolTipText("GET values");
        infoTextArea.setText(">");
        infoTextArea.setAlignmentY(0.0f);
        infoTextArea.setAlignmentX(0.0f);
        infoTextArea.setEditable(false);
        this.scrollPane_1.setViewportView(infoTextArea);
        infoTextArea.setForeground(new Color(0, 0, 128));
        infoTextArea.setBackground(new Color(230, 230, 250));
        infoTextArea.setFont(new Font("SansSerif", 2, 10));
        saveReferenceButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Utils.saveProperties("crossReference1_" + String.valueOf(Utils.telescopeNumber), String.valueOf(String.valueOf(crossReference1[0])) + "," + String.valueOf(crossReference1[1]));
                Utils.saveProperties("crossReference2_" + String.valueOf(Utils.telescopeNumber), String.valueOf(String.valueOf(crossReference2[0])) + "," + String.valueOf(crossReference2[1]));
                Utils.saveProperties("areaReference_" + String.valueOf(Utils.telescopeNumber), String.valueOf(String.valueOf(areaReference[0])) + "," + String.valueOf(areaReference[1]) + "," + String.valueOf(areaReference[2]) + "," + String.valueOf(areaReference[3]));
                PMCGUI.workOpcuaClient.areaReference = areaReference;
                PMCGUI.workOpcuaClient.crossReference1 = crossReference1;
                PMCGUI.workOpcuaClient.crossReference2 = crossReference2;
            }
        });
        saveReferenceButton.setToolTipText("Save referies");
        saveReferenceButton.setFont(new Font("SansSerif", 1, 10));
        saveReferenceButton.setBackground(Color.YELLOW);
        saveReferenceButton.setBounds(126, 468, 63, 18);
        this.frmPmcGui.getContentPane().add(saveReferenceButton);
        JPanel acquirePanel = new JPanel();
        acquirePanel.setBackground(new Color(204, 204, 153));
        acquirePanel.setBounds(153, 549, 382, 72);
        this.frmPmcGui.getContentPane().add(acquirePanel);
        JButton btnStart = new JButton("Start");
        btnStart.setBounds(10, 5, 65, 23);
        btnStart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (PMCGUI.this.doFitsCheckBox.isSelected()) {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_fitson"), (Object)true);
                    } else {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_fitson"), (Object)false);
                    }
                    if (PMCGUI.this.doPngCheckBox.isSelected()) {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_pngon"), (Object)true);
                    } else {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_pngon"), (Object)false);
                    }
                    if (PMCGUI.this.doAstrometrychckbx.isSelected()) {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_astrometry_on_off"), (Object)true);
                    } else {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_astrometry_on_off"), (Object)false);
                    }
                    if (PMCGUI.this.continousCheckBox.isSelected()) {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_continous_mode"), (Object)true);
                        String sDelay = PMCGUI.this.delayTimeTextField.getText().trim();
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_delay_btwn_imgs"), (Object)Integer.parseInt(sDelay));
                    } else {
                        PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_continous_mode"), (Object)false);
                    }
                    float integrationTime = Float.parseFloat(PMCGUI.this.tExposureField.getText());
                    PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_set_exptm"), (Object)Float.valueOf(integrationTime));
                    PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_image"), (Object)1);
                    AIV_GUI.writeOnInfoText("\n Start Image pressed");
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_image"), (Object)0);
                }
                catch (Exception e1) {
                    AIV_GUI.writeOnInfoText("--> no image acquired.." + e1.getMessage() + "\n", Color.red, true, false, false, false, 12);
                }
            }
        });
        acquirePanel.setLayout(null);
        btnStart.setForeground(new Color(255, 255, 51));
        btnStart.setFont(new Font("Tahoma", 1, 11));
        btnStart.setBackground(new Color(0, 102, 0));
        acquirePanel.add(btnStart);
        JLabel lblNewLabel = new JLabel("TExp (msec) ");
        lblNewLabel.setFont(new Font("Tahoma", 0, 10));
        lblNewLabel.setBounds(147, 9, 65, 14);
        acquirePanel.add(lblNewLabel);
        this.tExposureField.setBounds(85, 6, 54, 20);
        acquirePanel.add(this.tExposureField);
        this.tExposureField.setMinimumSize(new Dimension(5, 20));
        this.tExposureField.setBackground(new Color(255, 255, 240));
        this.tExposureField.setHorizontalAlignment(0);
        this.tExposureField.setText("30");
        this.tExposureField.setColumns(6);
        this.doAstrometrychckbx.setFont(new Font("Tahoma", 0, 10));
        this.doAstrometrychckbx.setSelected(true);
        this.doAstrometrychckbx.setBackground(new Color(204, 204, 160));
        this.doAstrometrychckbx.setBounds(6, 30, 93, 23);
        acquirePanel.add(this.doAstrometrychckbx);
        this.doFitsCheckBox.setFont(new Font("Tahoma", 0, 10));
        this.doFitsCheckBox.setSelected(true);
        this.doFitsCheckBox.setBackground(new Color(204, 204, 160));
        this.doFitsCheckBox.setBounds(123, 50, 73, 23);
        acquirePanel.add(this.doFitsCheckBox);
        this.doPngCheckBox.setFont(new Font("Tahoma", 0, 10));
        this.doPngCheckBox.setSelected(true);
        this.doPngCheckBox.setBackground(new Color(204, 204, 160));
        this.doPngCheckBox.setBounds(123, 27, 73, 28);
        acquirePanel.add(this.doPngCheckBox);
        JCheckBox deleteImagechckbx = new JCheckBox("DeleteImg");
        deleteImagechckbx.setFont(new Font("Tahoma", 0, 10));
        deleteImagechckbx.setForeground(Color.RED);
        deleteImagechckbx.setBackground(new Color(204, 204, 160));
        deleteImagechckbx.setBounds(6, 50, 93, 23);
        acquirePanel.add(deleteImagechckbx);
        this.contPanel.setBounds(274, 0, 108, 69);
        this.contPanel.setBackground(new Color(214, 214, 163));
        acquirePanel.add(this.contPanel);
        this.contPanel.setLayout(null);
        this.continousCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!PMCGUI.this.continousCheckBox.isSelected()) {
                    try {
                        if (PMCGUI.workOpcuaClient.client.isConnected()) {
                            PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, "pmc_continous_mode"), (Object)false);
                        }
                    }
                    catch (ServiceException | StatusException e1) {
                        AIV_GUI.writeOnInfoText("ContinousMode Error: " + e1.getMessage());
                    }
                }
            }
        });
        this.continousCheckBox.setFont(new Font("Tahoma", 0, 10));
        this.continousCheckBox.setBounds(17, 3, 73, 23);
        this.contPanel.add(this.continousCheckBox);
        this.continousCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        this.continousCheckBox.setToolTipText("set countinous mode");
        this.continousCheckBox.setBackground(new Color(204, 204, 160));
        this.delayTimeTextField = new JTextField();
        this.delayTimeTextField.setBounds(18, 29, 70, 17);
        this.contPanel.add(this.delayTimeTextField);
        this.delayTimeTextField.setText("30");
        this.delayTimeTextField.setMinimumSize(new Dimension(5, 20));
        this.delayTimeTextField.setHorizontalAlignment(0);
        this.delayTimeTextField.setColumns(6);
        this.delayTimeTextField.setBackground(new Color(255, 255, 240));
        JLabel lblDelaymsec = new JLabel("Delay (sec) ");
        lblDelaymsec.setHorizontalAlignment(0);
        lblDelaymsec.setFont(new Font("Tahoma", 0, 10));
        lblDelaymsec.setBounds(22, 49, 63, 14);
        this.contPanel.add(lblDelaymsec);
        zoomFactorComboBox.setVisible(false);
        zoomFactorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AIV_GUI.writeOnInfoText("\n GetId: " + e.getID() + "  -  index:" + zoomFactorComboBox.getSelectedIndex() + "    ");
                int indx = zoomFactorComboBox.getSelectedIndex();
                switch (indx) {
                    case 0: {
                        PMCGUI.nomTamFits.xFactor = 4.0f;
                        PMCGUI.nomTamFits.yFactor = 4.0f;
                        break;
                    }
                    case 1: {
                        PMCGUI.nomTamFits.xFactor = 2.0f;
                        PMCGUI.nomTamFits.yFactor = 2.0f;
                        break;
                    }
                    case 2: {
                        PMCGUI.nomTamFits.xFactor = 1.0f;
                        PMCGUI.nomTamFits.yFactor = 1.0f;
                        break;
                    }
                    case 3: {
                        PMCGUI.nomTamFits.xFactor = 0.5f;
                        PMCGUI.nomTamFits.yFactor = 0.5f;
                        break;
                    }
                    default: {
                        PMCGUI.nomTamFits.xFactor = 4.0f;
                        PMCGUI.nomTamFits.yFactor = 4.0f;
                    }
                }
                AIV_GUI.writeOnInfoText("\n New ZoomFactor: " + 1.0f / PMCGUI.nomTamFits.xFactor + " x " + 1.0f / PMCGUI.nomTamFits.yFactor + "  ");
            }
        });
        zoomFactorComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        zoomFactorComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0.25 x 0.25", "0.5 x 0.5", "1 x 1", "2 x 2"}));
        zoomFactorComboBox.setSelectedIndex(0);
        zoomFactorComboBox.setBounds(99, 747, 120, 26);
        this.frmPmcGui.getContentPane().add(zoomFactorComboBox);
        this.errorNoLabel.setForeground(Color.RED);
        this.errorNoLabel.setBounds(16, 604, 82, 14);
        this.frmPmcGui.getContentPane().add(this.errorNoLabel);
    }

    private void jtreeToOpcua(String nodeList, String acsName) {
        if (!PMCGUI.workOpcuaClient.client.isConnected()) {
            AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText(" OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
            return;
        }
        String nodeName = "";
        switch (nodeList) {
            case "GetList": {
                int ix = 0;
                while (ix < PMCGUI.pmcICD.get_ACSName_List.size()) {
                    if (acsName == PMCGUI.pmcICD.get_ACSName_List.get(ix)) {
                        nodeName = PMCGUI.pmcICD.get_NodeName_List.get(ix);
                        PMCGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Descruption: " + PMCGUI.pmcICD.get_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                if (!this.historyCheckBox.isSelected()) break;
                PMCGUI.showHistoryPlot(nodeName, acsName);
                break;
            }
            case "SetList": {
                int ix = 0;
                while (ix < PMCGUI.pmcICD.set_ACSName_List.size()) {
                    if (acsName == PMCGUI.pmcICD.set_ACSName_List.get(ix)) {
                        nodeName = PMCGUI.pmcICD.set_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("DataInputForm... SET");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + PMCGUI.pmcICD.set_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(PMCGUI.pmcICD.set_NodeName_List.get(ix)) + " [" + PMCGUI.pmcICD.set_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(PMCGUI.pmcICD.set_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(PMCGUI.getOPCUAdata(nodeName));
                        AIV_GUI.writeOnInfoText("Descruption: " + PMCGUI.pmcICD.set_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        DataInputForm.enterDataValueField.setForeground(Color.BLACK);
                    }
                    ++ix;
                }
                break;
            }
            case "CmdList": {
                int ix = 0;
                while (ix < PMCGUI.pmcICD.cmd_ACSName_List.size()) {
                    if (acsName == PMCGUI.pmcICD.cmd_ACSName_List.get(ix)) {
                        nodeName = PMCGUI.pmcICD.cmd_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("DataInputForm... CMD");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + PMCGUI.pmcICD.cmd_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(PMCGUI.pmcICD.cmd_NodeName_List.get(ix)) + " [" + PMCGUI.pmcICD.cmd_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(PMCGUI.pmcICD.cmd_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(PMCGUI.pmcICD.cmd_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.RED);
                        PMCGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Descruption: " + PMCGUI.pmcICD.cmd_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            case "ModeList": {
                int ix = 0;
                while (ix < PMCGUI.pmcICD.mode_ACSName_List.size()) {
                    if (acsName == PMCGUI.pmcICD.mode_ACSName_List.get(ix)) {
                        nodeName = PMCGUI.pmcICD.mode_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("DataInputForm... MODE");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + PMCGUI.pmcICD.mode_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(PMCGUI.pmcICD.mode_NodeName_List.get(ix)) + " [" + PMCGUI.pmcICD.mode_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(PMCGUI.pmcICD.mode_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(PMCGUI.pmcICD.mode_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.DARK_GRAY);
                        PMCGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Descruption: " + PMCGUI.pmcICD.mode_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            default: {
                AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
                AIV_GUI.writeOnInfoText(" acsCommand not valid: " + acsName + "\n", Color.RED, true, false, true, true, 12);
                return;
            }
        }
    }

    public static String getOPCUAdata(String nodeName) {
        DataValue datValue = null;
        if (nodeName.contains("ns=")) {
            datValue = workOpcuaClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
                return datValue.getValue().getValue().toString();
            }
            AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            return "";
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText(" nodeName not valid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
        return "";
    }

    public static void showHistoryPlot(String nodeName, String acsName) {
        DataValue[] dValue = null;
        try {
            dValue = workOpcuaClient.readHistory(nodeName);
            if (dValue != null) {
                PMCGUI.historyPlot.timeSeries.clear();
                PMCGUI.historyPlot.timeSeries.setKey((Comparable)((Object)("opcuaNode: " + nodeName)));
                PMCGUI.historyPlot.chart.setTitle(acsName);
                int ix = 0;
                while (ix < dValue.length) {
                    PMCGUI.historyPlot.timeSeries.add((RegularTimePeriod)new Millisecond(dValue[ix].getSourceTimestamp().getUtcCalendar().getTime()), dValue[ix].getValue().doubleValue());
                    ++ix;
                }
                historyPlot.setVisible(true);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void jtreeGetEditedText(String nodeName) throws BadLocationException {
        DataValue datValue = null;
        AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " get new value and press Return:: ");
        AIV_GUI.infoText.getDocument().getText(0, AIV_GUI.infoText.getDocument().getLength());
        if (nodeName.contains("ns=")) {
            datValue = workOpcuaClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
            } else {
                AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            }
            return;
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText("nodeName not vallid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
    }

    private void thatsAllFolks() {
        imageLabel.setIcon(new ImageIcon("./conf/endImageIcon.png"));
        AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
        AIV_GUI.inserIconOnInfoText(100, Utils.endImageIcon);
        AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
        imageLabel.repaint();
        this.frmPmcGui.repaint();
        if (PMCGUI.workOpcuaClient.client.isConnected()) {
            workOpcuaClient.stopClient();
        }
    }

    public static void setValueToOpcuaServer() {
        String setVal = DataInputForm.acsNameLabel.getText();
        setVal = setVal.substring(0, setVal.indexOf(")")).trim();
        int opcIndex = Integer.parseInt(setVal);
        String nodeName = "";
        String nodeType = "";
        if (DataInputForm.frmDatainputform.getTitle().contains("SET")) {
            nodeName = PMCGUI.pmcICD.set_NodeName_List.get(opcIndex);
            nodeType = PMCGUI.pmcICD.set_DataType_List.get(opcIndex);
        } else if (DataInputForm.frmDatainputform.getTitle().contains("CMD")) {
            nodeName = PMCGUI.pmcICD.cmd_NodeName_List.get(opcIndex);
            nodeType = PMCGUI.pmcICD.cmd_DataType_List.get(opcIndex);
        } else if (DataInputForm.frmDatainputform.getTitle().contains("MODE")) {
            nodeName = PMCGUI.pmcICD.mode_NodeName_List.get(opcIndex);
            nodeType = PMCGUI.pmcICD.mode_DataType_List.get(opcIndex);
        } else {
            AIV_GUI.writeOnInfoText("WRONG data...", Color.RED, true, false, false, false, 15);
            AIV_GUI.inserIconOnInfoText(20, Utils.thinkImageIcon);
            return;
        }
        String browserName = nodeName.substring(nodeName.lastIndexOf("=") + 1);
        String val = DataInputForm.enterDataValueField.getText().trim();
        try {
            PMCGUI.workOpcuaClient.client.writeValue(new NodeId(2, browserName), opcuaUtils.setInitValue(nodeType, val));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        PMCGUI.getOPCUAdata(nodeName);
        DataInputForm.frmDatainputform.setVisible(false);
    }

    public void treeSetModel() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("OPCUA_node_list"){
            {
                DefaultMutableTreeNode node_get = new DefaultMutableTreeNode("GetList");
                int g = 0;
                while (g < PMCGUI.pmcICD.get_ACSName_List.size()) {
                    node_get.add(new DefaultMutableTreeNode(PMCGUI.pmcICD.get_ACSName_List.get(g)));
                    ++g;
                }
                this.add(node_get);
                DefaultMutableTreeNode node_set = new DefaultMutableTreeNode("SetList");
                int g2 = 0;
                while (g2 < PMCGUI.pmcICD.set_ACSName_List.size()) {
                    node_set.add(new DefaultMutableTreeNode(PMCGUI.pmcICD.set_ACSName_List.get(g2)));
                    ++g2;
                }
                this.add(node_set);
                DefaultMutableTreeNode node_cmd = new DefaultMutableTreeNode("CmdList");
                int g3 = 0;
                while (g3 < PMCGUI.pmcICD.cmd_ACSName_List.size()) {
                    node_cmd.add(new DefaultMutableTreeNode(PMCGUI.pmcICD.cmd_ACSName_List.get(g3)));
                    ++g3;
                }
                this.add(node_cmd);
                DefaultMutableTreeNode node_mode = new DefaultMutableTreeNode("ModeList");
                int g4 = 0;
                while (g4 < PMCGUI.pmcICD.mode_ACSName_List.size()) {
                    node_mode.add(new DefaultMutableTreeNode(PMCGUI.pmcICD.mode_ACSName_List.get(g4)));
                    ++g4;
                }
                this.add(node_mode);
            }
        }));
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public void setVisible(boolean b) {
        this.frmPmcGui.setVisible(b);
    }

    public void dispose() {
        this.frmPmcGui.dispose();
    }
}

