/*
 * Decompiled with CFR 0.152.
 */
package oc.client;

import com.fazecast.jSerialComm.SerialPort;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class StandaDev {
    private static final Logger logger = Logger.getLogger(StandaDev.class);
    private boolean standaDevIsOpen = false;
    public int devSteps;
    public short devUSteps;
    public int devSpeed;
    public short devUSpeed;
    public float devTemp;
    public int serialNumber;
    public int brakeStatus;
    public boolean isRunningFlag = false;
    public boolean moveErrorFlag = false;
    public boolean alarmFlag = false;
    public boolean movingLeftFlag = false;
    public boolean movingRightFlag = false;
    public boolean switchLeftFlag = false;
    public boolean switchRightFlag = false;
    public boolean stopPressedFlag = false;
    public boolean startReadThread = false;
    public boolean startHomeThread = false;
    public boolean startMoveThread = false;
    public String COM_PORT = "COM14";
    public boolean homingStatus = false;
    private SerialPort standaComPort;
    public String deviceAnswer = "";
    byte[] answerData = null;
    public boolean semoforeRed = false;
    private byte[] gmovData;
    private Thread ReadThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (!StandaDev.this.startReadThread) {
                            Thread.sleep(300L);
                            continue;
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!StandaDev.this.isStandaDevIsOpen()) continue;
                        StandaDev.this.executeCommand("gets");
                        StandaDev.this.executeCommand("gbrk");
                        StandaDev.this.executeCommand("geds");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Exception: " + e.getMessage()));
                    continue;
                }
                break;
            }
        }
    };
    private Thread HomeThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (!StandaDev.this.startHomeThread) {
                        Thread.sleep(1000L);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StandaDev.this.isStandaDevIsOpen()) {
                        StandaDev.this.gotoHome();
                        if (StandaDev.this.stopPressedFlag) {
                            StandaDev.this.stopPressedFlag = false;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Exception: " + e.getMessage()));
                }
                StandaDev.this.startHomeThread = false;
            }
        }
    };
    private Thread MoveThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (!StandaDev.this.startMoveThread) {
                        Thread.sleep(1000L);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StandaDev.this.isStandaDevIsOpen();
                }
                catch (Exception e) {
                    logger.error((Object)("Exception: " + e.getMessage()));
                }
                StandaDev.this.startHomeThread = false;
            }
        }
    };

    public boolean isStandaDevIsOpen() {
        return this.standaDevIsOpen;
    }

    public void setStandaDevIsOpen(boolean standaDevIsOpen) {
        this.standaDevIsOpen = standaDevIsOpen;
    }

    public StandaDev(String comPort) {
        this.openRS232Port(comPort);
        if (this.isStandaDevIsOpen()) {
            this.startReadThread = true;
            this.ReadThread.start();
            this.HomeThread.start();
            this.MoveThread.start();
            this.executeCommand("gser");
        }
    }

    public String getCOM_PORT() {
        return this.COM_PORT;
    }

    public void setCOM_PORT(String cOM_PORT) {
        this.COM_PORT = cOM_PORT;
    }

    public String getDeviceAnswer() {
        return this.deviceAnswer;
    }

    public void wait_for_stop(int delay) {
        if (delay <= 0) {
            delay = 100;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(".");
        while (true) {
            try {
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.alarmFlag) {
                this.executeCommand("stop");
            }
            if (!this.isRunningFlag) {
                return;
            }
            if (this.stopPressedFlag) {
                return;
            }
            System.out.print(".");
        }
    }

    public void setDeviceAnswer(String deviceAnswer) {
        this.deviceAnswer = deviceAnswer;
    }

    public static void main(String[] args) {
        StandaDev testObj = null;
        StandaDev.getSerialsPort();
        testObj = new StandaDev("COM14");
        if (!testObj.isStandaDevIsOpen()) {
            System.out.println("---> COM port error");
            return;
        }
        String dataString = testObj.getDeviceAnswer();
        if (dataString.contains("errd") || dataString.contains("errc") || dataString.contains("errv")) {
            testObj.resync();
        }
        System.out.println("--->" + dataString);
        testObj.executeCommand("gser");
        System.out.println("--->" + testObj.serialNumber);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        testObj.setHomeDirection_1right_0left((short)1);
        System.exit(0);
        int ix = 0;
        while (ix < 10) {
            testObj.executeCommand("gpos");
            System.out.println("--->Steps = " + testObj.devSteps + "    uSpets=" + testObj.devUSteps);
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++ix;
        }
        try {
            Thread.sleep(100200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        testObj.closeRS232Port();
    }

    public static int getValue16(String dataS) {
        byte[] data = dataS.toUpperCase().getBytes();
        int length = data.length;
        System.out.println("----> length=" + length);
        int crc = 65535;
        int i = 0;
        while (i < length) {
            crc ^= data[i];
            int j = 0;
            while (j < 8) {
                int a = crc;
                int carry_flag = a & 1;
                crc >>= 1;
                if (carry_flag == 1) {
                    crc ^= 0xA001;
                }
                ++j;
            }
            ++i;
        }
        return crc;
    }

    public static byte[] getCRCValue16(byte[] data) {
        int length = data.length;
        int crc = 65535;
        int n = 0;
        int i = 0;
        while (i < length) {
            int i1 = data[i];
            if (data[i] < 0) {
                i1 = data[i] + 256;
            }
            crc ^= i1;
            ++n;
            int j = 0;
            while (j < 8) {
                int a = crc;
                int carry_flag = a & 1;
                crc >>= 1;
                if (carry_flag == 1) {
                    crc = (crc ^ 0xA001) & 0xFFFF;
                }
                ++j;
            }
            ++i;
        }
        byte[] bCRC = new byte[2];
        bCRC[1] = (byte)(crc & 0xFF);
        bCRC[0] = (byte)(crc >> 8 & 0xFF);
        return bCRC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sendRawValue(byte[] cmd) {
        byte[] readBuffer = new byte[256];
        try {
            int numRead;
            while (true) {
                if (!this.semoforeRed) {
                    this.semoforeRed = true;
                    numRead = 0;
                    this.standaComPort.clearDTR();
                    this.standaComPort.clearRTS();
                    this.standaComPort.writeBytes(cmd, (long)cmd.length);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            numRead = this.standaComPort.readBytes(readBuffer, (long)readBuffer.length);
            if (numRead > 0) {
                this.semoforeRed = false;
                return Arrays.copyOfRange(readBuffer, 0, numRead);
            }
            System.out.println(numRead);
        }
        catch (Exception e) {
            logger.info((Object)("sendRawValue: Read ERROR!" + e.getMessage()));
        }
        this.semoforeRed = false;
        return null;
    }

    public String readStanda() {
        byte[] readBuffer = new byte[1024];
        try {
            int numRead = 0;
            boolean sStart = false;
            boolean sEnd = false;
            byte[] wByte = new byte[]{103, 115, 101, 114};
            this.standaComPort.writeBytes(wByte, (long)wByte.length);
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            numRead = this.standaComPort.readBytes(readBuffer, (long)readBuffer.length);
            long pippo = 0L;
            int ix = 7;
            while (ix >= 5) {
                pippo |= (long)readBuffer[ix];
                pippo <<= 8;
                --ix;
            }
            int i1 = readBuffer[4];
            if (i1 < 0) {
                i1 += 256;
            }
            pippo |= (long)i1;
            long pippo1 = 0L;
            int ix2 = 4;
            while (ix2 <= 7) {
                pippo1 |= (long)readBuffer[ix2];
                pippo1 <<= 8;
                ++ix2;
            }
            System.out.println("pippo:" + pippo + "  numRead:" + numRead + "   pippo1:" + (pippo1 |= (long)readBuffer[7]));
            ix2 = 0;
            while (ix2 < numRead) {
                System.out.print(String.valueOf(readBuffer[ix2]) + "  ");
                ++ix2;
            }
            System.out.println();
            String dataString = "";
            dataString = new String(readBuffer);
            try {
                return dataString;
            }
            catch (Exception e) {
                logger.error((Object)"Read ERROR!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "niet";
    }

    public static void getSerialsPort() {
        logger.info((Object)("\nUsing Library Version v" + SerialPort.getVersion()));
        SerialPort[] ports = SerialPort.getCommPorts();
        logger.info((Object)"\nAvailable Ports:\n");
        int i = 0;
        while (i < ports.length) {
            logger.info((Object)("   [" + i + "] " + ports[i].getSystemPortName() + ": " + ports[i].getDescriptivePortName() + " - " + ports[i].getPortDescription()));
            ++i;
        }
    }

    public void openRS232Port(String COM_PORT) {
        this.standaComPort = SerialPort.getCommPort((String)COM_PORT);
        this.setStandaDevIsOpen(false);
        logger.info((Object)("\nPre-setting RTS: " + (this.standaComPort.setRTS() ? "Success" : "Failure")));
        boolean openedSuccessfully = this.standaComPort.openPort(0);
        logger.info((Object)("\nOpening " + this.standaComPort.getSystemPortName() + ": " + this.standaComPort.getDescriptivePortName() + " - " + this.standaComPort.getPortDescription() + ": " + openedSuccessfully));
        if (!openedSuccessfully) {
            this.setStandaDevIsOpen(false);
            return;
        }
        logger.info((Object)"Setting read timeout mode to non-blocking");
        this.standaComPort.setBaudRate(115200);
        this.standaComPort.setNumDataBits(8);
        this.standaComPort.setParity(0);
        this.standaComPort.setNumStopBits(2);
        this.standaComPort.setComPortTimeouts(1, 500, 0);
        this.setStandaDevIsOpen(true);
    }

    public void closeRS232Port() {
        if (!this.isStandaDevIsOpen()) {
            return;
        }
        this.standaComPort.removeDataListener();
        this.standaComPort.closePort();
        this.setStandaDevIsOpen(false);
        this.homingStatus = false;
        logger.info((Object)("\n\nClosing " + this.standaComPort.getDescriptivePortName() + ": " + this.standaComPort.closePort()));
    }

    public long get32BitValue(byte[] data) {
        long l1 = 0L;
        int ix = 3;
        while (ix >= 1) {
            l1 |= (long)data[ix];
            l1 <<= 8;
            --ix;
        }
        int i1 = data[0];
        if (i1 < 0) {
            i1 += 256;
        }
        return l1 |= (long)i1;
    }

    public int get16BitValue(byte[] data) {
        int l1 = 0;
        l1 |= data[1];
        l1 <<= 8;
        int i1 = data[0];
        if (i1 < 0) {
            i1 += 256;
        }
        return l1 |= i1;
    }

    public boolean executeCommand(String sCmd) {
        if (sCmd.length() != 4) {
            System.err.println("command not valid" + sCmd);
            return false;
        }
        byte[] cmdByte = sCmd.getBytes();
        this.answerData = this.sendRawValue(cmdByte);
        if (this.answerData != null && new String(this.answerData).contains(new String(cmdByte))) {
            this.setDeviceAnswer(this.answerData.toString());
            if (this.answerData.length > 4) {
                this.extractControllertValues(this.answerData);
            }
            return true;
        }
        return false;
    }

    public boolean setHomeDirection_1right_0left(short stat1_0) {
        this.executeCommand("ghom");
        byte[] register = this.answerData;
        if (register == null || register.length != 33) {
            System.err.println("setHomeDirection_1right_0left: command 'ghom' not valid length answer:" + register.length);
            return false;
        }
        boolean HOME_DIR_FIRST = true;
        short homeDirection = (short)this.get16BitValue(Arrays.copyOfRange(register, 20, 22));
        homeDirection = stat1_0 == 0 ? (short)(homeDirection & 0xFFFFFFFE) : (short)(homeDirection | 1);
        byte[] cmdByte = "shom".getBytes();
        int ix = 0;
        while (ix < cmdByte.length) {
            register[ix] = cmdByte[ix];
            ++ix;
        }
        register[20] = (byte)(homeDirection & 0xFF);
        register[21] = (byte)(homeDirection >> 8 & 0xFF);
        byte[] crc = StandaDev.getCRCValue16(Arrays.copyOfRange(register, 4, register.length - 2));
        register[register.length - 2] = crc[1];
        register[register.length - 1] = crc[0];
        byte[] answerData = this.sendRawValue(register);
        if (answerData != null && new String(answerData).contains(new String(cmdByte))) {
            this.setDeviceAnswer(answerData.toString());
            return true;
        }
        return false;
    }

    public boolean setBrake_1IN_0OUT(int stat_1in_0out) {
        this.executeCommand("gbrk");
        byte[] register = this.answerData;
        if (register == null || register.length != 25) {
            System.err.println("setBrake_1IN_0OUT: command 'gbrk' not valid length answer:");
            return false;
        }
        register[12] = stat_1in_0out == 1 ? (byte)(register[12] | 1) : (byte)(register[12] & 0xFFFFFFFE);
        byte[] cmdByte = "sbrk".getBytes();
        int ix = 0;
        while (ix < cmdByte.length) {
            register[ix] = cmdByte[ix];
            ++ix;
        }
        byte[] crc = StandaDev.getCRCValue16(Arrays.copyOfRange(register, 4, register.length - 2));
        register[register.length - 2] = crc[1];
        register[register.length - 1] = crc[0];
        byte[] answerData = this.sendRawValue(register);
        if (answerData != null && new String(answerData).contains(new String(cmdByte))) {
            this.setDeviceAnswer(answerData.toString());
            return true;
        }
        return false;
    }

    public void setBrakeOUT() {
        this.setBrake_1IN_0OUT(0);
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBrakeIN() {
        this.setBrake_1IN_0OUT(1);
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.executeCommand("stop");
        this.stopPressedFlag = true;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setBrakeIN();
    }

    public void getName() {
        this.executeCommand("gnme");
    }

    public void setZero() {
        this.executeCommand("zero");
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void jogModeLeft() {
        this.executeCommand("left");
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void jogModeRight() {
        this.executeCommand("rigt");
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getMotorInfo() {
        this.executeCommand("gmov");
        if (this.gmovData != null) {
            System.out.println();
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.answerData;
    }

    public boolean setSpeed(int speed, short uSpeed) {
        if (speed < 0) {
            speed = -speed;
        }
        if (uSpeed < 0) {
            uSpeed = -uSpeed;
        }
        int requestLength = 30;
        byte[] outData = new byte[requestLength];
        byte[] cmdByte = "smov".getBytes();
        this.getMotorInfo();
        int ix = 0;
        while (ix < cmdByte.length) {
            outData[ix] = cmdByte[ix];
            ++ix;
        }
        if (this.gmovData == null) {
            return false;
        }
        ix = 0;
        while (ix < this.gmovData.length) {
            outData[ix + 4] = this.gmovData[ix];
            ++ix;
        }
        if (uSpeed > 255) {
            float usp = (float)uSpeed / 256.0f;
            speed += (int)usp;
            uSpeed = (short)((usp - (float)((int)usp)) * 256.0f);
        }
        outData[4] = (byte)(speed & 0xFF);
        outData[5] = (byte)(speed >> 8 & 0xFF);
        outData[6] = (byte)(speed >> 16 & 0xFF);
        outData[7] = (byte)(speed >> 24 & 0xFF);
        outData[8] = (byte)(uSpeed & 0xFF);
        byte[] crc = StandaDev.getCRCValue16(Arrays.copyOfRange(outData, 4, outData.length - 2));
        outData[outData.length - 2] = crc[1];
        outData[outData.length - 1] = crc[0];
        byte[] answerData = this.sendRawValue(outData);
        if (answerData != null && new String(answerData).contains(new String(cmdByte))) {
            this.setDeviceAnswer(answerData.toString());
            return true;
        }
        return false;
    }

    public void gotoHome() {
        int signDir = 1;
        boolean gotoLeftHome = true;
        this.homingStatus = false;
        try {
            if (gotoLeftHome) {
                this.setHomeDirection_1right_0left((short)0);
            } else {
                this.setHomeDirection_1right_0left((short)1);
                signDir = -1;
            }
            this.moveRelativeOrAbsolute("movr", -1000000 * signDir, (short)0);
            this.wait_for_stop(200);
            if (this.stopPressedFlag) {
                return;
            }
            this.moveRelativeOrAbsolute("movr", 25 * signDir, (short)0);
            this.wait_for_stop(200);
            if (this.stopPressedFlag) {
                return;
            }
            this.executeCommand("home");
            this.wait_for_stop(200);
            if (this.stopPressedFlag) {
                return;
            }
            this.setZero();
            this.homingStatus = true;
        }
        catch (Exception e) {
            logger.error((Object)("gotHome Exception: " + e.getMessage()));
        }
    }

    public boolean moveRelativeOrAbsolute(String sCmd, int steps, short uSteps) {
        int answerLength = 4;
        int requestLength = 18;
        byte[] outData = new byte[requestLength];
        byte[] cmdByte = sCmd.getBytes();
        int ix = 0;
        while (ix < cmdByte.length) {
            outData[ix] = cmdByte[ix];
            ++ix;
        }
        if (uSteps > 255 | uSteps < -255) {
            float usp = (float)uSteps / 256.0f;
            steps += (int)usp;
            uSteps = (short)((usp - (float)((int)usp)) * 256.0f);
        }
        outData[4] = (byte)(steps & 0xFF);
        outData[5] = (byte)(steps >> 8 & 0xFF);
        outData[6] = (byte)(steps >> 16 & 0xFF);
        outData[7] = (byte)(steps >> 24 & 0xFF);
        outData[8] = (byte)(uSteps & 0xFF);
        outData[9] = (byte)(uSteps >> 8 & 0xFF);
        ix = 0;
        while (ix < 6) {
            outData[10 + ix] = 0;
            ++ix;
        }
        byte[] crc = StandaDev.getCRCValue16(Arrays.copyOfRange(outData, 4, outData.length - 2));
        outData[outData.length - 2] = crc[1];
        outData[outData.length - 1] = crc[0];
        byte[] answerData = this.sendRawValue(outData);
        if (answerData != null && new String(answerData).contains(new String(cmdByte))) {
            this.setDeviceAnswer(answerData.toString());
            return true;
        }
        return false;
    }

    public void resync() {
        byte[] wByte = new byte[5];
        System.out.println("------------------------------------  resync....");
        int ix = 0;
        while (ix < 1) {
            byte[] bData = this.sendRawValue(wByte);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++ix;
        }
    }

    private void extractControllertValues(byte[] data) {
        String sCmd;
        switch (sCmd = new String(Arrays.copyOfRange(data, 0, 4))) {
            case "gser": {
                if (data.length != 10) break;
                this.serialNumber = (int)this.get32BitValue(Arrays.copyOfRange(data, 4, 8));
                break;
            }
            case "gpos": {
                if (data.length != 26) break;
                this.devSteps = (int)this.get32BitValue(Arrays.copyOfRange(data, 4, 8));
                this.devUSteps = (short)this.get16BitValue(Arrays.copyOfRange(data, 8, 10));
                break;
            }
            case "gbrk": {
                if (data.length != 25) break;
                this.brakeStatus = Arrays.copyOfRange(data, 12, 13)[0] & 1;
                break;
            }
            case "gets": {
                if (data.length != 54) break;
                this.devSteps = (int)this.get32BitValue(Arrays.copyOfRange(data, 9, 13));
                this.devUSteps = (short)this.get16BitValue(Arrays.copyOfRange(data, 13, 15));
                this.devSpeed = (int)this.get32BitValue(Arrays.copyOfRange(data, 23, 27));
                this.devUSpeed = (short)this.get16BitValue(Arrays.copyOfRange(data, 27, 29));
                this.devTemp = (float)this.get16BitValue(Arrays.copyOfRange(data, 37, 39)) / 10.0f;
                int statusFlags = (int)this.get32BitValue(Arrays.copyOfRange(data, 39, 43));
                int n = (int)this.get32BitValue(Arrays.copyOfRange(data, 43, 47));
            }
            case "geds": {
                if (data.length == 26) break;
                break;
            }
            case "gnme": {
                if (data.length != 30) break;
                System.out.println("GetName= " + new String(data));
                break;
            }
            case "gmov": {
                this.gmovData = (byte[])(data.length != 30 ? null : new byte[data.length - 6]);
                int ix = 4;
                while (ix < data.length - 2) {
                    this.gmovData[ix - 4] = data[ix];
                    ++ix;
                }
                break;
            }
        }
    }
}

