/*
 * Decompiled with CFR 0.152.
 */
package oc.client;

import client.DataPoint;
import client.OpcuaUtils;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;
import gui.AIV_GUI;
import gui.DataInputForm;
import gui.OpcuaNodesGrid;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.text.BadLocationException;
import m12.client.MirrorGui;
import oc.client.OCICD;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.tcp.io.TcpConnection;

public class OCOpcuaClient {
    public UaClient client = new UaClient();
    OCICD ocICD = new OCICD();
    private Subscription subscription;
    private String devAcronym = "OC>";
    private List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    public NodeId nodeId;
    OpcuaUtils opcuaUtils = new OpcuaUtils();
    public DataInputForm dataInputForm = new DataInputForm("OC");
    private int telescopeIndex = -1;
    public String isoStamp = "";
    public String fitsImage = "ImageName";
    boolean oc_get_cmos_image_acquired = true;
    float oc_get_cmos_temp_setted = -99.9f;
    int heartbeat = 0;
    private MonitoredDataItemListener dataChangeListener = new MonitoredDataItemListener(){

        /*
         * Exception decompiling
         */
        public void onDataChange(MonitoredDataItem sender, DataValue prevValue, DataValue val) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[9] lbl85 : CaseStatement: default:\u000a, @NONE, blocks:[9] lbl85 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    private SubscriptionAliveListener subscriptionAliveListener = new SubscriptionAliveListener(){

        public void onAlive(Subscription s) {
            System.out.println(String.valueOf(OCOpcuaClient.this.devAcronym) + String.format("Subscription alive: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }

        public void onTimeout(Subscription s) {
            System.out.println(String.valueOf(OCOpcuaClient.this.devAcronym) + String.format("Subscription timeout: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }

        public void onAfterCreate(Subscription s) {
            System.out.println(String.valueOf(OCOpcuaClient.this.devAcronym) + String.format("Subscription created: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }
    };
    private SubscriptionNotificationListener subscriptionListener = new SubscriptionNotificationListener(){

        public void onDataChange(Subscription subscription, MonitoredDataItem item, DataValue newValue) {
        }

        public void onError(Subscription subscription, Object notification, Exception exception) {
            System.out.println(String.valueOf(OCOpcuaClient.this.devAcronym) + exception.getMessage());
        }

        public void onEvent(Subscription subscription, MonitoredEventItem item, Variant[] eventFields) {
            System.out.println(String.valueOf(OCOpcuaClient.this.devAcronym) + String.format("Subscription value received: item = %tc, value = %tc", item.getNodeId(), eventFields));
        }

        public void onNotificationData(Subscription subscription, NotificationData notification) {
        }

        public void onStatusChange(Subscription subscription, StatusCode oldStatus, StatusCode newStatus, DiagnosticInfo diagnosticInfo) {
        }

        public void onBufferOverflow(Subscription arg0, UnsignedInteger arg1, ExtensionObject[] arg2) {
        }

        public long onMissingData(UnsignedInteger arg0, long arg1, long arg2, StatusCode arg3) {
            return 0L;
        }
    };
    public int serverStatus = -1;
    public boolean deviceLinkStatus = false;
    public Thread opcuaNodeThread = new Thread(){

        @Override
        public synchronized void run() {
            int showCmdValue = AIV_GUI.opcuaShowNodeTypeOnGrid;
            while (true) {
                try {
                    while (true) {
                        if (!AIV_GUI.opcuaStartReadThread) {
                            Thread.sleep(100L);
                            continue;
                        }
                        AIV_GUI.opcuaStartReadThread = false;
                        String[] colNames = new String[]{"opcua-NodeName", "ACS name", "Value", "nodeType", "description", "ServerTStamp", "SourceTStamp", "StatusCode"};
                        AIV_GUI.writeOnInfoText("\n reading nodes...  ");
                        DataValue datValue = null;
                        Object[][] dataTable = null;
                        int noOfNodes = 0;
                        switch (AIV_GUI.opcuaShowNodeTypeOnGrid) {
                            case 1: {
                                dataTable = new Object[OCOpcuaClient.this.ocICD.get_NodeName_List.size()][colNames.length];
                                noOfNodes = OCOpcuaClient.this.ocICD.get_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = OCOpcuaClient.this.getDataValue(OCOpcuaClient.this.ocICD.get_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.get_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.get_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = OCOpcuaClient.this.getNodeType(OCOpcuaClient.this.ocICD.get_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.get_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.get_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.get_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.get_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + OCOpcuaClient.this.ocICD.get_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 2: {
                                dataTable = new Object[OCOpcuaClient.this.ocICD.set_NodeName_List.size()][colNames.length];
                                noOfNodes = OCOpcuaClient.this.ocICD.set_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = OCOpcuaClient.this.getDataValue(OCOpcuaClient.this.ocICD.set_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.set_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.set_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = OCOpcuaClient.this.getNodeType(OCOpcuaClient.this.ocICD.set_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.set_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.set_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.set_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.set_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + OCOpcuaClient.this.ocICD.set_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 3: {
                                dataTable = new Object[OCOpcuaClient.this.ocICD.cmd_NodeName_List.size()][colNames.length];
                                noOfNodes = OCOpcuaClient.this.ocICD.cmd_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = OCOpcuaClient.this.getDataValue(OCOpcuaClient.this.ocICD.cmd_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.cmd_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.cmd_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = OCOpcuaClient.this.getNodeType(OCOpcuaClient.this.ocICD.cmd_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.cmd_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.cmd_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.cmd_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.cmd_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + OCOpcuaClient.this.ocICD.cmd_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 4: {
                                dataTable = new Object[OCOpcuaClient.this.ocICD.mode_NodeName_List.size()][colNames.length];
                                noOfNodes = OCOpcuaClient.this.ocICD.mode_NodeName_List.size();
                                int ii = 0;
                                while (ii < noOfNodes) {
                                    datValue = OCOpcuaClient.this.getDataValue(OCOpcuaClient.this.ocICD.mode_NodeName_List.get(ii));
                                    if (datValue != null) {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.mode_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.mode_ACSName_List.get(ii);
                                        dataTable[ii][2] = datValue.getValue().getValue().toString();
                                        dataTable[ii][3] = OCOpcuaClient.this.getNodeType(OCOpcuaClient.this.ocICD.mode_NodeName_List.get(ii)).toString();
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.mode_Description_List.get(ii);
                                        dataTable[ii][5] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][6] = datValue.getServerTimestamp().getValue();
                                        dataTable[ii][7] = datValue.getStatusCode().getValue().toString();
                                    } else {
                                        dataTable[ii][0] = OCOpcuaClient.this.ocICD.mode_NodeName_List.get(ii);
                                        dataTable[ii][1] = OCOpcuaClient.this.ocICD.mode_ACSName_List.get(ii);
                                        dataTable[ii][2] = "node error";
                                        dataTable[ii][3] = "node error";
                                        dataTable[ii][4] = OCOpcuaClient.this.ocICD.mode_Description_List.get(ii);
                                        AIV_GUI.writeOnInfoText(" error detected on node " + OCOpcuaClient.this.ocICD.mode_NodeName_List.get(ii) + "\n", Color.RED, true, false, true, true, 12);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                        }
                        if (AIV_GUI.opcuaNodesGrid == null) {
                            AIV_GUI.opcuaNodesGrid = new OpcuaNodesGrid(colNames, dataTable, "server", OCOpcuaClient.this.client);
                            AIV_GUI.opcuaNodesGrid.frame.setTitle(AIV_GUI.nodesGridFrameTitle);
                        } else if (showCmdValue != AIV_GUI.opcuaShowNodeTypeOnGrid) {
                            showCmdValue = AIV_GUI.opcuaShowNodeTypeOnGrid;
                            AIV_GUI.opcuaNodesGrid.setUpTableData(dataTable);
                        }
                        int idx = 0;
                        while (idx < noOfNodes) {
                            AIV_GUI.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][2], idx, 2);
                            AIV_GUI.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][5], idx, 5);
                            AIV_GUI.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][6], idx, 6);
                            AIV_GUI.opcuaNodesGrid.nodeTable.setValueAt(dataTable[idx][7], idx, 7);
                            ++idx;
                        }
                        AIV_GUI.opcuaNodesGrid.nodeTable.repaint();
                        AIV_GUI.opcuaNodesGrid.frame.setVisible(true);
                    }
                }
                catch (InterruptedException e) {
                    AIV_GUI.writeOnInfoText("Exception: error reading opcua node:" + e.getMessage());
                    continue;
                }
                break;
            }
        }
    };

    public int getServerIndex() {
        return this.telescopeIndex;
    }

    public void setServerIndex(int telescopeIndex) {
        this.devAcronym = "OC" + String.valueOf(telescopeIndex) + ">";
        this.telescopeIndex = telescopeIndex;
    }

    public boolean startClient(String clnt, int index) {
        this.setServerIndex(index);
        return this.startClient(clnt);
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    private boolean isReachable(String devUrls) {
        boolean reachable = false;
        String clntAddr = devUrls.substring(devUrls.indexOf("//") + 2, devUrls.lastIndexOf(":"));
        try {
            InetAddress address = InetAddress.getByName(clntAddr);
            reachable = address.isReachable(4000);
            return reachable;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean startClient(String clnt) {
        block3: {
            this.client = new UaClient(clnt);
            if (this.isReachable(clnt)) break block3;
            System.out.println("OC server at URL" + clnt + " is NOT reachable!!");
            return false;
        }
        try {
            TcpConnection.setReceiveBufferSize((int)1000000);
            TcpConnection.setSendBufferSize((int)1000000);
            this.client.getEndpointConfiguration().setMaxArrayLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxByteStringLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxMessageSize(Integer.valueOf(768000000));
            this.client.getEndpointConfiguration().setMaxStringLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxBufferSize(Integer.valueOf(120000000));
            this.client.setSecurityMode(SecurityMode.NONE);
            this.client.setSessionTimeout(5000.0);
            this.client.setAutoReconnect(true);
            this.client.setStatusCheckTimeout(1000L);
            this.client.setTimeout(1000L);
            this.client.setSessionTimeout(3000L, TimeUnit.MILLISECONDS);
            this.client.getEndpointConfiguration().setOperationTimeout(Integer.valueOf(3000));
            this.createSubscription();
            this.client.connect();
            this.CreateDataPoints();
            this.activateMonitoringAll();
        }
        catch (ServiceException | StatusException | AddressSpaceException | URISyntaxException e) {
            System.out.println(" startClient error: " + e.getMessage());
            return false;
        }
        return true;
    }

    private int CreateDataPoints() throws ServiceException, AddressSpaceException {
        int ix = 0;
        while (ix < this.ocICD.get_NodeName_List.size()) {
            this.dataPointList.add(new DataPoint(this.client, this.getNodeId(this.ocICD.get_NodeName_List.get(ix))));
            System.out.println(String.valueOf(ix) + ") CreateDataPoints dataPointList = " + this.ocICD.get_NodeName_List.get(ix));
            ++ix;
        }
        System.out.println("CreateDataPoints size = " + this.dataPointList.size());
        return this.dataPointList.size();
    }

    public Object readValue(int ns, String browserName) {
        this.nodeId = new NodeId(ns, browserName);
        Object value = null;
        try {
            value = this.client.readValue(this.nodeId).getValue().getValue();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public DataValue getDataValue(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        DataValue dataValue = null;
        try {
            dataValue = this.client.readValue(this.nodeId);
        }
        catch (ServiceException | StatusException e) {
            System.out.println("Error on node " + nodeName + " >>" + e.getMessage());
        }
        return dataValue;
    }

    private void activateMonitoringAll() throws ServiceException, StatusException {
        int nItem = -1;
        for (DataPoint item : this.dataPointList) {
            try {
                ++nItem;
                this.addMonitoredDataPoint(item.getMonitorItem(this.dataChangeListener));
            }
            catch (ServiceException | StatusException e) {
                System.out.println("Error on activateMonitoringAll itemNo= " + nItem + "   " + item.toString() + " >>" + e.getMessage());
            }
        }
        this.startMonitoring();
    }

    public String getServerTimestamp(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        String value = null;
        try {
            value = this.client.readValue(this.nodeId).getServerTimestamp().toString();
        }
        catch (ServiceException | StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getSourceTimestamp(String nodeName) {
        if (nodeName == null | nodeName == "") {
            return "";
        }
        this.nodeId = this.getNodeId(nodeName);
        String value = "";
        try {
            value = this.client.readValue(this.nodeId).getSourceTimestamp().toString();
        }
        catch (ServiceException | StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getNodeType(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        UaType dataType = null;
        String value = null;
        try {
            try {
                UaVariable valiable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
                dataType = valiable.getDataType();
                NodeId dataTypeId = valiable.getDataTypeId();
                dataType = this.client.getAddressSpace().getType(dataTypeId);
                value = dataType.getDisplayName().getText();
            }
            catch (AddressSpaceException e) {
                e.printStackTrace();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void test() throws ServiceException, AddressSpaceException, Exception {
        this.startClient("opc.tcp://localhost:52620/OPCUA/AMA_WS1_Server");
        UaNode node = this.client.getAddressSpace().getNode(this.nodeId);
        if (node != null) {
            System.out.println(node.getNodeClass().toString());
            System.out.println(this.client.readValue(this.nodeId).getValue().getValue());
            System.out.println(this.client.readValue(this.nodeId).getValue().isArray());
        } else {
            System.out.println("node is null");
        }
    }

    public void ceckAllNodes() {
        int ix = 0;
        while (ix < this.ocICD.get_NodeName_List.size()) {
            this.getDataValue(this.ocICD.get_NodeName_List.get(ix));
            ++ix;
        }
        ix = 0;
        while (ix < this.ocICD.set_NodeName_List.size()) {
            this.getDataValue(this.ocICD.set_NodeName_List.get(ix));
            ++ix;
        }
        ix = 0;
        while (ix < this.ocICD.cmd_NodeName_List.size()) {
            this.getDataValue(this.ocICD.cmd_NodeName_List.get(ix));
            ++ix;
        }
        ix = 0;
        while (ix < this.ocICD.mode_NodeName_List.size()) {
            this.getDataValue(this.ocICD.mode_NodeName_List.get(ix));
            ++ix;
        }
    }

    public static void main(String[] args) throws Exception {
        OCOpcuaClient questo = new OCOpcuaClient();
        questo.startClient("opc.tcp://127.0.0.1:62660/OPCUA/AMA_OC_Server");
        questo.ceckAllNodes();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (questo.client.isConnected()) {
            questo.stopClient();
        }
    }

    public void main1(String[] args) throws Exception {
        this.test();
        System.out.println(">>>>>>" + this.readValue(2, "Int32Array"));
        UaVariable variable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
        if (variable != null) {
            NodeId nId = variable.getDataTypeId();
            boolean isArray = variable.getValue().getValue().isArray();
            System.out.println(String.valueOf(nId.getValue().toString()) + "   " + this.opcuaUtils.getTypeIdString(nId) + "  array? " + isArray);
            System.out.println(this.client.readValue(this.nodeId).getValue().getArrayDimensions()[0]);
            System.out.println(variable.getValue().getValue().toString());
            System.out.println("getSourceTimestamp: " + variable.getValue().getSourceTimestamp().toString());
            System.out.println("getSourcePicoseconds: " + variable.getValue().getSourcePicoseconds().toString());
            System.out.println("getServerTimestamp: " + variable.getValue().getServerTimestamp().toString());
            System.out.println("getServerPicoseconds: " + variable.getValue().getServerPicoseconds().toString());
        } else {
            System.out.println("variable is null");
        }
        this.client.writeValue(this.nodeId, (Object)255);
        this.client.writeValue(new NodeId(2, "tstint16"), (Object)255);
        this.client.writeValue(new NodeId(2, "tstint32"), (Object)65255);
        this.client.writeValue(new NodeId(2, "tstint64"), (Object)255L);
        this.client.writeValue(new NodeId(2, "tstbyte"), (Object)new UnsignedByte(222));
        this.client.writeValue(new NodeId(2, "tstsbyte"), (Object)-123);
        byte[] pippo = new byte[]{-128, -100, 5, 127, 127};
        this.client.writeValue(new NodeId(2, "tstbytestring"), (Object)pippo);
        this.client.writeValue(new NodeId(2, "tstuint16"), (Object)UnsignedShort.valueOf((int)2346));
        this.client.writeValue(new NodeId(2, "tstuint32"), (Object)UnsignedInteger.valueOf((long)2346L));
        this.client.writeValue(new NodeId(2, "tstuint64"), (Object)UnsignedLong.valueOf((long)2346L));
        this.client.writeValue(new NodeId(2, "tststring"), (Object)"pippo");
        this.client.writeValue(new NodeId(2, "tstdouble"), (Object)2346.0);
        this.client.writeValue(new NodeId(2, "tstfloat"), (Object)Float.valueOf(2346.0f));
        DataValue value = this.client.readValue(Identifiers.Server_ServerStatus_State);
        System.out.println(value);
    }

    protected void initialize(UaClient client) throws SecureIdentityException, IOException, UnknownHostException {
        ApplicationDescription appDescription = new ApplicationDescription();
        appDescription.setApplicationName(new LocalizedText("OC_OpcuaClient", Locale.ENGLISH));
        appDescription.setApplicationUri("urn:localhost:UA:OC_OpcuaClient");
        appDescription.setProductUri("urn:ASTRI-MiniArray.com:UA:OC_OpcuaClient");
        appDescription.setApplicationType(ApplicationType.Client);
        ApplicationIdentity identity = new ApplicationIdentity();
        identity.setApplicationDescription(appDescription);
        client.setApplicationIdentity(identity);
    }

    public void stopClient() {
        try {
            this.client.removeSubscription(this.subscription);
            this.stopMonitoring();
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("\nOC_Opcua_Client STOPPED!!");
        }
        catch (ServiceException | StatusException e) {
            System.out.println("ERROR stopClient: " + e.getMessage());
        }
        this.client.disconnect();
    }

    public NodeId getNodeId(String nId) {
        int idx;
        int ns = 0;
        String nodeName = nId;
        String displayedName = null;
        if (nodeName.contains("=") & nodeName.contains(";") && nodeName.indexOf("=", (idx = nodeName.indexOf("=", 0)) + 1) > 0) {
            ns = Integer.parseInt(nodeName.substring(nodeName.indexOf("=") + 1, nodeName.indexOf(";")).trim());
            displayedName = nodeName.substring(nodeName.lastIndexOf("=") + 1).trim();
            if (ns <= 0) {
                return null;
            }
            if (displayedName == null || displayedName.isEmpty()) {
                return null;
            }
        }
        return new NodeId(ns, displayedName);
    }

    private void createSubscription() throws ServiceException, StatusException {
        if (this.subscription == null) {
            this.subscription = new Subscription();
            this.subscription.setPublishingInterval(1000.0);
            this.subscription.addAliveListener(this.subscriptionAliveListener);
            this.subscription.addNotificationListener(this.subscriptionListener);
            this.subscription.setLifetimeCount(60L);
            this.subscription.setMaxKeepAliveCount(20L);
            this.subscription.setMaxNotificationsPerPublish(0L);
            this.subscription.setPriority(0);
        }
        if (!this.client.hasSubscription(this.subscription.getSubscriptionId())) {
            this.client.addSubscription(this.subscription);
        }
    }

    protected UnsignedInteger addMonitoredDataPoint(MonitoredDataItem item) throws ServiceException, StatusException {
        if (this.client.hasSubscription(this.subscription.getSubscriptionId())) {
            this.subscription.addItem((MonitoredItem)item);
            UnsignedInteger monId = item.getMonitoredItemId();
            return monId;
        }
        return null;
    }

    protected void startMonitoring() throws ServiceException, StatusException {
        this.subscription.setPublishingEnabled(true);
    }

    protected void stopMonitoring() throws ServiceException, StatusException {
        try {
            this.subscription.setPublishingEnabled(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void writeOnTextInfo() {
        String txt = "";
        try {
            MirrorGui.GETInfoTextArea.getDocument().remove(0, MirrorGui.GETInfoTextArea.getDocument().getLength());
            MirrorGui.GETInfoTextArea.append(">" + this.client.readValue(new NodeId(4, "AMC_UTILITIES.UTC_TIME")).getValue().getValue().toString() + "\n");
            int ix = 0;
            while (ix < this.ocICD.get_NodeName_List.size()) {
                try {
                    txt = this.ocICD.get_NodeName_List.get(ix);
                    txt = txt.substring(txt.lastIndexOf("=") + 1).trim();
                    txt = txt.contains("M1") ? "M1_" + txt.substring(txt.lastIndexOf(".") + 1).trim() : (txt.contains("M2") ? "M2_" + txt.substring(txt.lastIndexOf(".") + 1).trim() : txt.substring(txt.lastIndexOf(".") + 1).trim());
                    txt = String.valueOf(txt) + "=";
                    txt = String.valueOf(txt) + this.getDataValue(this.ocICD.get_NodeName_List.get(ix)).getValue().getValue().toString() + "\n";
                    MirrorGui.GETInfoTextArea.append(txt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++ix;
            }
        }
        catch (ServiceException | StatusException | BadLocationException e) {
            System.out.println("GETInfoTextArea Error: " + e.getMessage());
        }
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public boolean getDeviceLinkStatus() {
        return this.deviceLinkStatus;
    }

    public void setDeviceLinkStatus(boolean deviceLinkStatus) {
        this.deviceLinkStatus = deviceLinkStatus;
    }

    public void readFile(File localFile, FileTypeImpl fileType) throws ServiceException, StatusException, IOException, AddressSpaceException {
        NodeId fNode = new NodeId(4, ".\\conf\\newImageTest2.fits");
        UaNode f1 = this.client.getAddressSpace().getNode(fNode);
        System.out.println(">>" + f1.getNodeId().toString());
        fileType = new FileTypeImpl(this.client.getAddressSpace(), fNode, null, null);
        DataValue f2 = this.getDataValue("ns=4;s=.\\conf\\newImageTest2.fits");
        fileType.getSize().longValue();
        localFile = new File("./conf/test.test");
        System.out.println("readFile: {" + fileType.getBrowseName() + "} local={" + localFile + "}");
        long size = 12588480L;
        DateTime timestamp = fileType.getTimestamp();
        UnsignedInteger fileHandle = fileType.open(new FileTypeOpenMode[]{FileTypeOpenMode.Read});
        FileOutputStream fos = new FileOutputStream(localFile, false);
        try {
            int actualBlockSize = this.client.getEndpointConfiguration().getMaxByteStringLength() / 2;
            byte[] buff = new byte[actualBlockSize];
            long p = 0L;
            while (p < size) {
                fos.write(buff);
                p += (long)actualBlockSize;
            }
        }
        finally {
            fos.close();
            fileType.close(fileHandle);
        }
        localFile.setLastModified(timestamp.getTimeInMillis());
    }

    public DataValue[] readHistory(String nodeName) throws ServiceException, StatusException, AddressSpaceException {
        this.nodeId = this.getNodeId(nodeName);
        UaNode node = this.client.getAddressSpace().getNode(this.nodeId);
        DataValue[] values = null;
        if (node instanceof UaVariable) {
            UaVariable variable = (UaVariable)node;
            if (!variable.getHistorizing().booleanValue()) {
                AIV_GUI.writeOnInfoText("\n The variable " + variable.getBrowseName() + " does not have history");
                return null;
            }
            int action = 0;
            try {
                DateTime endTime = DateTime.currentTime();
                DateTime startTime = new DateTime((endTime.getMilliSeconds() - 3600000L) * 10000L);
                switch (action) {
                    case 0: {
                        values = this.client.historyReadRaw(this.nodeId, startTime, endTime, UnsignedInteger.ONE, Boolean.valueOf(true), null, TimestampsToReturn.Source);
                        if (values != null) {
                            AIV_GUI.writeOnInfoText("\n History of variable " + variable.getBrowseName() + " between " + startTime + " and " + endTime + " found:" + values.length + " values");
                            break;
                        }
                        AIV_GUI.writeOnInfoText("\n History of variable " + variable.getBrowseName() + " between " + startTime + " and " + endTime + " NO values found");
                        break;
                    }
                    case 1: {
                        System.out.println("at " + startTime + " and " + endTime);
                        DateTime[] reqTimes = new DateTime[]{startTime, endTime};
                        values = this.client.historyReadAtTimes(this.nodeId, reqTimes, null, TimestampsToReturn.Source);
                        break;
                    }
                    case 2: {
                        System.out.println("at " + startTime + " and " + endTime);
                        values = this.client.historyReadProcessed(this.nodeId, startTime, endTime, Double.valueOf(60000.0), Identifiers.AggregateFunction_Average, null, null, TimestampsToReturn.Source);
                    }
                }
                double[] dbl = new double[values.length];
                int ix = 0;
                while (ix < values.length) {
                    dbl[ix] = values[ix].getValue().doubleValue();
                    ++ix;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            AIV_GUI.writeOnInfoText("\n History is only available for object and variable nodes. The current node is a " + node.getNodeClass() + ".");
        }
        return values;
    }
}

