/*
 * Decompiled with CFR 0.152.
 */
package oc.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import gui.AIV_GUI;
import gui.DataInputForm;
import gui.HistoryPlot;
import gui.ShowFullImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import myproc.ErrorForm;
import myproc.GetFile;
import myproc.Utils;
import oc.client.ControllUtils;
import oc.client.CreateRoundButton;
import oc.client.OCOpcuaClient;
import oc.client.StandaDev;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;

public class OCCtrlsGUI
extends JFrame {
    public static ShowFullImage ocShowFullImage = new ShowFullImage("OptiCam show Image");
    public StandaDev[] standaDev = new StandaDev[2];
    static OCOpcuaClient ocOpcuaClient = new OCOpcuaClient();
    public ErrorForm errorForm;
    public int devIndex = 0;
    public static JTextField enterAngleValueField;
    public static JLabel deviceNameLabel;
    public static JLabel stepsLabel;
    private String deviceCode = "OC\t";
    public JTextField ocTempLabel = new JTextField();
    public JLabel lblOchumid = new JLabel("ocHumid:");
    public static JLabel outputInfoLabel;
    public JTextArea infoTextArea = new JTextArea();
    public ButtonGroup moveRadioGroup = new ButtonGroup();
    public JRadioButton relativeRadioButton = new JRadioButton("Rel");
    public JRadioButton jogRadioButton = new JRadioButton("Jog");
    public boolean gotoLeftHome = true;
    public JLabel temperatureLabel = new JLabel("Temp:");
    public JLabel valueLikaEnc = new JLabel("LikaEnc:");
    private JComboBox deviceComboBox = new JComboBox();
    private JComboBox positionComboBox = new JComboBox();
    private JPanel likaPanel = new JPanel();
    public static JLabel ledLabel;
    public JLabel lblStatusVal = new JLabel("--");
    JLabel lblErrorVal = new JLabel("--");
    public JLabel lblTempVal = new JLabel("--");
    public JMenuItem endMenuItem = new JMenuItem("END");
    public JTextField textFieldTime = new JTextField("--");
    public static JPanel ximeaPanel;
    public static JLabel tempCtrlStatusLabel;
    private GetFile getFile;
    public JTree tree = new JTree();
    JCheckBox historyCheckBox = new JCheckBox("PlotHistory");
    public static HistoryPlot historyPlot;
    public static DataInputForm ocDataInputForm;
    public static JCheckBox autoLoadCheckBox;
    public int standaDevice;
    public int currentPos;
    public int currentUPos;
    public static String[] ximeaError;
    public String[] ximeaStatus = new String[]{"--", " -Open", " -Closed", " -Warning", " -Alarm", " -", " -", " -Fault"};
    public boolean startShowDataThread = true;
    private Thread ShowDataThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (!OCCtrlsGUI.this.startShowDataThread || !OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                            Thread.sleep(300L);
                            continue;
                        }
                        try {
                            Thread.sleep(300L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        OCCtrlsGUI.this.textFieldTime.setText("Update at: " + OCCtrlsGUI.ocOpcuaClient.isoStamp);
                        OCCtrlsGUI.this.ocTempLabel.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_inside_temp").getValue().toString());
                        OCCtrlsGUI.this.ocHumidLabel.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_inside_humidity").getValue().toString());
                        OCCtrlsGUI.this.ocLightLabel.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_inside_light").getValue().toString());
                        OCCtrlsGUI.this.ocSoundNoiseLabel.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_inside_sound_noise").getValue().toString());
                        if (OCCtrlsGUI.this.devIndex == 0) {
                            OCCtrlsGUI.this.infoTextArea.setText("- CART:");
                            OCCtrlsGUI.this.infoTextArea.append("\nPos (uSteps)= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_usteps_pos").getValue().toString());
                            OCCtrlsGUI.this.infoTextArea.append("\n\nisRunning= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_running_status").getValue().toString() + "  \nmvErr= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_move_error").getValue().toString());
                            OCCtrlsGUI.this.infoTextArea.append("\nALARM= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_alarm").getValue().toString());
                            int swStatus = ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_switch_status").getValue().intValue();
                            if (swStatus == 0) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= false");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= false");
                            } else if (swStatus == 1) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= false");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= true");
                            } else if (swStatus == 2) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= true");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= false");
                            } else {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= -----");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= -----");
                            }
                            OCCtrlsGUI.this.infoTextArea.append("\n\nhomeStatus= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_homing_status").getValue().toString());
                            int brakeStatus = ocOpcuaClient.getDataValue("ns=2;s=ns=2;s=oc_get_cart_brake_status").getValue().intValue();
                            if (brakeStatus == 1) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nBrakeStatus= IN");
                            } else if (brakeStatus == 0) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nBrakeStatus= OUT");
                            } else {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nBrakeStatus= -----");
                            }
                            OCCtrlsGUI.this.infoTextArea.append("\nPosition= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_pos").getValue().toString());
                            OCCtrlsGUI.this.temperatureLabel.setText("T=" + ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_temp").getValue().toString() + "\u00b0");
                        } else if (OCCtrlsGUI.this.devIndex == 1) {
                            OCCtrlsGUI.this.infoTextArea.setText("- WHEEL:");
                            OCCtrlsGUI.this.infoTextArea.append("\nPos (uSteps)= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_usteps_pos").getValue().toString());
                            OCCtrlsGUI.this.infoTextArea.append("\n\nisRunning= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_running_status").getValue().toString() + "  \nmvErr= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_move_error").getValue().toString());
                            OCCtrlsGUI.this.infoTextArea.append("\nALARM= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_alarm").getValue().toString());
                            int swStatus = ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_switch_status").getValue().intValue();
                            if (swStatus == 0) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= false");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= false");
                            } else if (swStatus == 1) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= false");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= true");
                            } else if (swStatus == 2) {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= true");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= false");
                            } else {
                                OCCtrlsGUI.this.infoTextArea.append("\n\nswitchRightStatus= -----");
                                OCCtrlsGUI.this.infoTextArea.append("\nswitchLeftStatus= -----");
                            }
                            OCCtrlsGUI.this.infoTextArea.append("\n\nhomingStatus= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_homing_status").getValue().toString());
                            OCCtrlsGUI.this.infoTextArea.append("\nPosition= " + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_pos").getValue().toString());
                            OCCtrlsGUI.this.temperatureLabel.setText("T=" + ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_temp").getValue().toString() + "\u00b0");
                        } else {
                            OCCtrlsGUI.this.infoTextArea.setText("\n\n--No device...");
                        }
                        OCCtrlsGUI.this.lblTempVal.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_temp").getValue().toString());
                        int stsNo = ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_status").getValue().toNumber().intValue();
                        if (stsNo <= OCCtrlsGUI.this.ximeaStatus.length) {
                            OCCtrlsGUI.this.lblStatusVal.setText(String.valueOf(ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_status").getValue().toString()) + OCCtrlsGUI.this.ximeaStatus[stsNo]);
                            OCCtrlsGUI.this.lblStatusVal.setToolTipText(OCCtrlsGUI.this.ximeaStatus[stsNo]);
                        } else {
                            OCCtrlsGUI.this.lblStatusVal.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_status").getValue().toString());
                            OCCtrlsGUI.this.lblStatusVal.setToolTipText("Status number");
                        }
                        int errNo = ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_error").getValue().toNumber().intValue();
                        if (errNo <= ximeaError.length) {
                            OCCtrlsGUI.this.lblErrorVal.setText(String.valueOf(ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_error").getValue().toString()) + ximeaError[errNo]);
                            OCCtrlsGUI.this.lblErrorVal.setToolTipText(ximeaError[errNo]);
                            continue;
                        }
                        OCCtrlsGUI.this.lblErrorVal.setText(ocOpcuaClient.getDataValue("ns=2;s=oc_get_cmos_error").getValue().toString());
                        OCCtrlsGUI.this.lblErrorVal.setToolTipText("Error number");
                    }
                }
                catch (Exception e) {
                    OCCtrlsGUI.outputInfo("ShowDataThread Exception: " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    };
    public final JButton hideButton = new JButton("HIDE");
    public boolean startSaveOnFile = false;
    public boolean startHomeThread = false;
    private Thread HomeThread = new Thread(){

        @Override
        public synchronized void run() {
            boolean hSts = false;
            while (true) {
                try {
                    while (!OCCtrlsGUI.this.startHomeThread) {
                        Thread.sleep(300L);
                    }
                    int cnt = 0;
                    while (!hSts) {
                        OCCtrlsGUI.outputInfo("WAIT");
                        if (OCCtrlsGUI.this.devIndex == 0) {
                            hSts = (Boolean)ocOpcuaClient.getDataValue("ns=2;s=oc_get_cart_homing_status").getValue().getValue();
                        } else if (OCCtrlsGUI.this.devIndex == 1) {
                            hSts = (Boolean)ocOpcuaClient.getDataValue("ns=2;s=oc_get_wheel_homing_status").getValue().getValue();
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (cnt++ > 120) {
                            OCCtrlsGUI.outputInfo("WARNING .. homing timeOut..");
                            if (OCCtrlsGUI.this.devIndex == 0) {
                                OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_stop"), (Object)1);
                            } else if (OCCtrlsGUI.this.devIndex == 1) {
                                OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_stop"), (Object)1);
                            }
                            OCCtrlsGUI.outputInfo("homing..OK");
                            break;
                        }
                        OCCtrlsGUI.outputInfo("WAIT .. homing..");
                    }
                }
                catch (Exception e) {
                    OCCtrlsGUI.outputInfo("HomeThread Exception: " + e.getMessage());
                }
                OCCtrlsGUI.this.startHomeThread = false;
                OCCtrlsGUI.outputInfo("");
            }
        }
    };
    public boolean startLikaThread = true;
    public static int likaEncValue;
    private Thread LikaThread = new Thread(){

        @Override
        public synchronized void run() {
            int likaValue = 0;
            Color colorDef = OCCtrlsGUI.this.valueLikaEnc.getForeground();
            while (true) {
                try {
                    while (true) {
                        if (!OCCtrlsGUI.this.startLikaThread || !OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                            Thread.sleep(500L);
                            OCCtrlsGUI.this.valueLikaEnc.setText("----");
                            continue;
                        }
                        likaValue = ocOpcuaClient.getDataValue("ns=2;s=oc_get_lika_encoder_counts").getValue().intValue();
                        OCCtrlsGUI.this.valueLikaEnc.getForeground();
                        if (likaValue > 0) {
                            OCCtrlsGUI.this.valueLikaEnc.setForeground(colorDef);
                            OCCtrlsGUI.this.valueLikaEnc.setText(String.valueOf(likaValue));
                            continue;
                        }
                        OCCtrlsGUI.this.valueLikaEnc.setForeground(Color.red);
                        OCCtrlsGUI.this.valueLikaEnc.setText("NullValue");
                    }
                }
                catch (Exception e) {
                    OCCtrlsGUI.outputInfo("LikaThread Exception: " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    };
    private JTextField ocHumidLabel;
    private JTextField ocLightLabel;
    private JTextField ocSoundNoiseLabel;
    private JTextField tExposureField;
    public static JTextField imageNameTextField;
    public JCheckBox fileNameCheckBox = new JCheckBox("");
    public JCheckBox jpgCheckBox = new JCheckBox("");
    public static JTextField setTmpField;
    private String nodeName;
    private String acsVar;
    private String unitString;
    public boolean startHistoryThread = false;
    private Thread HistoryThread = new Thread(){

        @Override
        public synchronized void run() {
            boolean hSts = false;
            while (true) {
                try {
                    while (!OCCtrlsGUI.this.startHistoryThread) {
                        Thread.sleep(500L);
                    }
                    OCCtrlsGUI.showHistoryPlot(OCCtrlsGUI.this.nodeName, OCCtrlsGUI.this.acsVar, OCCtrlsGUI.this.unitString);
                }
                catch (Exception e) {
                    OCCtrlsGUI.outputInfo("HistoryThread Exception: " + e.getMessage());
                }
                OCCtrlsGUI.this.startHistoryThread = false;
                OCCtrlsGUI.outputInfo("");
            }
        }
    };
    public static boolean getImageThreadFlag;
    public String imageNameToGet = "";
    public Thread getImageThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                if (!getImageThreadFlag) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
                String fname = imageNameTextField.getText();
                try {
                    if (!OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                        AIV_GUI.writeOnInfoText(" OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
                        AIV_GUI.inserIconOnInfoText(15, Utils.badImageIcon);
                        return;
                    }
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(new NodeId(2, "oc_set_clientportnumber"), (Object)9999);
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(new NodeId(2, "oc_set_fname"), (Object)fname);
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(new NodeId(2, "oc_sendimage"), (Object)1);
                    String addr = Utils.ocURL;
                    addr = addr == null | addr == "" ? "127.0.0.1" : addr.substring(addr.indexOf("//") + 2, addr.lastIndexOf(":"));
                    outputInfoLabel.setText("downloading...");
                    OCCtrlsGUI.this.getFile = new GetFile();
                    OCCtrlsGUI.this.getFile.setfName("ocImage.fits");
                    boolean gf = OCCtrlsGUI.this.getFile.receiveFile(addr, 9999, "./conf/");
                    if (gf) {
                        AIV_GUI.writeOnInfoText("\n file transfer success.." + fname + "\n", Color.blue, true, false, false, false, 15);
                        OCCtrlsGUI.ocShowFullImage.maxScrollBar.setMaximum(65535);
                        OCCtrlsGUI.ocShowFullImage.minScrollBar.setMaximum(65535);
                        ocShowFullImage.setImageP("./conf/ocImage.fits", 0);
                        OCCtrlsGUI.ocShowFullImage.maxScrollBar.setValue(OCCtrlsGUI.ocShowFullImage.imageMaxVal);
                        OCCtrlsGUI.ocShowFullImage.minScrollBar.setValue(OCCtrlsGUI.ocShowFullImage.imageMinVal);
                        ocShowFullImage.setVisible(true);
                        outputInfoLabel.setText("Image downloaded saved on ./conf/ocImage.fits");
                        AIV_GUI.writeOnInfoText("\n Image " + fname + ".fits max =" + OCCtrlsGUI.ocShowFullImage.imageMaxVal + " --  min =" + OCCtrlsGUI.ocShowFullImage.imageMinVal + "\n", Color.blue, true, false, false, false, 15);
                    } else {
                        AIV_GUI.writeOnInfoText("\n file transfer ERROR..from:" + addr + " file:" + fname + "\n", Color.red, true, false, false, true, 15);
                        outputInfoLabel.setText("file transfer ERROR..");
                    }
                }
                catch (Exception e1) {
                    AIV_GUI.writeOnInfoText("\n file transfer ERROR.." + e1.getMessage() + "\n", Color.red, true, false, false, true, 15);
                    outputInfoLabel.setText("file transfer ERROR..");
                }
                getImageThreadFlag = false;
            }
        }
    };

    static {
        deviceNameLabel = new JLabel("ocTemp:");
        stepsLabel = new JLabel("Angle");
        outputInfoLabel = new JLabel("--------");
        ledLabel = new JLabel("\u2022");
        ximeaPanel = new JPanel();
        tempCtrlStatusLabel = new JLabel("--");
        historyPlot = new HistoryPlot();
        ocDataInputForm = new DataInputForm("OC");
        autoLoadCheckBox = new JCheckBox("AutoLoad");
        ximeaError = new String[]{" CMOC: no error", " CMOS: camera connection failed", " CMOS: chip temperature out of range (low)", " CMOS: chip temperature out of range (high)", " CMOS: acquisition timeout", " CMOS: unable to write file", " CMOS: unable to read file", " CMOS: command not valid", " CMOS: camera Fault"};
        likaEncValue = -1;
        getImageThreadFlag = false;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AIV_GUI.consolle.setVisible(true);
                    OCCtrlsGUI window = new OCCtrlsGUI("");
                    window.setVisible(true);
                    window.endMenuItem.setEnabled(true);
                    window.hideButton.setVisible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public OCCtrlsGUI(String deviceCode) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("./conf/StandaIcon.jpg"));
        this.setDeviceCode(deviceCode);
        this.initialize();
    }

    public void closeDevice() {
        this.infoTextArea.setText("\nClosing device..");
        this.startShowDataThread = false;
        try {
            if (this.devIndex == 0) {
                OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_open_close"), (Object)2);
            } else if (this.devIndex == 1) {
                OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_open_close"), (Object)2);
            }
        }
        catch (Exception e1) {
            System.out.println("Standa CloseError: " + e1.getMessage());
        }
        this.infoTextArea.append("\ndevice closed");
    }

    private void initialize() {
        ControllUtils.getProperties();
        Utils.getProperties();
        ocOpcuaClient.startClient(Utils.ocURL);
        OCCtrlsGUI.ocOpcuaClient.opcuaNodeThread.start();
        this.ShowDataThread.start();
        this.HomeThread.start();
        this.LikaThread.start();
        this.HistoryThread.start();
        this.getImageThread.start();
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        this.errorForm = new ErrorForm("OC", "oc_error_index", "oc_error_information", "oc_error_reset", 2, OCCtrlsGUI.ocOpcuaClient.client, "oc_error_information", "oc_error_number");
        this.setTitle("OCCtrlsGUI - OptiCam GUI for ASTRI-MiniArray project");
        this.setResizable(false);
        this.setBackground(Color.LIGHT_GRAY);
        this.setBounds(100, 100, 1015, 390);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(null);
        enterAngleValueField = new JTextField();
        enterAngleValueField.setText("0");
        enterAngleValueField.setHorizontalAlignment(0);
        enterAngleValueField.setFont(new Font("Tahoma", 1, 12));
        enterAngleValueField.setBackground(new Color(255, 255, 230));
        enterAngleValueField.setBounds(72, 142, 70, 24);
        this.getContentPane().add(enterAngleValueField);
        enterAngleValueField.setColumns(10);
        JButton openButton = new JButton("Open");
        openButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (OCCtrlsGUI.this.devIndex == 0) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_open_close"), (Object)1);
                    } else if (OCCtrlsGUI.this.devIndex == 1) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_open_close"), (Object)1);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Standa OpenError: " + e1.getMessage());
                }
                OCCtrlsGUI.this.startShowDataThread = true;
            }
        });
        openButton.setForeground(Color.BLUE);
        openButton.setFont(new Font("Tahoma", 1, 12));
        openButton.setBackground(new Color(50, 205, 50));
        openButton.setBounds(502, 6, 83, 28);
        this.getContentPane().add(openButton);
        JButton leftVersusButton = new JButton("<");
        leftVersusButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_table_index"), (Object)OCCtrlsGUI.this.devIndex);
                    if (OCCtrlsGUI.this.jogRadioButton.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_move_jog_0left_1right"), (Object)0);
                        return;
                    }
                    float angle = Float.parseFloat(enterAngleValueField.getText().trim());
                    if (OCCtrlsGUI.this.relativeRadioButton.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_reletive_shift"), (Object)Float.valueOf(-angle));
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_move_relative"), (Object)1);
                        return;
                    }
                }
                catch (Exception e1) {
                    System.out.println("moveLeft Error: " + e1.getMessage());
                }
            }
        });
        leftVersusButton.setForeground(new Color(0, 0, 0));
        leftVersusButton.setFont(new Font("Tahoma", 1, 14));
        leftVersusButton.setBackground(Color.LIGHT_GRAY);
        leftVersusButton.setBounds(23, 141, 50, 26);
        this.getContentPane().add(leftVersusButton);
        stepsLabel.setBackground(Color.YELLOW);
        stepsLabel.setHorizontalAlignment(0);
        stepsLabel.setForeground(Color.BLACK);
        stepsLabel.setFont(new Font("Tahoma", 1, 12));
        stepsLabel.setBounds(72, 121, 62, 25);
        this.getContentPane().add(stepsLabel);
        JButton closeButton = new JButton("Close");
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OCCtrlsGUI.this.closeDevice();
            }
        });
        closeButton.setForeground(Color.BLUE);
        closeButton.setFont(new Font("Tahoma", 1, 12));
        closeButton.setBackground(Color.ORANGE);
        closeButton.setBounds(502, 33, 83, 28);
        this.getContentPane().add(closeButton);
        JButton rightVersusButton = new JButton(">");
        rightVersusButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_table_index"), (Object)OCCtrlsGUI.this.devIndex);
                    if (OCCtrlsGUI.this.jogRadioButton.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_move_jog_0left_1right"), (Object)1);
                        return;
                    }
                    float angle = Float.parseFloat(enterAngleValueField.getText().trim());
                    if (OCCtrlsGUI.this.relativeRadioButton.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_reletive_shift"), (Object)Float.valueOf(angle));
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_move_relative"), (Object)1);
                        return;
                    }
                }
                catch (Exception e1) {
                    System.out.println("moveRight Error: " + e1.getMessage());
                }
            }
        });
        rightVersusButton.setForeground(Color.BLACK);
        rightVersusButton.setFont(new Font("Tahoma", 1, 14));
        rightVersusButton.setBackground(Color.LIGHT_GRAY);
        rightVersusButton.setBounds(142, 141, 50, 26);
        this.getContentPane().add(rightVersusButton);
        JScrollPane infoScrollPane = new JScrollPane();
        infoScrollPane.setBounds(286, 7, 197, 278);
        this.getContentPane().add(infoScrollPane);
        this.infoTextArea.setFont(new Font("Arial", 1, 13));
        this.infoTextArea.setText(">");
        this.infoTextArea.setForeground(Color.BLUE);
        this.infoTextArea.setBackground(SystemColor.control);
        infoScrollPane.setViewportView(this.infoTextArea);
        JLabel lblBrake = new JLabel("Brake");
        lblBrake.setHorizontalAlignment(0);
        lblBrake.setForeground(Color.BLACK);
        lblBrake.setFont(new Font("Tahoma", 1, 12));
        lblBrake.setBackground(Color.YELLOW);
        lblBrake.setBounds(10, 191, 70, 26);
        this.getContentPane().add(lblBrake);
        JButton brakeOutButton = new JButton("Out");
        brakeOutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OCCtrlsGUI.this.setBrakeOUT();
            }
        });
        brakeOutButton.setForeground(Color.BLACK);
        brakeOutButton.setFont(new Font("Tahoma", 1, 12));
        brakeOutButton.setBackground(Color.LIGHT_GRAY);
        brakeOutButton.setBounds(78, 191, 62, 26);
        this.getContentPane().add(brakeOutButton);
        JButton brakeInButton = new JButton("In");
        brakeInButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OCCtrlsGUI.this.setBrakeIN();
            }
        });
        brakeInButton.setForeground(Color.BLACK);
        brakeInButton.setFont(new Font("Tahoma", 1, 12));
        brakeInButton.setBackground(Color.LIGHT_GRAY);
        brakeInButton.setBounds(140, 191, 62, 26);
        this.getContentPane().add(brakeInButton);
        CreateRoundButton stopButton = new CreateRoundButton("STOP");
        stopButton.setBorder(new BevelBorder(1, null, null, null, null));
        stopButton.setAlignmentX(0.5f);
        stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (OCCtrlsGUI.this.devIndex == 0) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_stop"), (Object)1);
                    } else if (OCCtrlsGUI.this.devIndex == 1) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_stop"), (Object)1);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Standa StopError: " + e1.getMessage());
                }
            }
        });
        stopButton.setForeground(Color.BLUE);
        stopButton.setFont(new Font("Tahoma", 1, 12));
        stopButton.setBackground(Color.RED);
        stopButton.setBounds(502, 218, 82, 41);
        this.getContentPane().add(stopButton);
        JButton setZeroButton = new JButton("SetZero");
        setZeroButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (OCCtrlsGUI.this.devIndex == 0) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_zero"), (Object)1);
                    } else if (OCCtrlsGUI.this.devIndex == 1) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_zero"), (Object)1);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Standa ZeroError: " + e1.getMessage());
                }
            }
        });
        setZeroButton.setForeground(Color.BLUE);
        setZeroButton.setFont(new Font("Tahoma", 1, 12));
        setZeroButton.setBackground(new Color(255, 0, 255));
        setZeroButton.setBounds(503, 130, 81, 23);
        this.getContentPane().add(setZeroButton);
        this.moveRadioGroup.add(this.jogRadioButton);
        this.moveRadioGroup.add(this.relativeRadioButton);
        this.jogRadioButton.setBorderPainted(true);
        this.jogRadioButton.setBackground(new Color(153, 204, 0));
        this.jogRadioButton.setBounds(202, 128, 62, 24);
        this.getContentPane().add(this.jogRadioButton);
        this.relativeRadioButton.setSelected(true);
        this.relativeRadioButton.setBorderPainted(true);
        this.relativeRadioButton.setBackground(new Color(153, 204, 0));
        this.relativeRadioButton.setBounds(202, 156, 62, 24);
        this.getContentPane().add(this.relativeRadioButton);
        JButton homeLeftButton = new JButton("InitOnSwitch");
        homeLeftButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OCCtrlsGUI.this.startShowDataThread = true;
                try {
                    if (OCCtrlsGUI.this.devIndex == 0) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_home"), (Object)1);
                    } else if (OCCtrlsGUI.this.devIndex == 1) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_home"), (Object)1);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Standa HomeError: " + e1.getMessage());
                }
                if (OCCtrlsGUI.this.startHomeThread) {
                    OCCtrlsGUI.outputInfo(" command Already actived.. wait.. or press STOP");
                } else {
                    OCCtrlsGUI.this.startHomeThread = true;
                }
            }
        });
        homeLeftButton.setForeground(Color.BLUE);
        homeLeftButton.setFont(new Font("Tahoma", 1, 10));
        homeLeftButton.setBackground(Color.PINK);
        homeLeftButton.setBounds(493, 158, 100, 23);
        this.getContentPane().add(homeLeftButton);
        this.temperatureLabel.setAlignmentX(0.5f);
        this.temperatureLabel.setHorizontalAlignment(0);
        this.temperatureLabel.setForeground(Color.BLACK);
        this.temperatureLabel.setFont(new Font("Tahoma", 0, 12));
        this.temperatureLabel.setBackground(Color.YELLOW);
        this.temperatureLabel.setBounds(503, 109, 81, 18);
        this.getContentPane().add(this.temperatureLabel);
        this.likaPanel.setBorder(new EtchedBorder(1, null, null));
        this.likaPanel.setBackground(new Color(72, 209, 204));
        this.likaPanel.setBounds(6, 234, 276, 51);
        this.getContentPane().add(this.likaPanel);
        this.likaPanel.setLayout(null);
        JLabel lblLikaenc = new JLabel("LikaEnc:");
        lblLikaenc.setBounds(-1, 17, 66, 18);
        lblLikaenc.setHorizontalAlignment(0);
        lblLikaenc.setForeground(Color.BLUE);
        lblLikaenc.setFont(new Font("Tahoma", 1, 12));
        this.likaPanel.add(lblLikaenc);
        this.valueLikaEnc.setOpaque(true);
        this.valueLikaEnc.setBackground(new Color(240, 248, 255));
        this.valueLikaEnc.setHorizontalAlignment(0);
        this.valueLikaEnc.setForeground(new Color(0, 0, 128));
        this.valueLikaEnc.setFont(new Font("Tahoma", 1, 16));
        this.valueLikaEnc.setBounds(83, 13, 142, 24);
        this.likaPanel.add(this.valueLikaEnc);
        outputInfoLabel.setBounds(4, 290, 581, 25);
        this.getContentPane().add(outputInfoLabel);
        outputInfoLabel.setHorizontalAlignment(0);
        outputInfoLabel.setForeground(Color.BLACK);
        outputInfoLabel.setFont(new Font("Tahoma", 1, 11));
        outputInfoLabel.setBackground(Color.YELLOW);
        JButton defaultPosButton = new JButton("GoToDefPos");
        defaultPosButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OCCtrlsGUI.this.startShowDataThread = true;
                try {
                    if (OCCtrlsGUI.this.devIndex == 0) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_to_default_pos"), (Object)1);
                    } else if (OCCtrlsGUI.this.devIndex == 1) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_to_default_pos"), (Object)1);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Standa GoToDefaltPosition Error: " + e1.getMessage());
                }
            }
        });
        defaultPosButton.setForeground(Color.BLUE);
        defaultPosButton.setFont(new Font("Tahoma", 1, 10));
        defaultPosButton.setBackground(Color.PINK);
        defaultPosButton.setBounds(493, 184, 100, 23);
        this.getContentPane().add(defaultPosButton);
        JLabel lblGotoposition = new JLabel("SetPosition:");
        lblGotoposition.setHorizontalAlignment(0);
        lblGotoposition.setForeground(Color.BLUE);
        lblGotoposition.setFont(new Font("Tahoma", 1, 12));
        lblGotoposition.setBounds(10, 89, 102, 25);
        this.getContentPane().add(lblGotoposition);
        this.positionComboBox.setBounds(112, 89, 119, 24);
        this.getContentPane().add(this.positionComboBox);
        JButton goButton = new JButton("Go");
        goButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int pos = OCCtrlsGUI.this.positionComboBox.getSelectedIndex();
                try {
                    if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                        if (OCCtrlsGUI.this.devIndex == 0) {
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_cart_position"), (Object)(pos + 1));
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_goto_position"), (Object)1);
                        } else if (OCCtrlsGUI.this.devIndex == 1) {
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_wheel_position"), (Object)(pos + 1));
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_goto_position"), (Object)1);
                        }
                    } else {
                        System.out.println("Error OC_Server is not connected.");
                    }
                }
                catch (ServiceException | StatusException e1) {
                    e1.printStackTrace();
                }
            }
        });
        goButton.setForeground(Color.BLUE);
        goButton.setFont(new Font("Tahoma", 1, 12));
        goButton.setBackground(new Color(50, 205, 50));
        goButton.setBounds(234, 87, 49, 26);
        this.getContentPane().add(goButton);
        JButton resyncButton = new JButton("Resync");
        resyncButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (OCCtrlsGUI.this.devIndex == 0) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_resync"), (Object)2);
                    } else if (OCCtrlsGUI.this.devIndex == 1) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_wheel_resync"), (Object)2);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Standa ResyncError: " + e1.getMessage());
                }
            }
        });
        resyncButton.setToolTipText("resyncPort");
        resyncButton.setForeground(Color.ORANGE);
        resyncButton.setFont(new Font("Tahoma", 1, 12));
        resyncButton.setBackground(Color.DARK_GRAY);
        resyncButton.setBounds(502, 72, 83, 28);
        this.getContentPane().add(resyncButton);
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        panel.setBackground(new Color(102, 205, 170));
        panel.setBounds(6, 6, 276, 72);
        this.getContentPane().add(panel);
        panel.setLayout(null);
        deviceNameLabel.setBounds(6, 8, 56, 25);
        panel.add(deviceNameLabel);
        deviceNameLabel.setHorizontalAlignment(0);
        deviceNameLabel.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel.setForeground(Color.BLUE);
        deviceNameLabel.setLabelFor(openButton);
        this.ocTempLabel.setBounds(62, 8, 70, 25);
        panel.add(this.ocTempLabel);
        this.ocTempLabel.setText("---");
        this.ocTempLabel.setHorizontalAlignment(0);
        this.ocTempLabel.setFont(new Font("Tahoma", 1, 12));
        this.ocTempLabel.setColumns(10);
        this.ocTempLabel.setBackground(new Color(255, 255, 230));
        this.lblOchumid.setBounds(137, 8, 63, 25);
        panel.add(this.lblOchumid);
        this.lblOchumid.setHorizontalAlignment(0);
        this.lblOchumid.setForeground(Color.BLUE);
        this.lblOchumid.setFont(new Font("Tahoma", 1, 12));
        this.ocHumidLabel = new JTextField();
        this.ocHumidLabel.setBounds(202, 8, 70, 25);
        panel.add(this.ocHumidLabel);
        this.ocHumidLabel.setText("---");
        this.ocHumidLabel.setHorizontalAlignment(0);
        this.ocHumidLabel.setFont(new Font("Tahoma", 1, 12));
        this.ocHumidLabel.setColumns(10);
        this.ocHumidLabel.setBackground(new Color(255, 255, 230));
        JLabel lblOclight = new JLabel("ocLight:");
        lblOclight.setHorizontalAlignment(0);
        lblOclight.setForeground(Color.BLUE);
        lblOclight.setFont(new Font("Tahoma", 1, 12));
        lblOclight.setBounds(6, 40, 56, 25);
        panel.add(lblOclight);
        JLabel lblOsnoise = new JLabel("ocNoise:");
        lblOsnoise.setHorizontalAlignment(0);
        lblOsnoise.setForeground(Color.BLUE);
        lblOsnoise.setFont(new Font("Tahoma", 1, 12));
        lblOsnoise.setBounds(137, 40, 63, 25);
        panel.add(lblOsnoise);
        this.ocLightLabel = new JTextField();
        this.ocLightLabel.setText("---");
        this.ocLightLabel.setHorizontalAlignment(0);
        this.ocLightLabel.setFont(new Font("Tahoma", 1, 12));
        this.ocLightLabel.setColumns(10);
        this.ocLightLabel.setBackground(new Color(255, 255, 230));
        this.ocLightLabel.setBounds(62, 40, 70, 25);
        panel.add(this.ocLightLabel);
        this.ocSoundNoiseLabel = new JTextField();
        this.ocSoundNoiseLabel.setText("---");
        this.ocSoundNoiseLabel.setHorizontalAlignment(0);
        this.ocSoundNoiseLabel.setFont(new Font("Tahoma", 1, 12));
        this.ocSoundNoiseLabel.setColumns(10);
        this.ocSoundNoiseLabel.setBackground(new Color(255, 255, 230));
        this.ocSoundNoiseLabel.setBounds(202, 40, 70, 25);
        panel.add(this.ocSoundNoiseLabel);
        ximeaPanel.setToolTipText("XimeaPanel");
        ximeaPanel.setBackground(new Color(250, 235, 215));
        ximeaPanel.setBorder(new TitledBorder(new EtchedBorder(0, new Color(0, 0, 255), new Color(160, 160, 160)), "Ximea Panel", 2, 2, null, new Color(0, 0, 255)));
        ximeaPanel.setBounds(595, 7, 210, 308);
        this.getContentPane().add(ximeaPanel);
        ximeaPanel.setLayout(null);
        JPanel acquirePanel = new JPanel();
        acquirePanel.setBackground(new Color(204, 204, 153));
        acquirePanel.setBounds(10, 55, 190, 114);
        ximeaPanel.add(acquirePanel);
        acquirePanel.setLayout(null);
        JLabel lblmsec = new JLabel(" (sec) ");
        lblmsec.setBounds(139, 16, 43, 14);
        acquirePanel.add(lblmsec);
        JButton btnStart = new JButton("Start");
        btnStart.setToolTipText("Shot an image");
        btnStart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!OCCtrlsGUI.ocOpcuaClient.oc_get_cmos_image_acquired) {
                        Utils.beep(1);
                        OCCtrlsGUI.outputInfo("--> StartImage not allowed.. try later");
                        return;
                    }
                    OCCtrlsGUI.outputInfo("--> Start image....");
                    float integrationTime = Float.parseFloat(OCCtrlsGUI.this.tExposureField.getText().trim());
                    if (integrationTime <= 0.0f) {
                        Utils.beep(1);
                        OCCtrlsGUI.outputInfo("--> Check Integration Time Value...");
                        return;
                    }
                    OCCtrlsGUI.outputInfo("--> Integration Time =" + integrationTime);
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(new NodeId(2, "oc_set_exptm"), (Object)Float.valueOf(integrationTime));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (OCCtrlsGUI.this.fileNameCheckBox.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_rename_image"), (Object)true);
                    } else {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_rename_image"), (Object)false);
                    }
                    if (OCCtrlsGUI.this.jpgCheckBox.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_jpg_onoff"), (Object)true);
                    } else {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_jpg_onoff"), (Object)false);
                    }
                    if (OCCtrlsGUI.this.fileNameCheckBox.isSelected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(new NodeId(2, "oc_set_fname"), (Object)imageNameTextField.getText().trim());
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OCCtrlsGUI.ocOpcuaClient.client.writeValue(new NodeId(2, "oc_do_image"), (Object)1);
                }
                catch (Exception e1) {
                    OCCtrlsGUI.outputInfo("--> Error on start image.." + e1.getMessage());
                }
            }
        });
        btnStart.setBounds(10, 11, 65, 23);
        btnStart.setForeground(new Color(0, 0, 139));
        btnStart.setFont(new Font("Tahoma", 1, 12));
        btnStart.setBackground(new Color(0, 102, 0));
        acquirePanel.add(btnStart);
        this.tExposureField = new JTextField();
        this.tExposureField.setFont(new Font("Tahoma", 1, 12));
        this.tExposureField.setBounds(78, 11, 62, 22);
        this.tExposureField.setText("1.0");
        this.tExposureField.setHorizontalAlignment(0);
        this.tExposureField.setColumns(10);
        this.tExposureField.setBackground(new Color(255, 255, 240));
        acquirePanel.add(this.tExposureField);
        imageNameTextField = new JTextField();
        imageNameTextField.setText("ImageName");
        imageNameTextField.setHorizontalAlignment(0);
        imageNameTextField.setFont(new Font("Tahoma", 1, 12));
        imageNameTextField.setColumns(10);
        imageNameTextField.setBackground(new Color(255, 255, 240));
        imageNameTextField.setBounds(10, 58, 159, 24);
        acquirePanel.add(imageNameTextField);
        JLabel fileNameLabel = new JLabel("Set FileName");
        fileNameLabel.setBounds(10, 41, 70, 13);
        acquirePanel.add(fileNameLabel);
        this.fileNameCheckBox.setBounds(82, 37, 21, 18);
        acquirePanel.add(this.fileNameCheckBox);
        JLabel lblJpg = new JLabel("JPG:");
        lblJpg.setBounds(120, 40, 27, 13);
        acquirePanel.add(lblJpg);
        this.jpgCheckBox.setSelected(true);
        this.jpgCheckBox.setBounds(152, 37, 21, 18);
        acquirePanel.add(this.jpgCheckBox);
        JButton btnGetImg = new JButton("GetImg");
        btnGetImg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String fname = imageNameTextField.getText();
                if (getImageThreadFlag) {
                    AIV_GUI.writeOnInfoText("\n OptiCam GetImage: warning, retry later...");
                    outputInfoLabel.setText("OptiCam GetImage: warning, retry later...");
                    Utils.beep(1);
                } else {
                    getImageThreadFlag = true;
                }
            }
        });
        btnGetImg.setBorder(new BevelBorder(0, null, null, null, null));
        btnGetImg.setBounds(10, 87, 82, 23);
        acquirePanel.add(btnGetImg);
        btnGetImg.setToolTipText("cmd to get last image via ftp from the server");
        btnGetImg.setForeground(new Color(0, 0, 139));
        btnGetImg.setFont(new Font("Tahoma", 1, 10));
        btnGetImg.setBackground(Color.ORANGE);
        autoLoadCheckBox.setBounds(98, 88, 84, 18);
        acquirePanel.add(autoLoadCheckBox);
        JButton btnGetInfo = new JButton("GetInfo");
        btnGetInfo.setBounds(118, 280, 82, 23);
        ximeaPanel.add(btnGetInfo);
        btnGetInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cmos_info"), (Object)1);
                    } else {
                        System.out.println("Server is NOT connected");
                    }
                }
                catch (ServiceException | StatusException e1) {
                    System.out.println("Error on getInfo command." + e1.getMessage());
                }
            }
        });
        btnGetInfo.setToolTipText("to get info");
        btnGetInfo.setForeground(new Color(0, 0, 139));
        btnGetInfo.setFont(new Font("Tahoma", 1, 10));
        btnGetInfo.setBackground(Color.ORANGE);
        JButton btnOpen = new JButton("StartXm");
        btnOpen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block5: {
                    if (e.getClickCount() == 2) {
                        try {
                            if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                                OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cmos_ctrl_open_close"), (Object)1);
                                break block5;
                            }
                            System.out.println("Server is NOT connected");
                        }
                        catch (ServiceException | StatusException e1) {
                            System.out.println("Error on Open Ximea driver command." + e1.getMessage());
                        }
                    } else {
                        OCCtrlsGUI.outputInfo("use doubleClick..");
                    }
                }
            }
        });
        btnOpen.setToolTipText("start the Ximea control sw");
        btnOpen.setForeground(new Color(0, 0, 139));
        btnOpen.setFont(new Font("Tahoma", 1, 10));
        btnOpen.setBackground(Color.GREEN);
        btnOpen.setBounds(10, 25, 82, 23);
        ximeaPanel.add(btnOpen);
        JButton btnClose = new JButton("StopXm");
        btnClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block5: {
                    if (e.getClickCount() == 2) {
                        try {
                            if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                                OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cmos_ctrl_open_close"), (Object)0);
                                break block5;
                            }
                            System.out.println("Server is NOT connected");
                        }
                        catch (ServiceException | StatusException e1) {
                            System.out.println("Error on Close Ximea driver command." + e1.getMessage());
                        }
                    } else {
                        OCCtrlsGUI.outputInfo("use doubleClick..");
                    }
                }
            }
        });
        btnClose.setToolTipText("stop the Ximea control sw");
        btnClose.setForeground(new Color(0, 0, 139));
        btnClose.setFont(new Font("Tahoma", 1, 10));
        btnClose.setBackground(Color.RED);
        btnClose.setBounds(118, 25, 82, 23);
        ximeaPanel.add(btnClose);
        JButton btnSettmp = new JButton("SetTmp");
        btnSettmp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block5: {
                    try {
                        if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                            float tmp = Float.parseFloat(setTmpField.getText());
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_cmos_temperature"), (Object)Float.valueOf(tmp));
                            try {
                                Thread.sleep(300L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cmos_temperature_set"), (Object)1);
                            break block5;
                        }
                        System.out.println("Server is NOT connected");
                    }
                    catch (ServiceException | StatusException e1) {
                        System.out.println("Error on SETTemperature command." + e1.getMessage());
                    }
                }
            }
        });
        btnSettmp.setToolTipText("set temperature and enable controller");
        btnSettmp.setForeground(new Color(0, 0, 139));
        btnSettmp.setFont(new Font("Tahoma", 0, 10));
        btnSettmp.setBackground(Color.GREEN);
        btnSettmp.setBounds(10, 175, 70, 23);
        ximeaPanel.add(btnSettmp);
        JButton btnStop = new JButton("Stop");
        btnStop.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                        OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cmos_temperature_ctrl_off"), (Object)1);
                    } else {
                        System.out.println("Server is NOT connected");
                    }
                }
                catch (ServiceException | StatusException e1) {
                    System.out.println("Error on STOP ctrl Temperature command." + e1.getMessage());
                }
            }
        });
        btnStop.setToolTipText("turn off the cmos temperature controller");
        btnStop.setForeground(new Color(0, 0, 139));
        btnStop.setFont(new Font("Tahoma", 1, 10));
        btnStop.setBackground(Color.RED);
        btnStop.setBounds(138, 175, 62, 23);
        ximeaPanel.add(btnStop);
        setTmpField = new JTextField();
        setTmpField.setText("0.0");
        setTmpField.setHorizontalAlignment(0);
        setTmpField.setFont(new Font("Tahoma", 1, 10));
        setTmpField.setColumns(10);
        setTmpField.setBackground(new Color(255, 255, 240));
        setTmpField.setBounds(86, 175, 47, 23);
        ximeaPanel.add(setTmpField);
        Component horizontalStrut_1_1 = Box.createHorizontalStrut(20);
        horizontalStrut_1_1.setBackground(Color.BLUE);
        horizontalStrut_1_1.setBounds(10, 200, 190, 12);
        ximeaPanel.add(horizontalStrut_1_1);
        JLabel lblStatus = new JLabel("Status:");
        lblStatus.setBounds(10, 240, 38, 13);
        ximeaPanel.add(lblStatus);
        this.lblStatusVal.setBackground(Color.WHITE);
        this.lblStatusVal.setForeground(Color.BLUE);
        this.lblStatusVal.setBounds(50, 240, 150, 13);
        ximeaPanel.add(this.lblStatusVal);
        JLabel lblTemp = new JLabel("Temp:");
        lblTemp.setBounds(10, 216, 38, 13);
        ximeaPanel.add(lblTemp);
        this.lblTempVal.setHorizontalAlignment(0);
        this.lblTempVal.setForeground(Color.BLUE);
        this.lblTempVal.setBackground(Color.WHITE);
        this.lblTempVal.setBounds(50, 216, 38, 13);
        ximeaPanel.add(this.lblTempVal);
        JLabel lblError = new JLabel("Error:");
        lblError.setBounds(10, 256, 38, 13);
        ximeaPanel.add(lblError);
        this.lblErrorVal.setForeground(Color.BLUE);
        this.lblErrorVal.setBackground(Color.WHITE);
        this.lblErrorVal.setBounds(50, 256, 150, 13);
        ximeaPanel.add(this.lblErrorVal);
        tempCtrlStatusLabel.setHorizontalAlignment(0);
        tempCtrlStatusLabel.setForeground(new Color(85, 107, 47));
        tempCtrlStatusLabel.setBackground(new Color(255, 255, 224));
        tempCtrlStatusLabel.setBounds(118, 216, 82, 13);
        ximeaPanel.add(tempCtrlStatusLabel);
        JButton btnNewButton = new JButton("Cir");
        btnNewButton.setBounds(10, 280, 50, 23);
        ximeaPanel.add(btnNewButton);
        JButton btnCross = new JButton("Cross");
        btnCross.setBounds(57, 280, 50, 23);
        ximeaPanel.add(btnCross);
        btnCross.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ocShowFullImage.drawCross(5, 5, 10);
                ocShowFullImage.drawCross(100, 100, 50);
            }
        });
        btnNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ocShowFullImage.drawCircle(10, 10, 100);
                ocShowFullImage.drawCircle(400, 400, 300);
            }
        });
        this.treeSetModel();
        JScrollPane treeScrollPane = new JScrollPane();
        treeScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, Integer.MAX_VALUE));
        treeScrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 10));
        treeScrollPane.setBounds(812, 6, 187, 278);
        this.getContentPane().add(treeScrollPane);
        treeScrollPane.setViewportView(this.tree);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath tp = OCCtrlsGUI.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp.getPath().length == 3) {
                    OCCtrlsGUI.this.jtreeToOpcua(tp.getPath()[1].toString(), tp.getPath()[2].toString());
                }
            }
        });
        this.tree.setToolTipText("this is my tree...");
        this.tree.setScrollsOnExpand(false);
        this.tree.setName("OCtree");
        this.tree.setForeground(Color.LIGHT_GRAY);
        this.tree.setFont(new Font("SansSerif", 0, 10));
        this.tree.setBackground(new Color(255, 255, 204));
        treeScrollPane.setViewportView(this.tree);
        this.historyCheckBox.setFont(new Font("SansSerif", 1, 12));
        this.historyCheckBox.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.historyCheckBox.setBackground(new Color(255, 255, 204));
        this.historyCheckBox.setAlignmentX(0.5f);
        this.historyCheckBox.setBounds(822, 291, 89, 20);
        this.getContentPane().add(this.historyCheckBox);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setFont(new Font("Segoe UI", 1, 19));
        this.setJMenuBar(menuBar);
        JMenu fileNewMenu = new JMenu("File");
        fileNewMenu.setFont(new Font("Tahoma", 1, 14));
        menuBar.add(fileNewMenu);
        this.endMenuItem.setFont(new Font("Segoe UI", 1, 12));
        this.endMenuItem.setEnabled(false);
        this.endMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenuItem mntmNewMenuItem = new JMenuItem("Consolle");
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AIV_GUI.consolle.setVisible(true);
            }
        });
        fileNewMenu.add(mntmNewMenuItem);
        JMenuItem showPropsNewMenuItem = new JMenuItem("ShowProps");
        showPropsNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.showProps();
            }
        });
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("ErrorForm");
        mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCCtrlsGUI.this.errorForm.setVisible(true);
            }
        });
        fileNewMenu.add(mntmNewMenuItem_1);
        fileNewMenu.add(showPropsNewMenuItem);
        JMenuItem mntmNewMenuItem_2 = new JMenuItem("ShowAllNode");
        mntmNewMenuItem_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                AIV_GUI.nodesGridFrameTitle = "Optical Camera OPCUA node list - URL= " + Utils.ocURL;
                AIV_GUI.opcuaStartReadThread = true;
            }
        });
        fileNewMenu.add(mntmNewMenuItem_2);
        fileNewMenu.add(this.endMenuItem);
        Component horizontalStrut_2 = Box.createHorizontalStrut(46);
        menuBar.add(horizontalStrut_2);
        menuBar.add(this.hideButton);
        this.hideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OCCtrlsGUI.this.setVisible(false);
            }
        });
        this.hideButton.setForeground(Color.BLUE);
        this.hideButton.setFont(new Font("Tahoma", 1, 12));
        this.hideButton.setBackground(Color.LIGHT_GRAY);
        this.deviceComboBox.setInheritsPopupMenu(true);
        this.deviceComboBox.setFont(new Font("Tahoma", 1, 12));
        this.deviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int indx = OCCtrlsGUI.this.deviceComboBox.getSelectedIndex();
                try {
                    if (OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
                        if (indx == 1) {
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_table_index"), (Object)1);
                            OCCtrlsGUI.this.positionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Def-90'", "Default", "Def+90'"}));
                            OCCtrlsGUI.this.positionComboBox.setSelectedIndex(1);
                        } else {
                            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_set_table_index"), (Object)0);
                            OCCtrlsGUI.this.positionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Def-4.5'", "Def-3.0'", "Def-1.5'", "Default", "Def+1.5'", "Def+3.0'", "Def+4.5'"}));
                            OCCtrlsGUI.this.positionComboBox.setSelectedIndex(3);
                        }
                    } else {
                        System.out.println("Error OC_Server is not connected.");
                    }
                    OCCtrlsGUI.this.devIndex = indx;
                }
                catch (ServiceException | StatusException e1) {
                    System.out.println(e1.getMessage());
                }
                System.out.println();
            }
        });
        JLabel deviceNameLabel_1 = new JLabel("  Use --> ");
        deviceNameLabel_1.setHorizontalAlignment(0);
        deviceNameLabel_1.setForeground(Color.BLUE);
        deviceNameLabel_1.setFont(new Font("Tahoma", 1, 14));
        menuBar.add(deviceNameLabel_1);
        this.deviceComboBox.setBackground(Color.YELLOW);
        this.deviceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\u2022 CART ", "\u2022 WHEEL "}));
        this.deviceComboBox.setSelectedIndex(0);
        menuBar.add(this.deviceComboBox);
        JButton reconnectButton = new JButton("Reconnect");
        reconnectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ocOpcuaClient.stopClient();
                Utils.getProperties();
                ocOpcuaClient = new OCOpcuaClient();
                ocOpcuaClient.startClient(Utils.ocURL);
                OCCtrlsGUI.this.errorForm.dispose();
                OCCtrlsGUI.this.errorForm = new ErrorForm("OC", "oc_error_index", "oc_error_information", "oc_error_reset", 2, OCCtrlsGUI.ocOpcuaClient.client, "oc_error_information", "oc_error_number");
            }
        });
        reconnectButton.setForeground(Color.BLUE);
        reconnectButton.setFont(new Font("Tahoma", 1, 12));
        reconnectButton.setBackground(Color.LIGHT_GRAY);
        menuBar.add(reconnectButton);
        Component horizontalStrut = Box.createHorizontalStrut(98);
        menuBar.add(horizontalStrut);
        this.textFieldTime.setToolTipText("Update at: ");
        this.textFieldTime.setText("---");
        this.textFieldTime.setHorizontalAlignment(0);
        this.textFieldTime.setFont(new Font("Tahoma", 1, 12));
        this.textFieldTime.setColumns(10);
        this.textFieldTime.setBackground(new Color(255, 255, 230));
        this.textFieldTime.setAutoscrolls(false);
        menuBar.add(this.textFieldTime);
        ledLabel.setSize(new Dimension(6, 6));
        ledLabel.setForeground(Color.RED);
        ledLabel.setVerticalAlignment(3);
        ledLabel.setPreferredSize(new Dimension(20, 4));
        ledLabel.setToolTipText("heartBeat");
        ledLabel.setHorizontalTextPosition(0);
        ledLabel.setHorizontalAlignment(0);
        ledLabel.setFont(new Font("Tahoma", 1, 25));
        menuBar.add(ledLabel);
    }

    public void setBrakeOUT() {
        try {
            Thread.sleep(300L);
            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_brake_out"), (Object)1);
        }
        catch (Exception e) {
            System.out.println("Standa setBrakeOUT: " + e.getMessage());
        }
    }

    public void setBrakeIN() {
        try {
            Thread.sleep(300L);
            OCCtrlsGUI.ocOpcuaClient.client.writeValue(ocOpcuaClient.getNodeId("ns=2;s=oc_cart_brake_in"), (Object)1);
        }
        catch (Exception e) {
            System.out.println("Standa setBrakeOUT: " + e.getMessage());
        }
    }

    public static void outputInfo(String msg) {
        outputInfoLabel.setText(msg);
        System.out.println(msg);
    }

    public void treeSetModel() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("OPCUA_node_list"){
            {
                DefaultMutableTreeNode node_get = new DefaultMutableTreeNode("GetList");
                int g = 0;
                while (g < OCCtrlsGUI.ocOpcuaClient.ocICD.get_ACSName_List.size()) {
                    node_get.add(new DefaultMutableTreeNode(OCCtrlsGUI.ocOpcuaClient.ocICD.get_ACSName_List.get(g)));
                    ++g;
                }
                super.add(node_get);
                DefaultMutableTreeNode node_set = new DefaultMutableTreeNode("SetList");
                int g2 = 0;
                while (g2 < OCCtrlsGUI.ocOpcuaClient.ocICD.set_ACSName_List.size()) {
                    node_set.add(new DefaultMutableTreeNode(OCCtrlsGUI.ocOpcuaClient.ocICD.set_ACSName_List.get(g2)));
                    ++g2;
                }
                super.add(node_set);
                DefaultMutableTreeNode node_cmd = new DefaultMutableTreeNode("CmdList");
                int g3 = 0;
                while (g3 < OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_ACSName_List.size()) {
                    node_cmd.add(new DefaultMutableTreeNode(OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_ACSName_List.get(g3)));
                    ++g3;
                }
                super.add(node_cmd);
                DefaultMutableTreeNode node_mode = new DefaultMutableTreeNode("ModeList");
                int g4 = 0;
                while (g4 < OCCtrlsGUI.ocOpcuaClient.ocICD.mode_ACSName_List.size()) {
                    node_mode.add(new DefaultMutableTreeNode(OCCtrlsGUI.ocOpcuaClient.ocICD.mode_ACSName_List.get(g4)));
                    ++g4;
                }
                super.add(node_mode);
            }
        }));
    }

    private void jtreeToOpcua(String nodeList, String acsName) {
        if (!OCCtrlsGUI.ocOpcuaClient.client.isConnected()) {
            AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText(" OC OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
            return;
        }
        this.nodeName = "";
        this.unitString = "unit";
        this.acsVar = acsName;
        switch (nodeList) {
            case "GetList": {
                int ix = 0;
                while (ix < OCCtrlsGUI.ocOpcuaClient.ocICD.get_ACSName_List.size()) {
                    if (acsName.equals(OCCtrlsGUI.ocOpcuaClient.ocICD.get_ACSName_List.get(ix).trim())) {
                        this.nodeName = OCCtrlsGUI.ocOpcuaClient.ocICD.get_NodeName_List.get(ix);
                        this.unitString = OCCtrlsGUI.ocOpcuaClient.ocICD.get_Unit_List.get(ix);
                        OCCtrlsGUI.getOPCUAdata(this.nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + OCCtrlsGUI.ocOpcuaClient.ocICD.get_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                if (!this.historyCheckBox.isSelected()) break;
                if (this.startHistoryThread) {
                    OCCtrlsGUI.outputInfo("History command not allowed.. try again after..");
                    break;
                }
                this.startHistoryThread = true;
                break;
            }
            case "SetList": {
                int ix = 0;
                while (ix < OCCtrlsGUI.ocOpcuaClient.ocICD.set_ACSName_List.size()) {
                    if (acsName.equals(OCCtrlsGUI.ocOpcuaClient.ocICD.set_ACSName_List.get(ix))) {
                        this.nodeName = OCCtrlsGUI.ocOpcuaClient.ocICD.set_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... SET");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + OCCtrlsGUI.ocOpcuaClient.ocICD.set_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(OCCtrlsGUI.ocOpcuaClient.ocICD.set_NodeName_List.get(ix)) + " [" + OCCtrlsGUI.ocOpcuaClient.ocICD.set_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(OCCtrlsGUI.ocOpcuaClient.ocICD.set_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(OCCtrlsGUI.getOPCUAdata(this.nodeName));
                        AIV_GUI.writeOnInfoText("Description: " + OCCtrlsGUI.ocOpcuaClient.ocICD.set_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        DataInputForm.enterDataValueField.setForeground(Color.BLACK);
                    }
                    ++ix;
                }
                break;
            }
            case "CmdList": {
                int ix = 0;
                while (ix < OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_ACSName_List.size()) {
                    if (acsName.equals(OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_ACSName_List.get(ix))) {
                        this.nodeName = OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... CMD");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_NodeName_List.get(ix)) + " [" + OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.RED);
                        OCCtrlsGUI.getOPCUAdata(this.nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + OCCtrlsGUI.ocOpcuaClient.ocICD.cmd_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            case "ModeList": {
                int ix = 0;
                while (ix < OCCtrlsGUI.ocOpcuaClient.ocICD.mode_ACSName_List.size()) {
                    if (acsName.equals(OCCtrlsGUI.ocOpcuaClient.ocICD.mode_ACSName_List.get(ix))) {
                        this.nodeName = OCCtrlsGUI.ocOpcuaClient.ocICD.mode_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... MODE");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + OCCtrlsGUI.ocOpcuaClient.ocICD.mode_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(OCCtrlsGUI.ocOpcuaClient.ocICD.mode_NodeName_List.get(ix)) + " [" + OCCtrlsGUI.ocOpcuaClient.ocICD.mode_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(OCCtrlsGUI.ocOpcuaClient.ocICD.mode_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(OCCtrlsGUI.ocOpcuaClient.ocICD.mode_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.DARK_GRAY);
                        OCCtrlsGUI.getOPCUAdata(this.nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + OCCtrlsGUI.ocOpcuaClient.ocICD.mode_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            default: {
                AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
                AIV_GUI.writeOnInfoText(" acsCommand not valid: " + acsName + "\n", Color.RED, true, false, true, true, 12);
                return;
            }
        }
    }

    public static String getOPCUAdata(String nodeName) {
        DataValue datValue = null;
        if (nodeName.contains("ns=")) {
            datValue = ocOpcuaClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= " + datValue.getValue().getValue().toString() + " \n", Color.blue, true, false, false, true, 12);
                return datValue.getValue().getValue().toString();
            }
            AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            return "";
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText(" nodeName not valid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
        return "";
    }

    private void jtreeGetEditedText(String nodeName) throws BadLocationException {
        DataValue datValue = null;
        AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " get new value and press Return:: ");
        AIV_GUI.infoText.getDocument().getText(0, AIV_GUI.infoText.getDocument().getLength());
        if (nodeName.contains("ns=")) {
            datValue = ocOpcuaClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
            } else {
                AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            }
            return;
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText("nodeName not vallid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
    }

    public static void showHistoryPlot(String nodeName, String acsName, String unitString) {
        DataValue[] dValue = null;
        try {
            dValue = ocOpcuaClient.readHistory(nodeName);
            if (dValue != null) {
                OCCtrlsGUI.historyPlot.unitString = unitString;
                OCCtrlsGUI.historyPlot.chart.getXYPlot().getDomainAxis().setLabel("time");
                OCCtrlsGUI.historyPlot.chart.getXYPlot().getRangeAxis().setLabel(unitString);
                OCCtrlsGUI.historyPlot.timeSeries.clear();
                OCCtrlsGUI.historyPlot.timeSeries.setKey((Comparable)((Object)("opcuaNode: " + nodeName)));
                OCCtrlsGUI.historyPlot.chart.setTitle(acsName);
                int ix = 0;
                while (ix < dValue.length) {
                    OCCtrlsGUI.historyPlot.timeSeries.add((RegularTimePeriod)new Millisecond(dValue[ix].getSourceTimestamp().getUtcCalendar().getTime()), dValue[ix].getValue().doubleValue());
                    ++ix;
                }
                historyPlot.setVisible(true);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

