/*
 * Decompiled with CFR 0.152.
 */
package oc.client;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ControllUtils {
    public static boolean switchRightStatus = false;
    public static boolean switchLeftStatus = false;
    public static boolean movingLeftStatus = false;
    public static final int STATE_RIGHT_EDGE = 1;
    public static final int STATE_LEFT_EDGE = 2;
    public static int motionStatus = 0;
    public static boolean runningStatus = false;
    public static final int MVCMD_MOVE = 1;
    public static final int MVCMD_MOVRR = 2;
    public static final int MVCMD_LEFT = 3;
    public static final int MVCMD_RIGHT = 4;
    public static final int MVCMD_STOP = 5;
    public static final int MVCMD_SSTP = 8;
    public static final int MVCMD_RUNNING = 128;
    public static boolean moveErrorStatus = false;
    public static boolean movingRightStatus = false;
    public static final int MOVE_STATE_MOVING = 1;
    public static final int MVCMD_ERROR = 64;
    public static final int EXTIO_SETUP_OUTPUT = 1;
    public static final int EXTIO_SETUP_INVERT = 2;
    public static final byte BORDER_STOP_LEFT = 2;
    public static final byte BORDER_STOP_RIGHT = 4;
    public static final byte STATE_ALARM = 64;
    public static Properties prop = new Properties();
    public static String propertiesFileName = "./conf/OCControlsConfig.properties";
    public static int likaTrip = 66405;
    public static int likaLeftBorder = 642298;
    public static int likaRightBorder = 575893;
    public static String likaComPort = "COM22";
    public static float uStepPerLikaEncoderRes = 3.66632f;
    public static int[] wheelTrip = new int[]{12803, 114};
    public static int[] wheelHomePosition = new int[]{6401, 185};
    public static String wheelComPort = "xi-com:\\\\.\\COM21";
    public static float wheelStepPerDeg = 66.666664f;
    public static int wheelDefaultPosition = 2;
    public static int wheelErrorPositioning = 60;
    public static int wheelControllerSN = 16738;
    public static int[] cartTrip = new int[]{950, 262};
    public static int[] cartHomePosition = new int[]{475, 131};
    public static int cartDefaultPosition = 3;
    public static String cartComPort = "";
    public static float likaCountsPerDegree = 3198.88f;
    public static float likaCountsPer15Degree = 4798.32f;
    public static int likaHomePosition = 982237;
    public static int likaErrorPositioning = 2;
    public static int cartControllerSN = 16738;

    public static void getProperties() {
        ControllUtils.loadProperties(propertiesFileName);
        ControllUtils.showProps();
        wheelTrip = Arrays.stream(prop.getProperty("wheelTrip").split(",")).mapToInt(Integer::parseInt).toArray();
        wheelHomePosition = Arrays.stream(prop.getProperty("wheelHomePosition").split(",")).mapToInt(Integer::parseInt).toArray();
        wheelComPort = prop.getProperty("wheelComPort");
        wheelStepPerDeg = Float.parseFloat(prop.getProperty("wheelStepPerDeg"));
        wheelDefaultPosition = Integer.parseInt(prop.getProperty("wheelDefaultPosition"));
        wheelErrorPositioning = Integer.parseInt(prop.getProperty("wheelErrorPositioning"));
        wheelControllerSN = Integer.parseInt(prop.getProperty("wheelControllerSN"));
        cartTrip = Arrays.stream(prop.getProperty("cartTrip").split(",")).mapToInt(Integer::parseInt).toArray();
        cartHomePosition = Arrays.stream(prop.getProperty("cartHomePosition").split(",")).mapToInt(Integer::parseInt).toArray();
        cartComPort = prop.getProperty("cartComPort");
        cartDefaultPosition = Integer.parseInt(prop.getProperty("cartDefaultPosition"));
        cartControllerSN = Integer.parseInt(prop.getProperty("cartControllerSN"));
        likaTrip = Integer.parseInt(prop.getProperty("likaTrip"));
        likaLeftBorder = Integer.parseInt(prop.getProperty("likaLeftBorder"));
        likaRightBorder = Integer.parseInt(prop.getProperty("likaRightBorder"));
        likaComPort = prop.getProperty("likaComPort");
        uStepPerLikaEncoderRes = Float.parseFloat(prop.getProperty("uStepPerLikaEncoderRes"));
        likaCountsPerDegree = Float.parseFloat(prop.getProperty("likaCountsPerDegree"));
        likaCountsPer15Degree = Float.parseFloat(prop.getProperty("likaCountsPer15Degree"));
        likaHomePosition = Integer.parseInt(prop.getProperty("likaHomePosition"));
        likaErrorPositioning = Integer.parseInt(prop.getProperty("likaErrorPositioning"));
    }

    public static void showProps() {
        int nprop = prop.size();
        System.out.println(">>>>>>>>>>>>>>>  " + propertiesFileName + "      size=" + nprop);
        Enumeration<Object> enuKeys = prop.keys();
        while (enuKeys.hasMoreElements()) {
            String key = (String)enuKeys.nextElement();
            System.out.println("> " + key + "=" + prop.getProperty(key));
        }
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    private static void loadProperties(String configFileName) {
        try {
            FileInputStream propsInputStream = new FileInputStream(configFileName);
            prop.load(propsInputStream);
            propsInputStream.close();
        }
        catch (IOException e) {
            System.out.println("States.loadProperties: " + e.getMessage());
        }
    }

    public void saveProperties(String prop, String value) {
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(propertiesFileName);
            conf.setProperty(prop, (Object)value);
            conf.save();
        }
        catch (ConfigurationException e) {
            e.getMessage();
        }
    }

    static void writeStringOnfile(String str) throws IOException {
        FileWriter fw = new FileWriter("LikaTest.txt", true);
        fw.write(String.valueOf(str) + "\n");
        fw.close();
    }
}

