/*
 * Decompiled with CFR 0.152.
 */
package myproc;

import com.prosysopc.ua.client.ServerList;
import com.prosysopc.ua.client.ServerListException;
import gui.AIV_GUI;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.opcfoundation.ua.core.ApplicationDescription;
import pmc.client.PMCGUI;

public class Utils {
    public static int[][] mirror1Center = new int[][]{{241, 131}, {151, 185}, {151, 289}, {241, 342}, {331, 287}, {330, 185}, {155, 88}, {70, 237}, {155, 386}, {325, 388}, {416, 236}, {327, 87}, {241, 37}, {66, 136}, {68, 338}, {241, 437}, {414, 337}, {415, 136}};
    public static int[][] motor1Center = new int[][]{{270, 152}, {211, 152}, {241, 101}, {182, 170}, {153, 220}, {126, 169}, {154, 253}, {184, 303}, {124, 304}, {212, 320}, {271, 322}, {242, 372}, {299, 304}, {331, 255}, {359, 305}, {329, 221}, {299, 170}, {358, 171}, {171, 56}, {119, 86}, {170, 114}, {49, 207}, {49, 268}, {100, 238}, {120, 389}, {170, 418}, {169, 360}, {313, 419}, {362, 390}, {312, 359}, {432, 265}, {433, 219}, {383, 237}, {360, 85}, {313, 55}, {313, 115}, {270, 19}, {211, 18}, {241, 67}, {67, 103}, {36, 154}, {96, 152}, {37, 321}, {68, 372}, {96, 321}, {211, 457}, {270, 457}, {241, 407}, {417, 371}, {445, 321}, {386, 322}, {446, 153}, {414, 104}, {387, 153}};
    public static int[] mirror2Center = new int[]{180, 157};
    public static int[][] motor2Center = new int[][]{{248, 197}, {111, 198}, {179, 77}};
    public static ImageIcon joyImageIcon = new ImageIcon("./conf/joyImageIcon.png");
    public static ImageIcon badImageIcon = new ImageIcon("./conf/badImageIcon.png");
    public static ImageIcon goodImageIcon = new ImageIcon("./conf/goodImageIcon.png");
    public static ImageIcon thinkImageIcon = new ImageIcon("./conf/thinkImageIcon.png");
    public static ImageIcon endImageIcon = new ImageIcon("./conf/endImageIcon.png");
    public static ImageIcon happyImageIcon = new ImageIcon("./conf/happyImageIcon.png");
    public static ImageIcon cameraIcon = new ImageIcon("./conf/Camera.jpg");
    public static ImageIcon astri1Icon = new ImageIcon("./conf/astri1.jpg");
    public static ImageIcon mirror1Icon = new ImageIcon("./conf/m1ab.jpg");
    public static ImageIcon mirror2Icon = new ImageIcon("./conf/m2a.jpg");
    public static ImageIcon optiCamIcon = new ImageIcon("./conf/OptiCam.jpg");
    public static ImageIcon davisIcon = new ImageIcon("./conf/davis.jpg");
    public static ImageIcon sqmIcon = new ImageIcon("./conf/sqm.jpg");
    public static ImageIcon ascIcon = new ImageIcon("./conf/asc.jpg");
    public static ImageIcon standaIcon = new ImageIcon("./conf/StandaIcon.jpg");
    public static ImageIcon telescopeIcon = new ImageIcon("./conf/telescope.jpg");
    public static ImageIcon tazImage = new ImageIcon("./conf/taz.jpg");
    public static Properties prop = new Properties();
    public static String[] pmcURLs = new String[9];
    public static String[] amcURLs = new String[9];
    public static String ocURL;
    public static String pmcICDFileName;
    public static String amcICDFileName;
    public static String wsICDFileName;
    public static String sqmICDFileName;
    public static String tcuICDFileName;
    public static String thcuICDFileName;
    public static String ws1URL;
    public static String ws2URL;
    public static String sqm1URL;
    public static String sqm2URL;
    public static String sqm3URL;
    public static String[] tcuURLs;
    public static String[] thcuURLs;
    public static String discoveryServerUrl;
    public static String allSkyUrlString;
    public static String propertiesFileName;
    public static String ocICDFileName;
    public static int telescopeNumber;

    static {
        pmcICDFileName = "ICD_PMC_V20_2022_09_01.xlsx";
        amcICDFileName = "ICD_AMC_V10_2022_09_14c.xlsx";
        wsICDFileName = "ICD_WS_V172_2022_02_17.xlsx";
        sqmICDFileName = "ICD_SQM_V20_2022_09_06.xlsx";
        tcuICDFileName = "ICD_TCU_V40-2018_03_01.xls";
        thcuICDFileName = "ICD_THCU_V40-2018_03_01.xls";
        tcuURLs = new String[9];
        thcuURLs = new String[9];
        allSkyUrlString = "http://oldwww.oact.inaf.it/images/AllSkyCurrentImage.JPG";
        propertiesFileName = "./conf/GUIconfig.properties";
        ocICDFileName = "ICD_OC_V10_2022_09_01.xlsx";
        telescopeNumber = 1;
    }

    public static void setTelescope(int index) {
        if (index >= 1 && index <= 9) {
            telescopeNumber = index;
            System.out.println("Telescope number now is: " + index);
        } else {
            System.out.println("Telescope Number not valid.." + index);
        }
    }

    public static void getProperties() {
        Utils.loadProperties(propertiesFileName);
        int nprop = prop.size();
        Utils.showProps();
        if (nprop > 0) {
            int ix = 0;
            while (ix < pmcURLs.length) {
                Utils.pmcURLs[ix] = prop.getProperty("pmcURL_" + (ix + 1));
                ++ix;
            }
            ix = 0;
            while (ix < amcURLs.length) {
                Utils.amcURLs[ix] = prop.getProperty("amcURL_" + (ix + 1));
                ++ix;
            }
            ix = 0;
            while (ix < tcuURLs.length) {
                Utils.tcuURLs[ix] = prop.getProperty("tcuURL_" + (ix + 1));
                ++ix;
            }
            ix = 0;
            while (ix < thcuURLs.length) {
                Utils.thcuURLs[ix] = prop.getProperty("thcuURL_" + (ix + 1));
                ++ix;
            }
            discoveryServerUrl = prop.getProperty("discoveryServer");
            pmcICDFileName = prop.getProperty("pmcICDFileName");
            amcICDFileName = prop.getProperty("amcICDFileName");
            ocICDFileName = prop.getProperty("ocICDFileName");
            wsICDFileName = prop.getProperty("wsICDFileName");
            sqmICDFileName = prop.getProperty("sqmICDFileName");
            tcuICDFileName = prop.getProperty("tcuICDFileName");
            thcuICDFileName = prop.getProperty("thcuICDFileName");
            ocURL = prop.getProperty("ocURL");
            ws1URL = prop.getProperty("ws1URL");
            ws2URL = prop.getProperty("ws2URL");
            sqm1URL = prop.getProperty("sqm1URL");
            sqm2URL = prop.getProperty("sqm2URL");
            sqm3URL = prop.getProperty("sqm3URL");
        }
    }

    public static void getWorkReference() {
        PMCGUI.areaReference = Arrays.stream(prop.getProperty("areaReference_0").split(",")).mapToInt(Integer::parseInt).toArray();
        PMCGUI.crossReference1 = Arrays.stream(prop.getProperty("crossReference1_0").split(",")).mapToInt(Integer::parseInt).toArray();
        PMCGUI.crossReference2 = Arrays.stream(prop.getProperty("crossReference2_0").split(",")).mapToInt(Integer::parseInt).toArray();
    }

    public static void showProps() {
        int nprop = prop.size();
        System.out.println(">>>>>>>>>>>>>>>  " + propertiesFileName + "      size=" + nprop);
        Enumeration<Object> enuKeys = prop.keys();
        while (enuKeys.hasMoreElements()) {
            String key = (String)enuKeys.nextElement();
            System.out.println("> " + key + "=" + prop.getProperty(key));
        }
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    public static void showPropOnGuis() {
        int nprop = prop.size();
        AIV_GUI.writeOnInfoText(">>>>>>>>>>>>>>>  GUIconfig.properties      size=" + nprop + "\n");
        Enumeration<Object> enuKeys = prop.keys();
        while (enuKeys.hasMoreElements()) {
            String key = (String)enuKeys.nextElement();
            AIV_GUI.writeOnInfoText("> " + key + "=" + prop.getProperty(key));
        }
        AIV_GUI.writeOnInfoText(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
    }

    private static void loadProperties(String configFileName) {
        try {
            FileInputStream propsInputStream = new FileInputStream(configFileName);
            prop.load(propsInputStream);
            propsInputStream.close();
        }
        catch (IOException e) {
            System.out.println("States.loadProperties: " + e.getMessage());
        }
    }

    public static void saveProperties(String prop, String value) {
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(propertiesFileName);
            conf.setProperty(prop, (Object)value);
            conf.save();
        }
        catch (ConfigurationException e) {
            e.getMessage();
        }
    }

    public static String resolveEnvVars(String input) {
        if (input == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\$\\{(\\w+)\\}|\\$(\\w+)");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String envVarName = m.group(1) == null ? m.group(2) : m.group(1);
            String envVarValue = System.getenv(envVarName);
            m.appendReplacement(sb, envVarValue == null ? "" : envVarValue);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String statusToString(int code) {
        String status;
        switch (code) {
            case 0: {
                status = "OFF";
                break;
            }
            case 1: {
                status = "SAFE";
                break;
            }
            case 2: {
                status = "READY";
                break;
            }
            case 3: {
                status = "FAULT";
                break;
            }
            default: {
                status = "";
            }
        }
        return status;
    }

    public static String errorToString(int code) {
        String status;
        switch (code) {
            case 4000: {
                status = "NO ERRORS";
                break;
            }
            case 4001: {
                status = "DB ERROR";
                break;
            }
            case 4002: {
                status = "OPC-UA ERROR";
                break;
            }
            case 4003: {
                status = "I/O ERROR";
                break;
            }
            default: {
                status = "";
            }
        }
        return status;
    }

    public static String connToString(boolean val) {
        if (val) {
            return "CONNECTED";
        }
        return "NOT CONNECTED";
    }

    public static void showDiscoverServerNodes(String uri) throws ServerListException, IOException, InterruptedException {
        if (!Utils.ping(uri)) {
            AIV_GUI.writeOnInfoText("Host " + uri + " is not reachable \n");
            return;
        }
        ServerList serverList = new ServerList(uri);
        if (serverList.size() == 0) {
            AIV_GUI.writeOnInfoText("No servers found\n");
            return;
        }
        AIV_GUI.writeOnInfoText("========================== Found: " + serverList.size() + " server =======================\n");
        int i = 0;
        while (i < serverList.size()) {
            ApplicationDescription s = serverList.get(i);
            AIV_GUI.writeOnInfoText(String.valueOf(i) + ")  Name:    " + s.getApplicationName().getText() + "\n");
            AIV_GUI.writeOnInfoText(String.valueOf(i) + ")  Type:    " + s.getApplicationType() + "\n");
            AIV_GUI.writeOnInfoText(String.valueOf(i) + ")  Product: " + s.getProductUri() + "\n");
            AIV_GUI.writeOnInfoText(String.valueOf(i) + ")  Applic.: " + s.getApplicationUri() + "\n");
            String[] s1 = s.getDiscoveryUrls();
            AIV_GUI.writeOnInfoText(String.valueOf(i) + ")  Url:     " + s1[0] + "\n");
            AIV_GUI.writeOnInfoText("-------------------------------------------------------\n");
            ++i;
        }
        AIV_GUI.writeOnInfoText("========================== Found: " + serverList.size() + " server =======================\n");
    }

    public static Object[][] getDiscoverTable(String uri) throws ServerListException {
        ServerList serverList = new ServerList(uri);
        if (serverList.size() == 0) {
            return null;
        }
        Object[][] tableDiscovery = new String[serverList.size()][6];
        int i = 0;
        while (i < serverList.size()) {
            ApplicationDescription s = serverList.get(i);
            tableDiscovery[i][0] = String.valueOf(i);
            tableDiscovery[i][1] = s.getApplicationName().getText();
            tableDiscovery[i][2] = s.getApplicationType().toString();
            tableDiscovery[i][3] = s.getProductUri();
            tableDiscovery[i][4] = s.getApplicationUri();
            String[] s1 = s.getDiscoveryUrls();
            tableDiscovery[i][5] = s1[0];
            ++i;
        }
        return tableDiscovery;
    }

    public static void setEnablePanel(JPanel panel, boolean set, String title) {
        if (title != null | title == "") {
            TitledBorder blackline = BorderFactory.createTitledBorder(title);
            panel.setBorder(blackline);
        }
        panel.setEnabled(set);
        int ix = 0;
        while (ix < panel.getComponentCount()) {
            panel.getComponent(ix).setEnabled(set);
            ++ix;
        }
    }

    public static void beep(int nBeep) {
        int ix = 0;
        while (ix < nBeep) {
            Toolkit.getDefaultToolkit().beep();
            ++ix;
        }
    }

    private static boolean ping(String host) throws IOException, InterruptedException {
        if (host.contains("//")) {
            host = host.substring(host.indexOf("//") + 2);
        }
        if (host.contains(":")) {
            host = host.substring(0, host.lastIndexOf(":"));
        }
        System.out.println("LDS at: " + host);
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        ProcessBuilder processBuilder = new ProcessBuilder("ping", isWindows ? "-n" : "-c", "1", host);
        Process proc = processBuilder.start();
        int returnVal = proc.waitFor();
        return returnVal == 0;
    }
}

