/*
 * Decompiled with CFR 0.152.
 */
package myproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReadExcelData {
    private String excelFileName = null;
    private Workbook workbook = null;
    public int portNo = 52555;
    public int webPortNo = 42555;
    public String serverName = "ASTRI_ICMP_Server";
    public String deviceName = "myDevice";
    public String deviceDescr = "default device";
    public String foldeName = "myFolder";
    public String folderDescr = "default folder";
    public boolean isNewICDFormat = true;

    public ReadExcelData(String excelFName) throws IOException {
        this.excelFileName = excelFName;
        if (this.excelFileName == null) {
            return;
        }
        FileInputStream file = new FileInputStream(new File(this.excelFileName));
        this.workbook = this.excelFileName.contains("xlsx") ? new XSSFWorkbook((InputStream)file) : new HSSFWorkbook((InputStream)file);
        if (this.workbook != null) {
            this.workbook.setSheetHidden(0, false);
            int sheet = 0;
            int row = 0;
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            String[] cellsValue = this.getArrayString(sheet, row, nArray);
            if (cellsValue[1] == "" || cellsValue[2] == "") {
                row = 2;
                this.isNewICDFormat = false;
            } else {
                row = 1;
                this.isNewICDFormat = true;
            }
            int[] nArray2 = new int[4];
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            cellsValue = this.getArrayString(sheet, row, nArray2);
            if (cellsValue[0] != null) {
                this.foldeName = cellsValue[0];
            }
            if (cellsValue[1] != null) {
                this.folderDescr = cellsValue[1];
            }
            if (cellsValue[2] != null) {
                this.deviceName = cellsValue[2];
            }
            if (cellsValue[1] != null) {
                this.deviceDescr = cellsValue[1];
            }
            if (cellsValue[3] != null) {
                String sVal = cellsValue[3].substring(cellsValue[3].lastIndexOf(":") + 1).trim();
                sVal = sVal.substring(0, sVal.indexOf("/")).trim();
                this.portNo = Integer.parseInt(ReadExcelData.ceckNumericString(sVal));
                this.serverName = cellsValue[3].substring(cellsValue[3].lastIndexOf("/") + 1).trim();
            }
        }
    }

    public static Boolean ceckExcelFormat(String excelFName) {
        return true;
    }

    public static String ceckNumericString(String str) {
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '-' && c != '+' && c != '.' && c != 'E' && c != 'e' && !Character.isDigit(c)) {
                return "52555";
            }
            ++n2;
        }
        if (str.length() == 0) {
            return "52555";
        }
        return str;
    }

    public static void main(String[] args) {
        ReadExcelData pippo = null;
        try {
            pippo = new ReadExcelData("C:\\Users\\Utente\\Desktop\\astri\\OPCUA\\OCGUI\\ICD_PMC_V17_2021_04_15.xlsx");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Number of sheet =" + pippo.getNoOfSheet());
        if (pippo.getNoOfSheet() > 5) {
            int i1 = 0;
            while (i1 < pippo.getNoOfSheet()) {
                System.out.println("sheet name is >>>" + pippo.getSheetName(i1));
                pippo.readExcelSheet(i1);
                ++i1;
            }
        }
        pippo.readExcelSheet(0);
        pippo.readExcelSheet(1);
        pippo.readExcelSheet(2);
        pippo.readExcelSheet(3);
        pippo.readExcelSheet(4);
        pippo.readExcelSheet(5);
        pippo.readExcelSheet(6);
        int sheet = 3;
        int row = 1;
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 7;
        nArray[6] = 8;
        nArray[7] = 9;
        nArray[8] = 10;
        nArray[9] = 13;
        nArray[10] = 17;
        nArray[11] = 18;
        nArray[12] = 20;
        nArray[13] = 21;
        nArray[14] = 22;
        nArray[15] = 23;
        nArray[16] = 24;
        String[] cellHeader = pippo.getArrayString(sheet, 0, nArray);
        int[] nArray2 = new int[17];
        nArray2[1] = 1;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 6;
        nArray2[5] = 7;
        nArray2[6] = 8;
        nArray2[7] = 9;
        nArray2[8] = 10;
        nArray2[9] = 13;
        nArray2[10] = 17;
        nArray2[11] = 18;
        nArray2[12] = 20;
        nArray2[13] = 21;
        nArray2[14] = 22;
        nArray2[15] = 23;
        nArray2[16] = 24;
        String[] cellValue = pippo.getArrayString(sheet, row, nArray2);
        int i = 0;
        while (i < cellValue.length) {
            System.out.println(String.valueOf(i) + ") " + cellHeader[i] + ": " + cellValue[i]);
            ++i;
        }
    }

    public boolean readExcelSheet(int noSheet) {
        block16: {
            block15: {
                if (this.workbook != null) break block15;
                System.out.println("No workbook opened..");
                return false;
            }
            if (noSheet < this.workbook.getNumberOfSheets()) break block16;
            System.out.println("Sheet " + noSheet + " not found..");
            return false;
        }
        try {
            System.out.println("Sheet found = : " + this.workbook.getSheetName(noSheet) + "  " + noSheet + " of " + this.workbook.getNumberOfSheets());
            System.out.println("LastRowNumber = : " + this.workbook.getSheetAt(noSheet).getLastRowNum());
            this.workbook.setSheetHidden(noSheet, false);
            Sheet sheet1 = this.workbook.getSheetAt(noSheet);
            this.workbook.getSheetName(noSheet);
            for (Row row : sheet1) {
                Iterator cellIterator = row.cellIterator();
                System.out.print("Row: " + row.getRowNum() + "\t");
                int nCell = 0;
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    Cell c1 = row.getCell(nCell);
                    ++nCell;
                    if (c1 == null) {
                        System.out.print("#####\t");
                    }
                    CellType cType = cell.getCellTypeEnum();
                    switch (cell.getCellType()) {
                        case 0: {
                            System.out.print(String.valueOf(cell.getNumericCellValue()) + "\t");
                            break;
                        }
                        case 1: {
                            System.out.print(String.valueOf(cell.getStringCellValue()) + "\t");
                            break;
                        }
                        case 3: {
                            System.out.print("****\t");
                            break;
                        }
                        case 4: {
                            System.out.print(String.valueOf(cell.getBooleanCellValue()) + "\t");
                            break;
                        }
                        case 5: {
                            System.out.print(String.valueOf(cell.getErrorCellValue()) + "\t");
                            break;
                        }
                        case 2: {
                            System.out.print(String.valueOf(cell.getStringCellValue()) + "\t");
                            break;
                        }
                        default: {
                            System.out.print("????\t");
                        }
                    }
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public int getNoOfSheet() {
        if (this.workbook == null) {
            System.out.println("No workbook opened..");
            return -1;
        }
        return this.workbook.getNumberOfSheets();
    }

    public String getSheetName(int idx) {
        if (this.workbook == null) {
            System.out.println("No workbook opened..");
            return "sheet" + Integer.toString(idx);
        }
        return this.workbook.getSheetName(idx);
    }

    public int getNoOfRow(int sheetNo) {
        if (this.workbook == null) {
            System.out.println("No workbook opened..");
            return -1;
        }
        if (sheetNo <= this.getNoOfSheet()) {
            return this.workbook.getSheetAt(sheetNo).getLastRowNum();
        }
        return -1;
    }

    public String[] getArrayString(int noSheet, int noRow, int[] indexes) {
        if (this.workbook == null) {
            System.out.println("No workbook opened..");
            return null;
        }
        if (noSheet >= this.workbook.getNumberOfSheets()) {
            System.out.println("Sheet " + noSheet + " not found..");
            return null;
        }
        if (noRow > this.workbook.getSheetAt(noSheet).getLastRowNum()) {
            System.out.println("Row " + noRow + " not found..");
            return null;
        }
        String[] outArray = new String[indexes.length];
        Sheet sheet1 = this.workbook.getSheetAt(noSheet);
        Iterator rowIterator = sheet1.iterator();
        int cntRow = 0;
        int cntCell = 0;
        int indx = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (cntRow == noRow) {
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell c1 = row.getCell(cntCell);
                    if (indexes[indx] == cntCell) {
                        outArray[indx] = c1 == null ? "" : (c1.getCellType() == 2 ? c1.getStringCellValue() : c1.toString());
                        if (++indx == 11) {
                            System.out.println("Address >>> " + outArray[indx - 1] + " found..");
                        }
                        if (indx >= indexes.length) {
                            return outArray;
                        }
                    }
                    ++cntCell;
                }
            }
            ++cntRow;
        }
        return outArray;
    }

    public String[] getRowAsArrayOfString(int noSheet, int noRow) {
        if (this.workbook == null) {
            System.out.println("No workbook opened..");
            return null;
        }
        if (noSheet >= this.workbook.getNumberOfSheets()) {
            System.out.println("Sheet " + noSheet + " not found..");
            return null;
        }
        if (noRow > this.workbook.getSheetAt(noSheet).getLastRowNum()) {
            System.out.println("Row " + noRow + " not found..");
            return null;
        }
        Sheet sheet1 = this.workbook.getSheetAt(noSheet);
        Iterator rowIterator = sheet1.iterator();
        int cntRow = 0;
        int cntCell = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (cntRow == noRow) {
                System.out.println("getPhysicalNumberOfCells >>> " + row.getPhysicalNumberOfCells() + " found..");
                String[] outArray = new String[row.getPhysicalNumberOfCells()];
                Iterator cellIterator = row.cellIterator();
                while (cntCell < row.getPhysicalNumberOfCells()) {
                    Cell c1 = row.getCell(cntCell);
                    outArray[cntCell] = c1 == null ? "" : (c1.getCellType() == 2 ? c1.getStringCellValue() : c1.toString());
                    ++cntCell;
                }
                return outArray;
            }
            ++cntRow;
        }
        return null;
    }
}

