/*
 * Decompiled with CFR 0.152.
 */
package myproc;

import gui.AIV_GUI;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import myproc.TaskHandler;
import myproc.Utils;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.util.Cursor;
import pmc.client.PMCGUI;

public class NomTamFits {
    short[][] image = null;
    int bzero = 32768;
    private boolean imageLoaded = false;
    public String fitsImageName = "./conf/ImageTest1.fits";
    public Fits fits = null;
    public float xFactor = 1.0f;
    public float yFactor = 1.0f;
    public ImagePlus imgPlus = new ImagePlus();
    public ImagePlus imgPlus1 = new ImagePlus();
    public double newMin = 0.0;
    public double newMax = 255.0;

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public void setImageLoaded(boolean imageLoaded) {
        this.imageLoaded = imageLoaded;
    }

    public void showHeader() {
        try {
            if (!this.isImageLoaded()) {
                AIV_GUI.writeOnInfoText("No file fits is loaded..\n");
                return;
            }
            Header header = this.fits.getHDU(0).getHeader();
            Cursor c = header.iterator();
            AIV_GUI.writeOnInfoText("Cards= " + String.valueOf(header.getNumberOfCards()) + "\n");
            while (c.hasNext()) {
                HeaderCard card = (HeaderCard)c.next();
                if (card != null) {
                    AIV_GUI.writeOnInfoText(String.valueOf(card.getKey()) + "= \t" + card.getValue() + "\n");
                    if (card.getKey().equals("BZERO")) {
                        this.bzero = Integer.parseInt(card.getValue());
                    }
                    if (!card.getKey().equals("END")) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException | FitsException e) {
            e.printStackTrace();
        }
    }

    public void setNewFitsImage(String fitsImgName) {
        try {
            this.fitsImageName = fitsImgName == null | fitsImgName == "" ? "./conf/ImageTest1.fits" : fitsImgName;
            this.fits = new Fits(this.fitsImageName);
            ImageHDU hdu = (ImageHDU)this.fits.getHDU(0);
            ImageData imageData = (ImageData)hdu.getData();
            this.image = (short[][])imageData.getData();
            AIV_GUI.writeOnInfoText("Xdim = " + this.image[0].length + "Ydim = " + this.image.length + "\n");
            this.setImageLoaded(true);
            this.xFactor = this.image[0].length / PMCGUI.imageLabel.getWidth();
            this.yFactor = this.image.length / PMCGUI.imageLabel.getHeight();
            PMCGUI.lblZfact.setText("ZoomFct: " + 1.0f / this.xFactor + " * " + 1.0f / this.yFactor);
            this.fitsToJpg("./conf/", this.fitsImageName);
            this.refreshImage();
        }
        catch (IOException | FitsException e) {
            System.out.println("setNewFitsImage exception: " + e.getMessage());
            return;
        }
        try {
            if (PMCGUI.ds9RadioButton.isSelected()) {
                TaskHandler.killProcess("ds9.exe");
                Runtime.getRuntime().exec("C:\\Users\\Utente\\Documents\\DS9\\ds9.exe " + this.fitsImageName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NomTamFits(String imgName) {
        this.fitsImageName = imgName;
    }

    public static void main(String[] args) {
        NomTamFits questo = new NomTamFits(null);
        questo.setNewFitsImage(null);
        questo.showHeader();
        questo.refreshImage();
    }

    public int getPixelValue(int y, int x) {
        if (this.image == null) {
            return -99999;
        }
        if (y > this.image.length - 1 | x > this.image[0].length - 1) {
            return -99999;
        }
        return this.image[y][x] + this.bzero;
    }

    public int[] getColumnValue(int y, int x) {
        if (this.image == null) {
            return null;
        }
        if (y > this.image.length - 1 | x > this.image[0].length - 1) {
            return null;
        }
        int[] line = new int[this.image.length - 1];
        int ix = 0;
        while (ix < this.image.length - 1) {
            line[ix] = this.image[ix][x] + this.bzero;
            ++ix;
        }
        return line;
    }

    public int[] getLineValue(int y, int x) {
        if (this.image == null) {
            return null;
        }
        if (y > this.image.length - 1 | x > this.image[0].length - 1) {
            return null;
        }
        int[] col = new int[this.image[0].length - 1];
        int ix = 0;
        while (ix < this.image[0].length - 1) {
            col[ix] = this.image[y][ix] + this.bzero;
            ++ix;
        }
        return col;
    }

    public void fitsToJpg(String destination, String fitsImage) {
        try {
            ImagePlus imageP = IJ.openImage((String)fitsImage);
            File out = new File(String.valueOf(destination) + "preview" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            ImageIcon icon = new ImageIcon("./conf/preview" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            PMCGUI.showFullImage.imageLabel.setIcon(icon);
            this.imgPlus = imageP.resize((int)((float)imageP.getWidth() / this.xFactor), (int)((float)imageP.getHeight() / this.yFactor), "./conf/preview_" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            this.normalizeStack(this.imgPlus);
            BufferedImage imagen = this.imgPlus.getBufferedImage();
            ImageIO.write((RenderedImage)imagen, "jpg", out);
            File out1 = new File(String.valueOf(destination) + "small" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            float xF1 = this.image[0].length / PMCGUI.showAllImages.arrayImageLabel[Utils.telescopeNumber - 1].getWidth();
            float yF1 = this.image.length / PMCGUI.showAllImages.arrayImageLabel[Utils.telescopeNumber - 1].getHeight();
            this.imgPlus1 = imageP.resize((int)((float)imageP.getWidth() / xF1), (int)((float)imageP.getHeight() / yF1), "./conf/preview_" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            this.normalizeStack(this.imgPlus1);
            BufferedImage imagen1 = this.imgPlus1.getBufferedImage();
            ImageIO.write((RenderedImage)imagen1, "jpg", out1);
        }
        catch (Exception ex) {
            System.out.println("fitsToJpg error: " + ex.getMessage());
        }
    }

    public void refreshImage() {
        ImageIcon icon = new ImageIcon("./conf/preview" + String.valueOf(Utils.telescopeNumber) + ".jpg");
        icon.getImage().flush();
        PMCGUI.imageLabel.setIcon(icon);
        icon = new ImageIcon("./conf/small" + String.valueOf(Utils.telescopeNumber) + ".jpg");
        icon.getImage().flush();
        PMCGUI.showAllImages.arrayImageLabel[Utils.telescopeNumber - 1].setIcon(icon);
        PMCGUI.showFullImage.showImageOnLabel();
    }

    private void showImageOnAllView() {
        ImagePlus imageP = this.imgPlus;
        try {
            float xF1 = this.imgPlus.getWidth() / PMCGUI.showAllImages.arrayImageLabel[Utils.telescopeNumber - 1].getWidth();
            float yF1 = this.imgPlus.getHeight() / PMCGUI.showAllImages.arrayImageLabel[Utils.telescopeNumber - 1].getHeight();
            ImagePlus imgP = imageP.resize((int)((float)imageP.getWidth() / xF1), (int)((float)imageP.getHeight() / yF1), "./conf/preview" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            this.normalizeStack(imgP);
            File out = new File("./conf/small" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            BufferedImage imagen = imgP.getBufferedImage();
            ImageIO.write((RenderedImage)imagen, "jpg", out);
            ImageIcon icon = new ImageIcon("./conf/small" + String.valueOf(Utils.telescopeNumber) + ".jpg");
            icon.getImage().flush();
            PMCGUI.showAllImages.arrayImageLabel[Utils.telescopeNumber - 1].setIcon(icon);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImagePlus cropAndResize(ImagePlus originalImage, int targetWidth, int targetHeight) throws Exception {
        ImageStack classStack = new ImageStack(targetWidth, targetHeight);
        int i = 1;
        while (i <= originalImage.getStackSize()) {
            ImageProcessor ip = originalImage.getStack().getProcessor(i);
            ip.setInterpolationMethod(1);
            ip.resize(targetWidth, targetHeight);
            int cropX = (int)((float)ip.getWidth() / this.xFactor);
            int cropY = (int)((float)ip.getHeight() / this.yFactor);
            ip.setRoi(cropX, cropY, targetWidth, targetHeight);
            ImageProcessor cropped = ip.crop();
            BufferedImage croppedImage = ip.getBufferedImage();
            classStack.addSlice(ip);
            ++i;
        }
        ImagePlus CI = new ImagePlus("CI", classStack);
        CI.setCalibration(originalImage.getCalibration());
        return CI;
    }

    public void normalizeStack(ImagePlus imp) {
        int rh;
        int rw;
        int ry;
        int rx;
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        this.newMin = PMCGUI.minVal_scrollbar.getValue();
        this.newMax = PMCGUI.maxVal_scrollbar.getValue();
        PMCGUI.zStrechLabel.setText("zStretch: " + (int)this.newMin + "*" + (int)this.newMax);
        ImageProcessor ip = imp.getProcessor();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        byte[] mask = ip.getMaskArray();
        if (roi != null) {
            rx = roi.x;
            ry = roi.y;
            rw = roi.width;
            rh = roi.height;
        } else {
            rx = 0;
            ry = 0;
            rw = width;
            rh = height;
        }
        IJ.showStatus((String)"Finding min and max");
        StackStatistics stats = new StackStatistics(imp);
        double roiMin = stats.min;
        double roiMax = stats.max;
        if (roiMax <= roiMin) {
            roiMax = roiMin + 1.0;
        }
        double scale = (this.newMax - this.newMin) / (roiMax - roiMin);
        double offset = (this.newMin * roiMax - this.newMax * roiMin) / (roiMax - roiMin);
        int slice = 1;
        while (slice <= size) {
            IJ.showStatus((String)("Normalizing: " + slice + "/" + size));
            IJ.showProgress((int)slice, (int)size);
            ip = stack.getProcessor(slice);
            int y = 0;
            while (y < height) {
                int i = y * width + rx;
                int x = 0;
                while (x < width) {
                    double v = ip.getPixelValue(x, y);
                    v = scale * v + offset;
                    ip.putPixelValue(x, y, v);
                    ++i;
                    ++x;
                }
                ++y;
            }
            ++slice;
        }
    }

    public int[] getCentroid(int x1, int x2, int y1, int y2) {
        int[] centroid = new int[]{-1, -1};
        if (this.image == null) {
            return centroid;
        }
        double cx = 0.0;
        double cy = 0.0;
        double m = 0.0;
        try {
            int x = 0;
            while ((float)x < (float)(x2 - x1) * this.xFactor + 1.0f) {
                int y = 0;
                while ((float)y < this.yFactor * (float)(y2 - y1) + 1.0f) {
                    int iVal = this.image[(int)(this.yFactor * (float)y1 + (float)y)][(int)(this.xFactor * (float)x1 + (float)x)] + this.bzero;
                    cx += (double)(iVal * x);
                    cy += (double)(iVal * y);
                    m += (double)iVal;
                    ++y;
                }
                ++x;
            }
            centroid[0] = (int)(cx / m / (double)this.xFactor) + x1;
            centroid[1] = (int)(cy / m / (double)this.yFactor) + y1;
        }
        catch (Exception e) {
            AIV_GUI.writeOnInfoText("getCentroid error...." + e.getMessage() + "\n");
        }
        return centroid;
    }

    public int[] getMaxValue(int x1, int x2, int y1, int y2) {
        int[] maxValue = new int[]{-1, -1, -99999};
        if (this.image == null) {
            return maxValue;
        }
        int cx = 0;
        int cy = 0;
        int m = -99999;
        int iVal = 0;
        try {
            int x = 0;
            while ((float)x <= (float)(x2 - x1) * this.xFactor) {
                int y = 0;
                while ((float)y <= this.yFactor * (float)(y2 - y1)) {
                    iVal = this.image[(int)(this.yFactor * (float)y1 + (float)y)][(int)(this.xFactor * (float)x1 + (float)x)] + this.bzero;
                    if (iVal > m) {
                        cx = x;
                        cy = y;
                        m = iVal;
                    }
                    ++y;
                }
                ++x;
            }
            maxValue[0] = (int)((float)cx / this.xFactor + (float)x1);
            maxValue[1] = (int)((float)cy / this.yFactor + (float)y1);
            maxValue[2] = m;
        }
        catch (Exception e) {
            AIV_GUI.writeOnInfoText("getMaxValue error...." + e.getMessage() + "\n");
        }
        return maxValue;
    }
}

