/*
 * Decompiled with CFR 0.152.
 */
package myproc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class IcdReader {
    private final Logger logger = Logger.getLogger(IcdReader.class);
    private String excelFileName;
    private Workbook workbook;
    private int totRows;
    private ArrayList<String> shortName_List = new ArrayList();
    private ArrayList<String> browseName_List = new ArrayList();
    private ArrayList<Integer> ns_List = new ArrayList();
    private ArrayList<String> dataType_List = new ArrayList();
    private ArrayList<Byte> isArray_List = new ArrayList();
    public static String ICD_cells = "0,4,5,6,8,19";

    public IcdReader(String excelFileName) throws FileNotFoundException {
        this.excelFileName = excelFileName;
    }

    public static void main(String[] args) {
        try {
            IcdReader icdReader = new IcdReader("C:\\Users\\Utente\\Desktop\\astri\\OPCUA\\OCGUI\\ICD_PMC_V17_2021_04_15.xlsx");
            icdReader.readICDData("PMC", true);
        }
        catch (IOException | ConfigurationException e) {
            System.out.println(">>>>>>>>>>" + e.getMessage());
            e.printStackTrace();
        }
    }

    protected String[] readICDData(String devAcronym, boolean verbose) throws IOException, ConfigurationException {
        String[] varsGlobal = new String[3];
        String sheetCode = "";
        int[] cells = Arrays.stream(ICD_cells.split(",")).mapToInt(Integer::parseInt).toArray();
        FileInputStream excelInputStream = new FileInputStream(this.excelFileName);
        this.workbook = this.excelFileName.contains("xlsx") ? new XSSFWorkbook((InputStream)excelInputStream) : new HSSFWorkbook((InputStream)excelInputStream);
        if (this.workbook != null) {
            String opcuaUrl;
            String deviceName;
            System.out.println();
            this.logger.info((Object)(String.valueOf(devAcronym) + "Reading ICD device params..."));
            Sheet sheet = this.workbook.getSheetAt(0);
            varsGlobal[0] = deviceName = sheet.getRow(2).getCell(2).getStringCellValue();
            varsGlobal[1] = opcuaUrl = sheet.getRow(2).getCell(3).getStringCellValue();
            this.logger.info((Object)(String.valueOf(devAcronym) + "Device name: " + deviceName));
            this.logger.info((Object)(String.valueOf(devAcronym) + "Device OPC-UA URL: " + opcuaUrl));
            System.out.println();
            this.logger.info((Object)(String.valueOf(devAcronym) + "Reading ICD nodes..."));
            if (verbose) {
                System.out.println(String.valueOf(devAcronym) + "\n----------------------------------------------------------------------------------------------------------------");
                System.out.printf(String.valueOf(devAcronym) + "%-3s%-3s%-37s%-33s%-13s%-13s%-12s\n", "  #", "", "Browse Name", "Short Name", "Namespace", "Data Type", "Is Array", "Array Length");
                System.out.println(String.valueOf(devAcronym) + "----------------------------------------------------------------------------------------------------------------");
            }
            int sh = 1;
            while (sh <= 4) {
                if (sh == 1) {
                    sheetCode = "_GET_";
                } else if (sh == 2) {
                    sheetCode = "_SET_";
                } else if (sh == 3) {
                    sheetCode = "_CMD_";
                } else if (sh == 4) {
                    sheetCode = "_MODE_";
                }
                int sheetRows = 0;
                sheet = this.workbook.getSheetAt(sh);
                for (Row row : sheet) {
                    if (sheetRows > 0) {
                        int id = this.totRows + sheetRows - 1;
                        switch (sh) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        this.shortName_List.add(row.getCell(cells[0]).getStringCellValue());
                        String browseName = row.getCell(cells[1]).getStringCellValue();
                        this.ns_List.add(Integer.parseInt(browseName.substring(browseName.indexOf("=") + 1, browseName.indexOf(";"))));
                        this.browseName_List.add(browseName.substring(browseName.lastIndexOf("=") + 1));
                        String dataType = row.getCell(cells[2]).getStringCellValue();
                        if (dataType.contains("[")) {
                            this.dataType_List.add(dataType.substring(0, dataType.indexOf("[")));
                            this.isArray_List.add((byte)1);
                        } else {
                            this.dataType_List.add(dataType);
                            this.isArray_List.add((byte)0);
                        }
                        if (verbose) {
                            System.out.printf(String.valueOf(devAcronym) + sheetCode + "%3d%-3s%-37s%-36s%-12s%-14s%-13s\n", id + 1, "", this.browseName_List.get(id), this.shortName_List.get(id), this.ns_List.get(id), this.dataType_List.get(id), this.isArray_List.get(id));
                        }
                    }
                    ++sheetRows;
                }
                this.totRows += sheetRows - 1;
                ++sh;
            }
            if (verbose) {
                System.out.println();
            }
            varsGlobal[2] = String.valueOf(this.totRows);
            this.logger.info((Object)(String.valueOf(devAcronym) + "Found " + this.totRows + " nodes."));
        } else {
            this.logger.error((Object)(String.valueOf(devAcronym) + "No ICD file opened."));
        }
        return varsGlobal;
    }

    protected String getShortName(int id) {
        if (id > this.shortName_List.size()) {
            return null;
        }
        return this.shortName_List.get(id);
    }

    protected String getBrowseName(int id) {
        if (id > this.browseName_List.size()) {
            return null;
        }
        return this.browseName_List.get(id);
    }

    protected Integer getNs(int id) {
        if (id > this.ns_List.size()) {
            return null;
        }
        return this.ns_List.get(id);
    }

    protected String getDataType(int id) {
        if (id > this.dataType_List.size()) {
            return null;
        }
        return this.dataType_List.get(id);
    }

    protected Byte getIsArray(int id) {
        if (id > this.isArray_List.size()) {
            return null;
        }
        return this.isArray_List.get(id);
    }

    protected int getListDims() {
        return this.totRows;
    }
}

