/*
 * Decompiled with CFR 0.152.
 */
package m12.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import gui.AIV_GUI;
import gui.DataInputForm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import m12.client.M12ICD;
import m12.client.M12OpcuaClient;
import m12.client.M12StateMachine;
import m12.client.M2GUI;
import myproc.ErrorForm;
import myproc.Utils;
import oc.client.CreateRoundButton;
import org.apache.log4j.Logger;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;

public class MirrorGui
extends JFrame {
    private static Logger logger = Logger.getLogger(MirrorGui.class);
    public String frameTitle = "MirrorGUI - PBr-0.7-0922  -  on ASTRI" + Utils.telescopeNumber;
    JLabel ledLabel = new JLabel("\u2022");
    public ErrorForm errorForm;
    public JLabel ImageMirrorLabel = new JLabel("");
    public static JLabel selectedLabel = new JLabel("---");
    private JScrollPane scrollPane = new JScrollPane();
    public static M12ICD m12ICD;
    public static M12OpcuaClient m12OpcuaClient;
    public static M2GUI m2gui;
    public M12StateMachine m12StateMachine;
    public JTree nodeTree = new JTree();
    public static JTextArea GETInfoTextArea;
    public int motorIndex = -1;
    public int mirrorIndex = -1;
    public DataInputForm ocDataInputForm = new DataInputForm("OC");
    public static JCheckBox getTelemetryEnableCheckBox;
    JPanel motorPanel = new JPanel();
    JPanel mirrorPanel = new JPanel();
    JButton hideButton = new JButton("  HIDE  ");
    public JMenuItem exitMenuItem = new JMenuItem("Exit");
    JLabel outputInfoLabel = new JLabel("--------");
    JLabel pistonLabel = new JLabel("Offset=");
    JLabel tilt_YLabel = new JLabel("Tilt_Y=");
    JLabel tilt_XLabel = new JLabel("Tilt_X=");
    JButton tilt_YButton = new JButton("Go");
    JButton tilt_XButton = new JButton("Go");
    JLabel pistonMotorLabel = new JLabel("Offset=");
    public static boolean showMirrorCircleFlag;
    private Thread showMirrorReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    int Yc;
                    int Xc;
                    Graphics2D g2;
                    while (true) {
                        if (!showMirrorCircleFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showMirrorCircleFlag = false;
                        g2 = (Graphics2D)MirrorGui.this.ImageMirrorLabel.getGraphics();
                        Xc = Utils.mirror1Center[MirrorGui.this.mirrorIndex - 1][0];
                        Yc = Utils.mirror1Center[MirrorGui.this.mirrorIndex - 1][1];
                        g2.setStroke(new BasicStroke(2.0f));
                        if (Xc >= 0 & Yc >= 0) break;
                    }
                    g2.setColor(Color.yellow);
                    g2.draw(new Ellipse2D.Double(Xc - 47, Yc - 47, 94.0, 94.0));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    public static boolean showMotorCircleFlag;
    private Thread showMotorReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    int Yc;
                    int Xc;
                    Graphics2D g2;
                    while (true) {
                        if (!showMotorCircleFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showMotorCircleFlag = false;
                        GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
                        g2 = (Graphics2D)MirrorGui.this.ImageMirrorLabel.getGraphics();
                        Xc = Utils.motor1Center[MirrorGui.this.motorIndex - 1][0];
                        Yc = Utils.motor1Center[MirrorGui.this.motorIndex - 1][1];
                        g2.setStroke(new BasicStroke(2.0f));
                        if (Xc >= 0 & Yc >= 0) break;
                    }
                    g2.setColor(Color.white);
                    g2.draw(new Ellipse2D.Double(Xc - 14, Yc - 14, 28.0, 28.0));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    private Thread heartBeatThread = new Thread(){

        @Override
        public synchronized void run() {
            int oldValue = MirrorGui.m12OpcuaClient.heartbeat;
            while (true) {
                try {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (oldValue != MirrorGui.m12OpcuaClient.heartbeat) {
                            oldValue = MirrorGui.m12OpcuaClient.heartbeat;
                            if (MirrorGui.this.ledLabel.getForeground() == Color.gray) {
                                MirrorGui.this.ledLabel.setForeground(Color.green);
                                continue;
                            }
                            MirrorGui.this.ledLabel.setForeground(Color.gray);
                            continue;
                        }
                        MirrorGui.this.ledLabel.setForeground(Color.red);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    private JTextField pistonTextField;
    private JTextField tilt_XTextField;
    private JTextField tilt_YTextField;
    public boolean startShowDataThread = true;
    private Thread ShowDataThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (!MirrorGui.this.startShowDataThread & MirrorGui.m12OpcuaClient.client == null) {
                            Thread.sleep(300L);
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        MirrorGui.this.pistonLabel.setText("Offset= " + M12OpcuaClient.m1_mirror_center_pos);
                        MirrorGui.this.tilt_XLabel.setText("Tilt_X= " + M12OpcuaClient.m1_mirror_tilt_x);
                        MirrorGui.this.tilt_YLabel.setText("Tilt_Y= " + M12OpcuaClient.m1_mirror_tilt_y);
                        MirrorGui.this.pistonMotorLabel.setText("Offset= " + M12OpcuaClient.m1_motor_pos);
                        MirrorGui.this.textFieldTime.setText("Last Update:" + MirrorGui.m12OpcuaClient.isoStamp);
                    }
                }
                catch (Exception e) {
                    System.out.println("M1 ShowDataThread Exception: " + e.getMessage());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                break;
            }
        }
    };
    private JPanel panel_M1Cmd;
    private JTextField motorTextField;
    private JTextField textFieldTime;

    static {
        GETInfoTextArea = new JTextArea();
        getTelemetryEnableCheckBox = new JCheckBox("EnableGetTelemetry");
        showMirrorCircleFlag = false;
        showMotorCircleFlag = false;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.getProperties();
                    AIV_GUI.consolle.setVisible(true);
                    MirrorGui window = new MirrorGui();
                    window.setVisible(true);
                    window.exitMenuItem.setEnabled(true);
                    window.hideButton.setVisible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void outputInfo(String msg) {
        this.outputInfoLabel.setText(msg);
        System.out.println(msg);
    }

    public void outputInfo(String msg, String level) {
        block16: {
            this.outputInfoLabel.setText(msg);
            System.out.println(msg);
            if (level == null) break block16;
            switch (level) {
                case "warn": {
                    logger.warn((Object)msg);
                    break;
                }
                case "err": {
                    logger.error((Object)msg);
                    break;
                }
                case "debug": {
                    logger.debug((Object)msg);
                    break;
                }
                case "fatal": {
                    logger.fatal((Object)msg);
                    break;
                }
                default: {
                    logger.info((Object)msg);
                }
            }
        }
    }

    public MirrorGui() throws Exception {
        Utils.getProperties();
        m12ICD = new M12ICD();
        m12OpcuaClient = new M12OpcuaClient();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setFont(new Font("Segoe UI", 1, 12));
        menuBar.add(fileMenu);
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("M2GUI");
        mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m2gui.setVisible(true);
            }
        });
        mntmNewMenuItem_1.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(mntmNewMenuItem_1);
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenuItem mntmNewMenuItem = new JMenuItem("StateMachine");
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirrorGui.this.m12StateMachine.setVisible(true);
            }
        });
        JMenuItem mntmNewMenuItem_3 = new JMenuItem("ErrorForm");
        mntmNewMenuItem_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirrorGui.this.errorForm.setVisible(true);
            }
        });
        mntmNewMenuItem_3.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(mntmNewMenuItem_3);
        mntmNewMenuItem.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(mntmNewMenuItem);
        this.exitMenuItem.setEnabled(false);
        this.exitMenuItem.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(this.exitMenuItem);
        JMenu opcuaMenu = new JMenu("Opc-UA");
        opcuaMenu.setFont(new Font("Segoe UI", 1, 12));
        menuBar.add(opcuaMenu);
        JMenuItem mntmNewMenuItem_2 = new JMenuItem("CheckNodes");
        mntmNewMenuItem_2.setFont(new Font("Segoe UI", 1, 12));
        mntmNewMenuItem_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m12OpcuaClient.ceckAllNodes();
            }
        });
        opcuaMenu.add(mntmNewMenuItem_2);
        this.hideButton.setActionCommand("  HIDE  ");
        this.hideButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.hideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.setVisible(false);
            }
        });
        this.hideButton.setForeground(Color.BLUE);
        this.hideButton.setFont(new Font("Tahoma", 1, 12));
        this.hideButton.setBackground(new Color(255, 255, 0));
        menuBar.add(this.hideButton);
        JButton reconnectButton = new JButton("Reconnect");
        reconnectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                m12OpcuaClient.stopClient();
                Utils.getProperties();
                m12ICD = new M12ICD();
                MirrorGui.this.m12StateMachine = new M12StateMachine("", m12OpcuaClient, 1);
                m12OpcuaClient = new M12OpcuaClient();
                m12OpcuaClient.startClient(Utils.amcURLs[Utils.telescopeNumber - 1]);
                MirrorGui.this.errorForm = new ErrorForm("M1", "ws_error_index", "AMC_INFO.M1_ERROR_DESCRIPTION", "ws_error_reset", 4, MirrorGui.m12OpcuaClient.client, "AMC_INFO.M1_ERROR_DESCRIPTION", "AMC_INFO.M1_ERROR_NUMBER");
            }
        });
        reconnectButton.setForeground(Color.BLUE);
        reconnectButton.setFont(new Font("Tahoma", 1, 12));
        reconnectButton.setBackground(Color.LIGHT_GRAY);
        menuBar.add(reconnectButton);
        Component horizontalStrut = Box.createHorizontalStrut(129);
        menuBar.add(horizontalStrut);
        this.textFieldTime = new JTextField("---");
        this.textFieldTime.setToolTipText("Update at: ");
        this.textFieldTime.setHorizontalAlignment(0);
        this.textFieldTime.setFont(new Font("Tahoma", 1, 12));
        this.textFieldTime.setColumns(10);
        this.textFieldTime.setBackground(new Color(255, 255, 230));
        this.textFieldTime.setAutoscrolls(false);
        menuBar.add(this.textFieldTime);
        this.ledLabel.setAlignmentX(1.0f);
        this.ledLabel.setHorizontalAlignment(0);
        this.ledLabel.setToolTipText("heartBeat");
        this.ledLabel.setSize(new Dimension(15, 6));
        this.ledLabel.setPreferredSize(new Dimension(20, 8));
        this.ledLabel.setHorizontalTextPosition(0);
        this.ledLabel.setForeground(Color.RED);
        this.ledLabel.setFont(new Font("Tahoma", 1, 27));
        menuBar.add(this.ledLabel);
        m12OpcuaClient.startClient(Utils.amcURLs[Utils.telescopeNumber - 1]);
        m2gui = new M2GUI(m12OpcuaClient);
        this.m12StateMachine = new M12StateMachine("", m12OpcuaClient, 1);
        this.errorForm = new ErrorForm("M1", "ws_error_index", "AMC_INFO.M1_ERROR_DESCRIPTION", "ws_error_reset", 4, MirrorGui.m12OpcuaClient.client, "ws_error_information", "ws_error_number");
        this.initialize();
    }

    private void initialize() throws Exception {
        this.setResizable(false);
        Utils.setEnablePanel(this.mirrorPanel, false, "Mirror_??");
        Utils.setEnablePanel(this.motorPanel, false, "Motor_??");
        this.showMotorReferenceThread.start();
        this.showMirrorReferenceThread.start();
        this.heartBeatThread.start();
        this.ShowDataThread.start();
        this.setBounds(100, 100, 846, 825);
        this.getContentPane().setLayout(null);
        this.setTitle("M1GUI - PBr-0.5-0222");
        this.scrollPane.setBounds(8, 5, 170, 217);
        this.getContentPane().add(this.scrollPane);
        this.ImageMirrorLabel.setCursor(Cursor.getPredefinedCursor(1));
        this.ImageMirrorLabel.setBorder(new LineBorder(Color.BLUE, 2));
        this.ImageMirrorLabel.setToolTipText("M1 schema");
        this.ImageMirrorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point x = MirrorGui.this.ImageMirrorLabel.getMousePosition();
                try {
                    int ix = 0;
                    while (ix < Utils.mirror1Center.length) {
                        if (x.x > Utils.mirror1Center[ix][0] - 10 & x.x < Utils.mirror1Center[ix][0] + 10 & (x.y > Utils.mirror1Center[ix][1] - 10 & x.y < Utils.mirror1Center[ix][1] + 10)) {
                            MirrorGui.this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m1ab.jpg"));
                            selectedLabel.setBackground(Color.blue);
                            selectedLabel.setForeground(Color.yellow);
                            selectedLabel.setText("Mirror_" + (ix + 1));
                            MirrorGui.this.mirrorIndex = ix + 1;
                            showMirrorCircleFlag = true;
                            Utils.setEnablePanel(MirrorGui.this.mirrorPanel, true, "Mirror_" + MirrorGui.this.mirrorIndex);
                            Utils.setEnablePanel(MirrorGui.this.motorPanel, false, null);
                            MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M1_MIRROR.INDEX"), (Object)((short)MirrorGui.this.mirrorIndex));
                            break;
                        }
                        ++ix;
                    }
                    ix = 0;
                    while (ix < Utils.motor1Center.length) {
                        if (x.x > Utils.motor1Center[ix][0] - 10 & x.x < Utils.motor1Center[ix][0] + 10 & (x.y > Utils.motor1Center[ix][1] - 10 & x.y < Utils.motor1Center[ix][1] + 10)) {
                            MirrorGui.this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m1ab.jpg"));
                            selectedLabel.setBackground(Color.blue);
                            selectedLabel.setForeground(Color.white);
                            selectedLabel.setText("Motor_" + (ix + 1));
                            MirrorGui.this.motorIndex = ix + 1;
                            showMotorCircleFlag = true;
                            Utils.setEnablePanel(MirrorGui.this.motorPanel, true, "Motor_" + MirrorGui.this.motorIndex);
                            Utils.setEnablePanel(MirrorGui.this.mirrorPanel, false, null);
                            MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M1_MOTOR.INDEX"), (Object)((short)MirrorGui.this.mirrorIndex));
                            break;
                        }
                        ++ix;
                    }
                }
                catch (ServiceException | StatusException | NullPointerException e1) {
                    System.out.println("errore loop ");
                }
            }
        });
        this.ImageMirrorLabel.setForeground(Color.YELLOW);
        this.ImageMirrorLabel.setBackground(Color.GRAY);
        this.ImageMirrorLabel.setBounds(186, 5, 475, 482);
        this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m1ab.jpg"));
        this.ImageMirrorLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point x = MirrorGui.this.ImageMirrorLabel.getMousePosition();
            }
        });
        this.getContentPane().add(this.ImageMirrorLabel);
        this.implementsTelescopeButtons();
        this.treeSetModel();
        Utils.setEnablePanel(this.mirrorPanel, false, "Mirror_??");
        Utils.setEnablePanel(this.motorPanel, false, "Motor_??");
    }

    private void implementsTelescopeButtons() {
        JPanel panel = new JPanel();
        panel.setVisible(false);
        panel.setBackground(Color.ORANGE);
        panel.setBounds(677, 5, 75, 212);
        this.getContentPane().add(panel);
        final JRadioButton rdbtnTel_0 = new JRadioButton("Tel_1");
        rdbtnTel_0.setSelected(true);
        rdbtnTel_0.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_0.setHorizontalAlignment(2);
        rdbtnTel_0.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_0);
        final JRadioButton rdbtnTel_1 = new JRadioButton("Tel_2 ");
        rdbtnTel_1.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_1.setHorizontalAlignment(2);
        rdbtnTel_1.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_1);
        final JRadioButton rdbtnTel_2 = new JRadioButton("Tel_3");
        rdbtnTel_2.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_2.setHorizontalAlignment(2);
        rdbtnTel_2.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_2);
        final JRadioButton rdbtnTel_3 = new JRadioButton("Tel_4 ");
        rdbtnTel_3.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_3.setHorizontalAlignment(2);
        rdbtnTel_3.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_3);
        final JRadioButton rdbtnTel_4 = new JRadioButton("Tel_5 ");
        rdbtnTel_4.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_4.setHorizontalAlignment(2);
        rdbtnTel_4.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_4);
        final JRadioButton rdbtnTel_5 = new JRadioButton("Tel_6 ");
        rdbtnTel_5.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_5.setHorizontalAlignment(2);
        rdbtnTel_5.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_5);
        final JRadioButton rdbtnTel_6 = new JRadioButton("Tel_7 ");
        rdbtnTel_6.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_6.setHorizontalAlignment(2);
        rdbtnTel_6.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_6);
        final JRadioButton rdbtnTel_7 = new JRadioButton("Tel_8 ");
        rdbtnTel_7.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_7.setHorizontalAlignment(2);
        rdbtnTel_7.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_7);
        final JRadioButton rdbtnTel_8 = new JRadioButton("Tel_9 ");
        rdbtnTel_8.setPreferredSize(new Dimension(63, 17));
        rdbtnTel_8.setHorizontalAlignment(2);
        rdbtnTel_8.setBackground(Color.ORANGE);
        panel.add(rdbtnTel_8);
        ButtonGroup Telescopegroup = new ButtonGroup();
        Telescopegroup.add(rdbtnTel_0);
        Telescopegroup.add(rdbtnTel_1);
        Telescopegroup.add(rdbtnTel_2);
        Telescopegroup.add(rdbtnTel_3);
        Telescopegroup.add(rdbtnTel_4);
        Telescopegroup.add(rdbtnTel_5);
        Telescopegroup.add(rdbtnTel_6);
        Telescopegroup.add(rdbtnTel_7);
        Telescopegroup.add(rdbtnTel_8);
        JScrollPane scrollPane_1 = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(8, Integer.MAX_VALUE));
        this.scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 8));
        scrollPane_1.setBounds(8, 247, 170, 240);
        scrollPane_1.setToolTipText("GET values");
        scrollPane_1.setVerticalScrollBarPolicy(22);
        scrollPane_1.setHorizontalScrollBarPolicy(32);
        scrollPane_1.getVerticalScrollBar().setPreferredSize(new Dimension(8, Integer.MAX_VALUE));
        scrollPane_1.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 8));
        this.getContentPane().add(scrollPane_1);
        scrollPane_1.setViewportView(GETInfoTextArea);
        GETInfoTextArea.setToolTipText("GET values");
        GETInfoTextArea.setText(">");
        GETInfoTextArea.setForeground(new Color(0, 0, 128));
        GETInfoTextArea.setFont(new Font("SansSerif", 1, 8));
        GETInfoTextArea.setEditable(false);
        GETInfoTextArea.setBackground(new Color(230, 230, 250));
        GETInfoTextArea.setAlignmentY(0.0f);
        GETInfoTextArea.setAlignmentX(0.0f);
        selectedLabel.setOpaque(true);
        selectedLabel.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
        selectedLabel.setBounds(new Rectangle(0, 0, 1, 1));
        selectedLabel.setForeground(Color.YELLOW);
        selectedLabel.setHorizontalAlignment(0);
        selectedLabel.setBackground(Color.BLUE);
        selectedLabel.setFont(new Font("SansSerif", 1, 16));
        selectedLabel.setBounds(701, 247, 81, 27);
        this.getContentPane().add(selectedLabel);
        getTelemetryEnableCheckBox.setBounds(8, 226, 158, 18);
        this.getContentPane().add(getTelemetryEnableCheckBox);
        this.mirrorPanel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "Mirror_", 4, 2, null, new Color(0, 0, 0)));
        this.mirrorPanel.setBackground(new Color(255, 204, 153));
        this.mirrorPanel.setBounds(8, 498, 321, 210);
        this.getContentPane().add(this.mirrorPanel);
        this.mirrorPanel.setLayout(null);
        this.pistonLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.pistonLabel.setFont(new Font("Tahoma", 1, 12));
        this.pistonLabel.setBounds(10, 20, 127, 23);
        this.mirrorPanel.add(this.pistonLabel);
        this.pistonTextField = new JTextField();
        this.pistonTextField.setHorizontalAlignment(0);
        this.pistonTextField.setText("0.0");
        this.pistonTextField.setFont(new Font("Tahoma", 1, 12));
        this.pistonTextField.setBackground(new Color(255, 255, 204));
        this.pistonTextField.setBounds(147, 20, 89, 22);
        this.mirrorPanel.add(this.pistonTextField);
        this.pistonTextField.setColumns(10);
        final JButton pistonButton = new JButton("GoRel");
        pistonButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!pistonButton.isEnabled()) {
                        return;
                    }
                    MirrorGui.this.outputInfo("--> Start OffSet relative....ns=4;s=CMD_M1.OFFSET_MIRROR");
                    double offsetRel = Float.parseFloat(MirrorGui.this.pistonTextField.getText());
                    MirrorGui.m12OpcuaClient.client.writeValue(new NodeId(4, "SET_M1_MIRROR.CENTER_OFFSET"), (Object)offsetRel);
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M1.OFFSET_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    MirrorGui.this.outputInfo("GoRelerror:" + e1.getMessage());
                }
            }
        });
        pistonButton.setBorder(new BevelBorder(0, null, null, null, null));
        pistonButton.setFont(new Font("Tahoma", 1, 11));
        pistonButton.setBounds(242, 12, 53, 20);
        this.mirrorPanel.add(pistonButton);
        this.tilt_XLabel.setFont(new Font("Tahoma", 1, 12));
        this.tilt_XLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.tilt_XLabel.setBounds(10, 54, 127, 23);
        this.mirrorPanel.add(this.tilt_XLabel);
        this.tilt_XTextField = new JTextField();
        this.tilt_XTextField.setText("0.0");
        this.tilt_XTextField.setHorizontalAlignment(0);
        this.tilt_XTextField.setFont(new Font("Tahoma", 1, 12));
        this.tilt_XTextField.setColumns(10);
        this.tilt_XTextField.setBackground(new Color(255, 255, 204));
        this.tilt_XTextField.setBounds(147, 54, 89, 22);
        this.mirrorPanel.add(this.tilt_XTextField);
        this.tilt_XButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!MirrorGui.this.tilt_XButton.isEnabled()) {
                        return;
                    }
                    MirrorGui.this.outputInfo("--> Command: ns=4;s=CMD_M1.TILTX_MIRROR");
                    double tiltY = Float.parseFloat(MirrorGui.this.tilt_YTextField.getText());
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M1_MIRROR.TILT_Y"), (Object)tiltY);
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M1.TILTX_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    MirrorGui.this.outputInfo("Tilt_X error:" + e1.getMessage());
                }
            }
        });
        this.tilt_XButton.setFont(new Font("Tahoma", 1, 11));
        this.tilt_XButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.tilt_XButton.setBounds(242, 55, 53, 22);
        this.mirrorPanel.add(this.tilt_XButton);
        this.tilt_YLabel.setFont(new Font("Tahoma", 1, 12));
        this.tilt_YLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.tilt_YLabel.setBounds(10, 80, 127, 23);
        this.mirrorPanel.add(this.tilt_YLabel);
        this.tilt_YTextField = new JTextField();
        this.tilt_YTextField.setText("0.0");
        this.tilt_YTextField.setHorizontalAlignment(0);
        this.tilt_YTextField.setFont(new Font("Tahoma", 1, 12));
        this.tilt_YTextField.setColumns(10);
        this.tilt_YTextField.setBackground(new Color(255, 255, 204));
        this.tilt_YTextField.setBounds(147, 80, 89, 22);
        this.mirrorPanel.add(this.tilt_YTextField);
        this.tilt_YButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!MirrorGui.this.tilt_YButton.isEnabled()) {
                        return;
                    }
                    MirrorGui.this.outputInfo("--> Command: ns=4;s=CMD_M1.TILTY_MIRROR");
                    double tiltX = Float.parseFloat(MirrorGui.this.tilt_XTextField.getText());
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M1_MIRROR.TILT_X"), (Object)tiltX);
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M1.TILTY_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    MirrorGui.this.outputInfo("Tilt_Y error:" + e1.getMessage());
                }
            }
        });
        this.tilt_YButton.setFont(new Font("Tahoma", 1, 11));
        this.tilt_YButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.tilt_YButton.setBounds(242, 81, 53, 22);
        this.mirrorPanel.add(this.tilt_YButton);
        final JButton btnHomingMirror = new JButton("GoHome");
        btnHomingMirror.setBorder(new BevelBorder(0, null, null, null, null));
        btnHomingMirror.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnHomingMirror, "ns=4;s=CMD_M1.START_HOMING_MIRROR", true);
            }
        });
        btnHomingMirror.setToolTipText("M1_Homing_All");
        btnHomingMirror.setForeground(Color.BLUE);
        btnHomingMirror.setFont(new Font("Tahoma", 1, 10));
        btnHomingMirror.setBackground(new Color(255, 255, 153));
        btnHomingMirror.setBounds(10, 114, 75, 23);
        this.mirrorPanel.add(btnHomingMirror);
        final JButton btnGoAbs = new JButton("GoAbs");
        btnGoAbs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!btnGoAbs.isEnabled()) {
                        return;
                    }
                    MirrorGui.this.outputInfo("--> Start OffSet absolute....ns=4;s=CMD_M1.MOVE_MIRROR");
                    double offsetAbf = Float.parseFloat(MirrorGui.this.pistonTextField.getText());
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M1_MIRROR.CENTER_POS"), (Object)offsetAbf);
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M1.MOVE_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    MirrorGui.this.outputInfo("GoRelerror:" + e1.getMessage());
                }
            }
        });
        btnGoAbs.setFont(new Font("Tahoma", 1, 11));
        btnGoAbs.setBorder(new BevelBorder(0, null, null, null, null));
        btnGoAbs.setBounds(242, 31, 53, 20);
        this.mirrorPanel.add(btnGoAbs);
        final JButton btnM1HomeAll = new JButton("HomingAll");
        btnM1HomeAll.setBounds(10, 176, 81, 23);
        this.mirrorPanel.add(btnM1HomeAll);
        btnM1HomeAll.setBorder(new BevelBorder(0, null, null, null, null));
        btnM1HomeAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnM1HomeAll, "ns=4;s=CMD_M1.START_HOMING_ALL", true);
            }
        });
        btnM1HomeAll.setToolTipText("Homing_All_Mirror");
        btnM1HomeAll.setForeground(Color.BLUE);
        btnM1HomeAll.setFont(new Font("Tahoma", 1, 10));
        btnM1HomeAll.setBackground(new Color(255, 255, 153));
        final JButton btnStopall = new JButton("StopAll");
        btnStopall.setBounds(94, 176, 69, 23);
        this.mirrorPanel.add(btnStopall);
        btnStopall.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnStopall, "ns=4;s=CMD_M1.STOP_HOMING_ALL", true);
            }
        });
        btnStopall.setBorder(new BevelBorder(0, null, null, null, null));
        btnStopall.setToolTipText("Stop_Homing_All_Mirror");
        btnStopall.setForeground(new Color(255, 0, 0));
        btnStopall.setFont(new Font("Tahoma", 1, 10));
        btnStopall.setBackground(new Color(255, 255, 153));
        final JButton stopMirrorButton = new JButton("Stop");
        stopMirrorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(stopMirrorButton, "ns=4;s=CMD_M1.STOP_MIRROR", true);
            }
        });
        stopMirrorButton.setForeground(new Color(255, 0, 0));
        stopMirrorButton.setToolTipText("Stop_Move");
        stopMirrorButton.setFont(new Font("Tahoma", 1, 11));
        stopMirrorButton.setBorder(new BevelBorder(0, null, null, null, null));
        stopMirrorButton.setBounds(242, 106, 53, 22);
        this.mirrorPanel.add(stopMirrorButton);
        final JButton stopHomingButton = new JButton("Stop");
        stopHomingButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(stopHomingButton, "ns=4;s=CMD_M1.STOP_HOMING_MIRROR", true);
            }
        });
        stopHomingButton.setToolTipText("Stop_Home");
        stopHomingButton.setForeground(Color.RED);
        stopHomingButton.setFont(new Font("Tahoma", 1, 11));
        stopHomingButton.setBorder(new BevelBorder(0, null, null, null, null));
        stopHomingButton.setBounds(92, 114, 53, 23);
        this.mirrorPanel.add(stopHomingButton);
        final JButton btnEnableMirror = new JButton("Enable");
        btnEnableMirror.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnEnableMirror, "ns=4;s=CMD_M1.ENABLE_MIRROR", true);
            }
        });
        btnEnableMirror.setToolTipText("Enable_Mirror");
        btnEnableMirror.setForeground(Color.BLUE);
        btnEnableMirror.setFont(new Font("Tahoma", 1, 10));
        btnEnableMirror.setBorder(new BevelBorder(0, null, null, null, null));
        btnEnableMirror.setBackground(new Color(255, 255, 153));
        btnEnableMirror.setBounds(214, 150, 81, 23);
        this.mirrorPanel.add(btnEnableMirror);
        final JButton btnDisableMirror = new JButton("Disable");
        btnDisableMirror.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnDisableMirror, "ns=4;s=CMD_M1.DISABLE_MIRROR", true);
            }
        });
        btnDisableMirror.setToolTipText("Disable_Mirror");
        btnDisableMirror.setForeground(Color.RED);
        btnDisableMirror.setFont(new Font("Tahoma", 1, 10));
        btnDisableMirror.setBorder(new BevelBorder(0, null, null, null, null));
        btnDisableMirror.setBackground(new Color(255, 255, 153));
        btnDisableMirror.setBounds(214, 176, 81, 23);
        this.mirrorPanel.add(btnDisableMirror);
        this.motorPanel.setBackground(new Color(153, 204, 204));
        this.motorPanel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "Motor_", 1, 2, null, new Color(0, 0, 0)));
        this.motorPanel.setBounds(339, 498, 322, 210);
        this.getContentPane().add(this.motorPanel);
        this.motorPanel.setLayout(null);
        this.pistonMotorLabel.setFont(new Font("Tahoma", 1, 12));
        this.pistonMotorLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.pistonMotorLabel.setBounds(10, 19, 127, 23);
        this.motorPanel.add(this.pistonMotorLabel);
        this.motorTextField = new JTextField();
        this.motorTextField.setText("0.0");
        this.motorTextField.setHorizontalAlignment(0);
        this.motorTextField.setFont(new Font("Tahoma", 1, 12));
        this.motorTextField.setColumns(10);
        this.motorTextField.setBackground(new Color(255, 255, 204));
        this.motorTextField.setBounds(147, 19, 89, 22);
        this.motorPanel.add(this.motorTextField);
        final JButton motorRelButton = new JButton("GoRel");
        motorRelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!motorRelButton.isEnabled()) {
                        return;
                    }
                    MirrorGui.this.outputInfo("--> Start OffSet relative....ns=4;s=CMD_M1.OFFSET_MOTOR");
                    double offsetRel = Float.parseFloat(MirrorGui.this.motorTextField.getText());
                    MirrorGui.m12OpcuaClient.client.writeValue(new NodeId(4, "SET_M1_MOTOR.OFFSET"), (Object)offsetRel);
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M1.OFFSET_MOTOR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    MirrorGui.this.outputInfo("Error on ns=4;s=CMD_M1.OFFSET_MOTOR: " + e1.getMessage());
                }
            }
        });
        motorRelButton.setFont(new Font("Tahoma", 1, 11));
        motorRelButton.setBorder(new BevelBorder(0, null, null, null, null));
        motorRelButton.setBounds(242, 11, 53, 20);
        this.motorPanel.add(motorRelButton);
        final JButton motorAbsButton = new JButton("GoAbs");
        motorAbsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!motorAbsButton.isEnabled()) {
                        return;
                    }
                    MirrorGui.this.outputInfo("--> Start OffSet relative....ns=4;s=CMD_M1.MOVE_MOTOR");
                    double offsetRel = Float.parseFloat(MirrorGui.this.motorTextField.getText());
                    MirrorGui.m12OpcuaClient.client.writeValue(new NodeId(4, "SET_M1_MOTOR.POS"), (Object)offsetRel);
                    MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M1.MOVE_MOTOR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    MirrorGui.this.outputInfo("Error on ns=4;s=ns=4;s=CMD_M1.MOVE_MOTOR: " + e1.getMessage());
                }
            }
        });
        motorAbsButton.setFont(new Font("Tahoma", 1, 11));
        motorAbsButton.setBorder(new BevelBorder(0, null, null, null, null));
        motorAbsButton.setBounds(242, 30, 53, 20);
        this.motorPanel.add(motorAbsButton);
        final JButton stopMotorButton = new JButton("Stop");
        stopMotorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(stopMotorButton, "ns=4;s=CMD_M1.STOP_MOTOR", true);
            }
        });
        stopMotorButton.setToolTipText("Stop_Move");
        stopMotorButton.setForeground(Color.RED);
        stopMotorButton.setFont(new Font("Tahoma", 1, 11));
        stopMotorButton.setBorder(new BevelBorder(0, null, null, null, null));
        stopMotorButton.setBounds(242, 52, 53, 22);
        this.motorPanel.add(stopMotorButton);
        final JButton btnEnableAllMotors = new JButton("EnableAll");
        btnEnableAllMotors.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnEnableAllMotors, "ns=4;s=CMD_M1.ENABLE_ALL", true);
            }
        });
        btnEnableAllMotors.setToolTipText("Enable_Motors");
        btnEnableAllMotors.setForeground(Color.BLUE);
        btnEnableAllMotors.setFont(new Font("Tahoma", 1, 10));
        btnEnableAllMotors.setBorder(new BevelBorder(0, null, null, null, null));
        btnEnableAllMotors.setBackground(new Color(255, 255, 153));
        btnEnableAllMotors.setBounds(214, 150, 81, 23);
        this.motorPanel.add(btnEnableAllMotors);
        final JButton btnDisableAllMotors = new JButton("DisableAll");
        btnDisableAllMotors.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnDisableAllMotors, "ns=4;s=CMD_M1.DISABLE_ALL", true);
            }
        });
        btnDisableAllMotors.setToolTipText("Disable_Motors");
        btnDisableAllMotors.setForeground(Color.RED);
        btnDisableAllMotors.setFont(new Font("Tahoma", 1, 10));
        btnDisableAllMotors.setBorder(new BevelBorder(0, null, null, null, null));
        btnDisableAllMotors.setBackground(new Color(255, 255, 153));
        btnDisableAllMotors.setBounds(214, 176, 81, 23);
        this.motorPanel.add(btnDisableAllMotors);
        final JButton btnEnableMotor = new JButton("Enable");
        btnEnableMotor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnEnableMotor, "ns=4;s=CMD_M1.ENABLE_MOTOR", true);
            }
        });
        btnEnableMotor.setToolTipText("Enable_Motor");
        btnEnableMotor.setForeground(Color.BLUE);
        btnEnableMotor.setFont(new Font("Tahoma", 1, 10));
        btnEnableMotor.setBorder(new BevelBorder(0, null, null, null, null));
        btnEnableMotor.setBackground(new Color(255, 255, 153));
        btnEnableMotor.setBounds(10, 64, 73, 23);
        this.motorPanel.add(btnEnableMotor);
        final JButton btnDisableMotors = new JButton("Disable");
        btnDisableMotors.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnDisableMotors, "ns=4;s=CMD_M1.DISABLE_MOTOR", true);
            }
        });
        btnDisableMotors.setToolTipText("Disable_Motor");
        btnDisableMotors.setForeground(Color.RED);
        btnDisableMotors.setFont(new Font("Tahoma", 1, 10));
        btnDisableMotors.setBorder(new BevelBorder(0, null, null, null, null));
        btnDisableMotors.setBackground(new Color(255, 255, 153));
        btnDisableMotors.setBounds(88, 64, 81, 23);
        this.motorPanel.add(btnDisableMotors);
        this.outputInfoLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.outputInfoLabel.setToolTipText("infoLabel");
        this.outputInfoLabel.setHorizontalAlignment(0);
        this.outputInfoLabel.setForeground(Color.BLACK);
        this.outputInfoLabel.setFont(new Font("Tahoma", 1, 11));
        this.outputInfoLabel.setBackground(new Color(255, 250, 205));
        this.outputInfoLabel.setBounds(10, 719, 808, 27);
        this.getContentPane().add(this.outputInfoLabel);
        this.panel_M1Cmd = new JPanel();
        this.panel_M1Cmd.setBackground(new Color(153, 204, 255));
        this.panel_M1Cmd.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "AMC_Cmds", 4, 2, null, new Color(0, 0, 0)));
        this.panel_M1Cmd.setBounds(677, 427, 141, 281);
        this.getContentPane().add(this.panel_M1Cmd);
        this.panel_M1Cmd.setLayout(null);
        final JButton btnLoadConfPar = new JButton("LoadParams");
        btnLoadConfPar.setBounds(25, 23, 92, 30);
        this.panel_M1Cmd.add(btnLoadConfPar);
        btnLoadConfPar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnLoadConfPar, "ns=4;s=CMD_AMC.LOAD_CONF_PAR", true);
            }
        });
        btnLoadConfPar.setForeground(Color.BLUE);
        btnLoadConfPar.setFont(new Font("Tahoma", 1, 10));
        btnLoadConfPar.setBorder(new BevelBorder(0, null, null, null, null));
        btnLoadConfPar.setBackground(Color.LIGHT_GRAY);
        final JButton btnSaveConfPar = new JButton("SaveParams");
        btnSaveConfPar.setBounds(25, 56, 92, 30);
        this.panel_M1Cmd.add(btnSaveConfPar);
        btnSaveConfPar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnSaveConfPar, "ns=4;s=CMD_AMC.SAVE_CONF_PAR", true);
            }
        });
        btnSaveConfPar.setForeground(Color.BLUE);
        btnSaveConfPar.setFont(new Font("Tahoma", 1, 10));
        btnSaveConfPar.setBorder(new BevelBorder(0, null, null, null, null));
        btnSaveConfPar.setBackground(Color.LIGHT_GRAY);
        final JButton btnAlarmReset = new JButton("ResetAlarm");
        btnAlarmReset.setBounds(25, 112, 92, 27);
        this.panel_M1Cmd.add(btnAlarmReset);
        btnAlarmReset.setBorder(new BevelBorder(0, null, null, null, null));
        btnAlarmReset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnAlarmReset, "ns=4;s=CMD_AMC.RESET_ALARMS", true);
            }
        });
        btnAlarmReset.setToolTipText("ResetAlarm");
        btnAlarmReset.setForeground(new Color(255, 204, 0));
        btnAlarmReset.setFont(new Font("Tahoma", 1, 10));
        btnAlarmReset.setBackground(new Color(0, 0, 0));
        final JButton btnResetSystem = new JButton("RESET_Sys");
        btnResetSystem.setBounds(25, 150, 92, 30);
        this.panel_M1Cmd.add(btnResetSystem);
        btnResetSystem.setBorder(new BevelBorder(0, null, null, null, null));
        btnResetSystem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(btnResetSystem, "ns=4;s=CMD_AMC.RESET_SYSTEM", true);
            }
        });
        btnResetSystem.setForeground(Color.BLUE);
        btnResetSystem.setFont(new Font("Tahoma", 1, 10));
        btnResetSystem.setBackground(new Color(255, 102, 0));
        final CreateRoundButton stopButton = new CreateRoundButton("STOP");
        stopButton.setBounds(36, 191, 71, 67);
        this.panel_M1Cmd.add(stopButton);
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MirrorGui.this.sendCommand(stopButton, "ns=4;s=CMD_AMC.EMERGENCY_STOP", true);
            }
        });
        stopButton.setToolTipText("emergency stop");
        stopButton.setForeground(new Color(255, 255, 0));
        stopButton.setFont(new Font("Tahoma", 1, 15));
        stopButton.setBorder(new BevelBorder(1, null, null, null, null));
        stopButton.setBackground(Color.RED);
        stopButton.setAlignmentX(0.5f);
        rdbtnTel_0.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_0.isSelected()) {
                    Utils.setTelescope(1);
                }
            }
        });
        rdbtnTel_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_1.isSelected()) {
                    Utils.setTelescope(2);
                }
            }
        });
        rdbtnTel_2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_2.isSelected()) {
                    Utils.setTelescope(3);
                }
            }
        });
        rdbtnTel_3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_3.isSelected()) {
                    Utils.setTelescope(4);
                }
            }
        });
        rdbtnTel_4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_4.isSelected()) {
                    Utils.setTelescope(5);
                }
            }
        });
        rdbtnTel_5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_5.isSelected()) {
                    Utils.setTelescope(6);
                }
            }
        });
        rdbtnTel_6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_6.isSelected()) {
                    Utils.setTelescope(7);
                }
            }
        });
        rdbtnTel_7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_7.isSelected()) {
                    Utils.setTelescope(8);
                }
            }
        });
        rdbtnTel_8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdbtnTel_8.isSelected()) {
                    Utils.setTelescope(9);
                }
            }
        });
    }

    private void treeSetModel() {
        this.nodeTree.setForeground(Color.WHITE);
        this.nodeTree.setBackground(Color.LIGHT_GRAY);
        this.scrollPane.setViewportView(this.nodeTree);
        this.nodeTree.setFont(new Font("Tahoma", 0, 10));
        this.nodeTree.setToolTipText("This is my NodeTree  ;)");
        this.nodeTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath tp = MirrorGui.this.nodeTree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp.getPath().length == 3) {
                    MirrorGui.this.jtreeToOpcua(tp.getPath()[1].toString(), tp.getPath()[2].toString());
                }
            }
        });
        this.nodeTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("OPCUA_node_list"){
            {
                DefaultMutableTreeNode node_get = new DefaultMutableTreeNode("GetList");
                int g = 0;
                while (g < MirrorGui.m12ICD.get_ACSName_List.size()) {
                    node_get.add(new DefaultMutableTreeNode(MirrorGui.m12ICD.get_ACSName_List.get(g)));
                    ++g;
                }
                super.add(node_get);
                DefaultMutableTreeNode node_set = new DefaultMutableTreeNode("SetList");
                int g2 = 0;
                while (g2 < MirrorGui.m12ICD.set_ACSName_List.size()) {
                    node_set.add(new DefaultMutableTreeNode(MirrorGui.m12ICD.set_ACSName_List.get(g2)));
                    ++g2;
                }
                super.add(node_set);
                DefaultMutableTreeNode node_cmd = new DefaultMutableTreeNode("CmdList");
                int g3 = 0;
                while (g3 < MirrorGui.m12ICD.cmd_ACSName_List.size()) {
                    node_cmd.add(new DefaultMutableTreeNode(MirrorGui.m12ICD.cmd_ACSName_List.get(g3)));
                    ++g3;
                }
                super.add(node_cmd);
                DefaultMutableTreeNode node_mode = new DefaultMutableTreeNode("ModeList");
                int g4 = 0;
                while (g4 < MirrorGui.m12ICD.mode_ACSName_List.size()) {
                    node_mode.add(new DefaultMutableTreeNode(MirrorGui.m12ICD.mode_ACSName_List.get(g4)));
                    ++g4;
                }
                super.add(node_mode);
            }
        }));
    }

    private void jtreeToOpcua(String nodeList, String acsName) {
        if (!MirrorGui.m12OpcuaClient.client.isConnected()) {
            AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText(" OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
            return;
        }
        String nodeName = "";
        try {
            switch (nodeList) {
                case "GetList": {
                    int ix = 0;
                    while (ix < MirrorGui.m12ICD.get_ACSName_List.size()) {
                        if (acsName == MirrorGui.m12ICD.get_ACSName_List.get(ix)) {
                            nodeName = MirrorGui.m12ICD.get_NodeName_List.get(ix);
                            GETInfoTextArea.getDocument().remove(0, GETInfoTextArea.getDocument().getLength());
                            GETInfoTextArea.append("> " + nodeName + ": " + MirrorGui.getOPCUAdata(nodeName) + "\n");
                            GETInfoTextArea.append("> ACSName: " + acsName + "\n> Default Value =" + MirrorGui.m12ICD.set_DefaultValue_List.get(ix) + "\n");
                            GETInfoTextArea.append("> DataType: " + MirrorGui.m12ICD.set_DataType_List.get(ix) + "\n");
                            GETInfoTextArea.append("> Description: " + MirrorGui.m12ICD.get_Description_List.get(ix) + " \n");
                        }
                        ++ix;
                    }
                    break;
                }
                case "SetList": {
                    int ix = 0;
                    while (ix < MirrorGui.m12ICD.set_ACSName_List.size()) {
                        if (acsName == MirrorGui.m12ICD.set_ACSName_List.get(ix)) {
                            nodeName = MirrorGui.m12ICD.set_NodeName_List.get(ix);
                            DataInputForm.frmDatainputform.setVisible(true);
                            DataInputForm.frmDatainputform.setTitle("Mirror 1&2... SET");
                            DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + MirrorGui.m12ICD.set_DefaultValue_List.get(ix) + "]");
                            DataInputForm.opcuaNameLabel.setText(String.valueOf(MirrorGui.m12ICD.set_NodeName_List.get(ix)) + " [" + MirrorGui.m12ICD.set_DataType_List.get(ix) + "]");
                            DataInputForm.enterDataValueField.setToolTipText(MirrorGui.m12ICD.set_Description_List.get(ix));
                            DataInputForm.enterDataValueField.setText(MirrorGui.getOPCUAdata(nodeName));
                            AIV_GUI.writeOnInfoText("Description: " + MirrorGui.m12ICD.set_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                            DataInputForm.enterDataValueField.setForeground(Color.BLACK);
                        }
                        ++ix;
                    }
                    break;
                }
                case "CmdList": {
                    int ix = 0;
                    while (ix < MirrorGui.m12ICD.cmd_ACSName_List.size()) {
                        if (acsName == MirrorGui.m12ICD.cmd_ACSName_List.get(ix)) {
                            nodeName = MirrorGui.m12ICD.cmd_NodeName_List.get(ix);
                            DataInputForm.frmDatainputform.setVisible(true);
                            DataInputForm.frmDatainputform.setTitle("\"Mirror 1&2... CMD");
                            DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + MirrorGui.m12ICD.cmd_DefaultValue_List.get(ix) + "]");
                            DataInputForm.opcuaNameLabel.setText(String.valueOf(MirrorGui.m12ICD.cmd_NodeName_List.get(ix)) + " [" + MirrorGui.m12ICD.cmd_DataType_List.get(ix) + "]");
                            DataInputForm.enterDataValueField.setToolTipText(MirrorGui.m12ICD.cmd_Description_List.get(ix));
                            DataInputForm.enterDataValueField.setText(MirrorGui.m12ICD.cmd_CmdOrModeValue_List.get(ix));
                            DataInputForm.enterDataValueField.setForeground(Color.RED);
                            MirrorGui.getOPCUAdata(nodeName);
                            AIV_GUI.writeOnInfoText("Description: " + MirrorGui.m12ICD.cmd_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        }
                        ++ix;
                    }
                    break;
                }
                case "ModeList": {
                    int ix = 0;
                    while (ix < MirrorGui.m12ICD.mode_ACSName_List.size()) {
                        if (acsName == MirrorGui.m12ICD.mode_ACSName_List.get(ix)) {
                            nodeName = MirrorGui.m12ICD.mode_NodeName_List.get(ix);
                            DataInputForm.frmDatainputform.setVisible(true);
                            DataInputForm.frmDatainputform.setTitle("\"Mirror 1&2... MODE");
                            DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + MirrorGui.m12ICD.mode_DefaultValue_List.get(ix) + "]");
                            DataInputForm.opcuaNameLabel.setText(String.valueOf(MirrorGui.m12ICD.mode_NodeName_List.get(ix)) + " [" + MirrorGui.m12ICD.mode_DataType_List.get(ix) + "]");
                            DataInputForm.enterDataValueField.setToolTipText(MirrorGui.m12ICD.mode_Description_List.get(ix));
                            DataInputForm.enterDataValueField.setText(MirrorGui.m12ICD.mode_CmdOrModeValue_List.get(ix));
                            DataInputForm.enterDataValueField.setForeground(Color.DARK_GRAY);
                            MirrorGui.getOPCUAdata(nodeName);
                            AIV_GUI.writeOnInfoText("Description: " + MirrorGui.m12ICD.mode_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        }
                        ++ix;
                    }
                    break;
                }
                default: {
                    AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
                    AIV_GUI.writeOnInfoText(" acsCommand not valid: " + acsName + "\n", Color.RED, true, false, true, true, 12);
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ocSetValueToOpcuaServer() {
        String nodeType;
        String nodeName;
        block9: {
            String setVal = DataInputForm.acsNameLabel.getText();
            setVal = setVal.substring(0, setVal.indexOf(")")).trim();
            int opcIndex = Integer.parseInt(setVal);
            nodeName = "";
            nodeType = "";
            try {
                if (DataInputForm.frmDatainputform.getTitle().contains("SET")) {
                    nodeName = MirrorGui.m12ICD.set_NodeName_List.get(opcIndex);
                    nodeType = MirrorGui.m12ICD.set_DataType_List.get(opcIndex);
                    break block9;
                }
                if (DataInputForm.frmDatainputform.getTitle().contains("CMD")) {
                    nodeName = MirrorGui.m12ICD.cmd_NodeName_List.get(opcIndex);
                    nodeType = MirrorGui.m12ICD.cmd_DataType_List.get(opcIndex);
                    break block9;
                }
                if (DataInputForm.frmDatainputform.getTitle().contains("MODE")) {
                    nodeName = MirrorGui.m12ICD.mode_NodeName_List.get(opcIndex);
                    nodeType = MirrorGui.m12ICD.mode_DataType_List.get(opcIndex);
                    break block9;
                }
                AIV_GUI.writeOnInfoText("WRONG data...", Color.RED, true, false, false, false, 15);
                AIV_GUI.inserIconOnInfoText(20, Utils.thinkImageIcon);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String browserName = nodeName.substring(nodeName.lastIndexOf("=") + 1);
        String val = DataInputForm.enterDataValueField.getText().trim();
        try {
            MirrorGui.m12OpcuaClient.client.writeValue(new NodeId(2, browserName), AIV_GUI.opcuaUtils.setInitValue(nodeType, val));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        MirrorGui.getOPCUAdata(nodeName);
        DataInputForm.frmDatainputform.setVisible(false);
    }

    public static String getOPCUAdata(String nodeName) {
        DataValue datValue = null;
        if (nodeName.contains("ns=")) {
            datValue = m12OpcuaClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
                return datValue.getValue().getValue().toString();
            }
            AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            return "";
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText(" nodeName not valid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
        return "";
    }

    public void drawMotorCircleOnImage(int mtrIndex) {
        Graphics2D g2 = (Graphics2D)this.ImageMirrorLabel.getGraphics();
        int Xc = Utils.motor1Center[mtrIndex][0];
        int Yc = Utils.motor1Center[mtrIndex][1];
        g2.setStroke(new BasicStroke(2.0f));
        if (Xc >= 0 & Yc >= 0) {
            g2.setColor(Color.white);
            g2.draw(new Ellipse2D.Double(Xc - 12, Yc - 12, 24.0, 24.0));
        }
    }

    public void drawMirrorCircleOnImage(int mrrIndex) {
        GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
        Graphics2D g2 = (Graphics2D)this.ImageMirrorLabel.getGraphics();
        int Xc = Utils.mirror1Center[mrrIndex][0];
        int Yc = Utils.mirror1Center[mrrIndex][1];
        g2.setStroke(new BasicStroke(2.0f));
        if (Xc >= 0 & Yc >= 0) {
            g2.setColor(Color.yellow);
            g2.draw(new Ellipse2D.Double(Xc - 45, Yc - 45, 90.0, 90.0));
        }
    }

    public void sendCommand(JButton btn, String nodeName, boolean value) {
        try {
            if (!btn.isEnabled()) {
                return;
            }
            this.outputInfo("--> Command: " + nodeName);
            MirrorGui.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId(nodeName), (Object)value);
        }
        catch (ServiceException | StatusException e1) {
            this.outputInfo("Error on " + nodeName + e1.getMessage());
        }
    }
}

