/*
 * Decompiled with CFR 0.152.
 */
package m12.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import gui.AIV_GUI;
import gui.DataInputForm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import m12.client.M12OpcuaClient;
import m12.client.M12StateMachine;
import myproc.Utils;
import oc.client.CreateRoundButton;
import org.apache.log4j.Logger;
import org.opcfoundation.ua.builtintypes.NodeId;

public class M2GUI
extends JFrame {
    private static Logger logger = Logger.getLogger(M2GUI.class);
    public String frameTitle = "M2GUI-PBr0.7 on ASTRI" + Utils.telescopeNumber;
    public JLabel ImageMirrorLabel = new JLabel("");
    public static JLabel selectedLabel = new JLabel("---");
    public static M12OpcuaClient m12OpcuaClient;
    public M12StateMachine m12StateMachine;
    public int motorIndex = -1;
    public int mirrorIndex = -1;
    public DataInputForm ocDataInputForm = new DataInputForm("OC");
    JPanel motorPanel = new JPanel();
    JPanel mirrorPanel = new JPanel();
    public JMenuItem exitMenuItem = new JMenuItem("Exit");
    JMenuItem hideMenuItem = new JMenuItem("Hide");
    JLabel outputInfoLabel = new JLabel("--------");
    JLabel pistonLabel = new JLabel("Offset=");
    JLabel tilt_YLabel = new JLabel("Tilt_Y=");
    JLabel tilt_XLabel = new JLabel("Tilt_X=");
    JButton tilt_YButton = new JButton("Go");
    JButton tilt_XButton = new JButton("Go");
    JLabel pistonMotorLabel = new JLabel("Offset=");
    JLabel heartbeatLabel = new JLabel("0");
    public static boolean showMirrorCircleFlag;
    private Thread showMirrorReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    int Yc;
                    int Xc;
                    Graphics2D g2;
                    while (true) {
                        if (!showMirrorCircleFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showMirrorCircleFlag = false;
                        g2 = (Graphics2D)M2GUI.this.ImageMirrorLabel.getGraphics();
                        Xc = Utils.mirror2Center[0];
                        Yc = Utils.mirror2Center[1];
                        g2.setStroke(new BasicStroke(3.0f));
                        if (Xc >= 0 & Yc >= 0) break;
                    }
                    g2.setColor(Color.yellow);
                    g2.draw(new Ellipse2D.Double(Xc - 140, Yc - 140, 280.0, 280.0));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    public static boolean showMotorCircleFlag;
    private Thread showMotorReferenceThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    int Yc;
                    int Xc;
                    Graphics2D g2;
                    while (true) {
                        if (!showMotorCircleFlag) {
                            Thread.sleep(200L);
                            continue;
                        }
                        showMotorCircleFlag = false;
                        GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
                        g2 = (Graphics2D)M2GUI.this.ImageMirrorLabel.getGraphics();
                        Xc = Utils.motor2Center[M2GUI.this.motorIndex - 1][0];
                        Yc = Utils.motor2Center[M2GUI.this.motorIndex - 1][1];
                        g2.setStroke(new BasicStroke(2.0f));
                        if (Xc >= 0 & Yc >= 0) break;
                    }
                    g2.setColor(Color.ORANGE);
                    g2.draw(new Ellipse2D.Double(Xc - 50, Yc - 50, 100.0, 100.0));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    private Thread heartBeatThread = new Thread(){

        @Override
        public synchronized void run() {
            int oldValue = M2GUI.m12OpcuaClient.heartbeat;
            while (true) {
                try {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (oldValue != M2GUI.m12OpcuaClient.heartbeat) {
                            oldValue = M2GUI.m12OpcuaClient.heartbeat;
                            if (M2GUI.this.heartbeatLabel.getForeground() == Color.gray) {
                                M2GUI.this.heartbeatLabel.setForeground(Color.green);
                                continue;
                            }
                            M2GUI.this.heartbeatLabel.setForeground(Color.gray);
                            continue;
                        }
                        M2GUI.this.heartbeatLabel.setForeground(Color.red);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    };
    private JTextField pistonTextField;
    private JTextField tilt_XTextField;
    private JTextField tilt_YTextField;
    public boolean startShowDataThread = true;
    private Thread ShowDataThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (!M2GUI.this.startShowDataThread || !M2GUI.m12OpcuaClient.client.isConnected()) {
                            Thread.sleep(300L);
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        M2GUI.this.pistonLabel.setText("Offset= " + M12OpcuaClient.m2_mirror_center_pos);
                        M2GUI.this.tilt_XLabel.setText("Tilt_X= " + M12OpcuaClient.m2_mirror_tilt_x);
                        M2GUI.this.tilt_YLabel.setText("Tilt_Y= " + M12OpcuaClient.m2_mirror_tilt_y);
                        M2GUI.this.pistonMotorLabel.setText("Offset= " + M12OpcuaClient.m2_motor_pos);
                        M2GUI.this.heartbeatLabel.setText(String.valueOf(M2GUI.m12OpcuaClient.heartbeat));
                        M2GUI.this.textFieldTime.setText("Last:" + M2GUI.m12OpcuaClient.isoStamp);
                    }
                }
                catch (Exception e) {
                    System.out.println("M2 ShowDataThread Exception: " + e.getMessage());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                break;
            }
        }
    };
    private JTextField motorTextField;
    private JTextField textFieldTime;

    static {
        showMirrorCircleFlag = false;
        showMotorCircleFlag = false;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.getProperties();
                    AIV_GUI.consolle.setVisible(true);
                    M2GUI window = new M2GUI(null);
                    window.setVisible(true);
                    window.exitMenuItem.setEnabled(true);
                    window.hideMenuItem.setEnabled(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void outputInfo(String msg) {
        this.outputInfoLabel.setText(msg);
        System.out.println(msg);
    }

    public void outputInfo(String msg, String level) {
        block16: {
            this.outputInfoLabel.setText(msg);
            System.out.println(msg);
            if (level == null) break block16;
            switch (level) {
                case "warn": {
                    logger.warn((Object)msg);
                    break;
                }
                case "err": {
                    logger.error((Object)msg);
                    break;
                }
                case "debug": {
                    logger.debug((Object)msg);
                    break;
                }
                case "fatal": {
                    logger.fatal((Object)msg);
                    break;
                }
                default: {
                    logger.info((Object)msg);
                }
            }
        }
    }

    public M2GUI(M12OpcuaClient opcuaClient) throws Exception {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setFont(new Font("Segoe UI", 1, 12));
        menuBar.add(fileMenu);
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("M1GUI");
        mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        mntmNewMenuItem_1.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(mntmNewMenuItem_1);
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.hideMenuItem.setFont(new Font("Dialog", 1, 12));
        this.hideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2GUI.this.setVisible(false);
            }
        });
        JMenuItem mntmReconnect = new JMenuItem("Reconnect");
        mntmReconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m12OpcuaClient.stopClient();
                Utils.getProperties();
                m12OpcuaClient = new M12OpcuaClient();
                m12OpcuaClient.startClient(Utils.amcURLs[Utils.telescopeNumber - 1]);
            }
        });
        JMenuItem mntmNewMenuItem = new JMenuItem("StateMachine");
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2GUI.this.m12StateMachine.setVisible(true);
            }
        });
        mntmNewMenuItem.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(mntmNewMenuItem);
        mntmReconnect.setFont(new Font("Segoe UI", 1, 12));
        fileMenu.add(mntmReconnect);
        fileMenu.add(this.hideMenuItem);
        this.exitMenuItem.setEnabled(false);
        this.exitMenuItem.setFont(new Font("Dialog", 1, 12));
        fileMenu.add(this.exitMenuItem);
        JMenu amcMenu = new JMenu("AMC.Cmds");
        amcMenu.setFont(new Font("Segoe UI", 1, 12));
        menuBar.add(amcMenu);
        JMenuItem resetSystemMenuItem = new JMenuItem("ResetSystem");
        resetSystemMenuItem.setFont(new Font("Segoe UI", 1, 12));
        resetSystemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2GUI.this.sendCommand(null, "ns=4;s=CMD_AMC.RESET_SYSTEM", true);
            }
        });
        amcMenu.add(resetSystemMenuItem);
        JMenuItem resetAlarmMenuItem = new JMenuItem("ResetAlarm");
        resetAlarmMenuItem.setFont(new Font("Segoe UI", 1, 12));
        resetAlarmMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2GUI.this.sendCommand(null, "ns=4;s=CMD_AMC.RESET_ALARMS", true);
            }
        });
        amcMenu.add(resetAlarmMenuItem);
        JMenuItem loadParamsMenuItem = new JMenuItem("LoadParams");
        loadParamsMenuItem.setFont(new Font("Segoe UI", 1, 12));
        loadParamsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2GUI.this.sendCommand(null, "ns=4;s=CMD_AMC.LOAD_CONF_PAR", true);
            }
        });
        amcMenu.add(loadParamsMenuItem);
        JMenuItem saveParamaMenuItem = new JMenuItem("SaveParamts");
        saveParamaMenuItem.setFont(new Font("Segoe UI", 1, 12));
        saveParamaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                M2GUI.this.sendCommand(null, "ns=4;s=CMD_AMC.SAVE_CONF_PAR", true);
            }
        });
        amcMenu.add(saveParamaMenuItem);
        this.textFieldTime = new JTextField("---");
        this.textFieldTime.setToolTipText("Update at: ");
        this.textFieldTime.setHorizontalAlignment(0);
        this.textFieldTime.setFont(new Font("Tahoma", 1, 10));
        this.textFieldTime.setColumns(10);
        this.textFieldTime.setBackground(new Color(255, 255, 230));
        this.textFieldTime.setAutoscrolls(false);
        menuBar.add(this.textFieldTime);
        this.heartbeatLabel.setToolTipText("heartBeat");
        this.heartbeatLabel.setSize(new Dimension(15, 6));
        this.heartbeatLabel.setPreferredSize(new Dimension(48, 8));
        this.heartbeatLabel.setHorizontalTextPosition(0);
        this.heartbeatLabel.setHorizontalAlignment(0);
        this.heartbeatLabel.setForeground(new Color(0, 0, 205));
        this.heartbeatLabel.setFont(new Font("Tahoma", 0, 11));
        this.heartbeatLabel.setAlignmentX(1.0f);
        menuBar.add(this.heartbeatLabel);
        Utils.getProperties();
        m12OpcuaClient = new M12OpcuaClient();
        if (opcuaClient != null) {
            m12OpcuaClient = opcuaClient;
        } else {
            m12OpcuaClient.startClient(Utils.amcURLs[Utils.telescopeNumber - 1]);
        }
        this.m12StateMachine = new M12StateMachine("", m12OpcuaClient, 2);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.setResizable(false);
        this.setResizable(false);
        this.showMotorReferenceThread.start();
        this.showMirrorReferenceThread.start();
        this.ShowDataThread.start();
        this.setBounds(100, 100, 379, 730);
        this.getContentPane().setLayout(null);
        this.setTitle("M2GUI - PBr-0.5-0222");
        this.ImageMirrorLabel.setCursor(Cursor.getPredefinedCursor(1));
        this.ImageMirrorLabel.setBorder(new LineBorder(Color.BLUE, 2));
        this.ImageMirrorLabel.setToolTipText("M2 schema");
        this.ImageMirrorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point x = M2GUI.this.ImageMirrorLabel.getMousePosition();
                try {
                    if (x.x > Utils.mirror2Center[0] - 200 & x.x < Utils.mirror2Center[0] + 200 & (x.y > Utils.mirror2Center[1] - 200 & x.y < Utils.mirror2Center[1] + 200)) {
                        M2GUI.this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m2a.jpg"));
                        selectedLabel.setBackground(Color.blue);
                        selectedLabel.setForeground(Color.yellow);
                        selectedLabel.setText("M2");
                        Utils.setEnablePanel(M2GUI.this.motorPanel, false, null);
                        Utils.setEnablePanel(M2GUI.this.mirrorPanel, true, null);
                    }
                    int ix = 0;
                    while (ix < Utils.motor2Center.length) {
                        if (x.x > Utils.motor2Center[ix][0] - 50 & x.x < Utils.motor2Center[ix][0] + 50 & (x.y > Utils.motor2Center[ix][1] - 50 & x.y < Utils.motor2Center[ix][1] + 50)) {
                            M2GUI.this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m2a.jpg"));
                            selectedLabel.setBackground(Color.blue);
                            selectedLabel.setForeground(Color.white);
                            selectedLabel.setText("Motor_" + (ix + 1));
                            M2GUI.this.motorIndex = ix + 1;
                            showMotorCircleFlag = true;
                            Utils.setEnablePanel(M2GUI.this.motorPanel, true, "Motor_" + M2GUI.this.motorIndex);
                            Utils.setEnablePanel(M2GUI.this.mirrorPanel, false, null);
                            M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M2_MOTOR.INDEX"), (Object)((short)M2GUI.this.mirrorIndex));
                            break;
                        }
                        ++ix;
                    }
                }
                catch (ServiceException | StatusException | NullPointerException e1) {
                    System.out.println("errore loop ");
                }
            }
        });
        this.ImageMirrorLabel.setForeground(Color.YELLOW);
        this.ImageMirrorLabel.setBackground(Color.GRAY);
        this.ImageMirrorLabel.setBounds(8, 5, 350, 332);
        this.ImageMirrorLabel.setIcon(new ImageIcon("./conf/m2a.jpg"));
        this.ImageMirrorLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point x = M2GUI.this.ImageMirrorLabel.getMousePosition();
            }
        });
        this.getContentPane().add(this.ImageMirrorLabel);
        this.implementsM2Controls();
        Utils.setEnablePanel(this.mirrorPanel, false, null);
        Utils.setEnablePanel(this.motorPanel, false, "Motor_??");
    }

    private void implementsM2Controls() {
        selectedLabel.setOpaque(true);
        selectedLabel.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
        selectedLabel.setBounds(new Rectangle(0, 0, 1, 1));
        selectedLabel.setForeground(Color.YELLOW);
        selectedLabel.setHorizontalAlignment(0);
        selectedLabel.setBackground(Color.BLUE);
        selectedLabel.setFont(new Font("SansSerif", 1, 14));
        selectedLabel.setBounds(292, 502, 61, 27);
        this.getContentPane().add(selectedLabel);
        this.mirrorPanel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "M2", 4, 2, null, new Color(0, 0, 0)));
        this.mirrorPanel.setBackground(new Color(255, 204, 153));
        this.mirrorPanel.setBounds(10, 340, 272, 167);
        this.getContentPane().add(this.mirrorPanel);
        this.mirrorPanel.setLayout(null);
        this.pistonLabel.setBounds(10, 22, 115, 17);
        this.pistonLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.pistonLabel.setFont(new Font("Tahoma", 1, 12));
        this.mirrorPanel.add(this.pistonLabel);
        this.pistonTextField = new JTextField();
        this.pistonTextField.setBounds(133, 20, 75, 21);
        this.pistonTextField.setHorizontalAlignment(0);
        this.pistonTextField.setText("0.0");
        this.pistonTextField.setFont(new Font("Tahoma", 1, 12));
        this.pistonTextField.setBackground(new Color(255, 255, 204));
        this.mirrorPanel.add(this.pistonTextField);
        this.pistonTextField.setColumns(10);
        final JButton pistonButton = new JButton("GoRel");
        pistonButton.setBounds(212, 11, 44, 19);
        pistonButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!pistonButton.isEnabled()) {
                        return;
                    }
                    M2GUI.this.outputInfo("--> Start OffSet relative....ns=4;s=CMD_M2.OFFSET_MIRROR");
                    double offsetRel = Float.parseFloat(M2GUI.this.pistonTextField.getText());
                    M2GUI.m12OpcuaClient.client.writeValue(new NodeId(4, "SET_M2_MIRROR.CENTER_OFFSET"), (Object)offsetRel);
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M2.OFFSET_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    M2GUI.this.outputInfo("GoRelerror:" + e1.getMessage());
                }
            }
        });
        pistonButton.setBorder(new BevelBorder(0, null, null, null, null));
        pistonButton.setFont(new Font("Tahoma", 1, 11));
        this.mirrorPanel.add(pistonButton);
        this.tilt_XLabel.setBounds(10, 53, 115, 22);
        this.tilt_XLabel.setFont(new Font("Tahoma", 1, 12));
        this.tilt_XLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.mirrorPanel.add(this.tilt_XLabel);
        this.tilt_XTextField = new JTextField();
        this.tilt_XTextField.setBounds(133, 53, 75, 21);
        this.tilt_XTextField.setText("0.0");
        this.tilt_XTextField.setHorizontalAlignment(0);
        this.tilt_XTextField.setFont(new Font("Tahoma", 1, 12));
        this.tilt_XTextField.setColumns(10);
        this.tilt_XTextField.setBackground(new Color(255, 255, 204));
        this.mirrorPanel.add(this.tilt_XTextField);
        this.tilt_XButton.setBounds(212, 53, 44, 22);
        this.tilt_XButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!M2GUI.this.tilt_XButton.isEnabled()) {
                        return;
                    }
                    M2GUI.this.outputInfo("--> Command: ns=4;s=CMD_M2.TILTX_MIRROR");
                    double tiltY = Float.parseFloat(M2GUI.this.tilt_YTextField.getText());
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M2_MIRROR.TILT_Y"), (Object)tiltY);
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M2.TILTX_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    M2GUI.this.outputInfo("Tilt_X error:" + e1.getMessage());
                }
            }
        });
        this.tilt_XButton.setFont(new Font("Tahoma", 1, 11));
        this.tilt_XButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.mirrorPanel.add(this.tilt_XButton);
        this.tilt_YLabel.setBounds(10, 79, 115, 21);
        this.tilt_YLabel.setFont(new Font("Tahoma", 1, 12));
        this.tilt_YLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.mirrorPanel.add(this.tilt_YLabel);
        this.tilt_YTextField = new JTextField();
        this.tilt_YTextField.setBounds(133, 79, 75, 21);
        this.tilt_YTextField.setText("0.0");
        this.tilt_YTextField.setHorizontalAlignment(0);
        this.tilt_YTextField.setFont(new Font("Tahoma", 1, 12));
        this.tilt_YTextField.setColumns(10);
        this.tilt_YTextField.setBackground(new Color(255, 255, 204));
        this.mirrorPanel.add(this.tilt_YTextField);
        this.tilt_YButton.setBounds(212, 79, 44, 21);
        this.tilt_YButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!M2GUI.this.tilt_YButton.isEnabled()) {
                        return;
                    }
                    M2GUI.this.outputInfo("--> Command: ns=4;s=CMD_M2.TILTY_MIRROR");
                    double tiltX = Float.parseFloat(M2GUI.this.tilt_XTextField.getText());
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M2_MIRROR.TILT_X"), (Object)tiltX);
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M2.TILTY_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    M2GUI.this.outputInfo("Tilt_Y error:" + e1.getMessage());
                }
            }
        });
        this.tilt_YButton.setFont(new Font("Tahoma", 1, 11));
        this.tilt_YButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.mirrorPanel.add(this.tilt_YButton);
        final JButton btnHomingMirror = new JButton("GoHome");
        btnHomingMirror.setBounds(10, 136, 67, 22);
        btnHomingMirror.setBorder(new BevelBorder(0, null, null, null, null));
        btnHomingMirror.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(btnHomingMirror, "ns=4;s=CMD_M2.START_HOMING", true);
            }
        });
        btnHomingMirror.setToolTipText("M2_Homing");
        btnHomingMirror.setForeground(Color.BLUE);
        btnHomingMirror.setFont(new Font("Tahoma", 1, 10));
        btnHomingMirror.setBackground(new Color(255, 255, 153));
        this.mirrorPanel.add(btnHomingMirror);
        final JButton btnGoAbs = new JButton("GoAbs");
        btnGoAbs.setBounds(212, 31, 44, 19);
        btnGoAbs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!btnGoAbs.isEnabled()) {
                        return;
                    }
                    M2GUI.this.outputInfo("--> Start OffSet absolute....ns=4;s=CMD_M2.MOVE_MIRROR");
                    double offsetAbf = Float.parseFloat(M2GUI.this.pistonTextField.getText());
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=SET_M2_MIRROR.CENTER_POS"), (Object)offsetAbf);
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M2.MOVE_MIRROR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    M2GUI.this.outputInfo("GoAbs error:" + e1.getMessage());
                }
            }
        });
        btnGoAbs.setFont(new Font("Tahoma", 1, 11));
        btnGoAbs.setBorder(new BevelBorder(0, null, null, null, null));
        this.mirrorPanel.add(btnGoAbs);
        final JButton stopMirrorButton = new JButton("Stop");
        stopMirrorButton.setBounds(212, 104, 44, 19);
        stopMirrorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(stopMirrorButton, "ns=4;s=CMD_M2.STOP_MIRROR", true);
            }
        });
        stopMirrorButton.setForeground(new Color(255, 0, 0));
        stopMirrorButton.setToolTipText("Stop_Move");
        stopMirrorButton.setFont(new Font("Tahoma", 1, 11));
        stopMirrorButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.mirrorPanel.add(stopMirrorButton);
        final JButton stopHomingButton = new JButton("Stop");
        stopHomingButton.setBounds(80, 134, 40, 22);
        stopHomingButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(stopHomingButton, "ns=4;s=CMD_M2.STOP_HOMING", true);
            }
        });
        stopHomingButton.setToolTipText("Stop_Homing");
        stopHomingButton.setForeground(Color.RED);
        stopHomingButton.setFont(new Font("Tahoma", 1, 11));
        stopHomingButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.mirrorPanel.add(stopHomingButton);
        final JButton btnEnableMirror = new JButton("Enable");
        btnEnableMirror.setBounds(143, 134, 67, 22);
        btnEnableMirror.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(btnEnableMirror, "ns=4;s=CMD_M2.ENABLE_MIRROR", true);
            }
        });
        btnEnableMirror.setToolTipText("Enable_Mirror");
        btnEnableMirror.setForeground(Color.BLUE);
        btnEnableMirror.setFont(new Font("Tahoma", 1, 10));
        btnEnableMirror.setBorder(new BevelBorder(0, null, null, null, null));
        btnEnableMirror.setBackground(new Color(255, 255, 153));
        this.mirrorPanel.add(btnEnableMirror);
        final JButton btnDisableMirror = new JButton("Disable");
        btnDisableMirror.setBounds(215, 134, 41, 22);
        btnDisableMirror.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(btnDisableMirror, "ns=4;s=CMD_M2.DISABLE_MIRROR", true);
            }
        });
        btnDisableMirror.setToolTipText("Disable_Mirror");
        btnDisableMirror.setForeground(Color.RED);
        btnDisableMirror.setFont(new Font("Tahoma", 1, 10));
        btnDisableMirror.setBorder(new BevelBorder(0, null, null, null, null));
        btnDisableMirror.setBackground(new Color(255, 255, 153));
        this.mirrorPanel.add(btnDisableMirror);
        this.motorPanel.setBackground(new Color(153, 204, 204));
        this.motorPanel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "Motor_", 1, 2, null, new Color(0, 0, 0)));
        this.motorPanel.setBounds(8, 522, 274, 102);
        this.getContentPane().add(this.motorPanel);
        this.motorPanel.setLayout(null);
        this.pistonMotorLabel.setFont(new Font("Tahoma", 1, 12));
        this.pistonMotorLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.pistonMotorLabel.setBounds(10, 19, 115, 23);
        this.motorPanel.add(this.pistonMotorLabel);
        this.motorTextField = new JTextField();
        this.motorTextField.setText("0.0");
        this.motorTextField.setHorizontalAlignment(0);
        this.motorTextField.setFont(new Font("Tahoma", 1, 12));
        this.motorTextField.setColumns(10);
        this.motorTextField.setBackground(new Color(255, 255, 204));
        this.motorTextField.setBounds(135, 20, 75, 22);
        this.motorPanel.add(this.motorTextField);
        final JButton motorRelButton = new JButton("GoRel");
        motorRelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!motorRelButton.isEnabled()) {
                        return;
                    }
                    M2GUI.this.outputInfo("--> Start OffSet relative....ns=4;s=CMD_M2.OFFSET_MOTOR");
                    double offsetRel = Float.parseFloat(M2GUI.this.motorTextField.getText());
                    M2GUI.m12OpcuaClient.client.writeValue(new NodeId(4, "SET_M2_MOTOR.OFFSET"), (Object)offsetRel);
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M2.OFFSET_MOTOR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    M2GUI.this.outputInfo("Error on ns=4;s=CMD_M2.OFFSET_MIRROR: " + e1.getMessage());
                }
            }
        });
        motorRelButton.setFont(new Font("Tahoma", 1, 11));
        motorRelButton.setBorder(new BevelBorder(0, null, null, null, null));
        motorRelButton.setBounds(214, 11, 53, 20);
        this.motorPanel.add(motorRelButton);
        final JButton motorAbsButton = new JButton("GoAbs");
        motorAbsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (!motorAbsButton.isEnabled()) {
                        return;
                    }
                    M2GUI.this.outputInfo("--> Start Absolute...ns=4;s=CMD_M2.MOVE_MOTOR");
                    double offsetRel = Float.parseFloat(M2GUI.this.motorTextField.getText());
                    M2GUI.m12OpcuaClient.client.writeValue(new NodeId(4, "SET_M2_MOTOR.POS"), (Object)offsetRel);
                    M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId("ns=4;s=CMD_M2.MOVE_MOTOR"), (Object)true);
                }
                catch (ServiceException | StatusException e1) {
                    M2GUI.this.outputInfo("Error on ns=4;s=CMD_M2.MOVE_MOTOR: " + e1.getMessage());
                }
            }
        });
        motorAbsButton.setFont(new Font("Tahoma", 1, 11));
        motorAbsButton.setBorder(new BevelBorder(0, null, null, null, null));
        motorAbsButton.setBounds(214, 30, 53, 20);
        this.motorPanel.add(motorAbsButton);
        final JButton stopMotorButton = new JButton("Stop");
        stopMotorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(stopMotorButton, "ns=4;s=CMD_M2.STOP_MOTOR", true);
            }
        });
        stopMotorButton.setToolTipText("Stop_Move");
        stopMotorButton.setForeground(Color.RED);
        stopMotorButton.setFont(new Font("Tahoma", 1, 11));
        stopMotorButton.setBorder(new BevelBorder(0, null, null, null, null));
        stopMotorButton.setBounds(214, 52, 53, 22);
        this.motorPanel.add(stopMotorButton);
        final JButton btnEnableMotor = new JButton("Enable");
        btnEnableMotor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(btnEnableMotor, "ns=4;s=CMD_M2.ENABLE_MOTOR", true);
            }
        });
        btnEnableMotor.setToolTipText("Enable_Motor");
        btnEnableMotor.setForeground(Color.BLUE);
        btnEnableMotor.setFont(new Font("Tahoma", 1, 10));
        btnEnableMotor.setBorder(new BevelBorder(0, null, null, null, null));
        btnEnableMotor.setBackground(new Color(255, 255, 153));
        btnEnableMotor.setBounds(10, 64, 73, 23);
        this.motorPanel.add(btnEnableMotor);
        final JButton btnDisableMotors = new JButton("Disable");
        btnDisableMotors.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(btnDisableMotors, "ns=4;s=CMD_M2.DISABLE_MOTOR", true);
            }
        });
        btnDisableMotors.setToolTipText("Disable_Motor");
        btnDisableMotors.setForeground(Color.RED);
        btnDisableMotors.setFont(new Font("Tahoma", 1, 10));
        btnDisableMotors.setBorder(new BevelBorder(0, null, null, null, null));
        btnDisableMotors.setBackground(new Color(255, 255, 153));
        btnDisableMotors.setBounds(88, 64, 81, 23);
        this.motorPanel.add(btnDisableMotors);
        this.outputInfoLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.outputInfoLabel.setToolTipText("infoLabel");
        this.outputInfoLabel.setHorizontalAlignment(0);
        this.outputInfoLabel.setForeground(Color.BLACK);
        this.outputInfoLabel.setFont(new Font("Tahoma", 1, 11));
        this.outputInfoLabel.setBackground(new Color(255, 248, 220));
        this.outputInfoLabel.setBounds(8, 635, 350, 27);
        this.getContentPane().add(this.outputInfoLabel);
        final CreateRoundButton stopButton = new CreateRoundButton("STOP");
        stopButton.setBounds(292, 548, 66, 59);
        this.getContentPane().add(stopButton);
        stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M2GUI.this.sendCommand(stopButton, "ns=4;s=CMD_AMC.EMERGENCY_STOP", true);
            }
        });
        stopButton.setToolTipText("emergency stop");
        stopButton.setForeground(new Color(255, 255, 0));
        stopButton.setFont(new Font("Tahoma", 1, 15));
        stopButton.setBorder(new BevelBorder(1, null, null, null, null));
        stopButton.setBackground(Color.RED);
        stopButton.setAlignmentX(0.5f);
    }

    public void drawMotorCircleOnImage(int mtrIndex) {
        Graphics2D g2 = (Graphics2D)this.ImageMirrorLabel.getGraphics();
        int Xc = Utils.motor2Center[mtrIndex][0];
        int Yc = Utils.motor2Center[mtrIndex][1];
        g2.setStroke(new BasicStroke(2.0f));
        if (Xc >= 0 & Yc >= 0) {
            g2.setColor(Color.white);
            g2.draw(new Ellipse2D.Double(Xc - 12, Yc - 12, 24.0, 24.0));
        }
    }

    public void drawMirrorCircleOnImage() {
        GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, Color.RED, 500.0f, 0.0f, Color.WHITE);
        Graphics2D g2 = (Graphics2D)this.ImageMirrorLabel.getGraphics();
        int Xc = Utils.mirror2Center[0];
        int Yc = Utils.mirror2Center[1];
        g2.setStroke(new BasicStroke(2.0f));
        if (Xc >= 0 & Yc >= 0) {
            g2.setColor(Color.yellow);
            g2.draw(new Ellipse2D.Double(Xc - 45, Yc - 45, 90.0, 90.0));
        }
    }

    public void sendCommand(JButton btn, String nodeName, boolean value) {
        try {
            if (btn != null && !btn.isEnabled()) {
                return;
            }
            this.outputInfo("--> Command: " + nodeName);
            M2GUI.m12OpcuaClient.client.writeValue(m12OpcuaClient.getNodeId(nodeName), (Object)value);
        }
        catch (ServiceException | StatusException e1) {
            this.outputInfo("Error on " + nodeName + e1.getMessage());
        }
    }
}

