/*
 * Decompiled with CFR 0.152.
 */
package m12.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.border.LineBorder;
import m12.client.M12OpcuaClient;
import myproc.Utils;

public class M12StateMachine
extends JFrame {
    private JButton hideButton = new JButton("Hide");
    private M12OpcuaClient m12OpcuaClient;
    private int mirrorNo;
    JButton loadedButton = new JButton("Loaded");
    JButton standByButton = new JButton("StandBy");
    JButton onlineButton = new JButton("Online");
    JButton faultButton = new JButton("Fault");
    JButton maintenanceButton = new JButton("Maintenance");
    public String mirrorCode = "M1";
    public boolean startShowDataThread = true;
    private Thread ShowDataThread = new Thread(){
        short state = 0;

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (!M12StateMachine.this.startShowDataThread & M12StateMachine.this.m12OpcuaClient.client == null) {
                        Thread.sleep(300L);
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.state = M12StateMachine.this.mirrorNo == 1 ? M12OpcuaClient.m1_state : M12OpcuaClient.m2_state;
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(M12StateMachine.this.mirrorCode) + " ShowDataThread Exception: " + e.getMessage());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.state = (short)ThreadLocalRandom.current().nextInt(0, 10);
                M12StateMachine.this.setButtonDefault();
                switch (this.state) {
                    case 1: {
                        M12StateMachine.this.loadedButton.setBackground(Color.green);
                        break;
                    }
                    case 2: {
                        M12StateMachine.this.standByButton.setBackground(Color.green);
                        break;
                    }
                    case 3: {
                        M12StateMachine.this.onlineButton.setBackground(Color.green);
                        break;
                    }
                    case 4: {
                        M12StateMachine.this.maintenanceButton.setBackground(Color.yellow);
                        break;
                    }
                    case 5: {
                        M12StateMachine.this.faultButton.setBackground(Color.RED);
                        break;
                    }
                }
            }
        }
    };

    public M12StateMachine(String title, M12OpcuaClient m12OpcuaClient, int mirrorNo) {
        this.m12OpcuaClient = m12OpcuaClient;
        this.mirrorNo = mirrorNo;
        this.mirrorCode = "M1";
        if (mirrorNo == 2) {
            this.mirrorCode = "M2";
        }
        super.setIconImage(Utils.tazImage.getImage());
        super.setTitle(String.valueOf(this.mirrorCode) + "_State_Machine");
        super.setResizable(false);
        this.ShowDataThread.start();
        this.setSize(702, 576);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.hideButton.setBorderPainted(false);
        this.hideButton.setAlignmentX(0.5f);
        this.hideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M12StateMachine.this.setVisible(false);
            }
        });
        this.hideButton.setForeground(Color.BLUE);
        this.hideButton.setFont(new Font("Tahoma", 1, 10));
        this.hideButton.setBackground(Color.YELLOW);
        menuBar.add(this.hideButton);
        this.getContentPane().setLayout(null);
        final JLabel imageLabel = new JLabel("");
        imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point x = imageLabel.getMousePosition();
                System.out.print("{" + x.x + ", " + x.y + "}, \n");
            }
        });
        imageLabel.setIcon(new ImageIcon("./conf/M12StateMachine.jpg"));
        imageLabel.setBounds(0, 0, 687, 511);
        this.getContentPane().add(imageLabel);
        this.loadedButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M12StateMachine.this.sendCommand(M12StateMachine.this.standByButton, "ns=4;s=CMD_MODE." + M12StateMachine.this.mirrorCode + "_GO_LOADED", true);
            }
        });
        this.loadedButton.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.loadedButton.setForeground(new Color(0, 0, 139));
        this.loadedButton.setFont(new Font("Tahoma", 1, 15));
        this.loadedButton.setBounds(132, 58, 146, 63);
        imageLabel.add(this.loadedButton);
        this.standByButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M12StateMachine.this.sendCommand(M12StateMachine.this.standByButton, "ns=4;s=CMD_MODE." + M12StateMachine.this.mirrorCode + "_GO_STANDBY", true);
            }
        });
        this.standByButton.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.standByButton.setFont(new Font("Tahoma", 1, 15));
        this.standByButton.setBounds(132, 179, 146, 63);
        imageLabel.add(this.standByButton);
        this.onlineButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M12StateMachine.this.sendCommand(M12StateMachine.this.standByButton, "ns=4;s=CMD_MODE." + M12StateMachine.this.mirrorCode + "_GO_ONLINE", true);
            }
        });
        this.onlineButton.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.onlineButton.setFont(new Font("Tahoma", 1, 15));
        this.onlineButton.setBounds(132, 361, 146, 63);
        imageLabel.add(this.onlineButton);
        this.faultButton.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.faultButton.setFont(new Font("Tahoma", 1, 15));
        this.faultButton.setBounds(391, 177, 146, 63);
        imageLabel.add(this.faultButton);
        this.maintenanceButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                M12StateMachine.this.sendCommand(M12StateMachine.this.standByButton, "ns=4;s=CMD_MODE." + M12StateMachine.this.mirrorCode + "_GO_MAINTENANCE", true);
            }
        });
        this.maintenanceButton.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.maintenanceButton.setFont(new Font("Tahoma", 1, 15));
        this.maintenanceButton.setBounds(391, 361, 146, 63);
        imageLabel.add(this.maintenanceButton);
        JLabel lblNewLabel = new JLabel(this.mirrorCode);
        imageLabel.add(lblNewLabel);
        lblNewLabel.setFont(new Font("Tahoma", 1, 30));
        lblNewLabel.setForeground(new Color(0, 0, 139));
        lblNewLabel.setBackground(new Color(255, 222, 173));
        lblNewLabel.setBounds(553, 29, 57, 49);
        this.setVisible(false);
    }

    public static void main(String[] args) {
        M12StateMachine demo = new M12StateMachine("M12_StateMachine", null, 2);
        demo.setVisible(true);
    }

    public void setButtonDefault() {
        this.loadedButton.setForeground(new Color(0, 0, 139));
        this.standByButton.setForeground(new Color(0, 0, 139));
        this.onlineButton.setForeground(new Color(0, 0, 139));
        this.faultButton.setForeground(new Color(0, 0, 139));
        this.maintenanceButton.setForeground(new Color(0, 0, 139));
        this.loadedButton.setBackground(new Color(240, 240, 240));
        this.standByButton.setBackground(new Color(240, 240, 240));
        this.onlineButton.setBackground(new Color(240, 240, 240));
        this.faultButton.setBackground(new Color(240, 240, 240));
        this.maintenanceButton.setBackground(new Color(240, 240, 240));
    }

    public void sendCommand(JButton btn, String nodeName, boolean value) {
        try {
            if (!btn.isEnabled()) {
                return;
            }
            System.out.println("--> Command: " + nodeName);
            this.m12OpcuaClient.client.writeValue(this.m12OpcuaClient.getNodeId(nodeName), (Object)value);
        }
        catch (ServiceException | StatusException e1) {
            System.out.println("Error on " + nodeName + e1.getMessage());
        }
    }
}

