/*
 * Decompiled with CFR 0.152.
 */
package m12.client;

import client.DataPoint;
import client.OpcuaUtils;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;
import gui.DataInputForm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.text.BadLocationException;
import m12.client.M12ICD;
import m12.client.MirrorGui;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.tcp.io.TcpConnection;

public class M12OpcuaClient {
    public UaClient client;
    M12ICD m12ICD = new M12ICD();
    private Subscription subscription;
    private String devAcronym = "M12>";
    private List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    public NodeId nodeId;
    OpcuaUtils opcuaUtils = new OpcuaUtils();
    public DataInputForm dataInputForm = new DataInputForm("OC");
    private int telescopeIndex = -1;
    String isoStamp = "";
    public int heartbeat = 0;
    public static short m1_status;
    public static short m2_status;
    public static short m1_state;
    public static short m2_state;
    public static short m1_state_phase;
    public static short m2_state_phase;
    public static boolean m1_home_status;
    public static boolean m2_home_status;
    public static double m1_mirror_center_pos;
    public static double m1_mirror_tilt_x;
    public static double m1_mirror_tilt_y;
    public static double m2_mirror_center_pos;
    public static double m2_mirror_tilt_x;
    public static double m2_mirror_tilt_y;
    public static double m1_mirror_axis1_pos;
    public static double m1_mirror_axis2_pos;
    public static double m1_mirror_axis3_pos;
    public static double m2_mirror_axis1_pos;
    public static double m2_mirror_axis2_pos;
    public static double m2_mirror_axis3_pos;
    public static double m1_mirror_axis1_maxpos;
    public static double m1_mirror_axis2_maxpos;
    public static double m1_mirror_axis3_maxpos;
    public static double m1_mirror_axis1_minpos;
    public static double m1_mirror_axis2_minpos;
    public static double m1_mirror_axis3_minpos;
    public static double m2_mirror_axis1_maxpos;
    public static double m2_mirror_axis2_maxpos;
    public static double m2_mirror_axis3_maxpos;
    public static double m2_mirror_axis1_minpos;
    public static double m2_mirror_axis2_minpos;
    public static double m2_mirror_axis3_minpos;
    public static double m1_motor_pos;
    public static double m2_motor_pos;
    public static double m1_motor_vel;
    public static double m1_motor_current;
    public static double m2_motor_vel;
    public static double m2_motor_current;
    public static short m1_motor_status;
    public static short m1_motor_upper_switch_status;
    public static short m1_motor_lower_switch_status;
    public static short m2_motor_status;
    short m1_error_number;
    short m2_error_number;
    String m1_error_description;
    String m2_error_description;
    short m1_error_recovered_number;
    short m2_error_recovered_number;
    String m1_error_recovered_description;
    String m2_error_recovered_description;
    short m1_mirror_status;
    private MonitoredDataItemListener dataChangeListener = new MonitoredDataItemListener(){

        public void onDataChange(MonitoredDataItem sender, DataValue prevValue, DataValue val) {
            block136: {
                String name = sender.getNodeId().getValue().toString();
                if (!val.getStatusCode().isNotBad()) break block136;
                switch (name) {
                    case "AMC_UTILITIES.HEARTBEAT": {
                        M12OpcuaClient.this.heartbeat = val.getValue().toNumber().intValue();
                        break;
                    }
                    case "AMC_INFO.M1_ERROR_NUMBER": {
                        M12OpcuaClient.this.m1_error_number = val.getValue().toNumber().shortValue();
                        break;
                    }
                    case "AMC_UTILITIES.UTC_TIME": {
                        M12OpcuaClient.this.isoStamp = val.getValue().getValue().toString();
                        if (!MirrorGui.getTelemetryEnableCheckBox.isSelected()) break;
                        M12OpcuaClient.this.writeOnTextInfo();
                        break;
                    }
                    case "AMC_INFO.M1_STATUS": {
                        m1_status = val.getValue().shortValue();
                        break;
                    }
                    case "AMC_INFO.M1_HOME_STATUS": {
                        m1_home_status = val.getValue().booleanValue();
                        break;
                    }
                    case "AMC_INFO.M2_STATUS": {
                        m2_status = val.getValue().shortValue();
                        break;
                    }
                    case "AMC_INFO.M1_STATE": {
                        m1_state = val.getValue().shortValue();
                        break;
                    }
                    case "AMC_INFO.M2_STATE": {
                        m2_state = val.getValue().shortValue();
                        break;
                    }
                    case "AMC_INFO.M2_HOME_STATUS": {
                        m2_home_status = val.getValue().booleanValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.CENTER_POS": {
                        m1_mirror_center_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.TILT_X": {
                        m1_mirror_tilt_x = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.TILT_Y": {
                        m1_mirror_tilt_y = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.CENTER_POS": {
                        m2_mirror_center_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.TILT_X": {
                        m2_mirror_tilt_x = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.TILT_Y": {
                        m2_mirror_tilt_y = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS1_POS": {
                        m1_mirror_axis1_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS2_POS": {
                        m1_mirror_axis2_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS3_POS": {
                        m1_mirror_axis3_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS1_POS": {
                        m2_mirror_axis1_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS2_POS": {
                        m2_mirror_axis2_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS3_POS": {
                        m2_mirror_axis3_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MOTOR_INFO.POS": {
                        m1_motor_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MOTOR_INFO.POS": {
                        m2_motor_pos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MOTOR_INFO.VEL": {
                        m2_motor_vel = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MOTOR_INFO.VEL": {
                        m2_motor_vel = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MOTOR_INFO.CURRENT": {
                        m2_motor_current = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MOTOR_INFO.CURRENT": {
                        m2_motor_current = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.STATUS": {
                        m1_motor_status = val.getValue().shortValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.STATUS": {
                        m2_motor_status = val.getValue().shortValue();
                        break;
                    }
                    case "M1_MOTOR_INFO.UPPER_SWITCH_STATUS": {
                        m1_motor_upper_switch_status = val.getValue().shortValue();
                        break;
                    }
                    case "M1_MOTOR_INFO.LOWER_SWITCH_STATUS": {
                        m1_motor_lower_switch_status = val.getValue().shortValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS1_MAXPOS": {
                        m1_mirror_axis1_maxpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS2_MAXPOS": {
                        m1_mirror_axis2_maxpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS3_MAXPOS": {
                        m1_mirror_axis3_maxpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS1_MINPOS": {
                        m1_mirror_axis1_minpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS2_MINPOS": {
                        m1_mirror_axis2_minpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M1_MIRROR_INFO.AXIS3_MINPOS": {
                        m1_mirror_axis3_minpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS1_MAXPOS": {
                        m2_mirror_axis1_maxpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS2_MAXPOS": {
                        m2_mirror_axis2_maxpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS3_MAXPOS": {
                        m2_mirror_axis3_maxpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS1_MINPOS": {
                        m2_mirror_axis1_minpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS2_MINPOS": {
                        m2_mirror_axis2_minpos = val.getValue().doubleValue();
                        break;
                    }
                    case "M2_MIRROR_INFO.AXIS3_MINPOS": {
                        m2_mirror_axis3_minpos = val.getValue().doubleValue();
                        break;
                    }
                    case "amc_isotstamp": {
                        if (!MirrorGui.getTelemetryEnableCheckBox.isSelected()) break;
                        M12OpcuaClient.this.writeOnTextInfo();
                        break;
                    }
                }
            }
        }
    };
    private SubscriptionAliveListener subscriptionAliveListener = new SubscriptionAliveListener(){

        public void onAlive(Subscription s) {
            System.out.println(String.valueOf(M12OpcuaClient.this.devAcronym) + String.format("Subscription alive: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }

        public void onTimeout(Subscription s) {
            System.out.println(String.valueOf(M12OpcuaClient.this.devAcronym) + String.format("Subscription timeout: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }

        public void onAfterCreate(Subscription s) {
            System.out.println(String.valueOf(M12OpcuaClient.this.devAcronym) + String.format("Subscription created: ID=%d lastAlive=%tc", s.getSubscriptionId().getValue(), s.getLastAlive()));
        }
    };
    private SubscriptionNotificationListener subscriptionListener = new SubscriptionNotificationListener(){

        public void onDataChange(Subscription subscription, MonitoredDataItem item, DataValue newValue) {
        }

        public void onError(Subscription subscription, Object notification, Exception exception) {
            System.out.println(String.valueOf(M12OpcuaClient.this.devAcronym) + exception.getMessage());
        }

        public void onEvent(Subscription subscription, MonitoredEventItem item, Variant[] eventFields) {
            System.out.println(String.valueOf(M12OpcuaClient.this.devAcronym) + String.format("Subscription value received: item = %tc, value = %tc", item.getNodeId(), eventFields));
        }

        public void onNotificationData(Subscription subscription, NotificationData notification) {
        }

        public void onStatusChange(Subscription subscription, StatusCode oldStatus, StatusCode newStatus, DiagnosticInfo diagnosticInfo) {
        }

        public void onBufferOverflow(Subscription arg0, UnsignedInteger arg1, ExtensionObject[] arg2) {
        }

        public long onMissingData(UnsignedInteger arg0, long arg1, long arg2, StatusCode arg3) {
            return 0L;
        }
    };
    public int serverStatus = -1;
    public boolean deviceLinkStatus = false;

    static {
        m1_state = (short)-1;
        m2_state = (short)-1;
    }

    public int getServerIndex() {
        return this.telescopeIndex;
    }

    public void setServerIndex(int telescopeIndex) {
        this.devAcronym = "M12" + String.valueOf(telescopeIndex) + ">";
        this.telescopeIndex = telescopeIndex;
    }

    public boolean startClient(String clnt, int index) {
        this.setServerIndex(index);
        return this.startClient(clnt);
    }

    public boolean startClient(String clnt) {
        try {
            this.client = new UaClient(clnt);
            TcpConnection.setReceiveBufferSize((int)1000000);
            TcpConnection.setSendBufferSize((int)1000000);
            this.client.getEndpointConfiguration().setMaxArrayLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxByteStringLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxMessageSize(Integer.valueOf(768000000));
            this.client.getEndpointConfiguration().setMaxStringLength(Integer.valueOf(120000000));
            this.client.getEndpointConfiguration().setMaxBufferSize(Integer.valueOf(120000000));
            this.client.setSecurityMode(SecurityMode.NONE);
            this.client.setSessionTimeout(5000.0);
            this.client.setAutoReconnect(true);
            this.client.setStatusCheckTimeout(1000L);
            this.client.setTimeout(1000L);
            this.client.setSessionTimeout(3000L, TimeUnit.MILLISECONDS);
            this.client.getEndpointConfiguration().setOperationTimeout(Integer.valueOf(3000));
            this.createSubscription();
            this.client.connect();
            this.CreateDataPoints();
            this.activateMonitoringAll();
        }
        catch (ServiceException | StatusException | AddressSpaceException | URISyntaxException e) {
            System.out.println(" Opcua Client error: " + e.getMessage());
        }
        return false;
    }

    private int CreateDataPoints() throws ServiceException, AddressSpaceException {
        int ix = 0;
        while (ix < this.m12ICD.get_NodeName_List.size()) {
            this.dataPointList.add(new DataPoint(this.client, this.getNodeId(this.m12ICD.get_NodeName_List.get(ix))));
            System.out.println(String.valueOf(ix) + ") CreateDataPoints dataPointList = " + this.m12ICD.get_NodeName_List.get(ix));
            ++ix;
        }
        System.out.println("CreateDataPoints size = " + this.dataPointList.size());
        return this.dataPointList.size();
    }

    public Object readValue(int ns, String browserName) {
        this.nodeId = new NodeId(ns, browserName);
        Object value = null;
        try {
            value = this.client.readValue(this.nodeId).getValue().getValue();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public DataValue nodeCheck(String nodeName, String nodeType) {
        this.nodeId = this.getNodeId(nodeName);
        DataValue dataValue = null;
        try {
            dataValue = this.client.readValue(this.nodeId);
            System.out.print(String.format("NodeName: %1$50s", nodeName));
            System.out.print(" type is:" + this.getNodeType(nodeName) + "\t\tread:" + nodeType);
            System.out.print(" \tAccesstype is:" + this.getAccessLevel(nodeName));
            if (!this.getNodeType(nodeName).toUpperCase().trim().equals(nodeType.toUpperCase().trim())) {
                System.out.println("\t*******");
            } else {
                System.out.println();
            }
        }
        catch (ServiceException | StatusException e) {
            System.out.println("Error on node " + nodeName + " >>" + e.getMessage());
        }
        return dataValue;
    }

    public DataValue getDataValue(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        DataValue dataValue = null;
        try {
            dataValue = this.client.readValue(this.nodeId);
        }
        catch (ServiceException | StatusException e) {
            System.out.println("Error on node " + nodeName + " >>" + e.getMessage());
        }
        return dataValue;
    }

    private void activateMonitoringAll() throws ServiceException, StatusException {
        int nItem = -1;
        for (DataPoint item : this.dataPointList) {
            try {
                ++nItem;
                this.addMonitoredDataPoint(item.getMonitorItem(this.dataChangeListener));
            }
            catch (ServiceException | StatusException e) {
                System.out.println("Error on activateMonitoringAll itemNo= " + nItem + "   " + item.toString() + " >>" + e.getMessage());
            }
        }
        this.startMonitoring();
    }

    public String getServerTimestamp(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        String value = null;
        try {
            value = this.client.readValue(this.nodeId).getServerTimestamp().toString();
        }
        catch (ServiceException | StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getSourceTimestamp(String nodeName) {
        if (nodeName == null | nodeName == "") {
            return "";
        }
        this.nodeId = this.getNodeId(nodeName);
        String value = "";
        try {
            value = this.client.readValue(this.nodeId).getSourceTimestamp().toString();
        }
        catch (ServiceException | StatusException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getNodeType(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        UaType dataType = null;
        String value = null;
        try {
            try {
                UaVariable valiable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
                dataType = valiable.getDataType();
                NodeId dataTypeId = valiable.getDataTypeId();
                dataType = this.client.getAddressSpace().getType(dataTypeId);
                value = dataType.getDisplayName().getText();
            }
            catch (AddressSpaceException e) {
                e.printStackTrace();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getAccessLevel(String nodeName) {
        this.nodeId = this.getNodeId(nodeName);
        String value = null;
        Object accessType = null;
        try {
            try {
                UaVariable valiable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
                value = valiable.getAccessLevel().toString();
            }
            catch (AddressSpaceException e) {
                e.printStackTrace();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void test() throws ServiceException, AddressSpaceException, Exception {
        this.startClient("opc.tcp://localhost:52620/OPCUA/AMA_WS1_Server");
        UaNode node = this.client.getAddressSpace().getNode(this.nodeId);
        if (node != null) {
            System.out.println(node.getNodeClass().toString());
            System.out.println(this.client.readValue(this.nodeId).getValue().getValue());
            System.out.println(this.client.readValue(this.nodeId).getValue().isArray());
        } else {
            System.out.println("node is null");
        }
    }

    public void ceckAllNodes() {
        System.out.println(">>>>>  Start ceckAllNodes proc\n");
        System.out.println("==========    GET\n");
        int ix = 0;
        while (ix < this.m12ICD.get_NodeName_List.size()) {
            this.nodeCheck(this.m12ICD.get_NodeName_List.get(ix), this.m12ICD.get_DataType_List.get(ix));
            ++ix;
        }
        System.out.println("==========    SET\n");
        ix = 0;
        while (ix < this.m12ICD.set_NodeName_List.size()) {
            this.nodeCheck(this.m12ICD.set_NodeName_List.get(ix), this.m12ICD.set_DataType_List.get(ix));
            ++ix;
        }
        System.out.println("==========    CMD\n");
        ix = 0;
        while (ix < this.m12ICD.cmd_NodeName_List.size()) {
            this.nodeCheck(this.m12ICD.cmd_NodeName_List.get(ix), this.m12ICD.cmd_DataType_List.get(ix));
            ++ix;
        }
        System.out.println("==========    MODE\n");
        ix = 0;
        while (ix < this.m12ICD.mode_NodeName_List.size()) {
            this.nodeCheck(this.m12ICD.mode_NodeName_List.get(ix), this.m12ICD.mode_DataType_List.get(ix));
            ++ix;
        }
        System.out.println("\n>>>>>  End ceckAllNodes proc");
    }

    public static void main(String[] args) throws Exception {
        M12OpcuaClient questo = new M12OpcuaClient();
        questo.startClient("opc.tcp://127.0.0.1:52523/OPCUA/AMA_AMC_Server");
        if (!questo.client.isConnected()) {
            System.out.println("\n>>>>>  ERROR - Server not connected!!");
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        questo.ceckAllNodes();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (questo.client.isConnected()) {
            questo.stopClient();
        }
    }

    public void main1(String[] args) throws Exception {
        this.test();
        System.out.println(">>>>>>" + this.readValue(2, "Int32Array"));
        UaVariable variable = (UaVariable)this.client.getAddressSpace().getNode(this.nodeId);
        if (variable != null) {
            NodeId nId = variable.getDataTypeId();
            boolean isArray = variable.getValue().getValue().isArray();
            System.out.println(String.valueOf(nId.getValue().toString()) + "   " + this.opcuaUtils.getTypeIdString(nId) + "  array? " + isArray);
            System.out.println(this.client.readValue(this.nodeId).getValue().getArrayDimensions()[0]);
            System.out.println(variable.getValue().getValue().toString());
            System.out.println("getSourceTimestamp: " + variable.getValue().getSourceTimestamp().toString());
            System.out.println("getSourcePicoseconds: " + variable.getValue().getSourcePicoseconds().toString());
            System.out.println("getServerTimestamp: " + variable.getValue().getServerTimestamp().toString());
            System.out.println("getServerPicoseconds: " + variable.getValue().getServerPicoseconds().toString());
        } else {
            System.out.println("variable is null");
        }
        this.client.writeValue(this.nodeId, (Object)255);
        this.client.writeValue(new NodeId(2, "tstint16"), (Object)255);
        this.client.writeValue(new NodeId(2, "tstint32"), (Object)65255);
        this.client.writeValue(new NodeId(2, "tstint64"), (Object)255L);
        this.client.writeValue(new NodeId(2, "tstbyte"), (Object)new UnsignedByte(222));
        this.client.writeValue(new NodeId(2, "tstsbyte"), (Object)-123);
        byte[] pippo = new byte[]{-128, -100, 5, 127, 127};
        this.client.writeValue(new NodeId(2, "tstbytestring"), (Object)pippo);
        this.client.writeValue(new NodeId(2, "tstuint16"), (Object)UnsignedShort.valueOf((int)2346));
        this.client.writeValue(new NodeId(2, "tstuint32"), (Object)UnsignedInteger.valueOf((long)2346L));
        this.client.writeValue(new NodeId(2, "tstuint64"), (Object)UnsignedLong.valueOf((long)2346L));
        this.client.writeValue(new NodeId(2, "tststring"), (Object)"pippo");
        this.client.writeValue(new NodeId(2, "tstdouble"), (Object)2346.0);
        this.client.writeValue(new NodeId(2, "tstfloat"), (Object)Float.valueOf(2346.0f));
        DataValue value = this.client.readValue(Identifiers.Server_ServerStatus_State);
        System.out.println(value);
    }

    protected void initialize(UaClient client) throws SecureIdentityException, IOException, UnknownHostException {
        ApplicationDescription appDescription = new ApplicationDescription();
        appDescription.setApplicationName(new LocalizedText("AMC_OpcuaClient", Locale.ENGLISH));
        appDescription.setApplicationUri("urn:localhost:UA:AMC_OpcuaClient");
        appDescription.setProductUri("urn:ASTRI-MiniArray.com:UA:AMC_OpcuaClient");
        appDescription.setApplicationType(ApplicationType.Client);
        ApplicationIdentity identity = new ApplicationIdentity();
        identity.setApplicationDescription(appDescription);
        client.setApplicationIdentity(identity);
    }

    public void stopClient() {
        try {
            this.client.removeSubscription(this.subscription);
            this.stopMonitoring();
            System.out.println("\nM12_Opcua_Client STOPPED!!");
        }
        catch (ServiceException | StatusException e) {
            System.out.println("ERROR stopClient: " + e.getMessage());
        }
        this.client.disconnect();
    }

    public NodeId getNodeId(String nId) {
        int idx;
        int ns = 0;
        String nodeName = nId;
        String displayedName = null;
        if (nodeName.contains("=") & nodeName.contains(";") && nodeName.indexOf("=", (idx = nodeName.indexOf("=", 0)) + 1) > 0) {
            ns = Integer.parseInt(nodeName.substring(nodeName.indexOf("=") + 1, nodeName.indexOf(";")).trim());
            displayedName = nodeName.substring(nodeName.lastIndexOf("=") + 1).trim();
            if (ns <= 0) {
                return null;
            }
            if (displayedName == null || displayedName.isEmpty()) {
                return null;
            }
        }
        return new NodeId(ns, displayedName);
    }

    private void createSubscription() throws ServiceException, StatusException {
        if (this.subscription == null) {
            this.subscription = new Subscription();
            this.subscription.setPublishingInterval(1000.0);
            this.subscription.addAliveListener(this.subscriptionAliveListener);
            this.subscription.addNotificationListener(this.subscriptionListener);
            this.subscription.setLifetimeCount(60L);
            this.subscription.setMaxKeepAliveCount(20L);
            this.subscription.setMaxNotificationsPerPublish(0L);
            this.subscription.setPriority(0);
        }
        if (!this.client.hasSubscription(this.subscription.getSubscriptionId())) {
            this.client.addSubscription(this.subscription);
        }
    }

    protected UnsignedInteger addMonitoredDataPoint(MonitoredDataItem item) throws ServiceException, StatusException {
        if (this.client.hasSubscription(this.subscription.getSubscriptionId())) {
            this.subscription.addItem((MonitoredItem)item);
            UnsignedInteger monId = item.getMonitoredItemId();
            return monId;
        }
        return null;
    }

    protected void startMonitoring() throws ServiceException, StatusException {
        this.subscription.setPublishingEnabled(true);
    }

    protected void stopMonitoring() throws ServiceException, StatusException {
        this.subscription.setPublishingEnabled(false);
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void writeOnTextInfo() {
        String txt = "";
        try {
            MirrorGui.GETInfoTextArea.getDocument().remove(0, MirrorGui.GETInfoTextArea.getDocument().getLength());
            MirrorGui.GETInfoTextArea.append(">" + this.client.readValue(new NodeId(4, "AMC_UTILITIES.UTC_TIME")).getValue().getValue().toString() + "\n");
            int ix = 0;
            while (ix < this.m12ICD.get_NodeName_List.size()) {
                try {
                    txt = this.m12ICD.get_NodeName_List.get(ix);
                    txt = txt.substring(txt.lastIndexOf("=") + 1).trim();
                    txt = txt.contains("M1") ? "M1_" + txt.substring(txt.lastIndexOf(".") + 1).trim() : (txt.contains("M2") ? "M2_" + txt.substring(txt.lastIndexOf(".") + 1).trim() : txt.substring(txt.lastIndexOf(".") + 1).trim());
                    txt = String.valueOf(txt) + "=";
                    txt = String.valueOf(txt) + this.getDataValue(this.m12ICD.get_NodeName_List.get(ix)).getValue().getValue().toString() + "\n";
                    MirrorGui.GETInfoTextArea.append(txt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++ix;
            }
        }
        catch (ServiceException | StatusException | BadLocationException e) {
            System.out.println("GETInfoTextArea Error: " + e.getMessage());
        }
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public boolean getDeviceLinkStatus() {
        return this.deviceLinkStatus;
    }

    public void setDeviceLinkStatus(boolean deviceLinkStatus) {
        this.deviceLinkStatus = deviceLinkStatus;
    }

    public void readFile(File localFile, FileTypeImpl fileType) throws ServiceException, StatusException, IOException, AddressSpaceException {
        NodeId fNode = new NodeId(4, ".\\conf\\newImageTest2.fits");
        UaNode f1 = this.client.getAddressSpace().getNode(fNode);
        System.out.println(">>" + f1.getNodeId().toString());
        fileType = new FileTypeImpl(this.client.getAddressSpace(), fNode, null, null);
        DataValue f2 = this.getDataValue("ns=4;s=.\\conf\\newImageTest2.fits");
        fileType.getSize().longValue();
        localFile = new File("./conf/test.test");
        System.out.println("readFile: {" + fileType.getBrowseName() + "} local={" + localFile + "}");
        long size = 12588480L;
        DateTime timestamp = fileType.getTimestamp();
        UnsignedInteger fileHandle = fileType.open(new FileTypeOpenMode[]{FileTypeOpenMode.Read});
        FileOutputStream fos = new FileOutputStream(localFile, false);
        try {
            int actualBlockSize = this.client.getEndpointConfiguration().getMaxByteStringLength() / 2;
            byte[] buff = new byte[actualBlockSize];
            long p = 0L;
            while (p < size) {
                fos.write(buff);
                p += (long)actualBlockSize;
            }
        }
        finally {
            fos.close();
            fileType.close(fileHandle);
        }
        localFile.setLastModified(timestamp.getTimeInMillis());
    }
}

