/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import myproc.Utils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYPointDispersion
extends JFrame {
    private static JFreeChart chart;
    private static XYDataset xyDataSet;
    static JPanel chartPanel;
    public static XYSeries centroidSeries;
    public static XYSeries maxValueSeries;
    private static final Random rand;

    static {
        centroidSeries = new XYSeries((Comparable)((Object)"Centroid1"));
        maxValueSeries = new XYSeries((Comparable)((Object)"MaxValue"));
        rand = new Random();
    }

    public XYPointDispersion() {
        super("PMC - AstriMiniArray");
        super.setIconImage(Utils.tazImage.getImage());
        xyDataSet = XYPointDispersion.createDataset();
        chartPanel = XYPointDispersion.createChartPanel();
        chartPanel.setToolTipText("XYchart");
        this.getContentPane().add(chartPanel);
        this.setSize(634, 525);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.setVisible(false);
    }

    private static JPanel createChartPanel() {
        String chartTitle = "PMC centroid & maxValue XY_dispersion plot ";
        String xAxisLabel = "X";
        String yAxisLabel = "Y";
        XYDataset dataset = XYPointDispersion.createDataset();
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        renderer.setSeriesPaint(1, (Paint)Color.GREEN);
        renderer.setSeriesPaint(2, (Paint)Color.white);
        renderer.setDotWidth(8);
        renderer.setDotHeight(8);
        chart = ChartFactory.createScatterPlot((String)chartTitle, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)xyDataSet);
        chart.getTitle().setHeight(5.0);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setBackgroundPaint((Paint)Color.blue);
        return new ChartPanel(chart);
    }

    static XYDataset createDataset() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(centroidSeries);
        dataset.addSeries(maxValueSeries);
        return dataset;
    }

    private XYDataset newDataser(ArrayList<int[]> cntr, ArrayList<int[]> mxVal) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        centroidSeries = new XYSeries((Comparable)((Object)"Centroid"));
        maxValueSeries = new XYSeries((Comparable)((Object)"MaxValue"));
        int ix = 0;
        while (ix < cntr.size()) {
            centroidSeries.add((double)cntr.get(ix)[0], (double)cntr.get(ix)[1]);
            ++ix;
        }
        ix = 0;
        while (ix < mxVal.size()) {
            centroidSeries.add((double)mxVal.get(ix)[0], (double)mxVal.get(ix)[1]);
            ++ix;
        }
        dataset.addSeries(centroidSeries);
        dataset.addSeries(maxValueSeries);
        return dataset;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XYPointDispersion pippo = new XYPointDispersion();
                pippo.setVisible(true);
                xyDataSet = XYPointDispersion.createDataset();
                chartPanel = XYPointDispersion.createChartPanel();
            }
        });
    }
}

