/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import myproc.CustomOutputStream;

public class TextAreaLogProgram
extends JFrame {
    private static final long serialVersionUID = 1L;
    public JTextArea textArea = new JTextArea();
    public JScrollPane jscroll = null;
    private JButton hideButton = new JButton("Hide");
    private JButton buttonClear = new JButton("Clear");
    public PrintStream standardOut;
    private final JMenuBar menuBar = new JMenuBar();
    private final JButton upButton = new JButton("\u25b2");
    private final JButton downButton = new JButton("\u25bc");
    private final JTextField fontTextField = new JTextField();
    public JToggleButton stopToggleButton = new JToggleButton("Stop");

    public TextAreaLogProgram() {
        super("ASTRI-MiniArray - AIV_GUI Consolle");
        this.setFont(new Font("Dialog", 1, 12));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("./conf/taz.jpg"));
        this.textArea.setEditable(false);
        PrintStream printStream = new PrintStream(new CustomOutputStream(this.textArea));
        this.standardOut = System.out;
        System.setOut(printStream);
        System.setErr(printStream);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.setAlignmentX(1.0f);
        this.textArea.setText(">");
        this.textArea.setBackground(new Color(240, 255, 255));
        this.jscroll = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)this.jscroll, constraints);
        this.setJMenuBar(this.menuBar);
        this.buttonClear.setFont(new Font("Tahoma", 1, 10));
        this.menuBar.add(this.buttonClear);
        this.upButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Font font = TextAreaLogProgram.this.textArea.getFont();
                float size = (float)font.getSize() + 1.0f;
                TextAreaLogProgram.this.textArea.setFont(font.deriveFont(size));
                TextAreaLogProgram.this.fontTextField.setText(String.valueOf(TextAreaLogProgram.this.textArea.getFont().getSize()));
            }
        });
        this.upButton.setForeground(Color.BLUE);
        this.upButton.setFont(new Font("Tahoma", 1, 10));
        this.upButton.setBackground(Color.LIGHT_GRAY);
        this.menuBar.add(this.upButton);
        this.downButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Font font = TextAreaLogProgram.this.textArea.getFont();
                float size = (float)font.getSize() - 1.0f;
                TextAreaLogProgram.this.textArea.setFont(font.deriveFont(size));
                TextAreaLogProgram.this.fontTextField.setText(String.valueOf(TextAreaLogProgram.this.textArea.getFont().getSize()));
            }
        });
        this.fontTextField.setHorizontalAlignment(0);
        this.fontTextField.setMaximumSize(new Dimension(39, Integer.MAX_VALUE));
        this.fontTextField.setSelectionColor(new Color(0, 120, 215));
        this.fontTextField.setToolTipText("dimension of characters");
        this.fontTextField.setText("10");
        this.fontTextField.setFont(new Font("Tahoma", 1, 10));
        this.fontTextField.setAutoscrolls(false);
        this.fontTextField.setBackground(new Color(176, 196, 222));
        this.fontTextField.setText(String.valueOf(this.textArea.getFont().getSize()));
        this.menuBar.add(this.fontTextField);
        this.downButton.setForeground(Color.BLUE);
        this.downButton.setFont(new Font("Tahoma", 1, 10));
        this.downButton.setBackground(Color.LIGHT_GRAY);
        this.menuBar.add(this.downButton);
        this.stopToggleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultCaret caret = (DefaultCaret)TextAreaLogProgram.this.textArea.getCaret();
                if (TextAreaLogProgram.this.stopToggleButton.isSelected()) {
                    TextAreaLogProgram.this.stopToggleButton.setText("Release");
                    TextAreaLogProgram.this.jscroll.setVerticalScrollBarPolicy(21);
                    caret.setUpdatePolicy(1);
                    TextAreaLogProgram.this.textArea.setWrapStyleWord(false);
                    TextAreaLogProgram.this.textArea.setLineWrap(false);
                } else {
                    TextAreaLogProgram.this.stopToggleButton.setText("Stop");
                    TextAreaLogProgram.this.jscroll.setVerticalScrollBarPolicy(20);
                    caret.setUpdatePolicy(2);
                    TextAreaLogProgram.this.textArea.setWrapStyleWord(true);
                    TextAreaLogProgram.this.textArea.setLineWrap(true);
                }
            }
        });
        this.stopToggleButton.setBackground(Color.ORANGE);
        this.stopToggleButton.setFont(new Font("Tahoma", 1, 10));
        this.menuBar.add(this.stopToggleButton);
        this.hideButton.setFont(new Font("Tahoma", 1, 10));
        this.hideButton.setForeground(new Color(0, 0, 255));
        this.hideButton.setBackground(new Color(255, 255, 0));
        this.menuBar.add(this.hideButton);
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAreaLogProgram.this.setVisible(false);
            }
        });
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    TextAreaLogProgram.this.textArea.getDocument().remove(0, TextAreaLogProgram.this.textArea.getDocument().getLength());
                    TextAreaLogProgram.this.standardOut.println("Text area cleared");
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.setSize(900, 480);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void printLog() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    System.out.println("Time now is " + new Date());
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        thread.start();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TextAreaLogProgram().setVisible(true);
            }
        });
    }
}

