/*
 * Decompiled with CFR 0.152.
 */
package gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.ImageObserver;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import myproc.Utils;

public class ShowFullImage
extends JFrame {
    public JLabel imageLabel = new JLabel();
    JScrollPane scrollPane = new JScrollPane();
    private JButton hideButton = new JButton("Hide");
    public JComboBox zoomFactorComboBox = new JComboBox();
    public float xFactor = 1.0f;
    public float yFactor = 1.0f;
    private ImagePlus imageP = IJ.openImage((String)"./conf/imageTest.fits");
    public JLabel stretchLabel = new JLabel("   ---   ");
    public int newMin = 0;
    public int newMax = 4096;
    public ImagePlus imp = this.imageP;
    public JLabel labelCoordinate = new JLabel("---                       ");
    public JScrollBar minScrollBar = new JScrollBar();
    public JScrollBar maxScrollBar = new JScrollBar();
    private JSeparator separator = new JSeparator();
    public int imageMaxVal = 65000;
    public int imageMinVal = 65000;

    public void setImageP(String imagePName) {
        this.imageP = IJ.openImage((String)imagePName);
        this.showImageOnLabel();
    }

    public void setImageP(String imagePName, int zoomFactor) {
        this.imageP = IJ.openImage((String)imagePName);
        this.zoomFactorComboBox.setSelectedIndex(zoomFactor);
        this.zoomFactorComboBox.setVisible(false);
        this.setResizable(false);
        this.scrollPane.setLocation(-9, 0);
        this.showImageOnLabel();
    }

    public void showImageOnLabel() {
        this.imp = this.imageP.resize((int)((float)this.imageP.getWidth() / this.xFactor), (int)((float)this.imageP.getHeight() / this.yFactor), "./conf/fullImage.jpg");
        this.normalizeStack(this.imp);
        Image img = this.imp.getImage();
        img.flush();
        ImageIcon icon = new ImageIcon(img);
        icon.getImage().flush();
        this.imageLabel.setAlignmentY(0.0f);
        this.imageLabel.setSize(new Dimension((int)((float)this.imageP.getImage().getWidth((ImageObserver)this.imageP) / this.xFactor), (int)((float)this.imageP.getImage().getHeight((ImageObserver)this.imageP) / this.yFactor)));
        this.imageLabel.setPreferredSize(new Dimension((int)((float)this.imageP.getImage().getWidth((ImageObserver)this.imageP) / this.xFactor), (int)((float)this.imageP.getImage().getHeight((ImageObserver)this.imageP) / this.yFactor)));
        this.imageLabel.setLocation(0, 0);
        this.imageLabel.setIcon(icon);
    }

    public ShowFullImage(String title) {
        super(title);
        this.getContentPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ShowFullImage.this.scrollPane.setSize(ShowFullImage.this.getContentPane().getWidth(), ShowFullImage.this.getContentPane().getHeight());
                ShowFullImage.this.scrollPane.setLocation(0, 0);
            }
        });
        this.getContentPane().setBackground(Color.YELLOW);
        super.setIconImage(Utils.tazImage.getImage());
        this.setSize(767, 512);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        this.scrollPane.setLocation(0, 0);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.hideButton.setAlignmentX(0.5f);
        this.hideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ShowFullImage.this.setVisible(false);
            }
        });
        this.hideButton.setForeground(Color.BLUE);
        this.hideButton.setFont(new Font("Tahoma", 1, 10));
        this.hideButton.setBackground(Color.YELLOW);
        menuBar.add(this.hideButton);
        this.zoomFactorComboBox.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.zoomFactorComboBox.setBackground(Color.WHITE);
        menuBar.add(this.zoomFactorComboBox);
        this.zoomFactorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int indx = ShowFullImage.this.zoomFactorComboBox.getSelectedIndex();
                switch (indx) {
                    case 0: {
                        ShowFullImage.this.xFactor = 10.0f;
                        ShowFullImage.this.yFactor = 10.0f;
                        ShowFullImage.this.setSize(640, 700);
                        ShowFullImage.this.scrollPane.setSize(ShowFullImage.this.getContentPane().getWidth(), ShowFullImage.this.getContentPane().getHeight());
                        break;
                    }
                    case 1: {
                        ShowFullImage.this.xFactor = 4.0f;
                        ShowFullImage.this.yFactor = 4.0f;
                        ShowFullImage.this.setSize(788, 584);
                        ShowFullImage.this.setSize(767, 512);
                        ShowFullImage.this.scrollPane.setSize(ShowFullImage.this.getContentPane().getWidth(), ShowFullImage.this.getContentPane().getHeight());
                        break;
                    }
                    case 2: {
                        ShowFullImage.this.xFactor = 2.0f;
                        ShowFullImage.this.yFactor = 2.0f;
                        break;
                    }
                    case 3: {
                        ShowFullImage.this.xFactor = 1.0f;
                        ShowFullImage.this.yFactor = 1.0f;
                        break;
                    }
                    case 4: {
                        ShowFullImage.this.xFactor = 0.5f;
                        ShowFullImage.this.yFactor = 0.5f;
                        break;
                    }
                    default: {
                        ShowFullImage.this.xFactor = 1.0f;
                        ShowFullImage.this.yFactor = 1.0f;
                    }
                }
                ShowFullImage.this.showImageOnLabel();
                System.out.println(ShowFullImage.this.imageLabel.getSize() + "  " + ShowFullImage.this.imageLabel.getLocation());
            }
        });
        this.zoomFactorComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0.1 x 0.1", "0.25 x 0.25", "0.5 x 0.5", "1 x 1", "2 x 2"}));
        this.zoomFactorComboBox.setSelectedIndex(2);
        this.zoomFactorComboBox.setBounds(99, 747, 120, 26);
        this.labelCoordinate.setAlignmentX(0.5f);
        this.labelCoordinate.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.labelCoordinate.setHorizontalTextPosition(0);
        this.labelCoordinate.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.labelCoordinate.setMaximumSize(new Dimension(140, 19));
        this.labelCoordinate.setHorizontalAlignment(0);
        this.labelCoordinate.setFont(new Font("SansSerif", 1, 11));
        this.labelCoordinate.setBackground(Color.WHITE);
        this.labelCoordinate.setForeground(Color.BLUE);
        menuBar.add(this.labelCoordinate);
        this.minScrollBar.setValueIsAdjusting(true);
        this.minScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ShowFullImage.this.newMin = ShowFullImage.this.minScrollBar.getValue();
                ShowFullImage.this.showImageOnLabel();
            }
        });
        this.minScrollBar.setBlockIncrement(16);
        this.minScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ShowFullImage.this.stretchLabel.setText(" " + ShowFullImage.this.minScrollBar.getValue() + "*" + ShowFullImage.this.maxScrollBar.getValue() + " ");
                ShowFullImage.this.newMin = ShowFullImage.this.minScrollBar.getValue();
            }
        });
        menuBar.add(this.separator);
        this.minScrollBar.setBackground(SystemColor.info);
        this.minScrollBar.setOpaque(false);
        this.minScrollBar.setPreferredSize(new Dimension(50, 16));
        this.minScrollBar.setSize(new Dimension(70, 18));
        this.minScrollBar.setMaximum(4096);
        this.minScrollBar.setOrientation(0);
        menuBar.add(this.minScrollBar);
        this.stretchLabel.setForeground(Color.BLUE);
        this.stretchLabel.setFont(new Font("SansSerif", 1, 11));
        this.stretchLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.stretchLabel.setBackground(Color.WHITE);
        menuBar.add(this.stretchLabel);
        this.maxScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ShowFullImage.this.newMax = ShowFullImage.this.maxScrollBar.getValue();
                ShowFullImage.this.showImageOnLabel();
            }
        });
        this.maxScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ShowFullImage.this.stretchLabel.setText(" " + ShowFullImage.this.minScrollBar.getValue() + "*" + ShowFullImage.this.maxScrollBar.getValue() + " ");
                ShowFullImage.this.newMax = ShowFullImage.this.maxScrollBar.getValue();
            }
        });
        this.maxScrollBar.setSize(new Dimension(70, 18));
        this.maxScrollBar.setPreferredSize(new Dimension(50, 16));
        this.maxScrollBar.setOrientation(0);
        this.maxScrollBar.setOpaque(false);
        this.maxScrollBar.setMaximum(4096);
        this.maxScrollBar.setBlockIncrement(16);
        this.maxScrollBar.setBackground(Color.BLUE);
        this.maxScrollBar.setValue(4096);
        menuBar.add(this.maxScrollBar);
        this.getContentPane().setLayout(null);
        this.scrollPane.setSize(748, 439);
        this.imageLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point x = ShowFullImage.this.imageLabel.getMousePosition();
                try {
                    if (x.y >= 9) {
                        ShowFullImage.this.labelCoordinate.setText(" x=" + (float)x.x * ShowFullImage.this.xFactor + " - y=" + (float)(x.y - 9) * ShowFullImage.this.yFactor + "   " + ShowFullImage.this.imageP.getPixel((int)((float)x.x * ShowFullImage.this.xFactor), (int)((float)(x.y - 9) * ShowFullImage.this.yFactor))[0] + " ");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.imageLabel.setPreferredSize(new Dimension((int)((float)this.imageP.getImage().getWidth((ImageObserver)this.imageP) / this.xFactor), (int)((float)this.imageP.getImage().getHeight((ImageObserver)this.imageP) / this.yFactor)));
        this.scrollPane.setViewportView(this.imageLabel);
        this.getContentPane().add(this.scrollPane);
        this.imageLabel.setBackground(Color.ORANGE);
        this.imageLabel.validate();
        ImageIcon icon = new ImageIcon(this.imageP.getImage());
        this.imageLabel.setIcon(icon);
        System.out.println(this.imageLabel.getMaximumSize());
        this.showImageOnLabel();
        this.setVisible(false);
    }

    public void normalizeStack(ImagePlus imp) {
        int rh;
        int rw;
        int ry;
        int rx;
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        ImageProcessor ip = imp.getProcessor();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        byte[] mask = ip.getMaskArray();
        if (roi != null) {
            rx = roi.x;
            ry = roi.y;
            rw = roi.width;
            rh = roi.height;
        } else {
            rx = 0;
            ry = 0;
            rw = width;
            rh = height;
        }
        IJ.showStatus((String)"Finding min and max");
        StackStatistics stats = new StackStatistics(imp);
        double roiMin = stats.min;
        this.imageMinVal = (int)roiMin;
        double roiMax = stats.max;
        this.imageMaxVal = (int)roiMax;
        if (roiMax <= roiMin) {
            roiMax = roiMin + 1.0;
        }
        double scale = (double)(this.newMax - this.newMin) / (roiMax - roiMin);
        double offset = ((double)this.newMin * roiMax - (double)this.newMax * roiMin) / (roiMax - roiMin);
        int slice = 1;
        while (slice <= size) {
            IJ.showStatus((String)("Normalizing: " + slice + "/" + size));
            IJ.showProgress((int)slice, (int)size);
            ip = stack.getProcessor(slice);
            int y = 0;
            while (y < height) {
                int i = y * width + rx;
                int x = 0;
                while (x < width) {
                    double v = ip.getPixelValue(x, y);
                    v = scale * v + offset;
                    ip.putPixelValue(x, y, v);
                    ++i;
                    ++x;
                }
                ++y;
            }
            ++slice;
        }
    }

    public void testDraw() {
        Graphics2D g2 = (Graphics2D)this.imageLabel.getGraphics();
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.yellow);
        g2.fillArc(200, 200, 100, 100, 0, 360);
        g2.setColor(Color.magenta);
        g2.draw(new Ellipse2D.Double(100.0, 100.0, 100.0, 100.0));
        g2.setColor(Color.WHITE);
        g2.draw(new Line2D.Double(0.0, 100.0, this.imageLabel.getWidth(), 100.0));
        g2.draw(new Line2D.Double(100.0, 0.0, 100.0, this.imageLabel.getHeight()));
    }

    public void drawCircle(int x, int y, int radius) {
        Graphics2D g2 = (Graphics2D)this.imageLabel.getGraphics();
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.yellow);
        g2.setColor(Color.magenta);
        g2.draw(new Ellipse2D.Double(x - radius / 2, (y += 9) - radius / 2, radius, radius));
        g2.setColor(Color.yellow);
        this.drawCross(x, y - 9, 20);
    }

    public void drawCross(int x, int y, int len) {
        Graphics2D g2 = (Graphics2D)this.imageLabel.getGraphics();
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.yellow);
        g2.draw(new Line2D.Double(x, (y += 9) - (len /= 2), x, y + len));
        g2.setStroke(new BasicStroke(2.0f));
        g2.draw(new Line2D.Double(x - len, y, x + len, y));
    }

    public static void main(String[] args) {
        ShowFullImage demo = new ShowFullImage("PMC - show full image");
        demo.setVisible(true);
    }
}

