/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.client.UaClient;
import gui.AIV_GUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import myproc.Utils;

public class OpcuaNodesGrid {
    UaClient workOpcuaClient;
    public JFrame frame;
    public JTable nodeTable;
    private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
    private Object[][] data = new Object[][]{{"Kathy", "Smith", "Snowboarding", 5, false}, {"John", "Doe", "Rowing", 3, true}, {"Sue", "Black", "Knitting", 2, false}, {"Jane", "White", "Speed reading", 20, true}, {"Joe", "Brown", "Pool", 10, false}};
    private JMenuBar menuBar;
    private JMenuItem exitMenuItem;
    private JMenu mnNewMenu;
    private JSeparator separator;
    private JButton refreshButton;
    private static JButton modeButton;
    private JButton cmdButton;
    private JButton setButton;
    private JButton getButton;
    public String tableType = "server";
    private JButton refreshButton_1;
    public static boolean opcuaStartReadThread;
    public static int opcuaShowNodeTypeOnGrid;

    static {
        opcuaStartReadThread = false;
        opcuaShowNodeTypeOnGrid = 1;
    }

    public void setData(Object[][] data) {
        if (data != null) {
            this.data = data;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public OpcuaNodesGrid() {
        this.frame.setVisible(false);
        this.initialize();
    }

    public OpcuaNodesGrid(String[] columnNames, Object[][] data, String typeOfTable, UaClient uaClient) {
        this.workOpcuaClient = uaClient;
        this.setColumnNames(columnNames);
        this.setData(data);
        this.initialize();
        switch (typeOfTable) {
            case "server": {
                this.tableType = typeOfTable;
                this.refreshButton_1.setVisible(false);
                break;
            }
            case "discovery": {
                this.tableType = typeOfTable;
                modeButton.setVisible(false);
                this.getButton.setVisible(false);
                this.setButton.setVisible(false);
                this.cmdButton.setVisible(false);
                this.refreshButton.setVisible(false);
                this.frame.setTitle("Local Discovery Server Table. - Url= " + Utils.discoveryServerUrl);
                break;
            }
        }
    }

    public void initialize() {
        this.frame = new JFrame("OpcuaNodesGrid ...");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpcuaNodesGrid.this.frame.setVisible(false);
            }
        });
        this.frame.getContentPane().setLocation(new Point(100, 100));
        this.frame.setBounds(200, 300, 514, 316);
        this.frame.setDefaultCloseOperation(0);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.nodeTable = new JTable(this.data, this.columnNames);
        this.nodeTable.setBounds(3, 25, 497, 255);
        this.nodeTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.nodeTable.setFillsViewportHeight(true);
        this.frame.getContentPane().add((Component)this.nodeTable, "Center");
        this.nodeTable.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.nodeTable);
        scrollPane.setBackground(Color.ORANGE);
        scrollPane.setBounds(0, 0, 506, 280);
        this.frame.getContentPane().add(scrollPane);
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.mnNewMenu = new JMenu("File");
        this.menuBar.add(this.mnNewMenu);
        this.separator = new JSeparator();
        this.mnNewMenu.add(this.separator);
        this.exitMenuItem = new JMenuItem("Close");
        this.mnNewMenu.add(this.exitMenuItem);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!OpcuaNodesGrid.this.workOpcuaClient.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                AIV_GUI.opcuaStartReadThread = true;
            }
        });
        this.getButton = new JButton("GET");
        this.getButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!OpcuaNodesGrid.this.workOpcuaClient.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                AIV_GUI.opcuaShowNodeTypeOnGrid = 1;
                AIV_GUI.opcuaStartReadThread = true;
            }
        });
        this.getButton.setFont(new Font("SansSerif", 1, 11));
        this.getButton.setBackground(Color.YELLOW);
        this.menuBar.add(this.getButton);
        this.setButton = new JButton("SET");
        this.setButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!OpcuaNodesGrid.this.workOpcuaClient.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                AIV_GUI.opcuaShowNodeTypeOnGrid = 2;
                AIV_GUI.opcuaStartReadThread = true;
            }
        });
        this.setButton.setFont(new Font("SansSerif", 1, 11));
        this.setButton.setBackground(Color.YELLOW);
        this.menuBar.add(this.setButton);
        this.cmdButton = new JButton("CMD");
        this.cmdButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!OpcuaNodesGrid.this.workOpcuaClient.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                AIV_GUI.opcuaShowNodeTypeOnGrid = 3;
                AIV_GUI.opcuaStartReadThread = true;
            }
        });
        this.cmdButton.setFont(new Font("SansSerif", 1, 11));
        this.cmdButton.setBackground(Color.YELLOW);
        this.menuBar.add(this.cmdButton);
        modeButton = new JButton("MODE");
        modeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!OpcuaNodesGrid.this.workOpcuaClient.isConnected()) {
                    AIV_GUI.writeOnInfoText("--->>Client_OPC-UA is not connected..\n", Color.blue, true, false, false, false, 12);
                    return;
                }
                AIV_GUI.opcuaShowNodeTypeOnGrid = 4;
                AIV_GUI.opcuaStartReadThread = true;
            }
        });
        modeButton.setFont(new Font("SansSerif", 1, 11));
        modeButton.setBackground(Color.YELLOW);
        this.menuBar.add(modeButton);
        this.refreshButton.setFont(new Font("SansSerif", 1, 11));
        this.refreshButton.setBackground(Color.ORANGE);
        this.menuBar.add(this.refreshButton);
        this.refreshButton_1 = new JButton("Refresh");
        this.refreshButton_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Utils.showDiscoverServerNodes(Utils.discoveryServerUrl);
                }
                catch (ServerListException | IOException | InterruptedException throwable) {
                    // empty catch block
                }
                AIV_GUI.discoveryStartReadThread = true;
            }
        });
        this.refreshButton_1.setFont(new Font("SansSerif", 1, 11));
        this.refreshButton_1.setBackground(Color.ORANGE);
        this.menuBar.add(this.refreshButton_1);
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpcuaNodesGrid.this.frame.setVisible(false);
            }
        });
        this.frame.setVisible(true);
    }

    public void setColumnNames(String[] columnNames) {
        if (columnNames != null) {
            this.columnNames = columnNames;
        }
    }

    private void printDebugData(JTable table) {
        int numRows = table.getRowCount();
        int numCols = table.getColumnCount();
        TableModel model = table.getModel();
        System.out.println("Value of data: ");
        int i = 0;
        while (i < numRows) {
            System.out.print("    row " + i + ":");
            int j = 0;
            while (j < numCols) {
                System.out.print("  " + model.getValueAt(i, j));
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println("--------------------------");
    }

    public void setUpTableData(Object[][] data) {
        DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.setRowCount(data.length);
        tableModel.setDataVector(data, this.columnNames);
        this.nodeTable.setModel(tableModel);
    }

    public void setOpcuaStartReadThread(boolean opcuaStartReadThread) {
        OpcuaNodesGrid.opcuaStartReadThread = opcuaStartReadThread;
    }
}

