/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import myproc.Utils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class HistoryPlot
extends JFrame {
    public TimeSeries timeSeries = new TimeSeries((Comparable)((Object)""));
    public TimeSeriesCollection dataset = new TimeSeriesCollection(this.timeSeries);
    public JFreeChart chart;
    public String unitString = "unit";

    public HistoryPlot() {
        super("ASTRI miniArray - History Plot");
        super.setIconImage(Utils.tazImage.getImage());
        JFreeChart chart = this.createChart(this.dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JButton hideButton = new JButton("Hide");
        hideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryPlot.this.setVisible(false);
            }
        });
        hideButton.setForeground(Color.BLUE);
        hideButton.setFont(new Font("Tahoma", 1, 10));
        hideButton.setBackground(Color.YELLOW);
        menuBar.add(hideButton);
        JButton buttonReload = new JButton("Reload");
        buttonReload.setVisible(false);
        buttonReload.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        buttonReload.setFont(new Font("Tahoma", 1, 10));
        menuBar.add(buttonReload);
        this.setContentPane((Container)chartPanel);
        this.pack();
    }

    private JFreeChart createChart(TimeSeriesCollection dataset) {
        this.chart = ChartFactory.createTimeSeriesChart((String)"", (String)"Time", (String)this.unitString, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = this.chart.getXYPlot();
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getDomainAxis().setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        plot.mapDatasetToRangeAxis(1, 1);
        return this.chart;
    }

    public static void main(String[] args) {
    }
}

