/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.ui.GradientPaintTransformType;
import org.jfree.chart.ui.GradientPaintTransformer;
import org.jfree.chart.ui.StandardGradientPaintTransformer;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;

public class DialDemo1
extends JFrame {
    public DialDemo1(String s) {
        super(s);
        this.setDefaultCloseOperation(3);
        this.setContentPane(DialDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] args) {
        DialDemo1 dialdemo1 = new DialDemo1("JFreeChart - Demo Dial 1");
        dialdemo1.pack();
        dialdemo1.setVisible(true);
    }

    static class DemoPanel
    extends JPanel
    implements ChangeListener {
        JSlider slider;
        DefaultValueDataset dataset = new DefaultValueDataset(10.0);

        public static JFreeChart createStandardDialChart(String s, String s1, ValueDataset valuedataset, double d, double d1, double d2, int i) {
            DialPlot dialplot = new DialPlot();
            dialplot.setDataset(valuedataset);
            dialplot.setDialFrame((DialFrame)new StandardDialFrame());
            dialplot.setBackground((DialLayer)new DialBackground());
            DialTextAnnotation dialtextannotation = new DialTextAnnotation(s1);
            dialtextannotation.setFont(new Font("Dialog", 1, 14));
            dialtextannotation.setRadius(0.7);
            dialplot.addLayer((DialLayer)dialtextannotation);
            DialValueIndicator dialvalueindicator = new DialValueIndicator(0);
            dialplot.addLayer((DialLayer)dialvalueindicator);
            StandardDialScale standarddialscale = new StandardDialScale(d, d1, -120.0, -300.0, 10.0, 4);
            standarddialscale.setMajorTickIncrement(d2);
            standarddialscale.setMinorTickCount(i);
            standarddialscale.setTickRadius(0.88);
            standarddialscale.setTickLabelOffset(0.15);
            standarddialscale.setTickLabelFont(new Font("Dialog", 0, 14));
            dialplot.addScale(0, (DialScale)standarddialscale);
            dialplot.addPointer((DialPointer)new DialPointer.Pin());
            DialCap dialcap = new DialCap();
            dialplot.setCap((DialLayer)dialcap);
            return new JFreeChart(s, (Plot)dialplot);
        }

        @Override
        public void stateChanged(ChangeEvent changeevent) {
            this.dataset.setValue((Number)new Integer(this.slider.getValue()));
        }

        public DemoPanel() {
            super(new BorderLayout());
            JFreeChart jfreechart = DemoPanel.createStandardDialChart("Dial Demo 1", "Temperature", (ValueDataset)this.dataset, -40.0, 60.0, 10.0, 4);
            DialPlot dialplot = (DialPlot)jfreechart.getPlot();
            StandardDialRange standarddialrange = new StandardDialRange(40.0, 60.0, (Paint)Color.red);
            standarddialrange.setInnerRadius(0.52);
            standarddialrange.setOuterRadius(0.55);
            dialplot.addLayer((DialLayer)standarddialrange);
            StandardDialRange standarddialrange1 = new StandardDialRange(10.0, 40.0, (Paint)Color.orange);
            standarddialrange1.setInnerRadius(0.52);
            standarddialrange1.setOuterRadius(0.55);
            dialplot.addLayer((DialLayer)standarddialrange1);
            StandardDialRange standarddialrange2 = new StandardDialRange(-40.0, 10.0, (Paint)Color.green);
            standarddialrange2.setInnerRadius(0.52);
            standarddialrange2.setOuterRadius(0.55);
            dialplot.addLayer((DialLayer)standarddialrange2);
            GradientPaint gradientpaint = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 220));
            DialBackground dialbackground = new DialBackground((Paint)gradientpaint);
            dialbackground.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
            dialplot.setBackground((DialLayer)dialbackground);
            dialplot.removePointer(0);
            DialPointer.Pointer pointer = new DialPointer.Pointer();
            pointer.setFillPaint((Paint)Color.yellow);
            dialplot.addPointer((DialPointer)pointer);
            ChartPanel chartpanel = new ChartPanel(jfreechart);
            chartpanel.setPreferredSize(new Dimension(400, 400));
            this.slider = new JSlider(-40, 60);
            this.slider.setMajorTickSpacing(10);
            this.slider.setPaintLabels(true);
            this.slider.addChangeListener(this);
            this.add((Component)chartpanel);
            this.add((Component)this.slider, "South");
        }
    }
}

