/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import myproc.Utils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CombinedLineColumnPlots
extends JFrame {
    public XYSeries lineSeries = new XYSeries((Comparable)((Object)"Line"));
    public XYSeries columnSeries = new XYSeries((Comparable)((Object)"Column"));

    public CombinedLineColumnPlots(String title) {
        super("PMC - AstriMiniArray combined plots");
        super.setIconImage(Utils.tazImage.getImage());
        this.setSize(800, 300);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JButton btnNewButton = new JButton("ClearPlots");
        btnNewButton.setToolTipText("Warnig - press to clear all points");
        btnNewButton.setFont(new Font("Tahoma", 1, 10));
        btnNewButton.setForeground(Color.RED);
        btnNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        btnNewButton.setBackground(Color.LIGHT_GRAY);
        menuBar.add(btnNewButton);
        this.setVisible(false);
        JFreeChart chart = this.createCombinedChart();
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        panel.setForeground(new Color(0, 0, 255));
        panel.setBackground(new Color(204, 153, 0));
        panel.setAutoscrolls(true);
        this.setContentPane((Container)panel);
        panel.setLayout(null);
    }

    private JFreeChart createCombinedChart() {
        XYDataset data1 = this.createDataset1();
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        NumberAxis rangeAxis1 = new NumberAxis();
        XYPlot subplot1 = new XYPlot(data1, null, (ValueAxis)rangeAxis1, (XYItemRenderer)renderer1);
        XYDataset data2 = this.createDataset2();
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        NumberAxis rangeAxis2 = new NumberAxis();
        rangeAxis2.setAutoRangeIncludesZero(false);
        XYPlot subplot2 = new XYPlot(data2, null, (ValueAxis)rangeAxis2, (XYItemRenderer)renderer2);
        subplot2.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Domain"));
        plot.setGap(10.0);
        plot.add(subplot1, 2);
        plot.add(subplot2, 2);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return new JFreeChart("PMC - Charts of the line and column", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    private XYDataset createDataset1() {
        Random ran = new Random();
        int ix = 0;
        while (ix < 100) {
            this.lineSeries.add(ran.nextDouble() * 500.0, ran.nextDouble() * 1024.0);
            ++ix;
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(this.lineSeries);
        return collection;
    }

    private XYDataset createDataset2() {
        Random ran = new Random();
        int ix = 0;
        while (ix < 100) {
            this.columnSeries.add(ran.nextDouble() * 500.0, ran.nextDouble() * 1024.0);
            ++ix;
        }
        return new XYSeriesCollection(this.columnSeries);
    }

    public static void main(String[] args) {
        CombinedLineColumnPlots demo = new CombinedLineColumnPlots("PMC - Coordinate plots error");
        demo.setVisible(true);
    }
}

