/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import myproc.Utils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pmc.client.PMCGUI;

public class CombinedCooErrorPlots
extends JFrame {
    public XYSeries raErrorSeries = new XYSeries((Comparable)((Object)"RA_error"));
    public XYSeries decErrorSeries = new XYSeries((Comparable)((Object)"DEC_error"));
    public XYSeries azErrorSeries = new XYSeries((Comparable)((Object)"AZ_error"));
    public XYSeries elErrorSeries = new XYSeries((Comparable)((Object)"EL_error"));

    public CombinedCooErrorPlots(String title) {
        super("PMC - AstriMiniArray combined plots");
        super.setIconImage(Utils.tazImage.getImage());
        this.setSize(500, 442);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JButton btnNewButton = new JButton("ClearPlots");
        btnNewButton.setToolTipText("Warnig - press to clear all points");
        btnNewButton.setFont(new Font("Tahoma", 1, 10));
        btnNewButton.setForeground(Color.RED);
        btnNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PMCGUI.workOpcuaClient.clearErrorSeries();
                PMCGUI.workOpcuaClient.copyErrorXYSeries();
            }
        });
        btnNewButton.setBackground(Color.LIGHT_GRAY);
        menuBar.add(btnNewButton);
        this.setVisible(false);
        JFreeChart chart = this.createCombinedChart();
        ChartPanel panel = new ChartPanel(chart, true, true, true, false, true);
        panel.setAutoscrolls(true);
        this.setContentPane((Container)panel);
        panel.setLayout(null);
    }

    private JFreeChart createCombinedChart() {
        XYDataset data1 = this.createDataset1();
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer();
        NumberAxis rangeAxis1 = new NumberAxis();
        XYPlot subplot1 = new XYPlot(data1, null, (ValueAxis)rangeAxis1, (XYItemRenderer)renderer1);
        subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        XYDataset data2 = this.createDataset2();
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        NumberAxis rangeAxis2 = new NumberAxis();
        rangeAxis2.setAutoRangeIncludesZero(false);
        XYPlot subplot2 = new XYPlot(data2, null, (ValueAxis)rangeAxis2, (XYItemRenderer)renderer2);
        subplot2.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        XYDataset data3 = this.createDataset3();
        XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer();
        NumberAxis rangeAxis3 = new NumberAxis();
        rangeAxis3.setAutoRangeIncludesZero(false);
        XYPlot subplot3 = new XYPlot(data3, null, (ValueAxis)rangeAxis3, (XYItemRenderer)renderer3);
        subplot3.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        subplot3.setBackgroundPaint((Paint)Color.lightGray);
        XYDataset data4 = this.createDataset4();
        XYLineAndShapeRenderer renderer4 = new XYLineAndShapeRenderer();
        renderer4.setSeriesPaint(0, (Paint)Color.black);
        NumberAxis rangeAxis4 = new NumberAxis();
        rangeAxis4.setAutoRangeIncludesZero(false);
        XYPlot subplot4 = new XYPlot(data4, null, (ValueAxis)rangeAxis4, (XYItemRenderer)renderer4);
        subplot4.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        subplot4.setBackgroundPaint((Paint)Color.lightGray);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Domain"));
        plot.setGap(10.0);
        plot.add(subplot1, 2);
        plot.add(subplot2, 2);
        plot.add(subplot3, 2);
        plot.add(subplot4, 2);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return new JFreeChart("PMC - Charts of the coordinate error", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    private XYDataset createDataset1() {
        Random ran = new Random();
        int ix = 0;
        while (ix < 100) {
            this.raErrorSeries.add(ran.nextDouble() * 500.0, ran.nextDouble() * 50000.0);
            ++ix;
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(this.raErrorSeries);
        return collection;
    }

    private XYDataset createDataset2() {
        Random ran = new Random();
        int ix = 0;
        while (ix < 100) {
            this.decErrorSeries.add(ran.nextDouble() * 500.0, ran.nextDouble() * 50000.0);
            ++ix;
        }
        return new XYSeriesCollection(this.decErrorSeries);
    }

    private XYDataset createDataset3() {
        Random ran = new Random();
        int ix = 0;
        while (ix < 100) {
            this.azErrorSeries.add(ran.nextDouble() * 500.0, ran.nextDouble() * 50000.0);
            ++ix;
        }
        return new XYSeriesCollection(this.azErrorSeries);
    }

    private XYDataset createDataset4() {
        Random ran = new Random();
        int ix = 0;
        while (ix < 100) {
            this.elErrorSeries.add(ran.nextDouble() * 500.0, ran.nextDouble() * 50000.0);
            ++ix;
        }
        return new XYSeriesCollection(this.elErrorSeries);
    }

    public static void main(String[] args) {
        CombinedCooErrorPlots demo = new CombinedCooErrorPlots("PMC - Coordinate plots error");
        demo.setVisible(true);
    }
}

