/*
 * Decompiled with CFR 0.152.
 */
package gui;

import client.OpcuaUtils;
import com.prosysopc.ua.client.ServerListException;
import gui.CombinedCooErrorPlots;
import gui.CombinedCooPlotsCentroidAndMaxValue;
import gui.CombinedLineColumnPlots;
import gui.DataInputForm;
import gui.HistoryPlot;
import gui.OpcuaNodesGrid;
import gui.ShowAllimages;
import gui.TextAreaLogProgram;
import gui.XYPointDispersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import m12.client.M12ICD;
import m12.client.M2GUI;
import m12.client.MirrorGui;
import myproc.Utils;
import oc.client.OCCtrlsGUI;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import pmc.client.PMCGUI;
import pmc.client.PMCICD;
import sqm.client.SQMGUI;
import ws.client.WSGUI;

public class AIV_GUI {
    public static TextAreaLogProgram consolle = new TextAreaLogProgram();
    public MirrorGui mirrorGui;
    public M2GUI m2Gui;
    public OCCtrlsGUI ocCtrlsGUI;
    public WSGUI wsGUI;
    public SQMGUI sqmGUI;
    public static PMCGUI pmcGUI = null;
    public JFrame aivJFrame;
    public static JTextPane infoText = new JTextPane();
    public static int infoTextLineNumbers;
    public XYPointDispersion xyPointDispersion = new XYPointDispersion();
    public CombinedCooPlotsCentroidAndMaxValue combinedCooPlotsCentroidAndMaxValue = new CombinedCooPlotsCentroidAndMaxValue("");
    public static CombinedCooErrorPlots combinedCooErrorPlots;
    public static CombinedLineColumnPlots combinedLineColumnPlots;
    public static HistoryPlot historyPlot;
    private final JScrollPane scrollPane_2 = new JScrollPane();
    public static JFileChooser fileChooser;
    public static DataInputForm pmcDataInputForm;
    public static OpcuaUtils opcuaUtils;
    public static PMCICD pmcICD;
    public static M12ICD m12ICD;
    private final JMenuItem exitMenuItem = new JMenuItem("Exit");
    JLabel tazLabel = new JLabel("");
    public static OpcuaNodesGrid opcuaNodesGrid;
    public OpcuaNodesGrid discoveryNodeGrid;
    public static ShowAllimages showAllImages;
    public static int[] crossReference1;
    public static int[] crossReference2;
    public static int[] areaReference;
    public static int[] plotMouseCoo;
    public ArrayList<int[]> centroidArray = new ArrayList();
    public ArrayList<int[]> maxValueArray = new ArrayList();
    Thread threadEnd = new Thread(() -> {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                    System.exit(0);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    });
    public static String nodesGridFrameTitle;
    public static boolean opcuaStartReadThread;
    public static int opcuaShowNodeTypeOnGrid;
    public static boolean discoveryStartReadThread;
    private Thread discoveryNodeThread = new Thread(){

        @Override
        public synchronized void run() {
            String[] colNames = new String[]{" N.", " Name ", " Type ", " Product ", "ApplicationUri", "    Url     "};
            Object[][] dataTable = null;
            while (true) {
                try {
                    while (!discoveryStartReadThread) {
                        Thread.sleep(300L);
                    }
                    discoveryStartReadThread = false;
                    dataTable = Utils.getDiscoverTable(Utils.discoveryServerUrl);
                    if (AIV_GUI.this.discoveryNodeGrid == null) {
                        AIV_GUI.this.discoveryNodeGrid = new OpcuaNodesGrid(colNames, dataTable, "discovery", null);
                    } else {
                        AIV_GUI.this.discoveryNodeGrid.setUpTableData(dataTable);
                    }
                    int idx = 0;
                    while (idx < dataTable.length) {
                        AIV_GUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][1], idx, 1);
                        AIV_GUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][2], idx, 2);
                        AIV_GUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][3], idx, 3);
                        AIV_GUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][4], idx, 4);
                        AIV_GUI.this.discoveryNodeGrid.nodeTable.setValueAt(dataTable[idx][5], idx, 5);
                        ++idx;
                    }
                }
                catch (ServerListException | InterruptedException e) {
                    AIV_GUI.writeOnInfoText("Exception: error reading discovery server nodes:" + e.getMessage());
                }
                AIV_GUI.this.discoveryNodeGrid.nodeTable.repaint();
                AIV_GUI.this.discoveryNodeGrid.frame.setVisible(true);
            }
        }
    };
    private JPanel panel = new JPanel();
    private static JRadioButton rdBtnTelesc_0;
    private static JRadioButton rdBtnTelesc_1;
    private static JRadioButton rdBtnTelesc_2;
    private static JRadioButton rdBtnTelesc_3;
    private static JRadioButton rdBtnTelesc_4;
    private static JRadioButton rdBtnTelesc_5;
    private static JRadioButton rdBtnTelesc_6;
    private static JRadioButton rdBtnTelesc_7;
    private static JRadioButton rdBtnTelesc_8;
    public static JRadioButton[] rdBtnTelesc;
    private ButtonGroup telescRadioGroup = new ButtonGroup();
    private final JMenuItem propsMenuItem = new JMenuItem("ShowProps");
    private static Logger logger;
    JLabel pmcGuiLabel = new JLabel("");
    JLabel mountGuiLabel = new JLabel("");
    JLabel closeAllLabel = new JLabel("");
    JLabel mirror1GuiLabel = new JLabel("");
    JLabel mirror2GuiLabel = new JLabel("");
    JLabel optiCamGuiLabel = new JLabel("");
    JLabel wsGuiLabel = new JLabel("");
    JLabel ascGuiLabel = new JLabel("");
    JLabel sqmGuiLabel = new JLabel("");
    private final JMenuItem consolleMenuItem = new JMenuItem("Consolle");
    private final JPopupMenu popupMenu = new JPopupMenu();

    static {
        combinedCooErrorPlots = new CombinedCooErrorPlots("Errors Plot");
        combinedLineColumnPlots = new CombinedLineColumnPlots("Plots Line & Column");
        historyPlot = new HistoryPlot();
        fileChooser = new JFileChooser();
        pmcDataInputForm = new DataInputForm("PMC");
        opcuaUtils = new OpcuaUtils();
        showAllImages = new ShowAllimages();
        crossReference1 = new int[]{-1, -1};
        crossReference2 = new int[]{-1, -1};
        areaReference = new int[]{-1, -1, -1, -1};
        plotMouseCoo = new int[]{-1, -1};
        nodesGridFrameTitle = "OPCUA node list";
        opcuaStartReadThread = false;
        opcuaShowNodeTypeOnGrid = 1;
        discoveryStartReadThread = false;
        rdBtnTelesc_0 = new JRadioButton("ASTRI.1");
        rdBtnTelesc_1 = new JRadioButton("ASTRI.2");
        rdBtnTelesc_2 = new JRadioButton("ASTRI.3");
        rdBtnTelesc_3 = new JRadioButton("ASTRI.4");
        rdBtnTelesc_4 = new JRadioButton("ASTRI.5");
        rdBtnTelesc_5 = new JRadioButton("ASTRI.6");
        rdBtnTelesc_6 = new JRadioButton("ASTRI.7");
        rdBtnTelesc_7 = new JRadioButton("ASTRI.8");
        rdBtnTelesc_8 = new JRadioButton("ASTRI.9");
        rdBtnTelesc = new JRadioButton[]{rdBtnTelesc_0, rdBtnTelesc_1, rdBtnTelesc_2, rdBtnTelesc_3, rdBtnTelesc_4, rdBtnTelesc_5, rdBtnTelesc_6, rdBtnTelesc_7, rdBtnTelesc_8};
        logger = Logger.getLogger(AIV_GUI.class);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AIV_GUI window = new AIV_GUI();
                    window.aivJFrame.setVisible(true);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
    }

    public void setOpcuaStartReadThread(boolean opcuaStartReadThread) {
        AIV_GUI.opcuaStartReadThread = opcuaStartReadThread;
    }

    public AIV_GUI() throws Exception {
        try {
            PropertyConfigurator.configure((String)"./conf/log4j.properties");
        }
        catch (Exception FileNotFoundException) {
            System.out.println("file log4j.properties not found..." + FileNotFoundException.getMessage());
        }
        Utils.getProperties();
        this.discoveryNodeThread.start();
        this.setEnableIcons(false);
        this.initialize();
    }

    private void setLabelsIcon() {
        this.closeAllLabel.setVerticalAlignment(3);
        this.closeAllLabel.setHorizontalAlignment(0);
        this.closeAllLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.endImageIcon));
        this.pmcGuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (pmcGUI == null) {
                    try {
                        AIV_GUI.writeOnInfoText("Wait opening PMCGui...", Color.green, true, false, false, true, 15);
                        if (pmcGUI == null) {
                            AIV_GUI.writeOnInfoText("\nWait.. opening PMCGui...");
                            pmcGUI = new PMCGUI();
                        } else {
                            pmcGUI.setVisible(true);
                        }
                    }
                    catch (Exception e1) {
                        AIV_GUI.writeOnInfoText("Error opening PMCGui..." + e1.getMessage(), Color.red, true, false, false, true, 15);
                        return;
                    }
                }
                AIV_GUI.pmcGUI.exitMenuItem.setEnabled(false);
                pmcGUI.setVisible(true);
            }
        });
        this.pmcGuiLabel.setVerticalAlignment(3);
        this.pmcGuiLabel.setHorizontalAlignment(0);
        this.pmcGuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.cameraIcon));
        this.mountGuiLabel.setVerticalAlignment(3);
        this.mountGuiLabel.setHorizontalAlignment(0);
        this.mountGuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.astri1Icon));
        this.mirror1GuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AIV_GUI.this.mirrorGui == null) {
                    AIV_GUI.writeOnInfoText("Wait.. opening MirrorGui...", Color.green, true, false, false, true, 15);
                    try {
                        AIV_GUI.this.mirrorGui = new MirrorGui();
                    }
                    catch (Exception e1) {
                        AIV_GUI.writeOnInfoText("Error opening MirrorGui..." + e1.getMessage(), Color.red, true, false, false, true, 15);
                        return;
                    }
                }
                AIV_GUI.this.mirrorGui.setVisible(true);
                AIV_GUI.this.mirrorGui.exitMenuItem.setEnabled(false);
            }
        });
        this.mirror1GuiLabel.setVerticalAlignment(3);
        this.mirror1GuiLabel.setHorizontalAlignment(0);
        this.mirror1GuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.mirror1Icon));
        this.mirror2GuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AIV_GUI.this.m2Gui == null) {
                    AIV_GUI.writeOnInfoText("Wait.. opening M2Gui...", Color.green, true, false, false, true, 15);
                    try {
                        AIV_GUI.this.m2Gui = new M2GUI(null);
                    }
                    catch (Exception e1) {
                        AIV_GUI.writeOnInfoText("Error opening M2Gui..." + e1.getMessage(), Color.red, true, false, false, true, 15);
                        return;
                    }
                }
                AIV_GUI.this.m2Gui.setVisible(true);
                AIV_GUI.this.m2Gui.exitMenuItem.setEnabled(false);
            }
        });
        this.mirror2GuiLabel.setVerticalAlignment(3);
        this.mirror2GuiLabel.setHorizontalAlignment(0);
        this.mirror2GuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.mirror2Icon));
        this.optiCamGuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AIV_GUI.this.ocCtrlsGUI == null) {
                    AIV_GUI.writeOnInfoText("Wait.. opening ocCtrlsGUI...", Color.green, true, false, false, true, 15);
                    try {
                        AIV_GUI.this.ocCtrlsGUI = new OCCtrlsGUI("OC");
                    }
                    catch (Exception e1) {
                        AIV_GUI.writeOnInfoText("Error opening ocCtrlsGUI..." + e1.getMessage(), Color.red, true, false, false, true, 15);
                        return;
                    }
                }
                AIV_GUI.this.ocCtrlsGUI.setVisible(true);
                AIV_GUI.this.ocCtrlsGUI.endMenuItem.setEnabled(false);
                AIV_GUI.this.ocCtrlsGUI.hideButton.setVisible(true);
            }
        });
        this.optiCamGuiLabel.setVerticalAlignment(3);
        this.optiCamGuiLabel.setHorizontalAlignment(0);
        this.optiCamGuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.optiCamIcon));
        this.wsGuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AIV_GUI.this.wsGUI == null) {
                    AIV_GUI.writeOnInfoText("Wait.. opening WS-GUI...", Color.green, true, false, false, true, 15);
                    AIV_GUI.this.wsGUI = new WSGUI("WS");
                }
                AIV_GUI.this.wsGUI.setVisible(true);
                AIV_GUI.this.wsGUI.exitButton.setVisible(false);
            }
        });
        this.wsGuiLabel.setVerticalAlignment(3);
        this.wsGuiLabel.setHorizontalAlignment(0);
        this.wsGuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.davisIcon));
        this.sqmGuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AIV_GUI.this.sqmGUI == null) {
                    AIV_GUI.writeOnInfoText("Wait.. opening SQM-GUI...", Color.green, true, false, false, true, 15);
                    AIV_GUI.this.sqmGUI = new SQMGUI("SQM");
                }
                AIV_GUI.this.sqmGUI.setVisible(true);
                AIV_GUI.this.sqmGUI.exitButton.setVisible(false);
            }
        });
        this.sqmGuiLabel.setVerticalAlignment(3);
        this.sqmGuiLabel.setHorizontalAlignment(0);
        this.sqmGuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.sqmIcon));
        this.ascGuiLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    URL where = new URL(Utils.allSkyUrlString);
                    ImageIcon allSkyIcon = new ImageIcon(where);
                    AIV_GUI.inserIconOnInfoText(500, allSkyIcon);
                }
                catch (MalformedURLException e1) {
                    AIV_GUI.writeOnInfoText("All Sky Image error.." + e1.getMessage());
                }
            }
        });
        this.ascGuiLabel.setVerticalAlignment(3);
        this.ascGuiLabel.setHorizontalAlignment(0);
        this.ascGuiLabel.setIcon(AIV_GUI.getResizedImage(80, Utils.ascIcon));
    }

    private void initialize() throws Exception {
        this.setLabelsIcon();
        this.aivJFrame = new JFrame();
        this.aivJFrame.getContentPane().setFont(new Font("SansSerif", 1, 10));
        this.aivJFrame.setFont(new Font("Dialog", 1, 11));
        this.aivJFrame.getContentPane().setBounds(new Rectangle(0, 50, 0, 0));
        this.aivJFrame.getContentPane().setBackground(new Color(245, 222, 179));
        this.aivJFrame.setIconImage(Utils.astri1Icon.getImage());
        this.aivJFrame.setResizable(false);
        this.aivJFrame.setTitle("AIV_GUI - v0.8 - PBr141122 for ASTRI-MiniArray Project ");
        this.aivJFrame.setForeground(new Color(245, 222, 179));
        this.aivJFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AIV_GUI.this.thatsAllFolks();
                AIV_GUI.this.threadEnd.start();
            }
        });
        this.aivJFrame.setBounds(100, 100, 938, 562);
        this.aivJFrame.setDefaultCloseOperation(0);
        this.xyPointDispersion.setVisible(false);
        this.aivJFrame.getContentPane().setLayout(null);
        this.scrollPane_2.setBounds(117, 240, 801, 256);
        this.aivJFrame.getContentPane().add(this.scrollPane_2);
        infoText.setText("Please, select a telescope..");
        infoText.setLocation(296, 0);
        infoText.setToolTipText("InfoArea ");
        infoText.setBackground(new Color(255, 255, 240));
        this.scrollPane_2.setViewportView(infoText);
        AIV_GUI.addPopup(infoText, this.popupMenu);
        JMenuItem clearLineMenuItem_1 = new JMenuItem("ClearLine");
        clearLineMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    try {
                        Element root = infoText.getDocument().getDefaultRootElement();
                        Element firstLine = root.getElement(0);
                        infoText.getDocument().remove(firstLine.getStartOffset(), firstLine.getEndOffset());
                    }
                    catch (BadLocationException e1) {
                        System.out.println("AIV_GUI warning: " + e1.getMessage());
                    }
                }
            }
        });
        this.popupMenu.add(clearLineMenuItem_1);
        JMenuItem clearAllMenuItem = new JMenuItem("ClearAll");
        clearAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    infoText.setText("");
                }
            }
        });
        this.popupMenu.add(clearAllMenuItem);
        this.inplementPmcRadioButtonGroup();
        JMenuBar menuBar = new JMenuBar();
        this.aivJFrame.setJMenuBar(menuBar);
        Image newimg = Utils.tazImage.getImage().getScaledInstance(20, 20, 4);
        this.tazLabel.setIcon(new ImageIcon(newimg));
        menuBar.add(this.tazLabel);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    AIV_GUI.this.thatsAllFolks();
                    AIV_GUI.this.threadEnd.start();
                }
            }
        });
        JSeparator separator = new JSeparator();
        fileMenu.add(separator);
        JSeparator separator_1 = new JSeparator();
        fileMenu.add(separator_1);
        this.propsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    Utils.showPropOnGuis();
                }
            }
        });
        fileMenu.add(this.propsMenuItem);
        JMenuItem ldsMenuItem = new JMenuItem("LDServer");
        ldsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    try {
                        Utils.showDiscoverServerNodes(Utils.discoveryServerUrl);
                        discoveryStartReadThread = true;
                    }
                    catch (ServerListException | IOException | InterruptedException throwable) {
                        // empty catch block
                    }
                }
            }
        });
        fileMenu.add(ldsMenuItem);
        JMenuItem mntmNewMenuItem = new JMenuItem("showIcons");
        fileMenu.add(mntmNewMenuItem);
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
                    AIV_GUI.inserIconOnInfoText(20, Utils.badImageIcon);
                    AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
                    AIV_GUI.inserIconOnInfoText(20, Utils.endImageIcon);
                    AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
                    AIV_GUI.inserIconOnInfoText(20, Utils.goodImageIcon);
                    AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
                    AIV_GUI.inserIconOnInfoText(20, Utils.joyImageIcon);
                    AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
                    AIV_GUI.inserIconOnInfoText(20, Utils.thinkImageIcon);
                    AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
                    AIV_GUI.inserIconOnInfoText(20, Utils.happyImageIcon);
                    AIV_GUI.writeOnInfoText("\n");
                }
            }
        });
        this.consolleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    consolle.setVisible(true);
                }
            }
        });
        fileMenu.add(this.consolleMenuItem);
        this.exitMenuItem.setActionCommand("Exit");
        fileMenu.add(this.exitMenuItem);
    }

    public void assignNewTelescopeNumber(int indx) {
        this.setEnableIcons(true);
        try {
            AIV_GUI.writeOnInfoText("Selected Telescope ASTRI_" + (indx + 1) + "\n");
            if (pmcGUI != null) {
                PMCGUI.workOpcuaClient.stopClient();
                pmcGUI.setVisible(false);
                pmcGUI.dispose();
                pmcGUI = new PMCGUI();
                pmcGUI.setVisible(true);
                AIV_GUI.pmcGUI.exitMenuItem.setEnabled(false);
                pmcGUI.assignNewOpcuaClientToWorkArea(indx);
            }
            if (this.ocCtrlsGUI != null) {
                PMCGUI.workOpcuaClient.stopClient();
                pmcGUI.setVisible(false);
                pmcGUI.dispose();
                pmcGUI = new PMCGUI();
                pmcGUI.setVisible(true);
                AIV_GUI.pmcGUI.exitMenuItem.setEnabled(false);
                pmcGUI.assignNewOpcuaClientToWorkArea(indx);
            }
            Utils.telescopeNumber = indx + 1;
            Utils.saveProperties("telescopeNumber", String.valueOf(Utils.telescopeNumber));
        }
        catch (Exception e) {
            AIV_GUI.writeOnInfoText(String.valueOf(e.getMessage()) + "\n");
        }
    }

    private void inplementPmcRadioButtonGroup() {
        this.panel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "SelectTelescope", 2, 2, null, new Color(0, 0, 0)));
        this.panel.setBounds(10, 240, 97, 250);
        this.panel.setBackground(Color.ORANGE);
        this.aivJFrame.getContentPane().add(this.panel);
        rdBtnTelesc_0.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_0.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_0.setAlignmentX(0.5f);
        rdBtnTelesc_0.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_0.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_0.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_0.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(0);
                }
            }
        });
        rdBtnTelesc_0.setBackground(Color.ORANGE);
        rdBtnTelesc_0.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_0);
        rdBtnTelesc_1.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_1.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_1.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_1.setAlignmentX(0.5f);
        rdBtnTelesc_1.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_1.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(1);
                }
            }
        });
        rdBtnTelesc_1.setBackground(Color.ORANGE);
        rdBtnTelesc_1.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_1);
        rdBtnTelesc_2.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_2.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_2.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_2.setAlignmentX(0.5f);
        rdBtnTelesc_2.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_2.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(2);
                }
            }
        });
        rdBtnTelesc_2.setBackground(Color.ORANGE);
        rdBtnTelesc_2.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_2);
        rdBtnTelesc_3.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_3.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_3.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_3.setAlignmentX(0.5f);
        rdBtnTelesc_3.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_3.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(3);
                }
            }
        });
        rdBtnTelesc_3.setBackground(Color.ORANGE);
        rdBtnTelesc_3.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_3);
        rdBtnTelesc_4.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_4.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_4.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_4.setAlignmentX(0.5f);
        rdBtnTelesc_4.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_4.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(4);
                }
            }
        });
        rdBtnTelesc_4.setBackground(Color.ORANGE);
        rdBtnTelesc_4.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_4);
        rdBtnTelesc_5.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_5.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_5.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_5.setAlignmentX(0.5f);
        rdBtnTelesc_5.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_5.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(5);
                }
            }
        });
        rdBtnTelesc_5.setBackground(Color.ORANGE);
        rdBtnTelesc_5.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_5);
        rdBtnTelesc_6.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_6.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_6.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_6.setAlignmentX(0.5f);
        rdBtnTelesc_6.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_6.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(6);
                }
            }
        });
        rdBtnTelesc_6.setBackground(Color.ORANGE);
        rdBtnTelesc_6.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_6);
        rdBtnTelesc_7.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_7.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_7.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_7.setAlignmentX(0.5f);
        rdBtnTelesc_7.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_7.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(7);
                }
            }
        });
        rdBtnTelesc_7.setBackground(Color.ORANGE);
        rdBtnTelesc_7.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_7);
        rdBtnTelesc_8.setFont(new Font("Dialog", 1, 11));
        rdBtnTelesc_8.setMinimumSize(new Dimension(75, 28));
        rdBtnTelesc_8.setMaximumSize(new Dimension(75, 28));
        rdBtnTelesc_8.setAlignmentX(0.5f);
        rdBtnTelesc_8.setPreferredSize(new Dimension(72, 20));
        rdBtnTelesc_8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (rdBtnTelesc_8.isSelected()) {
                    AIV_GUI.this.assignNewTelescopeNumber(8);
                }
            }
        });
        rdBtnTelesc_8.setBackground(Color.ORANGE);
        rdBtnTelesc_8.setHorizontalAlignment(2);
        this.panel.add(rdBtnTelesc_8);
        this.telescRadioGroup.add(rdBtnTelesc_0);
        this.telescRadioGroup.add(rdBtnTelesc_1);
        this.telescRadioGroup.add(rdBtnTelesc_2);
        this.telescRadioGroup.add(rdBtnTelesc_3);
        this.telescRadioGroup.add(rdBtnTelesc_4);
        this.telescRadioGroup.add(rdBtnTelesc_5);
        this.telescRadioGroup.add(rdBtnTelesc_6);
        this.telescRadioGroup.add(rdBtnTelesc_7);
        this.telescRadioGroup.add(rdBtnTelesc_8);
        this.mirror1GuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "M1_Gui", 2, 1, null, new Color(0, 0, 255)));
        this.mirror1GuiLabel.setToolTipText("MirrorGUI");
        this.mirror1GuiLabel.setBounds(19, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.mirror1GuiLabel);
        this.optiCamGuiLabel.setToolTipText("MountGUI");
        this.optiCamGuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "OptiCamGui", 2, 1, null, new Color(0, 0, 255)));
        this.optiCamGuiLabel.setBounds(277, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.optiCamGuiLabel);
        this.wsGuiLabel.setToolTipText("MountGUI");
        this.wsGuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "WSGui", 2, 1, null, new Color(0, 0, 255)));
        this.wsGuiLabel.setBounds(664, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.wsGuiLabel);
        this.pmcGuiLabel.setToolTipText("MountGUI");
        this.pmcGuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "PMCGui", 2, 1, null, new Color(0, 0, 255)));
        this.pmcGuiLabel.setBounds(406, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.pmcGuiLabel);
        this.mountGuiLabel.setToolTipText("MountGUI");
        this.mountGuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "MountGui", 2, 1, null, new Color(0, 0, 255)));
        this.mountGuiLabel.setBounds(535, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.mountGuiLabel);
        this.closeAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AIV_GUI.this.thatsAllFolks();
            }
        });
        this.closeAllLabel.setToolTipText("END");
        this.closeAllLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "CloseAll", 2, 1, null, new Color(0, 0, 255)));
        this.closeAllLabel.setBounds(793, 118, 110, 110);
        this.aivJFrame.getContentPane().add(this.closeAllLabel);
        this.mirror2GuiLabel.setToolTipText("MirrorGUI");
        this.mirror2GuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "M2_Gui", 2, 1, null, new Color(0, 0, 255)));
        this.mirror2GuiLabel.setBounds(148, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.mirror2GuiLabel);
        this.sqmGuiLabel.setToolTipText("SQMGUI");
        this.sqmGuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "SQMGui", 2, 1, null, new Color(0, 0, 255)));
        this.sqmGuiLabel.setBounds(793, 11, 110, 110);
        this.aivJFrame.getContentPane().add(this.sqmGuiLabel);
        this.ascGuiLabel.setVerticalAlignment(3);
        this.ascGuiLabel.setToolTipText("All Sky Camare GUI");
        this.ascGuiLabel.setHorizontalAlignment(0);
        this.ascGuiLabel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "ASCGui", 2, 1, null, new Color(0, 0, 255)));
        this.ascGuiLabel.setBounds(19, 118, 110, 110);
        this.aivJFrame.getContentPane().add(this.ascGuiLabel);
    }

    public void writeOnInfoArea1(String string) {
        AIV_GUI.writeOnInfoText(string);
        AIV_GUI.writeOnInfoText("testo di prova \n");
        AIV_GUI.writeOnInfoText("testo di prova \n", Color.red, true, false, true, true, 0);
    }

    public static void writeOnInfoText(String txtMsg) {
        if (txtMsg == null) {
            return;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("HH:mm:ss");
        Date time = new Date();
        infoText.getDocument().getLength();
        System.out.println(txtMsg);
        try {
            if (!txtMsg.contains("\n")) {
                infoText.getStyledDocument().insertString(infoText.getStyledDocument().getLength(), String.valueOf(txtMsg) + " ", null);
            } else {
                infoText.getStyledDocument().insertString(infoText.getStyledDocument().getLength(), String.valueOf(txtMsg) + sdfDate.format(time) + ">", null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        infoTextLineNumbers = AIV_GUI.countOccurence(infoText.getText(), "\n");
        infoText.setCaretPosition(infoText.getDocument().getLength());
    }

    public static void writeOnInfoText(String txtMsg, Color color, boolean bold, boolean italic, boolean undeline, boolean hiLight, int charDim) {
        if (txtMsg == null) {
            return;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("HH:mm:ss");
        Date time = new Date();
        System.out.println(txtMsg);
        Color frgCol = infoText.getForeground();
        Color bckCol = infoText.getBackground();
        int chdim = infoText.getFont().getSize();
        StyledDocument doc = infoText.getStyledDocument();
        Style style = infoText.addStyle("I'm a Style", null);
        if (color != null) {
            StyleConstants.setForeground(style, color);
        }
        if (charDim > 0) {
            StyleConstants.setFontSize(style, charDim);
        }
        StyleConstants.setBold(style, bold);
        StyleConstants.setUnderline(style, undeline);
        StyleConstants.setItalic(style, italic);
        if (hiLight) {
            StyleConstants.setBackground(style, Color.yellow);
        }
        try {
            doc.insertString(doc.getLength(), txtMsg, style);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        StyleConstants.setBackground(style, bckCol);
        StyleConstants.setForeground(style, frgCol);
        StyleConstants.setBold(style, false);
        StyleConstants.setUnderline(style, false);
        StyleConstants.setItalic(style, false);
        StyleConstants.setFontSize(style, chdim);
        try {
            if (!txtMsg.contains("\n")) {
                doc.insertString(doc.getLength(), " ", style);
            } else {
                doc.insertString(doc.getLength(), String.valueOf(sdfDate.format(time)) + ">", style);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        infoTextLineNumbers = AIV_GUI.countOccurence(infoText.getText(), "\n");
        infoText.setCaretPosition(infoText.getDocument().getLength());
    }

    public static void inserIconOnInfoText(int dim, ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(dim, dim, 4);
        imageIcon = new ImageIcon(newimg);
        infoText.insertIcon(imageIcon);
    }

    public static ImageIcon getResizedImage(int dim, ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(dim, dim, 4);
        imageIcon = new ImageIcon(newimg);
        return imageIcon;
    }

    public static int countOccurence(String str, String find) {
        int index = 0;
        int count = 0;
        if (str == null) {
            return 0;
        }
        while ((index = str.indexOf(find, index)) != -1) {
            index += find.length();
            ++count;
        }
        return count;
    }

    private void thatsAllFolks() {
        AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
        AIV_GUI.inserIconOnInfoText(200, Utils.endImageIcon);
        AIV_GUI.writeOnInfoText(".........      ", Color.GREEN, true, false, false, false, 20);
        this.aivJFrame.repaint();
        this.threadEnd.start();
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private void setEnableIcons(boolean bEn) {
        this.mirror1GuiLabel.setEnabled(bEn);
        this.mirror2GuiLabel.setEnabled(bEn);
        this.pmcGuiLabel.setEnabled(bEn);
        this.mountGuiLabel.setEnabled(bEn);
    }
}

