/*
 * Decompiled with CFR 0.152.
 */
package ctrl;

import ctrl.CreateRoundButton;
import ctrl.StandaUtils;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import myproc.Utils;
import ru.ximc.libximc.JXimc;

public class StandaGui
extends JFrame {
    public static JTextField enterStepValueField;
    public static JLabel deviceNameLabel;
    public static JLabel opcuaNameLabel;
    private String deviceCode = "OC\t";
    public JTextField inputdeviceLabel = new JTextField();
    public JLabel outputInfoLabel = new JLabel("--------");
    public JTextArea infoTextArea = new JTextArea();
    public static JXimc.extio_settings_t externalIO;
    public static JXimc.brake_settings_t brakeSetting;
    public static JCheckBox stoptLeftCheckBox;
    public static JCheckBox stopRightCheckBox;
    public ButtonGroup moveRadioGroup = new ButtonGroup();
    public JRadioButton absoluteRadioButton = new JRadioButton("Abs");
    public JRadioButton relativeRadioButton = new JRadioButton("Rel");
    public JRadioButton jogRadioButton = new JRadioButton("Jog");
    public boolean gotoLeftHome = true;
    public JLabel temperatureLabel = new JLabel("Temp:");
    public int standaDevice;
    public boolean startReadThread = false;
    public int currentPos;
    public int currentUPos;
    public JXimc.edges_settings_t edgeStructure = null;
    public JXimc.status_t stateStructure = null;
    public JXimc.engine_settings_t engineStructure = null;
    private Thread ReadThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (!StandaGui.this.startReadThread) {
                            Thread.sleep(300L);
                            continue;
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        StandaGui.this.stateStructure = JXimc.get_status((int)StandaGui.this.standaDevice);
                        StandaGui.this.edgeStructure = JXimc.get_edges_settings((int)StandaGui.this.standaDevice);
                        externalIO = JXimc.get_extio_settings((int)StandaGui.this.standaDevice);
                        StandaGui.this.outputInfoLabel.setText("CurPos=" + StandaGui.this.stateStructure.CurPosition + " uCurPos=" + StandaGui.this.stateStructure.uCurPosition + "  MvCmdSts=" + StandaGui.this.stateStructure.MvCmdSts + "  MoveSts=" + StandaGui.this.stateStructure.MoveSts + "  Flags=" + StandaGui.this.stateStructure.Flags + "  CurT=" + StandaGui.this.stateStructure.CurT + "  GPIO=" + StandaGui.this.stateStructure.GPIOFlags);
                        StandaGui.this.currentPos = StandaGui.this.stateStructure.CurPosition;
                        StandaGui.this.currentUPos = StandaGui.this.stateStructure.uCurPosition;
                        StandaUtils.switchRightStatus = (StandaGui.this.stateStructure.GPIOFlags & 1) == 1;
                        StandaUtils.switchLeftStatus = (StandaGui.this.stateStructure.GPIOFlags & 2) == 2;
                        StandaUtils.runningStatus = (StandaGui.this.stateStructure.MvCmdSts & 0x80) == 128;
                        StandaUtils.moveErrorStatus = (StandaGui.this.stateStructure.MvCmdSts & 0x40) == 64;
                        StandaUtils.alarmStatus = (StandaGui.this.stateStructure.Flags & 0x40) == 64;
                        StandaGui.this.infoTextArea.setText("Pos= " + StandaGui.this.stateStructure.CurPosition + "  uPos= " + StandaGui.this.stateStructure.uCurPosition);
                        StandaGui.this.infoTextArea.append("\nSpeed= " + StandaGui.this.stateStructure.CurSpeed + "  uSpd= " + StandaGui.this.stateStructure.uCurSpeed);
                        StandaGui.this.infoTextArea.append("\nRunning=" + StandaUtils.runningStatus + "  mvErr= " + StandaUtils.moveErrorStatus);
                        StandaGui.this.infoTextArea.append("\nALARM= " + StandaUtils.alarmStatus);
                        StandaGui.this.infoTextArea.append("\n\nmovingRightStatus=" + StandaUtils.movingRightStatus);
                        StandaGui.this.infoTextArea.append("\nswitchRightStatus=" + StandaUtils.switchRightStatus);
                        StandaUtils.movingLeftStatus = (StandaGui.this.stateStructure.MvCmdSts & 3) == 3;
                        StandaUtils.movingRightStatus = (StandaGui.this.stateStructure.MvCmdSts & 4) == 4;
                        StandaGui.this.infoTextArea.append("\n\nmovingLeftStatus=" + StandaUtils.movingLeftStatus);
                        StandaGui.this.infoTextArea.append("\nswitchLeftStatus=" + StandaUtils.switchLeftStatus);
                        StandaUtils.stopBorderLeft = (StandaGui.this.edgeStructure.BorderFlags & 2) == 2;
                        StandaUtils.stopBorderRight = (StandaGui.this.edgeStructure.BorderFlags & 4) == 4;
                        StandaGui.this.infoTextArea.append("\n\nStopBorderLeft=" + StandaUtils.stopBorderLeft);
                        StandaGui.this.infoTextArea.append("\nStopBorderRight=" + StandaUtils.stopBorderRight);
                        brakeSetting = JXimc.get_brake_settings((int)StandaGui.this.standaDevice);
                        if (StandaGui.brakeSetting.BrakeFlags == 1) {
                            StandaGui.this.infoTextArea.append("\n\nBrakeStatus= IN");
                        } else {
                            StandaGui.this.infoTextArea.append("\n\nBrakeStatus= OUT");
                        }
                        float fTmp = StandaGui.this.stateStructure.CurT;
                        StandaGui.this.temperatureLabel.setText("Temp: " + fTmp / 10.0f);
                    }
                }
                catch (Exception e) {
                    StandaGui.this.outputInfoLabel.setText("Exception: " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    };
    private final JButton exitButton = new JButton("EXIT");
    private JTextField enterMicroStepValueField;
    private JTextField enterSpeedTextField;
    private JTextField enterUSpeedTextField;
    public boolean startHomeThread = false;
    private Thread HomeThread = new Thread(){

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (!StandaGui.this.startHomeThread) {
                        Thread.sleep(300L);
                    }
                    JXimc.home_settings_t homeStructure = JXimc.get_home_settings((int)StandaGui.this.standaDevice);
                    int spd = StandaGui.this.getSpeed(StandaGui.this.standaDevice) / 10;
                    byte uSpd = (byte)(StandaGui.this.getUSpeed(StandaGui.this.standaDevice) / 10);
                    homeStructure.FastHome = spd;
                    homeStructure.uFastHome = uSpd;
                    JXimc.set_home_settings((int)StandaGui.this.standaDevice, (JXimc.home_settings_t)homeStructure);
                    boolean HOME_DIR_FIRST = true;
                    homeStructure.HomeFlags = (short)(homeStructure.HomeFlags & 0xFFFFFFFE);
                    homeStructure.HomeDelta = 0;
                    int signDir = 1;
                    if (StandaGui.this.gotoLeftHome) {
                        homeStructure.HomeFlags = (short)(homeStructure.HomeFlags & 0xFFFFFFFE);
                    } else {
                        homeStructure.HomeFlags = (short)(homeStructure.HomeFlags | 1);
                        signDir = -1;
                    }
                    JXimc.set_home_settings((int)StandaGui.this.standaDevice, (JXimc.home_settings_t)homeStructure);
                    JXimc.command_movr((int)StandaGui.this.standaDevice, (int)(-1000000 * signDir), (short)0);
                    JXimc.command_wait_for_stop((int)StandaGui.this.standaDevice, (int)300);
                    JXimc.command_zero((int)StandaGui.this.standaDevice);
                    JXimc.command_movr((int)StandaGui.this.standaDevice, (int)(200 * signDir), (short)0);
                    JXimc.command_wait_for_stop((int)StandaGui.this.standaDevice, (int)300);
                    JXimc.command_zero((int)StandaGui.this.standaDevice);
                    JXimc.command_home((int)StandaGui.this.standaDevice);
                    JXimc.command_wait_for_stop((int)StandaGui.this.standaDevice, (int)300);
                    JXimc.command_zero((int)StandaGui.this.standaDevice);
                }
                catch (Exception e) {
                    StandaGui.this.outputInfoLabel.setText("Exception: " + e.getMessage());
                }
                StandaGui.this.startHomeThread = false;
            }
        }
    };

    static {
        deviceNameLabel = new JLabel("DeviceName:");
        opcuaNameLabel = new JLabel("Steps");
        stoptLeftCheckBox = new JCheckBox("Left");
        stopRightCheckBox = new JCheckBox("Right");
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StandaGui window = new StandaGui("");
                    window.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public StandaGui(String deviceCode) {
        this.setIconImage(Utils.standaIcon.getImage());
        this.setDeviceCode(deviceCode);
        this.initialize();
    }

    public void closeDevice() {
        System.out.println("Closing device");
        this.startReadThread = false;
        try {
            if (this.standaDevice != -1) {
                JXimc.close_device((int)this.standaDevice);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initLibrary() {
        String jniName = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "libjximc" : "jximc";
        System.out.println(System.getProperty("java.library.path"));
        System.loadLibrary("bindy");
        System.loadLibrary("xiwrapper");
        System.loadLibrary("libximc");
        System.loadLibrary(jniName);
        JXimc.set_bindy_key((String)"keyfile.sqlite");
    }

    private void initialize() {
        this.initLibrary();
        this.ReadThread.start();
        this.HomeThread.start();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                deviceNameLabel.setText("Ciao....");
                StandaGui.this.setVisible(false);
            }
        });
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        this.setTitle("StandaGui");
        this.setResizable(false);
        this.getContentPane().setBackground(Color.LIGHT_GRAY);
        this.setBounds(100, 100, 615, 364);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(null);
        deviceNameLabel.setHorizontalAlignment(0);
        deviceNameLabel.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel.setBounds(6, 6, 102, 25);
        deviceNameLabel.setForeground(Color.BLUE);
        this.getContentPane().add(deviceNameLabel);
        enterStepValueField = new JTextField();
        enterStepValueField.setText("0");
        enterStepValueField.setHorizontalAlignment(0);
        enterStepValueField.setFont(new Font("Tahoma", 1, 12));
        enterStepValueField.setBackground(new Color(255, 255, 230));
        enterStepValueField.setBounds(65, 61, 50, 26);
        this.getContentPane().add(enterStepValueField);
        enterStepValueField.setColumns(10);
        JButton openButton = new JButton("Open");
        openButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StandaGui.this.standaDevice = JXimc.open_device((String)StandaGui.this.inputdeviceLabel.getText().trim());
                System.out.println("deviceName=" + StandaGui.this.inputdeviceLabel.getText().trim() + "  " + StandaGui.this.standaDevice);
                if (StandaGui.this.standaDevice == -1) {
                    StandaGui.this.infoTextArea.setText("Cannot open a device");
                }
                StandaGui.this.viewStopBorder();
                StandaGui.this.startReadThread = true;
                StandaGui.this.getMotorCalibration();
            }
        });
        openButton.setForeground(Color.BLUE);
        openButton.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel.setLabelFor(openButton);
        openButton.setBackground(new Color(50, 205, 50));
        openButton.setBounds(512, 5, 83, 28);
        this.getContentPane().add(openButton);
        JButton leftVersusButton = new JButton("<");
        leftVersusButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StandaGui.this.standaDevice == -1) {
                    StandaGui.this.outputInfoLabel.setText(" sorry NO device is OPEN ");
                    return;
                }
                if (StandaGui.this.jogRadioButton.isSelected()) {
                    JXimc.command_left((int)StandaGui.this.standaDevice);
                    return;
                }
                int nSteps = Integer.parseInt(enterStepValueField.getText().trim());
                int nUSteps = Integer.parseInt(StandaGui.this.enterMicroStepValueField.getText().trim());
                if (StandaGui.this.relativeRadioButton.isSelected()) {
                    JXimc.command_movr((int)StandaGui.this.standaDevice, (int)(-nSteps), (short)((short)(-nUSteps)));
                    return;
                }
                if (StandaGui.this.absoluteRadioButton.isSelected()) {
                    JXimc.command_move((int)StandaGui.this.standaDevice, (int)nSteps, (short)((short)nUSteps));
                    return;
                }
            }
        });
        leftVersusButton.setForeground(new Color(0, 0, 0));
        leftVersusButton.setFont(new Font("Tahoma", 1, 14));
        leftVersusButton.setBackground(Color.LIGHT_GRAY);
        leftVersusButton.setBounds(16, 61, 50, 26);
        this.getContentPane().add(leftVersusButton);
        opcuaNameLabel.setBackground(Color.YELLOW);
        opcuaNameLabel.setHorizontalAlignment(0);
        opcuaNameLabel.setForeground(Color.BLACK);
        opcuaNameLabel.setFont(new Font("Tahoma", 1, 12));
        opcuaNameLabel.setBounds(65, 41, 50, 25);
        this.getContentPane().add(opcuaNameLabel);
        JButton closeButton = new JButton("Close");
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StandaGui.this.closeDevice();
            }
        });
        closeButton.setForeground(Color.BLUE);
        closeButton.setFont(new Font("Tahoma", 1, 12));
        closeButton.setBackground(Color.ORANGE);
        closeButton.setBounds(512, 32, 83, 28);
        this.getContentPane().add(closeButton);
        this.inputdeviceLabel.setText("xi-com:\\\\.\\COM14");
        this.inputdeviceLabel.setHorizontalAlignment(0);
        this.inputdeviceLabel.setFont(new Font("Tahoma", 1, 12));
        this.inputdeviceLabel.setColumns(10);
        this.inputdeviceLabel.setBackground(new Color(255, 255, 230));
        this.inputdeviceLabel.setBounds(101, 4, 173, 24);
        this.getContentPane().add(this.inputdeviceLabel);
        this.outputInfoLabel.setHorizontalAlignment(0);
        this.outputInfoLabel.setForeground(Color.BLACK);
        this.outputInfoLabel.setFont(new Font("Tahoma", 1, 11));
        this.outputInfoLabel.setBackground(Color.YELLOW);
        this.outputInfoLabel.setBounds(6, 265, 589, 25);
        this.getContentPane().add(this.outputInfoLabel);
        JButton rightVersusButton = new JButton(">");
        rightVersusButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StandaGui.this.standaDevice == -1) {
                    StandaGui.this.outputInfoLabel.setText(" sorry NO device is OPEN ");
                    return;
                }
                if (StandaGui.this.jogRadioButton.isSelected()) {
                    JXimc.command_right((int)StandaGui.this.standaDevice);
                    return;
                }
                int nSteps = Integer.parseInt(enterStepValueField.getText().trim());
                int nUSteps = Integer.parseInt(StandaGui.this.enterMicroStepValueField.getText().trim());
                if (StandaGui.this.relativeRadioButton.isSelected()) {
                    JXimc.command_movr((int)StandaGui.this.standaDevice, (int)nSteps, (short)((short)nUSteps));
                    return;
                }
                if (StandaGui.this.absoluteRadioButton.isSelected()) {
                    JXimc.command_move((int)StandaGui.this.standaDevice, (int)nSteps, (short)((short)nUSteps));
                    return;
                }
            }
        });
        rightVersusButton.setForeground(Color.BLACK);
        rightVersusButton.setFont(new Font("Tahoma", 1, 14));
        rightVersusButton.setBackground(Color.LIGHT_GRAY);
        rightVersusButton.setBounds(163, 61, 50, 26);
        this.getContentPane().add(rightVersusButton);
        this.enterMicroStepValueField = new JTextField();
        this.enterMicroStepValueField.setText("0");
        this.enterMicroStepValueField.setHorizontalAlignment(0);
        this.enterMicroStepValueField.setFont(new Font("Tahoma", 1, 12));
        this.enterMicroStepValueField.setColumns(10);
        this.enterMicroStepValueField.setBackground(new Color(255, 255, 230));
        this.enterMicroStepValueField.setBounds(115, 61, 50, 26);
        this.getContentPane().add(this.enterMicroStepValueField);
        JLabel lblUsteps = new JLabel("uSteps");
        lblUsteps.setHorizontalAlignment(0);
        lblUsteps.setForeground(Color.BLACK);
        lblUsteps.setFont(new Font("Tahoma", 1, 10));
        lblUsteps.setBackground(Color.YELLOW);
        lblUsteps.setBounds(111, 42, 50, 25);
        this.getContentPane().add(lblUsteps);
        JScrollPane infoScrollPane = new JScrollPane();
        infoScrollPane.setBounds(286, 7, 197, 250);
        this.getContentPane().add(infoScrollPane);
        this.infoTextArea.setText(">");
        this.infoTextArea.setForeground(Color.BLUE);
        this.infoTextArea.setBackground(SystemColor.control);
        infoScrollPane.setViewportView(this.infoTextArea);
        JLabel lblExtio = new JLabel("Stop@Border::");
        lblExtio.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        lblExtio.setHorizontalAlignment(2);
        lblExtio.setForeground(Color.BLACK);
        lblExtio.setFont(new Font("Tahoma", 1, 12));
        lblExtio.setBackground(Color.YELLOW);
        lblExtio.setBounds(8, 112, 93, 26);
        this.getContentPane().add(lblExtio);
        JLabel lblBrake = new JLabel("Brake");
        lblBrake.setHorizontalAlignment(0);
        lblBrake.setForeground(Color.BLACK);
        lblBrake.setFont(new Font("Tahoma", 1, 12));
        lblBrake.setBackground(Color.YELLOW);
        lblBrake.setBounds(88, 138, 102, 26);
        this.getContentPane().add(lblBrake);
        JButton brakeOutButton = new JButton("Out");
        brakeOutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                brakeSetting = JXimc.get_brake_settings((int)StandaGui.this.standaDevice);
                StandaGui.brakeSetting.BrakeFlags = 0;
                JXimc.set_brake_settings((int)StandaGui.this.standaDevice, (JXimc.brake_settings_t)brakeSetting);
            }
        });
        brakeOutButton.setForeground(Color.BLACK);
        brakeOutButton.setFont(new Font("Tahoma", 1, 12));
        brakeOutButton.setBackground(Color.LIGHT_GRAY);
        brakeOutButton.setBounds(76, 160, 62, 26);
        this.getContentPane().add(brakeOutButton);
        JButton brakeInButton = new JButton("In");
        brakeInButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                brakeSetting = JXimc.get_brake_settings((int)StandaGui.this.standaDevice);
                StandaGui.brakeSetting.BrakeFlags = 1;
                JXimc.set_brake_settings((int)StandaGui.this.standaDevice, (JXimc.brake_settings_t)brakeSetting);
            }
        });
        brakeInButton.setForeground(Color.BLACK);
        brakeInButton.setFont(new Font("Tahoma", 1, 12));
        brakeInButton.setBackground(Color.LIGHT_GRAY);
        brakeInButton.setBounds(138, 160, 62, 26);
        this.getContentPane().add(brakeInButton);
        CreateRoundButton stopButton = new CreateRoundButton("STOP");
        stopButton.setBorder(new BevelBorder(1, null, null, null, null));
        stopButton.setAlignmentX(0.5f);
        stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JXimc.command_sstp((int)StandaGui.this.standaDevice);
            }
        });
        stopButton.setForeground(Color.BLUE);
        stopButton.setFont(new Font("Tahoma", 1, 12));
        stopButton.setBackground(Color.RED);
        stopButton.setBounds(512, 212, 83, 30);
        this.getContentPane().add(stopButton);
        JButton setZeroButton = new JButton("SetZero");
        setZeroButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StandaGui.this.standaDevice == -1) {
                    StandaGui.this.outputInfoLabel.setText(" sorry NO device is OPEN ");
                    return;
                }
                JXimc.command_zero((int)StandaGui.this.standaDevice);
            }
        });
        setZeroButton.setForeground(Color.BLUE);
        setZeroButton.setFont(new Font("Tahoma", 1, 12));
        setZeroButton.setBackground(Color.ORANGE);
        setZeroButton.setBounds(512, 87, 81, 23);
        this.getContentPane().add(setZeroButton);
        stoptLeftCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JXimc.edges_settings_t edgeStructure = JXimc.get_edges_settings((int)StandaGui.this.standaDevice);
                edgeStructure.BorderFlags = stoptLeftCheckBox.isSelected() ? (byte)(edgeStructure.BorderFlags | 2) : (byte)(edgeStructure.BorderFlags & 0xFFFFFFFD);
                JXimc.set_edges_settings((int)StandaGui.this.standaDevice, (JXimc.edges_settings_t)edgeStructure);
            }
        });
        stoptLeftCheckBox.setBounds(98, 116, 50, 18);
        this.getContentPane().add(stoptLeftCheckBox);
        stopRightCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JXimc.edges_settings_t edgeStructure = JXimc.get_edges_settings((int)StandaGui.this.standaDevice);
                edgeStructure.BorderFlags = stopRightCheckBox.isSelected() ? (byte)(edgeStructure.BorderFlags | 4) : (byte)(edgeStructure.BorderFlags & 0xFFFFFFFB);
                JXimc.set_edges_settings((int)StandaGui.this.standaDevice, (JXimc.edges_settings_t)edgeStructure);
            }
        });
        stopRightCheckBox.setBounds(153, 116, 60, 18);
        this.getContentPane().add(stopRightCheckBox);
        this.moveRadioGroup.add(this.jogRadioButton);
        this.moveRadioGroup.add(this.relativeRadioButton);
        this.moveRadioGroup.add(this.absoluteRadioButton);
        this.jogRadioButton.setBorderPainted(true);
        this.jogRadioButton.setBackground(new Color(153, 204, 0));
        this.jogRadioButton.setBounds(220, 45, 62, 21);
        this.getContentPane().add(this.jogRadioButton);
        this.relativeRadioButton.setSelected(true);
        this.relativeRadioButton.setBorderPainted(true);
        this.relativeRadioButton.setBackground(new Color(153, 204, 0));
        this.relativeRadioButton.setBounds(220, 66, 62, 21);
        this.getContentPane().add(this.relativeRadioButton);
        this.absoluteRadioButton.setBorderPainted(true);
        this.absoluteRadioButton.setBackground(new Color(153, 204, 0));
        this.absoluteRadioButton.setBounds(220, 88, 62, 21);
        this.getContentPane().add(this.absoluteRadioButton);
        JLabel speedNameLabel = new JLabel("Speed-uSpd:");
        speedNameLabel.setHorizontalAlignment(2);
        speedNameLabel.setForeground(Color.BLACK);
        speedNameLabel.setFont(new Font("Tahoma", 1, 12));
        speedNameLabel.setBackground(Color.YELLOW);
        speedNameLabel.setBounds(16, 199, 93, 25);
        this.getContentPane().add(speedNameLabel);
        this.enterSpeedTextField = new JTextField();
        this.enterSpeedTextField.setText("0");
        this.enterSpeedTextField.setHorizontalAlignment(0);
        this.enterSpeedTextField.setFont(new Font("Tahoma", 1, 12));
        this.enterSpeedTextField.setColumns(10);
        this.enterSpeedTextField.setBackground(new Color(255, 255, 230));
        this.enterSpeedTextField.setBounds(105, 198, 50, 26);
        this.getContentPane().add(this.enterSpeedTextField);
        this.enterUSpeedTextField = new JTextField();
        this.enterUSpeedTextField.setText("0");
        this.enterUSpeedTextField.setHorizontalAlignment(0);
        this.enterUSpeedTextField.setFont(new Font("Tahoma", 1, 12));
        this.enterUSpeedTextField.setColumns(10);
        this.enterUSpeedTextField.setBackground(new Color(255, 255, 230));
        this.enterUSpeedTextField.setBounds(155, 198, 50, 26);
        this.getContentPane().add(this.enterUSpeedTextField);
        JButton speedSetButton = new JButton("Set");
        speedSetButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    StandaGui.this.engineStructure = JXimc.get_engine_settings((int)StandaGui.this.standaDevice);
                    StandaGui.this.engineStructure.NomSpeed = Integer.parseInt(StandaGui.this.enterSpeedTextField.getText());
                    StandaGui.this.engineStructure.uNomSpeed = (byte)Integer.parseInt(StandaGui.this.enterUSpeedTextField.getText());
                    JXimc.set_engine_settings((int)StandaGui.this.standaDevice, (JXimc.engine_settings_t)StandaGui.this.engineStructure);
                }
                catch (Exception e1) {
                    System.out.println("error engineStructure setValues... ");
                    return;
                }
            }
        });
        speedSetButton.setForeground(Color.BLACK);
        speedSetButton.setFont(new Font("Tahoma", 1, 14));
        speedSetButton.setBackground(Color.LIGHT_GRAY);
        speedSetButton.setBounds(212, 198, 62, 25);
        this.getContentPane().add(speedSetButton);
        JButton homeLeftButton = new JButton("HomeLeft");
        homeLeftButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StandaGui.this.standaDevice == -1) {
                    StandaGui.this.outputInfoLabel.setText(" sorry NO device is OPEN ");
                    return;
                }
                StandaGui.this.gotoLeftHome = true;
                if (StandaGui.this.startHomeThread) {
                    StandaGui.this.outputInfoLabel.setText(" command Already actived.. wait.. or press STOP");
                } else {
                    StandaGui.this.startHomeThread = true;
                }
            }
        });
        homeLeftButton.setForeground(Color.BLUE);
        homeLeftButton.setFont(new Font("Tahoma", 1, 10));
        homeLeftButton.setBackground(Color.PINK);
        homeLeftButton.setBounds(512, 115, 83, 23);
        this.getContentPane().add(homeLeftButton);
        JButton homeRightButton = new JButton("HomeRight");
        homeRightButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StandaGui.this.standaDevice == -1) {
                    StandaGui.this.outputInfoLabel.setText(" sorry NO device is OPEN ");
                    return;
                }
                StandaGui.this.gotoLeftHome = false;
                if (StandaGui.this.startHomeThread) {
                    StandaGui.this.outputInfoLabel.setText(" command Already actived.. wait.. or press STOP");
                } else {
                    StandaGui.this.startHomeThread = true;
                }
            }
        });
        homeRightButton.setForeground(Color.BLUE);
        homeRightButton.setFont(new Font("Tahoma", 1, 10));
        homeRightButton.setBackground(Color.PINK);
        homeRightButton.setBounds(512, 141, 83, 23);
        this.getContentPane().add(homeRightButton);
        this.temperatureLabel.setAlignmentX(0.5f);
        this.temperatureLabel.setHorizontalAlignment(0);
        this.temperatureLabel.setForeground(Color.BLACK);
        this.temperatureLabel.setFont(new Font("Tahoma", 0, 12));
        this.temperatureLabel.setBackground(Color.YELLOW);
        this.temperatureLabel.setBounds(512, 182, 81, 18);
        this.getContentPane().add(this.temperatureLabel);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.add(this.exitButton);
        this.exitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StandaGui.this.closeDevice();
                System.exit(0);
            }
        });
        this.exitButton.setForeground(Color.BLUE);
        this.exitButton.setFont(new Font("Tahoma", 1, 12));
        this.exitButton.setBackground(Color.LIGHT_GRAY);
    }

    public int getSpeed(int axNo) {
        JXimc.move_settings_t moveSettings = JXimc.get_move_settings((int)axNo);
        System.out.println("<<< speed " + moveSettings.Speed);
        return moveSettings.Speed;
    }

    public byte getUSpeed(int axNo) {
        JXimc.move_settings_t moveSettings = JXimc.get_move_settings((int)axNo);
        System.out.println("<<< speed " + moveSettings.uSpeed);
        return moveSettings.uSpeed;
    }

    public short getAccel(int axNo) {
        JXimc.move_settings_t moveSettings = JXimc.get_move_settings((int)axNo);
        System.out.println("<<< speed " + moveSettings.Accel);
        return moveSettings.Accel;
    }

    public short getDecel(int axNo) {
        JXimc.move_settings_t moveSettings = JXimc.get_move_settings((int)axNo);
        System.out.println("<<< speed " + moveSettings.Speed);
        return moveSettings.Decel;
    }

    public void getMotorCalibration() {
        JXimc.move_settings_t moveSettings = JXimc.get_move_settings((int)this.standaDevice);
        System.out.println("<<< speed " + moveSettings.Speed);
        System.out.println("<<< uspeed " + moveSettings.uSpeed);
        System.out.println("<<< Acc " + moveSettings.Accel);
        System.out.println("<<< decel " + moveSettings.Decel);
        System.out.println("<<< MoveFlags " + moveSettings.MoveFlags);
    }

    public void viewStopBorder() {
        this.edgeStructure = JXimc.get_edges_settings((int)this.standaDevice);
        if ((this.edgeStructure.BorderFlags & 2) == 2) {
            StandaUtils.stopBorderLeft = true;
            stoptLeftCheckBox.setSelected(true);
        } else {
            StandaUtils.stopBorderLeft = false;
            stoptLeftCheckBox.setSelected(false);
        }
        if ((this.edgeStructure.BorderFlags & 4) == 4) {
            StandaUtils.stopBorderRight = true;
            stopRightCheckBox.setSelected(true);
        } else {
            StandaUtils.stopBorderRight = false;
            stopRightCheckBox.setSelected(false);
        }
    }
}

