/*
 * Decompiled with CFR 0.152.
 */
package ctrl;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import java.io.InputStream;
import java.util.Scanner;

public class LikaEncoder {
    public static String COM_PORT = "COM7";
    private static SerialPort likaComPort;
    private static boolean likaComPortStatus;

    static {
        likaComPortStatus = false;
    }

    public static void main(String[] args) {
        LikaEncoder.getSerialsPort();
        COM_PORT = "COM18";
        LikaEncoder testObj = new LikaEncoder();
        LikaEncoder.openRS232Port(COM_PORT);
        if (!likaComPortStatus) {
            return;
        }
        int ix = 0;
        while (ix < 50) {
            LikaEncoder.readLika();
            ++ix;
        }
        LikaEncoder.cloreRS232Port();
    }

    public static int readLika() {
        byte[] readBuffer = new byte[1024];
        int numRead = 0;
        int sStart = 0;
        int sEnd = 0;
        int errCount = 0;
        likaComPort.clearDTR();
        likaComPort.clearRTS();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        numRead = likaComPort.readBytes(readBuffer, (long)readBuffer.length);
        String dataString = "";
        dataString = new String(readBuffer);
        try {
            if (dataString.contains("+")) {
                sStart = dataString.indexOf("+");
            }
            if (dataString.contains("\n")) {
                sEnd = dataString.indexOf("\n");
            }
            if (sStart < sEnd & numRead >= 10) {
                System.out.println("Read: " + numRead + " EncCounts=" + Integer.parseInt(dataString.substring(sStart, sStart + 7)) + " Start:" + sStart + "  end:" + sEnd + " errCounter:" + errCount);
                return Integer.parseInt(dataString.substring(sStart, sStart + 7));
            }
            System.out.println("Read: " + numRead + " bytes.???????" + dataString.trim());
            ++errCount;
            return -1;
        }
        catch (Exception e) {
            try {
                System.out.println("Read ERROR!");
                ++errCount;
                return -1;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return -1;
            }
        }
    }

    public static void getSerialsPort() {
        System.out.println("\nUsing Library Version v" + SerialPort.getVersion());
        SerialPort[] ports = SerialPort.getCommPorts();
        System.out.println("\nAvailable Ports:\n");
        int i = 0;
        while (i < ports.length) {
            System.out.println("   [" + i + "] " + ports[i].getSystemPortName() + ": " + ports[i].getDescriptivePortName() + " - " + ports[i].getPortDescription());
            ++i;
        }
    }

    public static void openRS232Port(String COM_PORT) {
        likaComPort = SerialPort.getCommPort((String)COM_PORT);
        likaComPortStatus = false;
        System.out.println("\nPre-setting RTS: " + (likaComPort.setRTS() ? "Success" : "Failure"));
        boolean openedSuccessfully = likaComPort.openPort(0);
        System.out.println("\nOpening " + likaComPort.getSystemPortName() + ": " + likaComPort.getDescriptivePortName() + " - " + likaComPort.getPortDescription() + ": " + openedSuccessfully);
        if (!openedSuccessfully) {
            return;
        }
        System.out.println("Setting read timeout mode to non-blocking");
        likaComPort.setBaudRate(9600);
        likaComPort.setNumDataBits(8);
        likaComPort.setParity(0);
        likaComPort.setNumStopBits(1);
        likaComPort.setComPortTimeouts(1, 500, 0);
        likaComPortStatus = true;
    }

    public static void cloreRS232Port() {
        if (!likaComPortStatus) {
            return;
        }
        likaComPort.removeDataListener();
        System.out.println("\n\nClosing " + likaComPort.getDescriptivePortName() + ": " + likaComPort.closePort());
    }

    public static void main1(String[] args) {
        int numRead2;
        byte[] wByte;
        SerialPort ubxPort;
        System.out.println("\nUsing Library Version v" + SerialPort.getVersion());
        SerialPort[] ports = SerialPort.getCommPorts();
        System.out.println("\nAvailable Ports:\n");
        int i = 0;
        while (i < ports.length) {
            System.out.println("   [" + i + "] " + ports[i].getSystemPortName() + ": " + ports[i].getDescriptivePortName() + " - " + ports[i].getPortDescription());
            ++i;
        }
        System.out.print("\nChoose your desired serial port or enter -1 to specify a port directly: ");
        int serialPortChoice = 0;
        try {
            Scanner inputScanner = new Scanner(System.in);
            serialPortChoice = inputScanner.nextInt();
            inputScanner.close();
        }
        catch (Exception inputScanner) {
            // empty catch block
        }
        if (serialPortChoice == -1) {
            String serialPortDescriptor = "";
            System.out.print("\nSpecify your desired serial port descriptor: ");
            try {
                Scanner inputScanner = new Scanner(System.in);
                serialPortDescriptor = inputScanner.nextLine();
                inputScanner.close();
            }
            catch (Exception inputScanner) {
                // empty catch block
            }
            ubxPort = SerialPort.getCommPort((String)serialPortDescriptor);
        } else {
            ubxPort = ports[serialPortChoice];
        }
        final byte[] readBuffer = new byte[2048];
        System.out.println("\nPre-setting RTS: " + (ubxPort.setRTS() ? "Success" : "Failure"));
        boolean openedSuccessfully = ubxPort.openPort(0);
        System.out.println("\nOpening " + ubxPort.getSystemPortName() + ": " + ubxPort.getDescriptivePortName() + " - " + ubxPort.getPortDescription() + ": " + openedSuccessfully);
        if (!openedSuccessfully) {
            return;
        }
        System.out.println("Setting read timeout mode to non-blocking");
        ubxPort.setBaudRate(9600);
        ubxPort.setComPortTimeouts(0, 1000, 0);
        try {
            int i2 = 0;
            while (i2 < 3) {
                wByte = new byte[]{58, 53, 48, 10};
                ubxPort.writeBytes(wByte, (long)wByte.length);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("\nReading #" + i2);
                System.out.println("Available: " + ubxPort.bytesAvailable());
                numRead2 = ubxPort.readBytes(readBuffer, (long)readBuffer.length);
                System.out.println("Read " + numRead2 + " bytes." + new String(readBuffer));
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nSetting read timeout mode to semi-blocking with a timeout of 200ms");
        ubxPort.setComPortTimeouts(1, 200, 0);
        try {
            int i3 = 0;
            while (i3 < 3) {
                wByte = new byte[]{58, 53, 48, 10};
                ubxPort.writeBytes(wByte, (long)wByte.length);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception numRead2) {
                    // empty catch block
                }
                System.out.println("\nReading #" + i3);
                System.out.println("Available: " + ubxPort.bytesAvailable());
                numRead2 = ubxPort.readBytes(readBuffer, (long)readBuffer.length);
                System.out.println("Read " + numRead2 + " bytes." + new String(readBuffer));
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nSetting read timeout mode to semi-blocking with no timeout 1000ms");
        ubxPort.setComPortTimeouts(1, 1000, 0);
        try {
            int i4 = 0;
            while (i4 < 3) {
                wByte = new byte[]{58, 53, 48, 10};
                ubxPort.writeBytes(wByte, (long)wByte.length);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception numRead3) {
                    // empty catch block
                }
                System.out.println("\nReading #" + i4);
                System.out.println("Available: " + ubxPort.bytesAvailable());
                numRead2 = ubxPort.readBytes(readBuffer, (long)readBuffer.length);
                System.out.println("Read " + numRead2 + " bytes." + new String(readBuffer));
                ++i4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nSetting read timeout mode to blocking with a timeout of 100ms");
        ubxPort.setComPortTimeouts(16, 100, 0);
        try {
            int i5 = 0;
            while (i5 < 3) {
                wByte = new byte[]{58, 53, 48, 10};
                ubxPort.writeBytes(wByte, (long)wByte.length);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception numRead4) {
                    // empty catch block
                }
                System.out.println("\nReading #" + i5);
                System.out.println("Available: " + ubxPort.bytesAvailable());
                numRead2 = ubxPort.readBytes(readBuffer, (long)readBuffer.length);
                System.out.println("Read " + numRead2 + " bytes." + new String(readBuffer));
                ++i5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nSetting read timeout mode to blocking with no timeout");
        ubxPort.setComPortTimeouts(16, 10, 0);
        try {
            int i6 = 0;
            while (i6 < 3) {
                wByte = new byte[]{58, 53, 48, 10};
                ubxPort.writeBytes(wByte, (long)wByte.length);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception numRead5) {
                    // empty catch block
                }
                System.out.println("\nReading #" + i6);
                System.out.println("Available: " + ubxPort.bytesAvailable());
                numRead2 = ubxPort.readBytes(readBuffer, (long)readBuffer.length);
                System.out.println("Read " + numRead2 + " bytes." + new String(readBuffer));
                ++i6;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nSwitching over to event-based reading");
        System.out.println("\nListening for any amount of data available\n");
        ubxPort.addDataListener(new SerialPortDataListener(){

            public int getListeningEvents() {
                return 1;
            }

            public void serialEvent(SerialPortEvent event) {
                byte[] wByte = new byte[]{58, 53, 48, 10};
                ubxPort.writeBytes(wByte, (long)wByte.length);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SerialPort comPort = event.getSerialPort();
                System.out.println("Available: " + comPort.bytesAvailable() + " bytes.");
                byte[] newData = new byte[comPort.bytesAvailable()];
                int numRead = comPort.readBytes(newData, (long)newData.length);
                System.out.println("Read " + numRead + " bytes." + new String(readBuffer));
            }
        });
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        ubxPort.removeDataListener();
        System.out.println("\nNow listening for full 100-byte data packets\n");
        PacketListener listener = new PacketListener();
        ubxPort.addDataListener((SerialPortDataListener)listener);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception wByte2) {
            // empty catch block
        }
        ubxPort.removeDataListener();
        System.out.println("\nNow listening for byte-delimited binary messages\n");
        MessageListener messageListener = new MessageListener();
        ubxPort.addDataListener((SerialPortDataListener)messageListener);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception numRead6) {
            // empty catch block
        }
        ubxPort.removeDataListener();
        System.out.println("\n\nClosing " + ubxPort.getDescriptivePortName() + ": " + ubxPort.closePort());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        System.out.println("Reopening " + ubxPort.getDescriptivePortName() + ": " + ubxPort.openPort() + "\n");
        ubxPort.setComPortTimeouts(16, 1000, 0);
        InputStream in = ubxPort.getInputStream();
        try {
            int j = 0;
            while (j < 1000) {
                System.out.print((char)in.read());
                ++j;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n\nClosing " + ubxPort.getDescriptivePortName() + ": " + ubxPort.closePort());
        openedSuccessfully = ubxPort.openPort(0);
        System.out.println("Reopening " + ubxPort.getSystemPortName() + ": " + ubxPort.getDescriptivePortName() + ": " + openedSuccessfully);
        if (!openedSuccessfully) {
            return;
        }
        System.out.println("Unplug the device sometime in the next 10 seconds to ensure that it closes properly...\n");
        ubxPort.setComPortTimeouts(16, 0, 0);
        ubxPort.addDataListener(new SerialPortDataListener(){

            public int getListeningEvents() {
                return 1;
            }

            public void serialEvent(SerialPortEvent event) {
                SerialPort comPort = event.getSerialPort();
                System.out.println("Available: " + comPort.bytesAvailable() + " bytes.");
                byte[] newData = new byte[comPort.bytesAvailable()];
                int numRead = comPort.readBytes(newData, (long)newData.length);
                System.out.println("Read " + numRead + " bytes.");
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ubxPort.removeDataListener();
        System.out.println("\n\nClosing " + ubxPort.getDescriptivePortName() + ": " + ubxPort.closePort());
    }

    private static final class MessageListener
    implements SerialPortMessageListener {
        private MessageListener() {
        }

        public String byteToHex(byte num) {
            char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
            return new String(hexDigits);
        }

        public int getListeningEvents() {
            return 16;
        }

        public void serialEvent(SerialPortEvent event) {
            byte[] byteArray = event.getReceivedData();
            StringBuffer hexStringBuffer = new StringBuffer();
            int i = 0;
            while (i < byteArray.length) {
                hexStringBuffer.append(this.byteToHex(byteArray[i]));
                ++i;
            }
            System.out.println("Received the following message: " + hexStringBuffer.toString());
        }

        public byte[] getMessageDelimiter() {
            return new byte[]{-75, 98};
        }

        public boolean delimiterIndicatesEndOfMessage() {
            return false;
        }
    }

    private static final class PacketListener
    implements SerialPortPacketListener {
        private PacketListener() {
        }

        public int getListeningEvents() {
            return 16;
        }

        public void serialEvent(SerialPortEvent event) {
            byte[] newData = event.getReceivedData();
            System.out.println("Received data of size: " + newData.length);
            int i = 0;
            while (i < newData.length) {
                System.out.print((char)newData[i]);
                ++i;
            }
            System.out.println("\n");
        }

        public int getPacketSize() {
            return 100;
        }
    }
}

