/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MyCertificateValidationListener;
import client.MyMonitoredDataItemListener;
import client.MyMonitoredEventItemListener;
import client.MyServerStatusListener;
import client.MySubscriptionAliveListener;
import client.MySubscriptionNotificationListener;
import client.MyUaClientListener;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CertificateValidationListener;
import com.prosysopc.ua.ContentFilterBuilder;
import com.prosysopc.ua.EventNotifierClass;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.PkiFileBasedCertificateValidator;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaCertificateValidator;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.InvalidServerEndpointException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredEventItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.ServerList;
import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.PropertyConfigurator;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.Argument;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.DataChangeFilter;
import org.opcfoundation.ua.core.DataChangeTrigger;
import org.opcfoundation.ua.core.DeadbandType;
import org.opcfoundation.ua.core.EUInformation;
import org.opcfoundation.ua.core.ElementOperand;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.FilterOperand;
import org.opcfoundation.ua.core.FilterOperator;
import org.opcfoundation.ua.core.HistoryEventFieldList;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.LiteralOperand;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.Range;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.SimpleAttributeOperand;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.HttpsSecurityPolicy;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;

public class SampleConsoleClient {
    protected static final int ACTION_ALL = -4;
    protected static final int ACTION_BACK = -2;
    protected static final int ACTION_RETURN = -1;
    protected static final int ACTION_ROOT = -3;
    protected static final int ACTION_TRANSLATE = -6;
    protected static final int ACTION_UP = -5;
    protected static String APP_NAME = "Client";
    protected static final List<String> cmdSequence = new ArrayList<String>();
    protected static boolean stackTraceOnException = false;
    public int noOfIcmoNodes = 0;
    public String[] nodeName = null;
    public String[] nodeType = null;
    public String[] nodeDescription = null;
    public String[] nodeResponce = null;
    public String[] nodeIPConfig = null;
    public int[] nodeFailCounter = null;
    public float[] nodeFailPercentage = null;
    public String[] nodeLocation = null;
    protected static UaClient client;
    protected UaClientListener clientListener = new MyUaClientListener();
    protected boolean connectToDiscoveryServer = false;
    protected MonitoredDataItemListener dataChangeListener = new MyMonitoredDataItemListener(this);
    protected String defaultServerUri = "opc.tcp://localhost:52001/OPCUA/ASTRI_ICMP_Server";
    protected final QualifiedName[] eventFieldNames;
    protected final MonitoredEventItemListener eventListener;
    protected final List<String> initialMonitoredItems;
    protected NodeId nodeId;
    protected String passWord;
    protected SecurityMode securityMode;
    protected ServerStatusListener serverStatusListener;
    protected String serverUri;
    protected int sessionCount;
    protected static boolean showReadValueDataType;
    protected Subscription subscription;
    protected SubscriptionAliveListener subscriptionAliveListener;
    protected SubscriptionNotificationListener subscriptionListener;
    protected String userName;
    protected CertificateValidationListener validationListener;

    static {
        showReadValueDataType = false;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configureAndWatch((String)SampleConsoleClient.class.getResource("log.properties").getFile(), (long)5000L);
        SampleConsoleClient sampleConsoleClient = new SampleConsoleClient();
        try {
            if (!sampleConsoleClient.parseCmdLineArgs(args)) {
                SampleConsoleClient.usage();
                return;
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                SampleConsoleClient.println("Invalid cmd line argument: " + e.getMessage());
            }
            SampleConsoleClient.usage();
            return;
        }
        sampleConsoleClient.initialize(args);
        sampleConsoleClient.mainMenu();
        SampleConsoleClient.println(String.valueOf(APP_NAME) + ": Closed");
    }

    protected static String dateTimeToString(String title, DateTime timestamp, UnsignedShort picoSeconds) {
        if (timestamp != null && !timestamp.equals((Object)DateTime.MIN_VALUE)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy MMM dd (zzz) HH:mm:ss.SSS");
            StringBuilder sb = new StringBuilder(title);
            sb.append(format.format(timestamp.getCalendar(TimeZone.getDefault()).getTime()));
            if (picoSeconds != null && !picoSeconds.equals((Object)UnsignedShort.valueOf((int)0))) {
                sb.append(String.format("/%d picos", picoSeconds.getValue()));
            }
            return sb.toString();
        }
        return "";
    }

    protected static int parseAction(String s) {
        if (s.equals("x")) {
            return -1;
        }
        if (s.equals("b")) {
            return -2;
        }
        if (s.equals("r")) {
            return -3;
        }
        if (s.equals("a")) {
            return -4;
        }
        if (s.equals("u")) {
            return -5;
        }
        if (s.equals("t")) {
            return -6;
        }
        return Integer.parseInt(s);
    }

    protected static void print(String string) {
        System.out.print(string);
    }

    protected static void printException(Exception e) {
        if (stackTraceOnException) {
            e.printStackTrace();
        } else {
            MethodCallStatusException me;
            StatusCode[] results;
            SampleConsoleClient.println(e.toString());
            if (e instanceof MethodCallStatusException && (results = (me = (MethodCallStatusException)e).getInputArgumentResults()) != null) {
                int i = 0;
                while (i < results.length) {
                    StatusCode s = results[i];
                    if (s.isBad()) {
                        SampleConsoleClient.println("Status for Input #" + i + ": " + s);
                        DiagnosticInfo d = me.getInputArgumentDiagnosticInfos()[i];
                        if (d != null) {
                            SampleConsoleClient.println("  DiagnosticInfo:" + i + ": " + d);
                        }
                    }
                    ++i;
                }
            }
            if (e.getCause() != null) {
                SampleConsoleClient.println("Caused by: " + e.getCause());
            }
        }
    }

    protected static void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    protected static String readFromServer(NodeId newNode) throws ServiceException, StatusException {
        DataValue value = client.readAttribute(newNode, UnsignedInteger.valueOf((long)13L));
        if (value.isNull()) {
            return null;
        }
        Object v = value.getValue().getValue();
        if (value.getValue().isArray()) {
            return MultiDimensionArrayUtils.toString((Object)v);
        }
        return v.toString();
    }

    protected static void println(String string) {
        System.out.println(string);
    }

    protected static int readAction() {
        return SampleConsoleClient.parseAction(SampleConsoleClient.readInput(true).toLowerCase());
    }

    protected static String readInput(boolean useCmdSequence) {
        if (useCmdSequence && !cmdSequence.isEmpty()) {
            String cmd;
            block8: {
                cmd = cmdSequence.remove(0);
                try {
                    int i = Integer.parseInt(cmd);
                    if (i >= 0) break block8;
                    try {
                        TimeUnit.SECONDS.sleep(-i);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return SampleConsoleClient.readInput(useCmdSequence);
                }
                catch (NumberFormatException i) {
                    // empty catch block
                }
            }
            return cmd;
        }
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String s = null;
        do {
            try {
                s = stdin.readLine();
            }
            catch (IOException e) {
                SampleConsoleClient.printException(e);
            }
        } while (s == null || s.length() == 0);
        return s;
    }

    protected static void usage() {
        SampleConsoleClient.println("Usage: " + APP_NAME + " [-d] [-t] [-n] [-?] [serverUri]");
        SampleConsoleClient.println("   -d         Connect to a discovery server");
        SampleConsoleClient.println("   -n nodeId  Define the NodeId to select after connect (requires serverUri)");
        SampleConsoleClient.println("   -s n|s|e[bits]   Define the security mode (n=none/s=sign/e=signAndEncrypt). Default is none.");
        SampleConsoleClient.println("                    Oprionally, define the bit strength (128 or 256) you want to use for encryption. Default is 128");
        SampleConsoleClient.println("   -k keySize Define the size of the public key of the application certificate (default 1024; other valid values 2048, 4096)");
        SampleConsoleClient.println("   -m nodeId  Subscribe to the given node at start up");
        SampleConsoleClient.println("   -t         Output stack trace for errors");
        SampleConsoleClient.println("   -dt        Show the DataType of read values When displaying them.");
        SampleConsoleClient.println("   -?         Show this help text");
        SampleConsoleClient.println("   serverUri  The address of the server to connect to. If you do not specify it, you will be prompted for it.");
        SampleConsoleClient.println("");
        SampleConsoleClient.println(" Examples of valid arguments:");
        SampleConsoleClient.println("   opc.tcp://localhost:4841                            (UA Demo Server)");
        SampleConsoleClient.println("   opc.tcp://localhost:52001/OPCUA/ASTRI_ICMP_Server   (ASTRI ICT Server)");
        SampleConsoleClient.println("   opc.tcp://localhost:51210/UA/SampleServer           (OPC Foundation Sample Server)");
        SampleConsoleClient.println("   -d opc.tcp://localhost:4840/UADiscovery             (OPC Foundation Discovery Server)");
    }

    public SampleConsoleClient() {
        QualifiedName[] qualifiedNameArray = new QualifiedName[8];
        qualifiedNameArray[0] = new QualifiedName("EventType");
        qualifiedNameArray[1] = new QualifiedName("Message");
        qualifiedNameArray[2] = new QualifiedName("SourceName");
        qualifiedNameArray[3] = new QualifiedName("Time");
        qualifiedNameArray[4] = new QualifiedName("Severity");
        qualifiedNameArray[5] = new QualifiedName("ActiveState/Id");
        this.eventFieldNames = qualifiedNameArray;
        this.eventListener = new MyMonitoredEventItemListener(this, this.eventFieldNames);
        this.initialMonitoredItems = new ArrayList<String>();
        this.nodeId = null;
        this.securityMode = SecurityMode.NONE;
        this.serverStatusListener = new MyServerStatusListener();
        this.serverUri = null;
        this.sessionCount = 0;
        this.subscriptionAliveListener = new MySubscriptionAliveListener();
        this.subscriptionListener = new MySubscriptionNotificationListener();
        this.validationListener = new MyCertificateValidationListener();
    }

    private String nodeClassToStr(NodeClass nodeClass) {
        return "[" + nodeClass + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NodeId browse(NodeId nodeId, NodeId prevId) throws ServiceException, StatusException {
        List upReferences;
        List references;
        this.printCurrentNode(nodeId);
        try {
            client.getAddressSpace().setMaxReferencesPerNode(1000);
            references = client.getAddressSpace().browse(nodeId);
            int i = 0;
            while (i < references.size()) {
                SampleConsoleClient.printf("%d - %s\n", i, this.referenceToString((ReferenceDescription)references.get(i)));
                ++i;
            }
            upReferences = client.getAddressSpace().browseUp(nodeId);
        }
        catch (Exception e) {
            SampleConsoleClient.printException(e);
            references = new ArrayList();
            upReferences = new ArrayList();
        }
        System.out.println("-------------------------------------------------------");
        SampleConsoleClient.println("- Enter node number to browse into that");
        SampleConsoleClient.println("- Enter a to show/hide all references");
        if (prevId != null) {
            String prevName = null;
            try {
                UaNode prevNode = client.getAddressSpace().getNode(prevId);
                if (prevNode != null) {
                    prevName = prevNode.getDisplayName().getText();
                }
            }
            catch (AddressSpaceException e) {
                prevName = prevId.toString();
            }
            if (prevName != null) {
                SampleConsoleClient.println("- Enter b to browse back to the previous node (" + prevName + ")");
            }
        }
        if (!upReferences.isEmpty()) {
            SampleConsoleClient.println("- Enter u to browse up to the 'parent' node");
        }
        SampleConsoleClient.println("- Enter r to browse back to the root node");
        SampleConsoleClient.println("- Enter t to translate a BrowsePath to NodeId");
        System.out.println("- Enter x to select the current node and return to previous menu");
        System.out.println("-------------------------------------------------------");
        block23: while (true) {
            int action = SampleConsoleClient.readAction();
            switch (action) {
                case -1: {
                    return nodeId;
                }
                case -2: {
                    if (prevId == null) continue block23;
                    return prevId;
                }
                case -5: {
                    if (upReferences.isEmpty()) return this.browse(Identifiers.RootFolder, nodeId);
                    try {
                        ReferenceDescription upReference = null;
                        if (upReferences.size() == 1) {
                            upReference = (ReferenceDescription)upReferences.get(0);
                        } else {
                            SampleConsoleClient.println("Which inverse reference do you wish to go up?");
                            int i = 0;
                            while (i < upReferences.size()) {
                                SampleConsoleClient.printf("%d - %s\n", i, this.referenceToString((ReferenceDescription)upReferences.get(i)));
                                ++i;
                            }
                            while (upReference == null) {
                                int upIndex = SampleConsoleClient.readAction();
                                try {
                                    upReference = (ReferenceDescription)upReferences.get(upIndex);
                                }
                                catch (Exception e) {
                                    SampleConsoleClient.printException(e);
                                }
                            }
                        }
                        if (upReference.getNodeId().isLocal()) return this.browse(client.getAddressSpace().getNamespaceTable().toNodeId(upReference.getNodeId()), nodeId);
                        SampleConsoleClient.println("Not a local node");
                    }
                    catch (ServiceResultException e1) {
                        SampleConsoleClient.printException((Exception)((Object)e1));
                    }
                }
                case -3: {
                    return this.browse(Identifiers.RootFolder, nodeId);
                }
                case -4: {
                    if (NodeId.isNull((NodeId)client.getAddressSpace().getReferenceTypeId())) {
                        client.getAddressSpace().setReferenceTypeId(Identifiers.HierarchicalReferences);
                        client.getAddressSpace().setBrowseDirection(BrowseDirection.Forward);
                        return this.browse(nodeId, prevId);
                    } else {
                        client.getAddressSpace().setReferenceTypeId(NodeId.NULL);
                        client.getAddressSpace().setBrowseDirection(BrowseDirection.Both);
                    }
                    return this.browse(nodeId, prevId);
                }
                case -6: {
                    SampleConsoleClient.println("Which node do you wish to translate?");
                    SampleConsoleClient.println("Use / to separate nodes in the browsePath, e.g. 'Types/ObjectTypes/BaseObjectType/3:YourType'");
                    SampleConsoleClient.println("where each element is a 'parseable' BrowseName, i.e. the namespaceIndex can be defined with a prefix, like '3:'");
                    String browsePathString = SampleConsoleClient.readInput(false);
                    ArrayList<RelativePathElement> browsePath = new ArrayList<RelativePathElement>();
                    String[] stringArray = browsePathString.split("/");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        QualifiedName targetName = QualifiedName.parseQualifiedName((String)s);
                        browsePath.add(new RelativePathElement(Identifiers.HierarchicalReferences, Boolean.valueOf(false), Boolean.valueOf(true), targetName));
                        ++n2;
                    }
                    try {
                        BrowsePathTarget[] pathTargets;
                        BrowsePathTarget[] browsePathTargetArray = pathTargets = client.getAddressSpace().translateBrowsePathToNodeId(nodeId, browsePath.toArray(new RelativePathElement[0]));
                        int n3 = pathTargets.length;
                        n = 0;
                        while (true) {
                            if (n >= n3) continue block23;
                            BrowsePathTarget pathTarget = browsePathTargetArray[n];
                            String targetStr = "Target: " + pathTarget.getTargetId();
                            if (!pathTarget.getRemainingPathIndex().equals((Object)UnsignedInteger.MAX_VALUE)) {
                                targetStr = String.valueOf(targetStr) + " - RemainingPathIndex: " + pathTarget.getRemainingPathIndex();
                            }
                            SampleConsoleClient.println(targetStr);
                            ++n;
                        }
                    }
                    catch (StatusException e1) {
                        SampleConsoleClient.printException((Exception)((Object)e1));
                    }
                    continue block23;
                }
            }
            try {
                NodeId target;
                ReferenceDescription r = (ReferenceDescription)references.get(action);
                try {
                    target = this.browse(client.getAddressSpace().getNamespaceTable().toNodeId(r.getNodeId()), nodeId);
                }
                catch (ServiceResultException e) {
                    throw new ServiceException(e);
                }
                if (target == nodeId) return this.browse(nodeId, prevId);
                return target;
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("No such item: " + action);
                continue;
            }
            break;
        }
    }

    protected void callMethod(NodeId nodeId, NodeId methodId) throws ServiceException, ServerConnectionException, AddressSpaceException, MethodArgumentException, StatusException {
        UaMethod method = client.getAddressSpace().getMethod(methodId);
        Variant[] inputs = this.readInputArguments(method);
        Variant[] outputs = client.call(nodeId, methodId, inputs);
        this.printOutputArguments(method, outputs);
    }

    protected void connect() throws ServerConnectionException {
        if (!client.isConnected()) {
            try {
                if (client.getProtocol() == UaApplication.Protocol.Https) {
                    SampleConsoleClient.println("Using HttpsSecurityPolicies " + Arrays.toString(client.getHttpsSettings().getHttpsSecurityPolicies()));
                } else {
                    String securityPolicy = client.getEndpoint() == null ? client.getSecurityMode().getSecurityPolicy().getPolicyUri() : client.getEndpoint().getSecurityPolicyUri();
                    SampleConsoleClient.println("Using SecurityPolicy " + securityPolicy);
                }
                client.setSessionName(String.valueOf(APP_NAME) + " Session" + ++this.sessionCount);
                client.connect();
                try {
                    SampleConsoleClient.println("ServerStatus: " + client.getServerStatus());
                }
                catch (StatusException ex) {
                    SampleConsoleClient.printException((Exception)((Object)ex));
                }
            }
            catch (InvalidServerEndpointException e) {
                SampleConsoleClient.print("Invalid Endpoint: ");
                SampleConsoleClient.printException((Exception)((Object)e));
                try {
                    this.printEndpoints(client.discoverEndpoints());
                }
                catch (Exception exception) {}
            }
            catch (ServerConnectionException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
                try {
                    this.printSecurityModes(client.getSupportedSecurityModes());
                }
                catch (ServerConnectionException serverConnectionException) {
                }
                catch (ServiceException serviceException) {}
            }
            catch (SessionActivationException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
                try {
                    this.printUserIdentityTokens(client.getSupportedUserIdentityTokens());
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return;
            }
            catch (ServiceException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
        }
    }

    protected QualifiedName[] createBrowsePath(QualifiedName qualifiedName) {
        if (!qualifiedName.getName().contains("/")) {
            return new QualifiedName[]{qualifiedName};
        }
        int namespaceIndex = qualifiedName.getNamespaceIndex();
        String[] names = qualifiedName.getName().split("/");
        QualifiedName[] result = new QualifiedName[names.length];
        int i = 0;
        while (i < names.length) {
            result[i] = new QualifiedName(namespaceIndex, names[i]);
            ++i;
        }
        return result;
    }

    protected EventFilter createEventFilter(QualifiedName[] eventFields) {
        NodeId eventTypeId = Identifiers.BaseEventType;
        UnsignedInteger eventAttributeId = Attributes.Value;
        String indexRange = null;
        SimpleAttributeOperand[] selectClauses = new SimpleAttributeOperand[eventFields.length + 1];
        int i = 0;
        while (i < eventFields.length) {
            QualifiedName[] browsePath = this.createBrowsePath(eventFields[i]);
            selectClauses[i] = new SimpleAttributeOperand(eventTypeId, browsePath, eventAttributeId, indexRange);
            ++i;
        }
        selectClauses[eventFields.length] = new SimpleAttributeOperand(eventTypeId, null, Attributes.NodeId, null);
        EventFilter filter = new EventFilter();
        filter.setSelectClauses(selectClauses);
        ContentFilterBuilder fb = new ContentFilterBuilder(client.getEncoderContext());
        fb.add(FilterOperator.Not, new FilterOperand[]{new ElementOperand(UnsignedInteger.valueOf((long)1L))});
        LiteralOperand filteredType = new LiteralOperand(new Variant((Object)Identifiers.GeneralModelChangeEventType));
        fb.add(FilterOperator.OfType, new FilterOperand[]{filteredType});
        filter.setWhereClause(fb.getContentFilter());
        return filter;
    }

    protected MonitoredDataItem createMonitoredDataItem(NodeId nodeId, UnsignedInteger attributeId) {
        MonitoredDataItem dataItem = new MonitoredDataItem(nodeId, attributeId, MonitoringMode.Reporting, this.subscription.getPublishingInterval());
        dataItem.setDataChangeListener(this.dataChangeListener);
        DataChangeFilter filter = new DataChangeFilter();
        filter.setDeadbandValue(Double.valueOf(1.0));
        filter.setTrigger(DataChangeTrigger.StatusValue);
        filter.setDeadbandType(UnsignedInteger.valueOf((long)DeadbandType.Percent.getValue()));
        return dataItem;
    }

    protected MonitoredEventItem createMonitoredEventItem(NodeId nodeId) throws StatusException {
        this.initEventFieldNames();
        EventFilter filter = this.createEventFilter(this.eventFieldNames);
        MonitoredEventItem eventItem = new MonitoredEventItem(nodeId, filter);
        eventItem.setEventListener(this.eventListener);
        return eventItem;
    }

    protected void createMonitoredItem(Subscription sub, NodeId nodeId, UnsignedInteger attributeId) throws ServiceException, StatusException {
        UnsignedInteger monitoredItemId = null;
        if (!sub.hasItem(nodeId, attributeId)) {
            MonitoredEventItem item;
            if (attributeId == Attributes.EventNotifier) {
                MonitoredEventItem eventItem;
                item = eventItem = this.createMonitoredEventItem(nodeId);
            } else {
                MonitoredDataItem dataItem = this.createMonitoredDataItem(nodeId, attributeId);
                DataChangeFilter filter = null;
                dataItem.setDataChangeFilter(filter);
                item = dataItem;
            }
            double requestedSamplingInterval = item.getSamplingInterval();
            sub.addItem((MonitoredItem)item);
            monitoredItemId = item.getMonitoredItemId();
            double revisitedSamplingInterval = item.getSamplingInterval();
            if (Double.isInfinite(revisitedSamplingInterval)) {
                SampleConsoleClient.println("Error, got infinite number as revised sampling interval");
            } else if (Double.isNaN(revisitedSamplingInterval)) {
                SampleConsoleClient.println("Error, got NaN as revised sampling interval");
            } else if (revisitedSamplingInterval < 0.0) {
                SampleConsoleClient.println("Warning, got negative number as revised sampling interval");
            } else if (Math.abs(requestedSamplingInterval - revisitedSamplingInterval) > 0.01) {
                SampleConsoleClient.println(String.format("The requested sampling inteval is different than reguested, requested: %s, got: %s", requestedSamplingInterval, revisitedSamplingInterval));
            }
        }
        SampleConsoleClient.println("-------------------------------------------------------");
        SampleConsoleClient.println("Subscription: Id=" + sub.getSubscriptionId() + " ItemId=" + monitoredItemId);
    }

    protected void createMonitoredItemsForChildren(Subscription subscription, String nodeIds) throws ServiceException, StatusException {
        String parentNodeId = nodeIds.substring(0, nodeIds.length() - 2);
        NodeId nodeId = NodeId.parseNodeId((String)parentNodeId);
        List refs = client.getAddressSpace().browse(nodeId, BrowseDirection.Forward, Identifiers.HasChild, true, new NodeClass[]{NodeClass.Variable});
        ArrayList<MonitoredDataItem> items = new ArrayList<MonitoredDataItem>(refs.size());
        SampleConsoleClient.println("Subscribing to " + refs.size() + " items under node " + parentNodeId);
        for (ReferenceDescription r : refs) {
            try {
                items.add(this.createMonitoredDataItem(client.getNamespaceTable().toNodeId(r.getNodeId()), Attributes.Value));
            }
            catch (ServiceResultException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
        }
        try {
            subscription.addItems(items.toArray(new MonitoredItem[items.size()]));
            SampleConsoleClient.println("done");
        }
        catch (Exception e) {
            SampleConsoleClient.printException(e);
        }
    }

    protected Subscription createSubscription() throws ServiceException, StatusException {
        Subscription subscription = new Subscription();
        subscription.addAliveListener(this.subscriptionAliveListener);
        subscription.addNotificationListener(this.subscriptionListener);
        client.addSubscription(subscription);
        return subscription;
    }

    protected static String dataValueToString(NodeId nodeId, UnsignedInteger attributeId, DataValue value) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node: ");
        sb.append(nodeId);
        sb.append(".");
        sb.append(AttributesUtil.toString((UnsignedInteger)attributeId));
        sb.append(" | Status: ");
        sb.append(value.getStatusCode());
        if (value.getStatusCode().isNotBad()) {
            sb.append(" | Value: ");
            if (value.isNull()) {
                sb.append("NULL");
            } else {
                if (showReadValueDataType && Attributes.Value.equals((Object)attributeId)) {
                    try {
                        UaVariable variable = (UaVariable)client.getAddressSpace().getNode(nodeId);
                        if (variable == null) {
                            sb.append("(Cannot read node datatype from the server) ");
                        } else {
                            NodeId dataTypeId = variable.getDataTypeId();
                            UaType dataType = variable.getDataType();
                            if (dataType == null) {
                                dataType = client.getAddressSpace().getType(dataTypeId);
                            }
                            Variant variant = value.getValue();
                            variant.getCompositeClass();
                            if (attributeId.equals((Object)Attributes.Value)) {
                                if (dataType != null) {
                                    sb.append("(" + dataType.getDisplayName().getText() + ")");
                                } else {
                                    sb.append("(DataTypeId: " + dataTypeId + ")");
                                }
                            }
                        }
                    }
                    catch (ServiceException variable) {
                    }
                    catch (AddressSpaceException variable) {
                        // empty catch block
                    }
                }
                Object v = value.getValue().getValue();
                if (value.getValue().isArray()) {
                    sb.append(MultiDimensionArrayUtils.toString((Object)v));
                } else {
                    sb.append(v);
                }
            }
        }
        sb.append(SampleConsoleClient.dateTimeToString(" | ServerTimestamp: ", value.getServerTimestamp(), value.getServerPicoseconds()));
        sb.append(SampleConsoleClient.dateTimeToString(" | SourceTimestamp: ", value.getSourceTimestamp(), value.getSourcePicoseconds()));
        return sb.toString();
    }

    protected void disconnect() {
        client.disconnect();
    }

    protected boolean discover() throws ServerListException, URISyntaxException {
        EndpointDescription endpoint;
        ApplicationDescription serverApp = this.discoverServer(client.getUri());
        if (serverApp != null && (endpoint = this.discoverEndpoints(serverApp)) != null) {
            client.disconnect();
            client.setEndpoint(endpoint);
            return true;
        }
        return false;
    }

    protected EndpointDescription discoverEndpoints(ApplicationDescription serverApp) throws URISyntaxException {
        String[] discoveryUrls = serverApp.getDiscoveryUrls();
        if (discoveryUrls != null) {
            UaClient discoveryClient = new UaClient();
            int i = 0;
            ArrayList<EndpointDescription> edList = new ArrayList<EndpointDescription>();
            SampleConsoleClient.println("Available endpoints: ");
            SampleConsoleClient.println(String.format("%s - %-50s - %-20s - %-20s - %s", "#", "URI", "Security Mode", "Security Policy", "Transport Profile"));
            String[] stringArray = discoveryUrls;
            int n = discoveryUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                discoveryClient.setUri(url);
                try {
                    EndpointDescription[] endpointDescriptionArray = discoveryClient.discoverEndpoints();
                    int n3 = endpointDescriptionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        EndpointDescription ed = endpointDescriptionArray[n4];
                        SampleConsoleClient.println(String.format("%s - %-50s - %-20s - %-20s - %s", i++, ed.getEndpointUrl(), ed.getSecurityMode(), ed.getSecurityPolicyUri().replaceFirst("http://opcfoundation.org/UA/SecurityPolicy#", ""), ed.getTransportProfileUri().replaceFirst("http://opcfoundation.org/UA-Profile/Transport/", "")));
                        edList.add(ed);
                        ++n4;
                    }
                }
                catch (Exception e) {
                    SampleConsoleClient.println("Cannot discover Endpoints from URL " + url + ": " + e.getMessage());
                }
                ++n2;
            }
            System.out.println("-------------------------------------------------------");
            SampleConsoleClient.println("- Enter endpoint number to select that one");
            SampleConsoleClient.println("- Enter x to return to cancel");
            System.out.println("-------------------------------------------------------");
            Object endpoint = null;
            while (endpoint == null) {
                int n5;
                block10: {
                    n5 = SampleConsoleClient.readAction();
                    if (n5 != -1) break block10;
                    return null;
                }
                try {
                    return (EndpointDescription)edList.get(n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            SampleConsoleClient.println("No suitable discoveryUrl available: using the current Url");
        }
        return null;
    }

    protected String eventFieldsToString(QualifiedName[] fieldNames, Variant[] fieldValues) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < fieldValues.length) {
            Object fieldValue = fieldValues[i] == null ? null : fieldValues[i].getValue();
            try {
                UaNode node = null;
                if (fieldValue instanceof NodeId) {
                    node = client.getAddressSpace().getNode((NodeId)fieldValue);
                } else if (fieldValue instanceof ExpandedNodeId) {
                    node = client.getAddressSpace().getNode((ExpandedNodeId)fieldValue);
                }
                if (node != null) {
                    fieldValue = String.format("%s {%s}", node.getBrowseName(), fieldValue);
                }
            }
            catch (Exception node) {
                // empty catch block
            }
            if (i < fieldNames.length) {
                QualifiedName fieldName = fieldNames[i];
                sb.append(String.valueOf(fieldName.getName()) + "=" + fieldValue + "; ");
            } else {
                sb.append("Node=" + fieldValue + "; ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String eventToString(NodeId nodeId, QualifiedName[] fieldNames, Variant[] fieldValues) {
        return String.format("Node: %s Fields: %s", nodeId, this.eventFieldsToString(fieldNames, fieldValues));
    }

    protected String getCurrentNodeAsString(UaNode node) {
        String nodeStr = "";
        String typeStr = "";
        String analogInfoStr = "";
        nodeStr = node.getDisplayName().getText();
        UaType type = null;
        if (node instanceof UaInstance) {
            type = ((UaInstance)node).getTypeDefinition();
        }
        String string = typeStr = type == null ? this.nodeClassToStr(node.getNodeClass()) : type.getDisplayName().getText();
        if (node instanceof AnalogItemType) {
            try {
                AnalogItemType analogNode = (AnalogItemType)node;
                EUInformation units = analogNode.getEngineeringUnits();
                analogInfoStr = units == null ? "" : " Units=" + units.getDisplayName().getText();
                Range range = analogNode.getEuRange();
                analogInfoStr = String.valueOf(analogInfoStr) + (range == null ? "" : String.format(" Range=(%f; %f)", range.getLow(), range.getHigh()));
                System.out.println("getValueRank " + analogNode.getValueRank());
                if (analogNode.getValue().getValue().isArray()) {
                    int[] i1 = analogNode.getValue().getValue().getArrayDimensions();
                    System.out.println("arrayLength " + i1[0]);
                }
                System.out.println("getDimension " + analogNode.getValue().getValue().getDimension());
                System.out.println("getValue " + analogNode.getValue().getValue());
                System.out.println("dataType " + analogNode.getDataType().getBrowseName().toString() + "  " + analogNode.getDataTypeId().toString());
            }
            catch (Exception e) {
                SampleConsoleClient.printException(e);
            }
        }
        String currentNodeStr = String.format("*** Current Node: %s: %s (ID: %s)%s", nodeStr, typeStr, node.getNodeId(), analogInfoStr);
        return currentNodeStr;
    }

    protected void initEventFieldNames() throws StatusException {
        if (this.eventFieldNames[this.eventFieldNames.length - 1] == null) {
            String SAMPLE_ADDRESS_SPACE = "http://www.prosysopc.com/OPCUA/SampleAddressSpace";
            int namespaceIndex = client.getNamespaceTable().getIndex(SAMPLE_ADDRESS_SPACE);
            if (namespaceIndex < 0) {
                namespaceIndex = 0;
            }
            this.eventFieldNames[this.eventFieldNames.length - 2] = new QualifiedName(namespaceIndex, "MyVariable");
            this.eventFieldNames[this.eventFieldNames.length - 1] = new QualifiedName(namespaceIndex, "MyProperty");
        }
    }

    protected boolean extractArrayString(String aString, int aLength) {
        int count = 0;
        aString = aString.trim();
        int i = 0;
        while (i < aString.length()) {
            if (aString.charAt(i) == ',') {
                ++count;
            }
            ++i;
        }
        return count == aLength - 1;
    }

    protected void initialize(String[] args) throws URISyntaxException, SecureIdentityException, IOException, SessionActivationException, ServerListException {
        SampleConsoleClient.println("Connecting to " + this.serverUri);
        client = new UaClient(this.serverUri);
        client.setListener(this.clientListener);
        PkiFileBasedCertificateValidator validator = new PkiFileBasedCertificateValidator();
        client.setCertificateValidator((UaCertificateValidator)validator);
        validator.setValidationListener(this.validationListener);
        ApplicationDescription appDescription = new ApplicationDescription();
        appDescription.setApplicationName(new LocalizedText(APP_NAME, Locale.ENGLISH));
        appDescription.setApplicationUri("urn:localhost:UA:ICT_Client");
        appDescription.setProductUri("urn:prosysopc.com:UA:ICT_Client");
        appDescription.setApplicationType(ApplicationType.Client);
        File privatePath = new File(validator.getBaseDir(), "private");
        KeyPair issuerCertificate = null;
        int[] keySizes = null;
        ApplicationIdentity identity = ApplicationIdentity.loadOrCreateCertificate((ApplicationDescription)appDescription, (String)"Sample Organisation", (String)"opcua", (File)privatePath, issuerCertificate, keySizes, (boolean)true, (String[])new String[0]);
        String hostName = InetAddress.getLocalHost().getHostName();
        identity.setHttpsCertificate(ApplicationIdentity.loadOrCreateHttpsCertificate((ApplicationDescription)appDescription, (String)hostName, (String)"opcua", issuerCertificate, (File)privatePath, (boolean)true));
        client.setApplicationIdentity(identity);
        client.setLocale(Locale.ENGLISH);
        client.setTimeout(30000L);
        client.setStatusCheckTimeout(10000L);
        client.addServerStatusListener(this.serverStatusListener);
        client.setSecurityMode(this.securityMode);
        client.getHttpsSettings().setHttpsSecurityPolicies(HttpsSecurityPolicy.ALL);
        client.getHttpsSettings().setCertificateValidator((CertificateValidator)validator);
        if (this.userName == null) {
            client.setUserIdentity(new UserIdentity());
        } else {
            if (this.passWord == null) {
                SampleConsoleClient.print("Enter password for user " + this.userName + ":");
                this.passWord = SampleConsoleClient.readInput(false);
            }
            client.setUserIdentity(new UserIdentity(this.userName, this.passWord));
        }
        client.getEndpointConfiguration().setMaxByteStringLength(Integer.valueOf(Integer.MAX_VALUE));
        client.getEndpointConfiguration().setMaxArrayLength(Integer.valueOf(Integer.MAX_VALUE));
    }

    protected void mainMenu() throws ServerListException, URISyntaxException, ServiceException, StatusException {
        UnsignedInteger attributeId = UnsignedInteger.valueOf((long)13L);
        if (this.connectToDiscoveryServer && !this.discover()) {
            return;
        }
        this.connect();
        this.subscribeToInitialItems();
        if (this.nodeId == null) {
            this.nodeId = new NodeId(9, "icmp_isotstamp");
        }
        if (this.subscription == null) {
            this.subscription = this.createSubscription();
        }
        this.createMonitoredItem(this.subscription, this.nodeId, attributeId);
        while (true) {
            this.printMenu(this.nodeId);
            try {
                switch (SampleConsoleClient.readAction()) {
                    case -1: {
                        this.disconnect();
                        return;
                    }
                    case 0: {
                        if (!this.discover()) break;
                        this.connect();
                        break;
                    }
                    case 1: {
                        this.connect();
                        break;
                    }
                    case 2: {
                        this.disconnect();
                        break;
                    }
                    case 3: {
                        NodeId browseId = this.browse(this.nodeId, null);
                        if (browseId == null) break;
                        this.nodeId = browseId;
                        break;
                    }
                    case 4: {
                        SampleConsoleClient.read(this.nodeId);
                        break;
                    }
                    case 5: {
                        this.write(this.nodeId);
                        break;
                    }
                    case 6: {
                        this.registerNodes(this.nodeId);
                        break;
                    }
                    case 7: {
                        this.unregisterNodes();
                        break;
                    }
                    case 8: {
                        this.subscribe(this.nodeId);
                        this.subscribe(new NodeId(4, "MAIN.arrayint8w"));
                        break;
                    }
                    case 9: {
                        NodeId methodId = this.readMethodId(this.nodeId);
                        if (methodId == null) break;
                        this.callMethod(this.nodeId, methodId);
                        break;
                    }
                    case 10: {
                        this.readHistory(this.nodeId);
                    }
                }
                continue;
            }
            catch (Exception e) {
                SampleConsoleClient.printException(e);
                continue;
            }
            break;
        }
    }

    protected boolean parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        int i = 0;
        boolean secModeSet = false;
        while (args.length > i && (args[i].startsWith("-") || args[i].startsWith("/"))) {
            if (args[i].equals("-d")) {
                SampleConsoleClient.println("Connecting to a discovery server.");
                this.connectToDiscoveryServer = true;
            } else if (args[i].equals("-n")) {
                this.nodeId = NodeId.parseNodeId((String)args[++i]);
            } else if (args[i].equals("-s")) {
                String arg = args[++i];
                secModeSet = true;
            } else if (args[i].equals("-k")) {
                CertificateUtils.setKeySize((int)Integer.parseInt(args[++i]));
            } else if (args[i].equals("-m")) {
                this.initialMonitoredItems.add(args[++i]);
            } else if (args[i].equals("-u")) {
                this.userName = args[++i];
            } else if (args[i].equals("-p")) {
                this.passWord = args[++i];
            } else if (args[i].equals("-t")) {
                stackTraceOnException = true;
            } else if (args[i].equals("-dt")) {
                showReadValueDataType = true;
            } else {
                if (args[i].equals("-?")) {
                    return false;
                }
                throw new IllegalArgumentException(args[i]);
            }
            ++i;
        }
        if (i < args.length) {
            this.serverUri = args[i++];
            while (i < args.length && !args[i].startsWith("#")) {
                cmdSequence.add(args[i++]);
            }
        }
        if (this.serverUri == null) {
            this.serverUri = this.promptServerUri();
            if (!secModeSet) {
                this.promptSecurityMode();
            }
        }
        return true;
    }

    protected void printCurrentNode(NodeId nodeId) {
        if (client.isConnected()) {
            try {
                UaNode node = client.getAddressSpace().getNode(nodeId);
                if (node == null) {
                    return;
                }
                String currentNodeStr = this.getCurrentNodeAsString(node);
                if (currentNodeStr != null) {
                    SampleConsoleClient.println(currentNodeStr);
                    SampleConsoleClient.println("");
                }
            }
            catch (ServiceException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
            catch (AddressSpaceException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
        }
    }

    protected void printEndpoints(EndpointDescription[] endpoints) {
        SampleConsoleClient.println("Endpoints supported by the server (by Discovery Service)");
        EndpointDescription[] endpointDescriptionArray = endpoints;
        int n = endpoints.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointDescription e = endpointDescriptionArray[n2];
            SampleConsoleClient.println(String.format("%s [%s,%s]", e.getEndpointUrl(), e.getSecurityPolicyUri(), e.getSecurityMode()));
            ++n2;
        }
    }

    protected void printMenu(NodeId nodeId) {
        SampleConsoleClient.println("");
        SampleConsoleClient.println("");
        SampleConsoleClient.println("");
        if (client.isConnected()) {
            SampleConsoleClient.println("*** Connected to: " + client.getUri());
            SampleConsoleClient.println("");
            if (nodeId != null) {
                this.printCurrentNode(nodeId);
            }
        } else {
            SampleConsoleClient.println("*** NOT connected to: " + client.getUri());
        }
        System.out.println("-------------------------------------------------------");
        SampleConsoleClient.println("- Enter x to close client");
        System.out.println("-------------------------------------------------------");
        System.out.println("- Enter 0 to start discovery                          -");
        System.out.println("- Enter 1 to connect to server                        -");
        System.out.println("- Enter 2 to disconnect from server                   -");
        System.out.println("- Enter 3 to browse the server address space          -");
        System.out.println("- Enter 4 to read values                              -");
        System.out.println("- Enter 5 to write values                             -");
        System.out.println("- Enter 6 to register nodes                           -");
        System.out.println("- Enter 7 to unregister nodes                         -");
        if (this.subscription == null) {
            System.out.println("- Enter 8 to create a subscription                    -");
        } else {
            System.out.println("- Enter 8 to add a new item to the subscription       -");
        }
        System.out.println("- Enter 9 to call a method                            -");
        System.out.println("- Enter 10 to read history                            -");
        System.out.println("-------------------------------------------------------");
    }

    protected void printOutputArguments(UaMethod method, Variant[] outputs) throws ServiceException, AddressSpaceException, MethodArgumentException, StatusException {
        if (outputs != null && outputs.length > 0) {
            SampleConsoleClient.println("Output values:");
            Argument[] outputArguments = method.getOutputArguments();
            int i = 0;
            while (i < outputArguments.length) {
                UaType dataType = client.getAddressSpace().getType(outputArguments[i].getDataType());
                SampleConsoleClient.println(String.format("%s: %s {%s} = %s", outputArguments[i].getName(), dataType.getBrowseName(), outputArguments[i].getDescription().getText(), outputs[i].getValue()));
                ++i;
            }
        } else {
            SampleConsoleClient.println("OK (no output)");
        }
    }

    protected void printSecurityModes(List<SecurityMode> supportedSecurityModes) {
        SampleConsoleClient.println("SecurityModes supported by the server:");
        for (SecurityMode m : supportedSecurityModes) {
            SampleConsoleClient.println(m.toString());
        }
    }

    protected void printUserIdentityTokens(UserTokenPolicy[] supportedUserIdentityTokens) {
        SampleConsoleClient.println("The server supports the following user tokens:");
        UserTokenPolicy[] userTokenPolicyArray = supportedUserIdentityTokens;
        int n = supportedUserIdentityTokens.length;
        int n2 = 0;
        while (n2 < n) {
            UserTokenPolicy p = userTokenPolicyArray[n2];
            SampleConsoleClient.println(p.getTokenType().toString());
            ++n2;
        }
    }

    protected void promptSecurityMode() {
        SampleConsoleClient.println("Security mode is n=None");
        this.securityMode = SecurityMode.NONE;
    }

    protected String promptServerUri() throws IllegalArgumentException {
        SampleConsoleClient.println("No server URI defined. (Run with /? to see command line usage)");
        SampleConsoleClient.println("Use the default server URI\n'" + this.defaultServerUri);
        return this.defaultServerUri;
    }

    protected static void read(NodeId nodeId) throws ServiceException, StatusException {
        SampleConsoleClient.println("read node " + nodeId);
        UnsignedInteger attributeId = SampleConsoleClient.readAttributeId();
        DataValue value = client.readAttribute(nodeId, attributeId);
        SampleConsoleClient.println(SampleConsoleClient.dataValueToString(nodeId, attributeId, value));
    }

    protected static UnsignedInteger readAttributeId() {
        SampleConsoleClient.println("Select the node attribute.");
        long i = Attributes.NodeId.getValue();
        while (i < Attributes.UserExecutable.getValue()) {
            SampleConsoleClient.printf("%d - %s\n", i, AttributesUtil.toString((UnsignedInteger)UnsignedInteger.valueOf((long)i)));
            ++i;
        }
        int action = SampleConsoleClient.readAction();
        if (action < 0) {
            return null;
        }
        UnsignedInteger attributeId = UnsignedInteger.valueOf((long)action);
        System.out.println("attribute: " + AttributesUtil.toString((UnsignedInteger)attributeId));
        return attributeId;
    }

    protected void readHistory(NodeId nodeId) throws ServiceException, StatusException, AddressSpaceException {
        UaNode node = client.getAddressSpace().getNode(nodeId);
        if (node instanceof UaVariable) {
            UaVariable variable = (UaVariable)node;
            if (!variable.getAccessLevel().contains(AccessLevel.HistoryRead)) {
                SampleConsoleClient.println("The variable does not have history");
                return;
            }
            SampleConsoleClient.println("0 - raw data");
            SampleConsoleClient.println("1 - at times");
            int action = SampleConsoleClient.readAction();
            SampleConsoleClient.println("Reading history of variable " + variable.getBrowseName());
            try {
                DateTime endTime = DateTime.currentTime();
                DateTime startTime = new DateTime((endTime.getMilliSeconds() - 3600000L) * 10000L);
                DataValue[] values = null;
                switch (action) {
                    case 0: {
                        SampleConsoleClient.println("between " + startTime + " and " + endTime);
                        values = client.historyReadRaw(nodeId, startTime, endTime, UnsignedInteger.ONE, Boolean.valueOf(true), null, TimestampsToReturn.Source);
                        break;
                    }
                    case 1: {
                        SampleConsoleClient.println("at " + startTime + " and " + endTime);
                        DateTime[] reqTimes = new DateTime[]{startTime, endTime};
                        values = client.historyReadAtTimes(nodeId, reqTimes, null, TimestampsToReturn.Source);
                        break;
                    }
                    case 2: {
                        SampleConsoleClient.println("at " + startTime + " and " + endTime);
                        values = client.historyReadProcessed(nodeId, startTime, endTime, Double.valueOf(60000.0), Identifiers.AggregateFunction_Average, null, null, TimestampsToReturn.Source);
                    }
                }
                if (values != null) {
                    SampleConsoleClient.println("Count = " + values.length);
                    int i = 0;
                    while (i < values.length) {
                        SampleConsoleClient.println("Value " + (i + 1) + " = " + values[i].getValue().getValue() + " | " + values[i].getSourceTimestamp());
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                SampleConsoleClient.printException(e);
            }
        } else if (node instanceof UaObject) {
            UaObject object = (UaObject)node;
            if (!object.getEventNotifier().contains(EventNotifierClass.HistoryRead)) {
                SampleConsoleClient.println("The object does not have history");
                return;
            }
            SampleConsoleClient.println("Reading event history of node " + node);
            try {
                DateTime endTime = DateTime.currentTime();
                DateTime startTime = new DateTime((endTime.getMilliSeconds() - 3600000L) * 10000L);
                HistoryEventFieldList[] events = null;
                SampleConsoleClient.println("between " + startTime + " and " + endTime);
                this.initEventFieldNames();
                EventFilter eventFilter = this.createEventFilter(this.eventFieldNames);
                events = client.historyReadEvents(nodeId, startTime, endTime, UnsignedInteger.ZERO, eventFilter, TimestampsToReturn.Source);
                if (events != null) {
                    SampleConsoleClient.println("Count = " + events.length);
                    int i = 0;
                    while (i < events.length) {
                        SampleConsoleClient.println("Event " + (i + 1) + " = " + this.eventFieldsToString(this.eventFieldNames, events[i].getEventFields()));
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                SampleConsoleClient.printException(e);
            }
        } else {
            SampleConsoleClient.println("History is only available for object and variable nodes. The current node is a " + node.getNodeClass() + ".");
        }
    }

    protected Variant[] readInputArguments(UaMethod method) throws ServiceException, ServerConnectionException, AddressSpaceException, MethodArgumentException, StatusException {
        Argument[] inputArguments = method.getInputArguments();
        if (inputArguments == null || inputArguments.length == 0) {
            return new Variant[0];
        }
        Variant[] inputs = new Variant[inputArguments.length];
        SampleConsoleClient.println("Enter value for Inputs:");
        int i = 0;
        while (i < inputs.length) {
            UaDataType dataType = (UaDataType)client.getAddressSpace().getType(inputArguments[i].getDataType());
            SampleConsoleClient.println(String.format("%s: %s {%s} = ", inputArguments[i].getName(), dataType.getDisplayName().getText(), inputArguments[i].getDescription().getText()));
            while (inputs[i] == null) {
                try {
                    inputs[i] = client.getAddressSpace().getDataTypeConverter().parseVariant(SampleConsoleClient.readInput(false), dataType);
                }
                catch (NumberFormatException e) {
                    SampleConsoleClient.printException(e);
                }
            }
            ++i;
        }
        return inputs;
    }

    protected NodeId readMethodId(NodeId nodeId) throws ServerConnectionException, ServiceException, StatusException, AddressSpaceException {
        int action;
        NodeClass nodeClass = client.getAddressSpace().getNode(nodeId).getNodeClass();
        if (!nodeClass.equals((Object)NodeClass.Object)) {
            SampleConsoleClient.println("Not in an object.");
            SampleConsoleClient.println("You must be in an object that has methods to be able to call methods.");
            if (nodeClass.equals((Object)NodeClass.Method)) {
                SampleConsoleClient.println("Since you are currently at a method node, back up one step to the object.");
            }
            return null;
        }
        List methods = client.getAddressSpace().getMethods(nodeId);
        if (methods.size() == 0) {
            SampleConsoleClient.println("No methods available.");
            return null;
        }
        SampleConsoleClient.println("Select the method to execute.");
        int i = 0;
        while (i < methods.size()) {
            SampleConsoleClient.printf("%d - %s\n", i, ((UaMethod)methods.get(i)).getDisplayName().getText());
            ++i;
        }
        while ((action = SampleConsoleClient.readAction()) >= methods.size()) {
        }
        if (action < 0) {
            return null;
        }
        NodeId methodId = ((UaMethod)methods.get(action)).getNodeId();
        System.out.println("Method: " + methodId);
        return methodId;
    }

    protected String referenceToString(ReferenceDescription r) throws ServerConnectionException, ServiceException, StatusException {
        String typeStr;
        if (r == null) {
            return "";
        }
        String referenceTypeStr = null;
        try {
            UaReferenceType referenceType = (UaReferenceType)client.getAddressSpace().getType(r.getReferenceTypeId());
            if (referenceType != null && referenceType.getDisplayName() != null) {
                referenceTypeStr = r.getIsForward().booleanValue() ? referenceType.getDisplayName().getText() : referenceType.getInverseName().getText();
            }
        }
        catch (AddressSpaceException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
            SampleConsoleClient.print(r.toString());
            referenceTypeStr = r.getReferenceTypeId().getValue().toString();
        }
        switch (r.getNodeClass()) {
            case Object: 
            case Variable: {
                try {
                    UaNode type = client.getAddressSpace().getNode(r.getTypeDefinition());
                    if (type != null) {
                        typeStr = type.getDisplayName().getText();
                        break;
                    }
                    typeStr = r.getTypeDefinition().getValue().toString();
                }
                catch (AddressSpaceException e) {
                    SampleConsoleClient.printException((Exception)((Object)e));
                    SampleConsoleClient.print("type not found: " + r.getTypeDefinition().toString());
                    typeStr = r.getTypeDefinition().getValue().toString();
                }
                break;
            }
            default: {
                typeStr = this.nodeClassToStr(r.getNodeClass());
            }
        }
        return String.format("%s%s (ReferenceType=%s, BrowseName=%s%s)", r.getDisplayName().getText(), ": " + typeStr, referenceTypeStr, r.getBrowseName(), r.getIsForward() != false ? "" : " [Inverse]");
    }

    protected void registerNodes(NodeId nodeId) {
        try {
            NodeId[] registeredNodeId = client.getAddressSpace().registerNodes(new NodeId[]{nodeId});
            SampleConsoleClient.println("Registered NodeId " + nodeId + " -> registeredNodeId is " + registeredNodeId[0]);
        }
        catch (ServiceException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
        }
    }

    protected void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    protected void subscribe(NodeId nodeId) {
        if (nodeId == null) {
            SampleConsoleClient.println("*** Select a node to subscribe first ");
            SampleConsoleClient.println("");
            return;
        }
        SampleConsoleClient.println("*** Subscribing to node: " + nodeId);
        SampleConsoleClient.println("");
        UnsignedInteger attributeId = SampleConsoleClient.readAttributeId();
        if (attributeId != null) {
            try {
                if (this.subscription == null) {
                    this.subscription = this.createSubscription();
                }
                this.createMonitoredItem(this.subscription, nodeId, attributeId);
            }
            catch (ServiceException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
            catch (StatusException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
            try {
                this.subscriptionMenu();
            }
            catch (ServiceException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
            catch (StatusException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
            }
        }
    }

    protected void subscribeToInitialItems() {
        if (!this.initialMonitoredItems.isEmpty()) {
            try {
                if (this.subscription == null) {
                    this.subscription = this.createSubscription();
                }
            }
            catch (ServiceException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
                return;
            }
            catch (StatusException e) {
                SampleConsoleClient.printException((Exception)((Object)e));
                return;
            }
        }
        for (String s : this.initialMonitoredItems) {
            try {
                if (s.endsWith("/*")) {
                    this.createMonitoredItemsForChildren(this.subscription, s);
                    continue;
                }
                this.createMonitoredItem(this.subscription, NodeId.parseNodeId((String)s), Attributes.Value);
            }
            catch (IllegalArgumentException e1) {
                SampleConsoleClient.printException(e1);
            }
            catch (ServiceException e1) {
                SampleConsoleClient.printException((Exception)((Object)e1));
            }
            catch (StatusException e1) {
                SampleConsoleClient.printException((Exception)((Object)e1));
            }
        }
        try {
            if (this.subscription != null) {
                this.subscriptionMenu();
            }
        }
        catch (ServiceException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
        }
        catch (StatusException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void subscriptionMenu() throws ServiceException, StatusException {
        this.subscription.setPublishingEnabled(true);
        while (true) lbl-1000:
        // 8 sources

        {
            SampleConsoleClient.println("-------------------------------------------------------");
            SampleConsoleClient.println("- Enter x to end (and remove) the subcription");
            SampleConsoleClient.println("- Enter p to pause the subscription (e.g. to add new items)");
            SampleConsoleClient.println("- Enter r to remove an item from the subscription");
            SampleConsoleClient.println("- Enter i to change the publishing interval of the subscription");
            SampleConsoleClient.println("-------------------------------------------------------");
            input = SampleConsoleClient.readInput(true);
            if (input.equals("r")) {
                this.subscription.setPublishingEnabled(false);
                try {
                    removedItem = null;
                    while (true) {
                        if (removedItem != null) ** GOTO lbl-1000
                        SampleConsoleClient.println("-------------------------------------------------------");
                        SampleConsoleClient.println("Monitored Items:");
                        var6_13 = this.subscription.getItems();
                        var5_11 = var6_13.length;
                        var4_8 = 0;
                        while (var4_8 < var5_11) {
                            item = var6_13[var4_8];
                            SampleConsoleClient.println(item.toString());
                            ++var4_8;
                        }
                        SampleConsoleClient.println("- Enter the ClientHandle of the item to remove it");
                        SampleConsoleClient.println("- Enter x to cancel.");
                        SampleConsoleClient.println("-------------------------------------------------------");
                        handleStr = SampleConsoleClient.readInput(true);
                        if (handleStr.equals("x")) ** GOTO lbl-1000
                        try {
                            handle = UnsignedInteger.parseUnsignedInteger((String)handleStr);
                            removedItem = this.subscription.removeItem(handle);
                            SampleConsoleClient.printf(removedItem != null ? "Item %s removed\n" : "No such item: %s\n", new Object[]{handle});
                        }
                        catch (Exception e) {
                            SampleConsoleClient.printException(e);
                        }
                    }
                }
                finally {
                    this.subscription.setPublishingEnabled(true);
                }
                continue;
            }
            if (input.equals("p")) {
                this.subscription.setPublishingEnabled(false);
                ** break;
            }
            if (input.equals("x")) {
                try {
                    sc = SampleConsoleClient.client.removeSubscription(this.subscription);
                    if (sc != null && sc.isNotGood()) {
                        throw new StatusException(sc);
                    }
                }
                catch (Exception e) {
                    SampleConsoleClient.print("Got exception while deleting Subscription: ");
                    SampleConsoleClient.printException(e);
                }
                this.subscription = null;
                ** break;
            }
            if (!input.equals("i")) continue;
            wasEnabled = this.subscription.isPublishingEnabled();
            SampleConsoleClient.println("Current publishing interval is " + this.subscription.getPublishingInterval() + " ms");
            SampleConsoleClient.print("New publishing interval: ");
            try {
                this.subscription.setPublishingEnabled(false);
                try {
                    interval = Double.parseDouble(SampleConsoleClient.readInput(true));
                    this.subscription.setPublishingInterval(interval);
                    SampleConsoleClient.println("Publishing interval changed to " + interval + " ms");
                }
                catch (NumberFormatException e) {
                    SampleConsoleClient.printException(e);
                }
            }
            finally {
                this.subscription.setPublishingEnabled(wasEnabled);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
lbl74:
        // 2 sources

    }

    protected void unregisterNodes() {
        try {
            NodeId[] nodes = client.getAddressSpace().unregisterAllNodes();
            SampleConsoleClient.println("Unregistered " + nodes.length + " node(s).");
        }
        catch (ServiceException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
        }
    }

    protected void write(NodeId nodeId) throws ServiceException, AddressSpaceException, StatusException {
        UnsignedInteger attributeId = SampleConsoleClient.readAttributeId();
        UaNode node = client.getAddressSpace().getNode(nodeId);
        SampleConsoleClient.println("Writing to node " + nodeId + " - " + node.getDisplayName().getText());
        UaDataType dataType = null;
        if (attributeId.equals((Object)Attributes.Value) && node instanceof UaVariable) {
            UaVariable v = (UaVariable)node;
            if (v.getDataType() == null) {
                v.setDataType(client.getAddressSpace().getType(v.getDataTypeId()));
            }
            dataType = (UaDataType)v.getDataType();
            SampleConsoleClient.println("DataType: " + dataType.getDisplayName().getText());
        }
        SampleConsoleClient.print("Enter the value to write: ");
        String value = SampleConsoleClient.readInput(true);
        try {
            String convertedValue = dataType != null ? client.getAddressSpace().getDataTypeConverter().parseVariant(value, dataType) : value;
            boolean status = client.writeAttribute(nodeId, attributeId, (Object)convertedValue);
            if (status) {
                SampleConsoleClient.println("OK");
            } else {
                SampleConsoleClient.println("OK (completes asynchronously)");
            }
        }
        catch (ServiceException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
        }
        catch (StatusException e) {
            SampleConsoleClient.printException((Exception)((Object)e));
        }
    }

    ApplicationDescription discoverServer(String uri) throws ServerListException {
        ServerList serverList = new ServerList(uri);
        if (serverList.size() == 0) {
            SampleConsoleClient.println("No servers found");
            return null;
        }
        SampleConsoleClient.println(String.format("%s - %-25s - %-15s - %-30s - %s", "#", "Name", "Type", "Product", "Application"));
        int i = 0;
        while (i < serverList.size()) {
            ApplicationDescription s = serverList.get(i);
            SampleConsoleClient.println(String.format("%d - %-25s - %-15s - %-30s - %s", i, s.getApplicationName().getText(), s.getApplicationType(), s.getProductUri(), s.getApplicationUri()));
            ++i;
        }
        System.out.println("-------------------------------------------------------");
        SampleConsoleClient.println("- Enter client number to select that one");
        SampleConsoleClient.println("- Enter x to return to cancel");
        System.out.println("-------------------------------------------------------");
        int action = SampleConsoleClient.readAction();
        switch (action) {
            case -1: {
                return null;
            }
        }
        return serverList.get(action);
    }
}

