/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.CreateTypedArray;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;

public class OpcuaUtils {
    public String getTypeIdString(NodeId identifier) {
        if (identifier == null) {
            return "";
        }
        int id1 = Integer.parseInt(identifier.getValue().toString());
        switch (id1) {
            case 29: {
                return "Enumeration";
            }
            case 6: {
                return "Int32";
            }
            case 4: {
                return "Int16";
            }
            case 8: {
                return "Int64";
            }
            case 27: {
                return "Integer";
            }
            case 7: {
                return "UInt32";
            }
            case 5: {
                return "UInt16";
            }
            case 9: {
                return "UInt64";
            }
            case 28: {
                return "UInteger";
            }
            case 11: {
                return "Double";
            }
            case 10: {
                return "Float";
            }
            case 1: {
                return "Boolean";
            }
            case 12: {
                return "String";
            }
            case 2: {
                return "SByte";
            }
            case 3: {
                return "Byte";
            }
            case 15: {
                return "ByteString";
            }
            case 23: {
                return "DataValue";
            }
            case 293: {
                return "Date";
            }
            case 12881: {
                return "DateString";
            }
            case 13: {
                return "DateTime";
            }
        }
        return "***";
    }

    public int getType(NodeId identifier) {
        if (identifier == null) {
            return -1;
        }
        int id1 = Integer.parseInt(identifier.getValue().toString());
        switch (id1) {
            case 29: {
                return -1;
            }
            case 6: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 27: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 28: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 15: {
                return -1;
            }
            case 23: {
                return 3;
            }
            case 293: {
                return 4;
            }
            case 12881: {
                return 5;
            }
            case 13: {
                return 6;
            }
        }
        return -1;
    }

    public Object setInitValue(String idString, String iValue) {
        if (idString == null) {
            return null;
        }
        int vectorSize = 0;
        try {
            int idx;
            if (idString.contains("[") & idString.contains("]")) {
                vectorSize = Integer.parseInt(idString.substring(idString.indexOf("[") + 1, idString.indexOf("]")).trim());
                idx = idString.indexOf("[", 0);
                if (idString.indexOf("]", idx + 1) > 0) {
                    idString = idString.substring(0, idString.indexOf("[")).trim();
                }
            }
            if (idString.contains("*")) {
                vectorSize = this.getSizeValueFromPosition(idString, "*", 2);
                idx = idString.indexOf("*", 0);
                if (idString.indexOf("*", idx + 1) > 0) {
                    idString = idString.substring(0, idString.indexOf("*")).trim();
                }
            }
            switch (idString.toUpperCase()) {
                case "I32": 
                case "INT32": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return Integer.parseInt(iValue);
                    }
                    return CreateTypedArray.getInt32Array(vectorSize);
                }
                case "I64": 
                case "INT64": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return Long.parseLong(iValue);
                    }
                    return CreateTypedArray.getInt64Array(vectorSize);
                }
                case "I16": 
                case "INT16": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return Short.parseShort(iValue);
                    }
                    return CreateTypedArray.getInt16Array(vectorSize);
                }
                case "UINT32": 
                case "UI32": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return UnsignedInteger.parseUnsignedInteger((String)iValue);
                    }
                    return CreateTypedArray.getUInt32Array(vectorSize);
                }
                case "UINT64": 
                case "UI64": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return UnsignedLong.parseUnsignedLong((String)iValue);
                    }
                    return CreateTypedArray.getUInt64Array(vectorSize);
                }
                case "UINT16": 
                case "UI16": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return UnsignedShort.parseUnsignedShort((String)iValue);
                    }
                    return CreateTypedArray.getUInt16Array(vectorSize);
                }
                case "DBL": 
                case "DOUBLE": {
                    if (iValue.isEmpty()) {
                        iValue = "0.0";
                    }
                    if (vectorSize == 0) {
                        return Double.parseDouble(iValue);
                    }
                    return CreateTypedArray.getDoubleArray(vectorSize);
                }
                case "FLT": 
                case "FLOAT": {
                    if (iValue.isEmpty()) {
                        iValue = "0.0";
                    }
                    if (vectorSize == 0) {
                        return Float.valueOf(Float.parseFloat(iValue));
                    }
                    return CreateTypedArray.getFloatArray(vectorSize);
                }
                case "B": 
                case "BOOL": 
                case "BOOLEAN": {
                    if (iValue.isEmpty()) {
                        iValue = "TRUE";
                    }
                    if (vectorSize == 0) {
                        return Boolean.parseBoolean(iValue);
                    }
                    return CreateTypedArray.getBooleanArray(vectorSize);
                }
                case "STRING": 
                case "STR": 
                case "BYTESTRING": {
                    if (iValue.isEmpty()) {
                        iValue = "*****";
                    }
                    if (vectorSize == 0) {
                        return iValue;
                    }
                    return CreateTypedArray.getStringArray(vectorSize);
                }
                case "BYTE": 
                case "SBYTE": {
                    if (iValue.isEmpty()) {
                        iValue = "0";
                    }
                    if (iValue.contains(".")) {
                        iValue = iValue.substring(0, iValue.indexOf("."));
                    }
                    if (vectorSize == 0) {
                        return Byte.parseByte(iValue);
                    }
                    return CreateTypedArray.getByteArray(vectorSize);
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("ERROR > idString:" + idString + "  iValue:" + iValue);
            return null;
        }
    }

    private int getSizeValueFromPosition(String str, String find, int pos) {
        int index = 0;
        int count = 1;
        while (true) {
            int index1 = str.indexOf(find, index);
            if (count == pos) {
                String sVal = "";
                sVal = index1 == -1 ? str.substring(index) : str.substring(index, index1);
                return Integer.parseInt(sVal);
            }
            if (index1 == -1 && count > pos) {
                return -1;
            }
            index = index1 + find.length();
            ++count;
        }
    }
}

