/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.SampleConsoleClient;
import com.prosysopc.ua.client.ConnectException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.UaClientListener;
import org.opcfoundation.ua.application.Session;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.PublishRequest;
import org.opcfoundation.ua.core.PublishResponse;
import org.opcfoundation.ua.core.RepublishResponse;

public class MyUaClientListener
implements UaClientListener {
    private static final long ALLOWED_PUBLISHTIME_DIFFERENCE = 3600000L;
    private static boolean publishTimeOverride = false;
    private static final double UNREALISTIC_LONG_TIMEOUT = 8.64E7;
    private static final double UNREALISTIC_SHORT_TIMEOUT = 10000.0;

    public void onAfterCreateSessionChannel(UaClient client, Session session) throws ConnectException {
        String input;
        Session s = client.getSession();
        if (s.getSessionTimeout() <= 10000.0) {
            this.pl("The RevisedSessionTimeout is unrealistically short: " + s.getSessionTimeout() + " ms. Do you still want to connect? y=Yes, anything else is No");
            input = SampleConsoleClient.readInput(false).toLowerCase();
            if (!input.equals("y")) {
                throw new ConnectException("Canceled by user", "", null);
            }
        }
        if (s.getSessionTimeout() >= 8.64E7) {
            this.pl("The RevisedSessionTimeout is unrealistically long: " + s.getSessionTimeout() + " ms. Do you still want to connect? y=Yes, anything else is No");
            input = SampleConsoleClient.readInput(false).toLowerCase();
            if (!input.equals("y")) {
                throw new ConnectException("Canceled by user", "", null);
            }
        }
        if ((s.getServerNonce() == null || s.getServerNonce().length < 32) && MessageSecurityMode.None != client.getSecurityMode().getMessageSecurityMode()) {
            this.pl("The serverNonce is less than 32 bytes, Do you still want to connect? y=Yes, anything else is No");
            input = SampleConsoleClient.readInput(false).toLowerCase();
            if (!input.equals("y")) {
                throw new ConnectException("Canceled by user", "", null);
            }
        }
    }

    public void onBeforePublishRequest(UaClient client, PublishRequest publishRequest) {
    }

    public boolean validatePublishResponse(UaClient client, PublishResponse response) {
        return this.validatePublishTime(response.getNotificationMessage().getPublishTime());
    }

    public boolean validateRepublishResponse(UaClient client, RepublishResponse response) {
        return this.validatePublishTime(response.getNotificationMessage().getPublishTime());
    }

    private void pl(String line) {
        SampleConsoleClient.println(line);
    }

    private boolean validatePublishTime(DateTime publishTime) {
        if (publishTimeOverride) {
            return true;
        }
        long diff = Math.abs(DateTime.currentTime().getTimeInMillis() - publishTime.getTimeInMillis());
        if (diff > 3600000L && !publishTime.equals((Object)DateTime.MIN_VALUE) && !publishTime.equals((Object)DateTime.MAX_VALUE)) {
            this.pl(String.format("PublishResponse PublishTime difference to current time more than allowed,  discarding data, (%sms vs %sms)", diff, 3600000L));
            return false;
        }
        return true;
    }
}

