/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.SampleConsoleClient;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.NotificationData;

public class MySubscriptionNotificationListener
implements SubscriptionNotificationListener {
    public void onBufferOverflow(Subscription subscription, UnsignedInteger sequenceNumber, ExtensionObject[] notificationData) {
        SampleConsoleClient.println("*** SUBCRIPTION BUFFER OVERFLOW ***");
    }

    public void onDataChange(Subscription subscription, MonitoredDataItem item, DataValue newValue) {
        try {
            switch (item.getNodeId().getValue().toString()) {
                case "icmp_fail_percentage_array": {
                    if (item.getValue().getValue().isArray()) {
                        int[] i1 = item.getValue().getValue().getArrayDimensions();
                        System.out.println("arrayLength " + i1[0] + "  occurrence-->" + this.countOccurence(newValue.getValue().toString(), ","));
                    }
                    break;
                }
                case "local_ping_response": {
                    System.out.println("Value -->" + newValue.getValue().getValue().toString());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        SampleConsoleClient.println("Data notification:  " + item.getNodeId().getValue().toString() + "  Value: " + newValue.getValue().toString());
    }

    private int countOccurence(String str, String find) {
        int index = 0;
        int count = 0;
        if (str == null) {
            return 0;
        }
        while ((index = str.indexOf(find, index)) != -1) {
            index += find.length();
            ++count;
        }
        return count;
    }

    public void onError(Subscription subscription, Object notification, Exception exception) {
        SampleConsoleClient.printException(exception);
    }

    public void onEvent(Subscription subscription, MonitoredEventItem item, Variant[] eventFields) {
    }

    public long onMissingData(UnsignedInteger lastSequenceNumber, long sequenceNumber, long newSequenceNumber, StatusCode serviceResult) {
        SampleConsoleClient.println("Data missed: lastSequenceNumber=" + lastSequenceNumber + " newSequenceNumber=" + newSequenceNumber);
        return newSequenceNumber;
    }

    public void onNotificationData(Subscription subscription, NotificationData notification) {
    }

    public void onStatusChange(Subscription subscription, StatusCode oldStatus, StatusCode newStatus, DiagnosticInfo diagnosticInfo) {
    }
}

