/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.SampleConsoleClient;
import com.prosysopc.ua.CertificateValidationListener;
import com.prosysopc.ua.PkiFileBasedCertificateValidator;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.EnumSet;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.utils.CertificateUtils;

public class MyCertificateValidationListener
implements CertificateValidationListener {
    public PkiFileBasedCertificateValidator.ValidationResult onValidate(Cert certificate, ApplicationDescription applicationDescription, EnumSet<PkiFileBasedCertificateValidator.CertificateCheck> passedChecks) {
        this.println("");
        this.println("*** The Server Certificate : ");
        this.println("");
        this.println("Subject   : " + certificate.getCertificate().getSubjectX500Principal().toString());
        this.println("Issued by : " + certificate.getCertificate().getIssuerX500Principal().toString());
        this.println("Valid from: " + certificate.getCertificate().getNotBefore().toString());
        this.println("        to: " + certificate.getCertificate().getNotAfter().toString());
        this.println("");
        if (!passedChecks.contains(PkiFileBasedCertificateValidator.CertificateCheck.Signature)) {
            this.println("* The Certificate is NOT SIGNED BY A TRUSTED SIGNER!");
        }
        if (!passedChecks.contains(PkiFileBasedCertificateValidator.CertificateCheck.Validity)) {
            boolean isOld;
            Date today = new Date();
            boolean isYoung = certificate.getCertificate().getNotBefore().compareTo(today) > 0;
            boolean bl = isOld = certificate.getCertificate().getNotAfter().compareTo(today) < 0;
            String oldOrYoung = isOld ? "(anymore)" : (isYoung ? "(yet)" : "");
            this.println("* The Certificate time interval IS NOT VALID " + oldOrYoung + "!");
        }
        if (!passedChecks.contains(PkiFileBasedCertificateValidator.CertificateCheck.Uri)) {
            this.println("* The Certificate URI DOES NOT MATCH the ApplicationDescription URI!");
            this.println("    ApplicationURI in ApplicationDescription = " + applicationDescription.getApplicationUri());
            try {
                this.println("    ApplicationURI in Certificate            = " + CertificateUtils.getApplicationUriOfCertificate((Cert)certificate));
            }
            catch (CertificateParsingException e) {
                this.println("    ApplicationURI in Certificate is INVALID");
            }
        }
        if (passedChecks.contains(PkiFileBasedCertificateValidator.CertificateCheck.SelfSigned)) {
            this.println("* The Certificate is self-signed.");
        }
        this.println("");
        if (passedChecks.containsAll(PkiFileBasedCertificateValidator.CertificateCheck.COMPULSORY)) {
            return PkiFileBasedCertificateValidator.ValidationResult.AcceptPermanently;
        }
        while (true) {
            this.println("Note: If the certificate is not OK,");
            this.println("you will be prompted again, even if you answer 'Always' here.");
            this.println("");
            this.println("Do you want to accept this certificate?\n (A=Always, Y=Yes, this time, N=No)\n (D=Show Details of the Certificate)");
            String input = this.readInput().toLowerCase();
            if (input.equals("a")) {
                return PkiFileBasedCertificateValidator.ValidationResult.AcceptPermanently;
            }
            if (input.equals("y")) {
                return PkiFileBasedCertificateValidator.ValidationResult.AcceptOnce;
            }
            if (input.equals("n")) {
                return PkiFileBasedCertificateValidator.ValidationResult.Reject;
            }
            if (!input.equals("d")) continue;
            this.println("Certificate Details:" + certificate.getCertificate().toString());
        }
    }

    private void println(String string) {
        SampleConsoleClient.println(string);
    }

    private String readInput() {
        return SampleConsoleClient.readInput(false);
    }
}

