/*
 * Decompiled with CFR 0.152.
 */
package asc.client;

import asc.client.ASC_OpcuaClient;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import gui.AIV_GUI;
import gui.DataInputForm;
import gui.HistoryPlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import myproc.ErrorForm;
import myproc.Utils;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;

public class ASCGUI
extends JFrame {
    public JComboBox deviceComboBox = new JComboBox();
    public static ASC_OpcuaClient ws_WorkClient;
    public ASC_OpcuaClient ws1_OpcuaClient = new ASC_OpcuaClient();
    public ASC_OpcuaClient ws2_OpcuaClient = new ASC_OpcuaClient();
    public int wsIndex = 0;
    public ErrorForm errorForm;
    public static DataInputForm wsDataInputForm;
    public static HistoryPlot historyPlot;
    public JCheckBox historyCheckBox = new JCheckBox("PlotHistory");
    public JTree tree = new JTree();
    public JButton exitButton = new JButton("END");
    public static JLabel ledLabel;
    public JComboBox historyComboBox = new JComboBox();
    public static JMenuItem hideNewMenuItem;
    public JLabel errorNoLabel = new JLabel("ErrNo=");
    private Thread heartBeatThread = new Thread(){

        @Override
        public synchronized void run() {
            int oldValue = ASCGUI.ws_WorkClient.heartbeat;
            while (true) {
                try {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (oldValue != ASCGUI.ws_WorkClient.heartbeat) {
                            oldValue = ASCGUI.ws_WorkClient.heartbeat;
                            if (ledLabel.getForeground() == Color.gray) {
                                ledLabel.setForeground(Color.green);
                            } else {
                                ledLabel.setForeground(Color.gray);
                            }
                        } else {
                            ledLabel.setForeground(Color.red);
                        }
                        ASCGUI.this.textField_0.setText(ASCGUI.ws_WorkClient.extTemp.subSequence(0, ASCGUI.ws_WorkClient.extTemp.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_1.setText(ASCGUI.ws_WorkClient.extUmid);
                        ASCGUI.this.textField_2.setText(ASCGUI.ws_WorkClient.insideTemp.subSequence(0, ASCGUI.ws_WorkClient.insideTemp.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_3.setText(ASCGUI.ws_WorkClient.insideUmid);
                        ASCGUI.this.textField_4.setText(ASCGUI.ws_WorkClient.windSpeed.subSequence(0, ASCGUI.ws_WorkClient.windSpeed.indexOf(".") + 2).toString());
                        ASCGUI.this.extraWindField.setText(ASCGUI.ws_WorkClient.windSpeed.subSequence(0, ASCGUI.ws_WorkClient.windSpeed.indexOf(".") + 2).toString());
                        ASCGUI.this.extraGustField.setText(ASCGUI.ws_WorkClient.windGust10m.subSequence(0, ASCGUI.ws_WorkClient.windGust10m.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_5.setText(ASCGUI.ws_WorkClient.windDir);
                        ASCGUI.this.textField_6.setText(ASCGUI.ws_WorkClient.barometer.subSequence(0, ASCGUI.ws_WorkClient.barometer.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_7.setText(ASCGUI.ws_WorkClient.solarRad);
                        ASCGUI.this.textField_8.setText(ASCGUI.ws_WorkClient.uvRad.subSequence(0, ASCGUI.ws_WorkClient.uvRad.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_9.setText(ASCGUI.ws_WorkClient.consoleBatt.subSequence(0, ASCGUI.ws_WorkClient.consoleBatt.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_10.setText(ASCGUI.ws_WorkClient.issBatt);
                        ASCGUI.this.textField_11.setText(ASCGUI.ws_WorkClient.dewpoint.subSequence(0, ASCGUI.ws_WorkClient.dewpoint.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_12.setText(ASCGUI.ws_WorkClient.windGust10m.subSequence(0, ASCGUI.ws_WorkClient.windGust10m.indexOf(".") + 2).toString());
                        ASCGUI.this.textField_13.setText(ASCGUI.ws_WorkClient.win10avg.subSequence(0, ASCGUI.ws_WorkClient.win10avg.indexOf(".") + 2).toString());
                        ASCGUI.ws_WorkClient.errorNumber = ws_WorkClient.getDataValue("ns=2;s=ws_error_number").getValue().toNumber().intValue();
                        ASCGUI.this.errorNoLabel.setText("ErrNo= " + Integer.toString(ASCGUI.ws_WorkClient.errorNumber));
                        ASCGUI.this.textFieldTime.setText("Updated at:  " + ASCGUI.ws_WorkClient.isoStamp);
                    }
                }
                catch (Exception e) {
                    ASCGUI.this.textField_0.setText("--");
                    ASCGUI.this.textField_1.setText("--");
                    ASCGUI.this.textField_2.setText("--");
                    ASCGUI.this.textField_3.setText("--");
                    ASCGUI.this.textField_4.setText("--");
                    ASCGUI.this.textField_5.setText("--");
                    ASCGUI.this.textField_6.setText("--");
                    ASCGUI.this.textField_7.setText("--");
                    ASCGUI.this.textField_8.setText("--");
                    ASCGUI.this.textField_9.setText("--");
                    ASCGUI.this.textField_10.setText("--");
                    ASCGUI.this.textField_11.setText("--");
                    ASCGUI.this.textField_12.setText("--");
                    ASCGUI.this.textField_13.setText("--");
                    ASCGUI.this.textFieldTime.setText("--");
                    ASCGUI.this.errorNoLabel.setText("ErrNo= --");
                    ASCGUI.this.extraWindField.setText("--");
                    ASCGUI.this.extraGustField.setText("--");
                    continue;
                }
                break;
            }
        }
    };
    private JTextField textField_0;
    private JTextField textField_1;
    private JTextField textField_2;
    private JTextField textField_3;
    private JTextField textField_4;
    private JTextField textField_5;
    private JTextField textField_6;
    private JTextField textField_7;
    private JTextField textField_8;
    private JTextField textField_9;
    private JTextField textField_10;
    private JTextField textField_11;
    private JTextField extraWindField;
    private JTextField textField_12;
    private JTextField extraGustField;
    private JTextField textFieldTime;
    private JTextField textField_13;

    static {
        wsDataInputForm = new DataInputForm("WS");
        historyPlot = new HistoryPlot();
        ledLabel = new JLabel("\u2022");
        hideNewMenuItem = new JMenuItem("Hide");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Utils.getProperties();
                    AIV_GUI.consolle.setVisible(true);
                    ASCGUI window = new ASCGUI("");
                    window.setVisible(true);
                    window.exitButton.setVisible(true);
                    hideNewMenuItem.setEnabled(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ASCGUI(String devCode) {
        this.setTitle("SQMGUI - v1.1.0 - PBr041122 for ASTRI-MiniArray Project ");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("./conf/davis.png"));
        this.ws1_OpcuaClient.startClient(Utils.ws1URL);
        this.ws2_OpcuaClient.startClient(Utils.ws2URL);
        ws_WorkClient = this.ws1_OpcuaClient;
        this.errorForm = new ErrorForm("WS1", "ws_error_index", "ws_error_info", "ws_error_reset", 2, ASCGUI.ws_WorkClient.client, "ws_error_information", "ws_error_number");
        this.heartBeatThread.start();
        this.setResizable(false);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu wsNewMenu = new JMenu("File");
        wsNewMenu.setFont(new Font("Segoe UI", 1, 12));
        menuBar.add(wsNewMenu);
        hideNewMenuItem.setFont(new Font("Segoe UI", 1, 12));
        hideNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ASCGUI.this.setVisible(false);
            }
        });
        wsNewMenu.add(hideNewMenuItem);
        JMenuItem mntmNewMenuItem = new JMenuItem("Consolle");
        mntmNewMenuItem.setFont(new Font("Segoe UI", 1, 12));
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    AIV_GUI.consolle.setVisible(true);
                }
            }
        });
        JMenuItem mntmNewMenuItem_1 = new JMenuItem("ErrorForm");
        mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ASCGUI.this.errorForm.setVisible(true);
            }
        });
        mntmNewMenuItem_1.setFont(new Font("Segoe UI", 1, 12));
        wsNewMenu.add(mntmNewMenuItem_1);
        wsNewMenu.add(mntmNewMenuItem);
        JLabel deviceNameLabel_1 = new JLabel("  Set --> ");
        deviceNameLabel_1.setHorizontalAlignment(0);
        deviceNameLabel_1.setForeground(Color.BLUE);
        deviceNameLabel_1.setFont(new Font("Tahoma", 1, 14));
        menuBar.add(deviceNameLabel_1);
        this.deviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int indx;
                ASCGUI.this.wsIndex = indx = ASCGUI.this.deviceComboBox.getSelectedIndex();
                ws_WorkClient = indx == 0 ? ASCGUI.this.ws1_OpcuaClient : ASCGUI.this.ws2_OpcuaClient;
                ASCGUI.this.errorForm.dispose();
                ASCGUI.this.errorForm = new ErrorForm("WS" + (indx + 1), "ws_error_index", "ws_error_info", "ws_error_reset", 2, ASCGUI.ws_WorkClient.client, "ws_error_information", "ws_error_number");
            }
        });
        this.deviceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\u2022 WS1 near ASTRI6", "\u2022 __WS2 near.."}));
        this.deviceComboBox.setSelectedIndex(0);
        this.deviceComboBox.setInheritsPopupMenu(true);
        this.deviceComboBox.setFont(new Font("Tahoma", 1, 14));
        this.deviceComboBox.setBackground(Color.YELLOW);
        menuBar.add(this.deviceComboBox);
        Component horizontalStrut_1 = Box.createHorizontalStrut(6);
        menuBar.add(horizontalStrut_1);
        this.textFieldTime = new JTextField();
        this.textFieldTime.setToolTipText("last update");
        this.textFieldTime.setAutoscrolls(false);
        this.textFieldTime.setText("---");
        this.textFieldTime.setHorizontalAlignment(0);
        this.textFieldTime.setFont(new Font("Tahoma", 1, 12));
        this.textFieldTime.setColumns(10);
        this.textFieldTime.setBackground(new Color(255, 255, 230));
        menuBar.add(this.textFieldTime);
        ledLabel.setVerticalAlignment(3);
        ledLabel.setToolTipText("heartBeat");
        ledLabel.setSize(new Dimension(15, 2));
        ledLabel.setPreferredSize(new Dimension(20, 4));
        ledLabel.setHorizontalTextPosition(0);
        ledLabel.setHorizontalAlignment(0);
        ledLabel.setForeground(Color.RED);
        ledLabel.setFont(new Font("Tahoma", 1, 25));
        menuBar.add(ledLabel);
        this.getContentPane().setLayout(null);
        this.treeSetModel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(10, 0, 187, 309);
        this.getContentPane().add(scrollPane);
        scrollPane.setViewportView(this.tree);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath tp = ASCGUI.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp.getPath().length == 3) {
                    ASCGUI.this.jtreeToOpcua(tp.getPath()[1].toString(), tp.getPath()[2].toString());
                }
            }
        });
        this.tree.setToolTipText("this is my tree...");
        this.tree.setScrollsOnExpand(false);
        this.tree.setName("WStree");
        this.tree.setForeground(Color.LIGHT_GRAY);
        this.tree.setFont(new Font("SansSerif", 0, 10));
        this.tree.setBackground(new Color(255, 255, 204));
        this.historyCheckBox.setFont(new Font("SansSerif", 1, 12));
        this.historyCheckBox.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.historyCheckBox.setBackground(new Color(255, 255, 204));
        this.historyCheckBox.setAlignmentX(0.5f);
        this.historyCheckBox.setBounds(10, 320, 89, 20);
        this.getContentPane().add(this.historyCheckBox);
        this.exitButton.setBorder(new BevelBorder(0, null, null, null, null));
        this.exitButton.setToolTipText("End");
        this.exitButton.setBounds(441, 320, 74, 36);
        this.exitButton.setVisible(false);
        this.getContentPane().add(this.exitButton);
        this.exitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        this.exitButton.setForeground(Color.BLUE);
        this.exitButton.setFont(new Font("Tahoma", 1, 12));
        this.exitButton.setBackground(Color.LIGHT_GRAY);
        String[] hStr = new String[25];
        int ix = 0;
        while (ix <= 24) {
            hStr[ix] = "-" + String.valueOf(ix) + "Hr";
            ++ix;
        }
        this.historyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ASCGUI.ws_WorkClient.historyIndex = ASCGUI.this.historyComboBox.getSelectedIndex();
            }
        });
        this.historyComboBox.setModel(new DefaultComboBoxModel<String>(hStr));
        this.historyComboBox.setSelectedIndex(1);
        this.historyComboBox.setBackground(Color.ORANGE);
        this.historyComboBox.setBounds(109, 319, 88, 24);
        this.getContentPane().add(this.historyComboBox);
        JLabel deviceNameLabel = new JLabel("External Temp:");
        deviceNameLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel.setHorizontalAlignment(2);
        deviceNameLabel.setForeground(Color.BLUE);
        deviceNameLabel.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel.setBounds(207, 11, 104, 25);
        this.getContentPane().add(deviceNameLabel);
        this.textField_0 = new JTextField();
        this.textField_0.setText("---");
        this.textField_0.setHorizontalAlignment(0);
        this.textField_0.setFont(new Font("Tahoma", 1, 14));
        this.textField_0.setColumns(10);
        this.textField_0.setBackground(new Color(255, 255, 230));
        this.textField_0.setBounds(321, 11, 70, 25);
        this.getContentPane().add(this.textField_0);
        JLabel deviceNameLabel_2 = new JLabel("External Umid:");
        deviceNameLabel_2.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_2.setHorizontalAlignment(2);
        deviceNameLabel_2.setForeground(Color.BLUE);
        deviceNameLabel_2.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_2.setBounds(207, 35, 104, 25);
        this.getContentPane().add(deviceNameLabel_2);
        this.textField_1 = new JTextField();
        this.textField_1.setText("---");
        this.textField_1.setHorizontalAlignment(0);
        this.textField_1.setFont(new Font("Tahoma", 1, 14));
        this.textField_1.setColumns(10);
        this.textField_1.setBackground(new Color(255, 255, 230));
        this.textField_1.setBounds(321, 35, 70, 25);
        this.getContentPane().add(this.textField_1);
        JLabel deviceNameLabel_3 = new JLabel("Inside Temp:");
        deviceNameLabel_3.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_3.setHorizontalAlignment(2);
        deviceNameLabel_3.setForeground(Color.BLUE);
        deviceNameLabel_3.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_3.setBounds(207, 60, 104, 25);
        this.getContentPane().add(deviceNameLabel_3);
        this.textField_2 = new JTextField();
        this.textField_2.setText("---");
        this.textField_2.setHorizontalAlignment(0);
        this.textField_2.setFont(new Font("Tahoma", 1, 14));
        this.textField_2.setColumns(10);
        this.textField_2.setBackground(new Color(255, 255, 230));
        this.textField_2.setBounds(321, 60, 70, 25);
        this.getContentPane().add(this.textField_2);
        JLabel deviceNameLabel_4 = new JLabel("Inside Umid:");
        deviceNameLabel_4.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_4.setHorizontalAlignment(2);
        deviceNameLabel_4.setForeground(Color.BLUE);
        deviceNameLabel_4.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_4.setBounds(207, 84, 104, 25);
        this.getContentPane().add(deviceNameLabel_4);
        this.textField_3 = new JTextField();
        this.textField_3.setText("---");
        this.textField_3.setHorizontalAlignment(0);
        this.textField_3.setFont(new Font("Tahoma", 1, 14));
        this.textField_3.setColumns(10);
        this.textField_3.setBackground(new Color(255, 255, 230));
        this.textField_3.setBounds(321, 84, 70, 25);
        this.getContentPane().add(this.textField_3);
        JLabel deviceNameLabel_5 = new JLabel("Wind Speed:");
        deviceNameLabel_5.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_5.setHorizontalAlignment(2);
        deviceNameLabel_5.setForeground(Color.BLUE);
        deviceNameLabel_5.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_5.setBounds(207, 109, 104, 25);
        this.getContentPane().add(deviceNameLabel_5);
        this.textField_4 = new JTextField();
        this.textField_4.setText("---");
        this.textField_4.setHorizontalAlignment(0);
        this.textField_4.setFont(new Font("Tahoma", 1, 14));
        this.textField_4.setColumns(10);
        this.textField_4.setBackground(new Color(255, 255, 230));
        this.textField_4.setBounds(321, 109, 70, 25);
        this.getContentPane().add(this.textField_4);
        JLabel deviceNameLabel_6 = new JLabel("Wind Direction:");
        deviceNameLabel_6.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_6.setHorizontalAlignment(2);
        deviceNameLabel_6.setForeground(Color.BLUE);
        deviceNameLabel_6.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_6.setBounds(207, 134, 104, 25);
        this.getContentPane().add(deviceNameLabel_6);
        this.textField_5 = new JTextField();
        this.textField_5.setText("---");
        this.textField_5.setHorizontalAlignment(0);
        this.textField_5.setFont(new Font("Tahoma", 1, 14));
        this.textField_5.setColumns(10);
        this.textField_5.setBackground(new Color(255, 255, 230));
        this.textField_5.setBounds(321, 134, 70, 25);
        this.getContentPane().add(this.textField_5);
        JLabel deviceNameLabel_7 = new JLabel("Atm. Pressure:");
        deviceNameLabel_7.setBorder(new EmptyBorder(1, 1, 1, 1));
        deviceNameLabel_7.setHorizontalAlignment(2);
        deviceNameLabel_7.setForeground(Color.BLUE);
        deviceNameLabel_7.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_7.setBounds(207, 158, 104, 25);
        this.getContentPane().add(deviceNameLabel_7);
        this.textField_6 = new JTextField();
        this.textField_6.setText("---");
        this.textField_6.setHorizontalAlignment(0);
        this.textField_6.setFont(new Font("Tahoma", 1, 14));
        this.textField_6.setColumns(10);
        this.textField_6.setBackground(new Color(255, 255, 230));
        this.textField_6.setBounds(321, 158, 70, 25);
        this.getContentPane().add(this.textField_6);
        JLabel lblSolarRadiation = new JLabel("Solar Radiation:");
        lblSolarRadiation.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblSolarRadiation.setHorizontalAlignment(2);
        lblSolarRadiation.setForeground(Color.BLUE);
        lblSolarRadiation.setFont(new Font("Tahoma", 1, 12));
        lblSolarRadiation.setBounds(207, 183, 104, 25);
        this.getContentPane().add(lblSolarRadiation);
        this.textField_7 = new JTextField();
        this.textField_7.setText("---");
        this.textField_7.setHorizontalAlignment(0);
        this.textField_7.setFont(new Font("Tahoma", 1, 14));
        this.textField_7.setColumns(10);
        this.textField_7.setBackground(new Color(255, 255, 230));
        this.textField_7.setBounds(321, 183, 70, 25);
        this.getContentPane().add(this.textField_7);
        JLabel lblUv = new JLabel("UV Index:");
        lblUv.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblUv.setHorizontalAlignment(2);
        lblUv.setForeground(Color.BLUE);
        lblUv.setFont(new Font("Tahoma", 1, 12));
        lblUv.setBounds(207, 208, 104, 25);
        this.getContentPane().add(lblUv);
        this.textField_8 = new JTextField();
        this.textField_8.setText("---");
        this.textField_8.setHorizontalAlignment(0);
        this.textField_8.setFont(new Font("Tahoma", 1, 14));
        this.textField_8.setColumns(10);
        this.textField_8.setBackground(new Color(255, 255, 230));
        this.textField_8.setBounds(321, 208, 70, 25);
        this.getContentPane().add(this.textField_8);
        JLabel lblRain = new JLabel("Console Batt.:");
        lblRain.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblRain.setHorizontalAlignment(2);
        lblRain.setForeground(Color.BLUE);
        lblRain.setFont(new Font("Tahoma", 1, 12));
        lblRain.setBounds(207, 233, 104, 25);
        this.getContentPane().add(lblRain);
        this.textField_9 = new JTextField();
        this.textField_9.setText("---");
        this.textField_9.setHorizontalAlignment(0);
        this.textField_9.setFont(new Font("Tahoma", 1, 14));
        this.textField_9.setColumns(10);
        this.textField_9.setBackground(new Color(255, 255, 230));
        this.textField_9.setBounds(321, 233, 70, 25);
        this.getContentPane().add(this.textField_9);
        JLabel lblIssBattstatus = new JLabel("ISS Batt.Status:");
        lblIssBattstatus.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblIssBattstatus.setHorizontalAlignment(2);
        lblIssBattstatus.setForeground(Color.BLUE);
        lblIssBattstatus.setFont(new Font("Tahoma", 1, 12));
        lblIssBattstatus.setBounds(207, 258, 104, 25);
        this.getContentPane().add(lblIssBattstatus);
        this.textField_10 = new JTextField();
        this.textField_10.setText("---");
        this.textField_10.setHorizontalAlignment(0);
        this.textField_10.setFont(new Font("Tahoma", 1, 14));
        this.textField_10.setColumns(10);
        this.textField_10.setBackground(new Color(255, 255, 230));
        this.textField_10.setBounds(321, 258, 70, 25);
        this.getContentPane().add(this.textField_10);
        JLabel lblDewpointTemp = new JLabel("Dewpoint Temp:");
        lblDewpointTemp.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblDewpointTemp.setHorizontalAlignment(2);
        lblDewpointTemp.setForeground(Color.BLUE);
        lblDewpointTemp.setFont(new Font("Tahoma", 1, 12));
        lblDewpointTemp.setBounds(207, 282, 104, 25);
        this.getContentPane().add(lblDewpointTemp);
        this.textField_11 = new JTextField();
        this.textField_11.setText("---");
        this.textField_11.setHorizontalAlignment(0);
        this.textField_11.setFont(new Font("Tahoma", 1, 14));
        this.textField_11.setColumns(10);
        this.textField_11.setBackground(new Color(255, 255, 230));
        this.textField_11.setBounds(321, 282, 70, 25);
        this.getContentPane().add(this.textField_11);
        this.errorModel();
        this.initialize();
    }

    private void initialize() {
        this.setBounds(100, 100, 564, 428);
        this.setDefaultCloseOperation(0);
    }

    private void jtreeToOpcua(String nodeList, String acsName) {
        if (!ASCGUI.ws_WorkClient.client.isConnected()) {
            AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
            AIV_GUI.writeOnInfoText(" WS OPCUA-Server is not connected \n", Color.RED, true, false, true, true, 12);
            return;
        }
        String nodeName = "";
        String unitString = "unit";
        switch (nodeList) {
            case "GetList": {
                int ix = 0;
                while (ix < ASCGUI.ws_WorkClient.wsICD.get_ACSName_List.size()) {
                    if (acsName.equals(ASCGUI.ws_WorkClient.wsICD.get_ACSName_List.get(ix).trim())) {
                        nodeName = ASCGUI.ws_WorkClient.wsICD.get_NodeName_List.get(ix);
                        unitString = ASCGUI.ws_WorkClient.wsICD.get_Unit_List.get(ix);
                        ASCGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + ASCGUI.ws_WorkClient.wsICD.get_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                if (!this.historyCheckBox.isSelected()) break;
                ASCGUI.showHistoryPlot(nodeName, acsName, unitString);
                break;
            }
            case "SetList": {
                int ix = 0;
                while (ix < ASCGUI.ws_WorkClient.wsICD.set_ACSName_List.size()) {
                    if (acsName.equals(ASCGUI.ws_WorkClient.wsICD.set_ACSName_List.get(ix))) {
                        nodeName = ASCGUI.ws_WorkClient.wsICD.set_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... SET");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + ASCGUI.ws_WorkClient.wsICD.set_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(ASCGUI.ws_WorkClient.wsICD.set_NodeName_List.get(ix)) + " [" + ASCGUI.ws_WorkClient.wsICD.set_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(ASCGUI.ws_WorkClient.wsICD.set_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(ASCGUI.getOPCUAdata(nodeName));
                        AIV_GUI.writeOnInfoText("Description: " + ASCGUI.ws_WorkClient.wsICD.set_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                        DataInputForm.enterDataValueField.setForeground(Color.BLACK);
                    }
                    ++ix;
                }
                break;
            }
            case "CmdList": {
                int ix = 0;
                while (ix < ASCGUI.ws_WorkClient.wsICD.cmd_ACSName_List.size()) {
                    if (acsName.equals(ASCGUI.ws_WorkClient.wsICD.cmd_ACSName_List.get(ix))) {
                        nodeName = ASCGUI.ws_WorkClient.wsICD.cmd_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... CMD");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + ASCGUI.ws_WorkClient.wsICD.cmd_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(ASCGUI.ws_WorkClient.wsICD.cmd_NodeName_List.get(ix)) + " [" + ASCGUI.ws_WorkClient.wsICD.cmd_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(ASCGUI.ws_WorkClient.wsICD.cmd_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(ASCGUI.ws_WorkClient.wsICD.cmd_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.RED);
                        ASCGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + ASCGUI.ws_WorkClient.wsICD.cmd_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            case "ModeList": {
                int ix = 0;
                while (ix < ASCGUI.ws_WorkClient.wsICD.mode_ACSName_List.size()) {
                    if (acsName.equals(ASCGUI.ws_WorkClient.wsICD.mode_ACSName_List.get(ix))) {
                        nodeName = ASCGUI.ws_WorkClient.wsICD.mode_NodeName_List.get(ix);
                        DataInputForm.frmDatainputform.setVisible(true);
                        DataInputForm.frmDatainputform.setTitle("pmcDataInputForm... MODE");
                        DataInputForm.acsNameLabel.setText(String.valueOf(ix) + ") " + acsName + " [" + ASCGUI.ws_WorkClient.wsICD.mode_DefaultValue_List.get(ix) + "]");
                        DataInputForm.opcuaNameLabel.setText(String.valueOf(ASCGUI.ws_WorkClient.wsICD.mode_NodeName_List.get(ix)) + " [" + ASCGUI.ws_WorkClient.wsICD.mode_DataType_List.get(ix) + "]");
                        DataInputForm.enterDataValueField.setToolTipText(ASCGUI.ws_WorkClient.wsICD.mode_Description_List.get(ix));
                        DataInputForm.enterDataValueField.setText(ASCGUI.ws_WorkClient.wsICD.mode_CmdOrModeValue_List.get(ix));
                        DataInputForm.enterDataValueField.setForeground(Color.DARK_GRAY);
                        ASCGUI.getOPCUAdata(nodeName);
                        AIV_GUI.writeOnInfoText("Description: " + ASCGUI.ws_WorkClient.wsICD.mode_Description_List.get(ix) + " \n", Color.blue, true, false, false, true, 10);
                    }
                    ++ix;
                }
                break;
            }
            default: {
                AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
                AIV_GUI.writeOnInfoText(" acsCommand not valid: " + acsName + "\n", Color.RED, true, false, true, true, 12);
                return;
            }
        }
    }

    public static String getOPCUAdata(String nodeName) {
        DataValue datValue = null;
        if (nodeName.contains("ns=")) {
            datValue = ws_WorkClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= " + datValue.getValue().getValue().toString() + " \n", Color.blue, true, false, false, true, 12);
                return datValue.getValue().getValue().toString();
            }
            AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            return "";
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText(" nodeName not valid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
        return "";
    }

    public static void showHistoryPlot(String nodeName, String acsName, String unitString) {
        DataValue[] dValue = null;
        try {
            dValue = ws_WorkClient.readHistory(nodeName);
            if (dValue != null) {
                ASCGUI.historyPlot.unitString = unitString;
                ASCGUI.historyPlot.chart.getXYPlot().getDomainAxis().setLabel("time");
                ASCGUI.historyPlot.chart.getXYPlot().getRangeAxis().setLabel(unitString);
                ASCGUI.historyPlot.timeSeries.clear();
                ASCGUI.historyPlot.timeSeries.setKey((Comparable)((Object)("opcuaNode: " + nodeName)));
                ASCGUI.historyPlot.chart.setTitle(acsName);
                int ix = 0;
                while (ix < dValue.length) {
                    ASCGUI.historyPlot.timeSeries.add((RegularTimePeriod)new Millisecond(dValue[ix].getSourceTimestamp().getUtcCalendar().getTime()), dValue[ix].getValue().doubleValue());
                    ++ix;
                }
                historyPlot.setVisible(true);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void jtreeGetEditedText(String nodeName) throws BadLocationException {
        DataValue datValue = null;
        AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " get new value and press Return:: ");
        AIV_GUI.infoText.getDocument().getText(0, AIV_GUI.infoText.getDocument().getLength());
        if (nodeName.contains("ns=")) {
            datValue = ws_WorkClient.getDataValue(nodeName);
            if (datValue != null) {
                AIV_GUI.writeOnInfoText(String.valueOf(nodeName) + " Value= ");
                AIV_GUI.writeOnInfoText(String.valueOf(datValue.getValue().getValue().toString()) + " \n", Color.blue, true, false, false, true, 12);
            } else {
                AIV_GUI.writeOnInfoText(" error detected on node " + nodeName + "\n", Color.RED, true, false, true, true, 15);
            }
            return;
        }
        AIV_GUI.inserIconOnInfoText(12, Utils.badImageIcon);
        AIV_GUI.writeOnInfoText("nodeName not vallid: " + nodeName + "\n", Color.RED, true, false, true, true, 12);
    }

    public void errorModel() {
        JLabel deviceNameLabel_5 = new JLabel("Wind (km/h)");
        deviceNameLabel_5.setHorizontalAlignment(2);
        deviceNameLabel_5.setForeground(Color.BLUE);
        deviceNameLabel_5.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_5.setBounds(426, 53, 104, 25);
        this.getContentPane().add(deviceNameLabel_5);
        this.extraWindField = new JTextField();
        this.extraWindField.setForeground(Color.BLUE);
        this.extraWindField.setText("000,0");
        this.extraWindField.setHorizontalAlignment(0);
        this.extraWindField.setFont(new Font("Tahoma", 1, 28));
        this.extraWindField.setColumns(10);
        this.extraWindField.setBackground(new Color(255, 255, 230));
        this.extraWindField.setBounds(426, 78, 104, 49);
        this.getContentPane().add(this.extraWindField);
        JLabel lblWindGustTemp = new JLabel("WindGust10m:");
        lblWindGustTemp.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblWindGustTemp.setHorizontalAlignment(2);
        lblWindGustTemp.setForeground(Color.BLUE);
        lblWindGustTemp.setFont(new Font("Tahoma", 1, 12));
        lblWindGustTemp.setBounds(207, 307, 104, 25);
        this.getContentPane().add(lblWindGustTemp);
        this.textField_12 = new JTextField();
        this.textField_12.setForeground(new Color(0, 0, 0));
        this.textField_12.setText("---");
        this.textField_12.setHorizontalAlignment(0);
        this.textField_12.setFont(new Font("Tahoma", 1, 14));
        this.textField_12.setColumns(10);
        this.textField_12.setBackground(new Color(255, 255, 230));
        this.textField_12.setBounds(321, 307, 70, 25);
        this.getContentPane().add(this.textField_12);
        this.extraGustField = new JTextField();
        this.extraGustField.setForeground(new Color(178, 34, 34));
        this.extraGustField.setText("000.0");
        this.extraGustField.setHorizontalAlignment(0);
        this.extraGustField.setFont(new Font("Tahoma", 1, 28));
        this.extraGustField.setColumns(10);
        this.extraGustField.setBackground(new Color(255, 255, 230));
        this.extraGustField.setBounds(426, 159, 104, 49);
        this.getContentPane().add(this.extraGustField);
        JLabel lblWin10avg = new JLabel("Wind10Avg:");
        lblWin10avg.setBorder(new EmptyBorder(1, 1, 1, 1));
        lblWin10avg.setHorizontalAlignment(2);
        lblWin10avg.setForeground(Color.BLUE);
        lblWin10avg.setFont(new Font("Tahoma", 1, 12));
        lblWin10avg.setBounds(207, 332, 104, 25);
        this.getContentPane().add(lblWin10avg);
        this.textField_13 = new JTextField();
        this.textField_13.setText("---");
        this.textField_13.setHorizontalAlignment(0);
        this.textField_13.setForeground(Color.BLACK);
        this.textField_13.setFont(new Font("Tahoma", 1, 14));
        this.textField_13.setColumns(10);
        this.textField_13.setBackground(new Color(255, 255, 230));
        this.textField_13.setBounds(321, 332, 70, 25);
        this.getContentPane().add(this.textField_13);
        JLabel deviceNameLabel_5_1 = new JLabel("Gust (km/h)");
        deviceNameLabel_5_1.setHorizontalAlignment(2);
        deviceNameLabel_5_1.setForeground(new Color(178, 34, 34));
        deviceNameLabel_5_1.setFont(new Font("Tahoma", 1, 12));
        deviceNameLabel_5_1.setBounds(426, 133, 104, 25);
        this.getContentPane().add(deviceNameLabel_5_1);
        JButton btnReconnect = new JButton("Reconnect");
        btnReconnect.setBorder(new BevelBorder(0, null, null, null, null));
        btnReconnect.setBounds(421, 246, 115, 36);
        this.getContentPane().add(btnReconnect);
        btnReconnect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ws_WorkClient.stopClient();
                Utils.getProperties();
                if (ASCGUI.this.wsIndex == 0) {
                    ASCGUI.this.ws1_OpcuaClient = new ASC_OpcuaClient();
                    ASCGUI.this.ws1_OpcuaClient.startClient(Utils.ws1URL);
                    ws_WorkClient = ASCGUI.this.ws1_OpcuaClient;
                } else {
                    ASCGUI.this.ws2_OpcuaClient = new ASC_OpcuaClient();
                    ASCGUI.this.ws2_OpcuaClient.startClient(Utils.ws2URL);
                    ws_WorkClient = ASCGUI.this.ws2_OpcuaClient;
                }
            }
        });
        btnReconnect.setToolTipText("Connect to OPCUA Server & reload properties");
        btnReconnect.setForeground(Color.LIGHT_GRAY);
        btnReconnect.setFont(new Font("Tahoma", 1, 12));
        btnReconnect.setBackground(Color.BLUE);
        this.errorNoLabel.setForeground(new Color(220, 20, 60));
        this.errorNoLabel.setBorder(new LineBorder(new Color(255, 0, 0), 1, true));
        this.errorNoLabel.setBounds(436, 11, 85, 20);
        this.getContentPane().add(this.errorNoLabel);
    }

    public static void wsSetValueToOpcuaServer() {
        String setVal = DataInputForm.acsNameLabel.getText();
        setVal = setVal.substring(0, setVal.indexOf(")")).trim();
        int opcIndex = Integer.parseInt(setVal);
        String nodeName = "";
        String nodeType = "";
        if (DataInputForm.frmDatainputform.getTitle().contains("SET")) {
            nodeName = ASCGUI.ws_WorkClient.wsICD.set_NodeName_List.get(opcIndex);
            nodeType = ASCGUI.ws_WorkClient.wsICD.set_DataType_List.get(opcIndex);
        } else if (DataInputForm.frmDatainputform.getTitle().contains("CMD")) {
            nodeName = ASCGUI.ws_WorkClient.wsICD.cmd_NodeName_List.get(opcIndex);
            nodeType = ASCGUI.ws_WorkClient.wsICD.cmd_DataType_List.get(opcIndex);
        } else if (DataInputForm.frmDatainputform.getTitle().contains("MODE")) {
            nodeName = ASCGUI.ws_WorkClient.wsICD.mode_NodeName_List.get(opcIndex);
            nodeType = ASCGUI.ws_WorkClient.wsICD.mode_DataType_List.get(opcIndex);
        } else {
            System.out.println("WRONG data...");
            return;
        }
        String browserName = nodeName.substring(nodeName.lastIndexOf("=") + 1);
        String val = DataInputForm.enterDataValueField.getText().trim();
        try {
            ASCGUI.ws_WorkClient.client.writeValue(new NodeId(2, browserName), AIV_GUI.opcuaUtils.setInitValue(nodeType, val));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (StatusException e) {
            e.printStackTrace();
        }
        ASCGUI.getOPCUAdata(nodeName);
        DataInputForm.frmDatainputform.setVisible(false);
    }

    public void treeSetModel() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("OPCUA_node_list"){
            {
                DefaultMutableTreeNode node_get = new DefaultMutableTreeNode("GetList");
                int g = 0;
                while (g < ASCGUI.ws_WorkClient.wsICD.get_ACSName_List.size()) {
                    node_get.add(new DefaultMutableTreeNode(ASCGUI.ws_WorkClient.wsICD.get_ACSName_List.get(g)));
                    ++g;
                }
                super.add(node_get);
                DefaultMutableTreeNode node_set = new DefaultMutableTreeNode("SetList");
                int g2 = 0;
                while (g2 < ASCGUI.ws_WorkClient.wsICD.set_ACSName_List.size()) {
                    node_set.add(new DefaultMutableTreeNode(ASCGUI.ws_WorkClient.wsICD.set_ACSName_List.get(g2)));
                    ++g2;
                }
                super.add(node_set);
                DefaultMutableTreeNode node_cmd = new DefaultMutableTreeNode("CmdList");
                int g3 = 0;
                while (g3 < ASCGUI.ws_WorkClient.wsICD.cmd_ACSName_List.size()) {
                    node_cmd.add(new DefaultMutableTreeNode(ASCGUI.ws_WorkClient.wsICD.cmd_ACSName_List.get(g3)));
                    ++g3;
                }
                super.add(node_cmd);
                DefaultMutableTreeNode node_mode = new DefaultMutableTreeNode("ModeList");
                int g4 = 0;
                while (g4 < ASCGUI.ws_WorkClient.wsICD.mode_ACSName_List.size()) {
                    node_mode.add(new DefaultMutableTreeNode(ASCGUI.ws_WorkClient.wsICD.mode_ACSName_List.get(g4)));
                    ++g4;
                }
                super.add(node_mode);
            }
        }));
    }
}

