/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryReadable;

public class InputStreamReadable
implements IBinaryReadable {
    ByteOrder order = ByteOrder.nativeOrder();
    InputStream is;
    long limit;
    long position;

    public InputStreamReadable(InputStream inputStream, long l) {
        this.is = inputStream;
        this.limit = l;
    }

    int _get() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new EOFException();
        }
        ++this.position;
        return n & 0xFF;
    }

    @Override
    public byte get() throws IOException {
        return (byte)this._get();
    }

    @Override
    public void get(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.is.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            this.position += (long)n3;
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.get(byArray, 0, byArray.length);
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)this._get());
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n) throws IOException {
        if (n < 256) {
            for (int i = 0; i < n; ++i) {
                byteBuffer.put((byte)this._get());
            }
        } else {
            byte[] byArray = new byte[n];
            this.get(byArray, 0, n);
            byteBuffer.put(byArray);
        }
    }

    @Override
    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            return this._get() << 24 | this._get() << 16 | this._get() << 8 | this._get();
        }
        return this._get() | this._get() << 8 | this._get() << 16 | this._get() << 24;
    }

    @Override
    public long getLong() throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            return (long)this._get() << 56 | (long)this._get() << 48 | (long)this._get() << 40 | (long)this._get() << 32 | (long)this._get() << 24 | (long)this._get() << 16 | (long)this._get() << 8 | (long)this._get();
        }
        return (long)this._get() | (long)this._get() << 8 | (long)this._get() << 16 | (long)this._get() << 24 | (long)this._get() << 32 | (long)this._get() << 40 | (long)this._get() << 48 | (long)this._get() << 56;
    }

    @Override
    public short getShort() throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            return (short)(this._get() << 8 | this._get());
        }
        return (short)(this._get() | this._get() << 8);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    public void skip(long l) throws IOException {
        this.is.skip(l);
    }
}

