/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.opcfoundation.ua.utils.IncubationQueue;

public class IncubationBuffer
extends InputStream {
    protected static final ByteBuffer CLOSED_MARKER = ByteBuffer.allocate(0);
    protected IncubationQueue<ByteBuffer> queue = new IncubationQueue(true);
    protected ByteBuffer cur;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incubate(ByteBuffer byteBuffer) {
        IncubationQueue<ByteBuffer> incubationQueue = this.queue;
        synchronized (incubationQueue) {
            this.queue.incubate(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hatch(ByteBuffer byteBuffer) {
        IncubationQueue<ByteBuffer> incubationQueue = this.queue;
        synchronized (incubationQueue) {
            this.queue.hatch(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IncubationQueue<ByteBuffer> incubationQueue = this.queue;
        synchronized (incubationQueue) {
            this.queue.incubate(CLOSED_MARKER);
            this.queue.hatch(CLOSED_MARKER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClose() {
        IncubationQueue<ByteBuffer> incubationQueue = this.queue;
        synchronized (incubationQueue) {
            this.queue.clear();
            this.queue.incubate(CLOSED_MARKER);
            this.queue.hatch(CLOSED_MARKER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getByteBuffer() throws InterruptedIOException {
        IncubationQueue<ByteBuffer> incubationQueue = this.queue;
        synchronized (incubationQueue) {
            if (this.cur == CLOSED_MARKER) {
                return null;
            }
            if (this.cur != null && this.cur.hasRemaining()) {
                return this.cur;
            }
            if (this.cur != null && !this.cur.hasRemaining()) {
                this.cur = null;
            }
            try {
                this.cur = this.queue.removeNextHatched();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (this.cur == CLOSED_MARKER) {
                return null;
            }
            return this.cur;
        }
    }

    @Override
    public int read() throws IOException {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getByteBuffer();
            if (byteBuffer == null) {
                return n3 > 0 ? n3 : -1;
            }
            int n4 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.get(byArray, n, n4);
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        IncubationQueue<ByteBuffer> incubationQueue = this.queue;
        synchronized (incubationQueue) {
            ByteBuffer byteBuffer;
            int n = 0;
            if (this.cur != null) {
                n += this.cur.remaining();
            }
            Iterator<ByteBuffer> iterator = this.queue.iterator();
            while (iterator.hasNext() && this.queue.isHatched(byteBuffer = iterator.next())) {
                n += byteBuffer.remaining();
            }
            return n;
        }
    }
}

