/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.asyncsocket;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.CurrentThreadExecutor;
import org.opcfoundation.ua.utils.IStatefulObject;
import org.opcfoundation.ua.utils.StateListener;
import org.opcfoundation.ua.utils.asyncsocket.AsyncInputStream;
import org.opcfoundation.ua.utils.asyncsocket.AsyncOutputStream;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSelector;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSocket;
import org.opcfoundation.ua.utils.asyncsocket.BufferMonitor;
import org.opcfoundation.ua.utils.asyncsocket.BufferMonitorState;
import org.opcfoundation.ua.utils.asyncsocket.ListenableSocketChannel;
import org.opcfoundation.ua.utils.asyncsocket.MonitorListener;
import org.opcfoundation.ua.utils.asyncsocket.SocketState;
import org.opcfoundation.ua.utils.bytebuffer.ByteQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSocketImpl
extends AbstractState<SocketState, IOException>
implements AsyncSocket,
IStatefulObject<SocketState, IOException> {
    private static final int BUF_SIZE = 65536;
    ListenableSocketChannel ls;
    SocketChannel chan;
    AsyncSocketInputStream is;
    AsyncSocketOutputStream os;
    Executor triggerExecutor;
    static Logger log = LoggerFactory.getLogger(AsyncSocketImpl.class);
    ListenableSocketChannel.ConnectionListener cl = new ListenableSocketChannel.ConnectionListener(){

        @Override
        public void onConnected(ListenableSocketChannel listenableSocketChannel) {
            AsyncSocketImpl.this.ls.setConnectListener(null);
            AsyncSocketImpl.this.setState(SocketState.Connected);
        }

        @Override
        public void onConnectFailed(ListenableSocketChannel listenableSocketChannel, IOException iOException) {
            AsyncSocketImpl.this.ls.setConnectListener(null);
            AsyncSocketImpl.this.setState(SocketState.Closed);
        }
    };
    ListenableSocketChannel.ReadableListener rl = new ListenableSocketChannel.ReadableListener(){

        @Override
        public void onDataReadable(ListenableSocketChannel listenableSocketChannel) {
            if (AsyncSocketImpl.this.is.closed) {
                try {
                    AsyncSocketImpl.this.close();
                }
                catch (IOException iOException) {}
            } else {
                AsyncSocketImpl.this.is.readChannel();
                AsyncSocketImpl.this.is.prepareToReadMore();
            }
        }
    };
    ListenableSocketChannel.WriteableListener wl = new ListenableSocketChannel.WriteableListener(){

        @Override
        public void onDataWriteable(ListenableSocketChannel listenableSocketChannel) {
            AsyncSocketImpl.this.os.writeToChannel();
            AsyncSocketImpl.this.os.checkWriteMore();
        }
    };

    public AsyncSocketImpl() throws IOException {
        this((SocketChannel)SocketChannel.open().configureBlocking(false), CurrentThreadExecutor.INSTANCE, new AsyncSelector());
    }

    public AsyncSocketImpl(SocketChannel socketChannel) throws IOException {
        this(socketChannel, CurrentThreadExecutor.INSTANCE, new AsyncSelector());
    }

    public AsyncSocketImpl(SocketChannel socketChannel, Executor executor, AsyncSelector asyncSelector) throws IOException {
        super(socketChannel.isConnected() ? SocketState.Connected : SocketState.Ready, SocketState.Error);
        this.triggerExecutor = executor;
        this.ls = new ListenableSocketChannel(socketChannel, CurrentThreadExecutor.INSTANCE, asyncSelector);
        this.chan = this.ls.getChannel();
        this.is = new AsyncSocketInputStream();
        this.os = new AsyncSocketOutputStream();
        this.addStateListener(new StateListener<SocketState>(){

            @Override
            public void onStateTransition(IStatefulObject<SocketState, ?> iStatefulObject, SocketState socketState, SocketState socketState2) {
                if (SocketState.FINAL_STATES.contains((Object)socketState2)) {
                    AsyncSocketImpl.this.is.close();
                    AsyncSocketImpl.this.os.close();
                }
            }
        });
    }

    @Override
    protected void onStateTransition(SocketState socketState, SocketState socketState2) {
        if (SocketState.FINAL_STATES.contains((Object)socketState2)) {
            this.is.close();
            this.os.close();
        }
    }

    @Override
    public AsyncInputStream getInputStream() {
        return this.is;
    }

    @Override
    public AsyncOutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public AsyncSocketImpl close() throws IOException {
        this.ls.close();
        this.attemptSetState(SocketState.NON_FINAL_STATES, SocketState.Closed);
        return this;
    }

    @Override
    public SocketChannel socketChannel() {
        return this.chan;
    }

    @Override
    public Socket socket() {
        return this.chan.socket();
    }

    @Override
    protected boolean setState(SocketState socketState) {
        return super.setState(socketState, CurrentThreadExecutor.INSTANCE, null) == socketState;
    }

    @Override
    protected boolean isStateTransitionAllowed(SocketState socketState, SocketState socketState2) {
        return !SocketState.FINAL_STATES.contains(this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.assertNoError();
        SocketState socketState = (SocketState)((Object)this.getState());
        if (socketState != SocketState.Ready) {
            throw new IOException("Socket not ready");
        }
        AsyncSocketImpl asyncSocketImpl = this;
        synchronized (asyncSocketImpl) {
            try {
                this.ls.connect(socketAddress);
                this.ls.setConnectListener(this.cl);
                this.setState(SocketState.Connecting);
            }
            catch (IOException iOException) {
                this.ls.setConnectListener(null);
                throw iOException;
            }
        }
    }

    public boolean syncConnect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress);
        try {
            this.waitForState(SocketState.CONNECTING_TRANSITION_STATES);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.getError() != null) {
            throw (IOException)this.getError();
        }
        return this.chan.isConnected();
    }

    @Override
    public IStatefulObject<SocketState, IOException> getStateMonitor() {
        return this;
    }

    public void closeOnFlush() {
        this.getOutputStream().createMonitor(this.getOutputStream().getPosition(), new MonitorListener(){

            @Override
            public void onStateTransition(IStatefulObject<BufferMonitorState, ?> iStatefulObject, BufferMonitorState bufferMonitorState, BufferMonitorState bufferMonitorState2) {
                try {
                    AsyncSocketImpl.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    class AsyncSocketOutputStream
    extends AsyncOutputStream {
        TreeSet<BufferMonitor> alarms = new TreeSet();
        ByteQueue q = new ByteQueue(16384);
        boolean closed;

        AsyncSocketOutputStream() {
        }

        @Override
        public synchronized void write(int n) throws IOException {
            this.q.put((byte)n);
            this.writeToChannel();
            this.checkWriteMore();
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            this.q.put(byArray, n, n2);
            this.writeToChannel();
            this.checkWriteMore();
        }

        @Override
        public synchronized void offer(ByteBuffer byteBuffer) {
            this.q.offer(byteBuffer);
            this.writeToChannel();
            this.checkWriteMore();
        }

        @Override
        public synchronized void write(ByteBuffer byteBuffer) {
            this.q.put(byteBuffer);
            this.writeToChannel();
            this.checkWriteMore();
        }

        @Override
        public synchronized void write(ByteBuffer byteBuffer, int n) {
            this.q.put(byteBuffer, n);
            this.writeToChannel();
            this.checkWriteMore();
        }

        private synchronized void checkWriteMore() {
            if (this.closed) {
                AsyncSocketImpl.this.ls.setWriteListener(null);
                return;
            }
            boolean bl = !this.q.isEmpty() && AsyncSocketImpl.this.getState() == SocketState.Connected;
            AsyncSocketImpl.this.ls.setWriteListener(bl ? AsyncSocketImpl.this.wl : null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferMonitor createMonitor(long l, MonitorListener monitorListener) {
            BufferMonitor bufferMonitor = new BufferMonitor(l, AsyncSocketImpl.this.triggerExecutor){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    AsyncSocketOutputStream asyncSocketOutputStream = AsyncSocketOutputStream.this;
                    synchronized (asyncSocketOutputStream) {
                        if (this.getState() != BufferMonitorState.Waiting) {
                            return;
                        }
                        AsyncSocketOutputStream.this.alarms.remove(this);
                        this.setState(BufferMonitorState.Canceled, this.eventExecutor, null);
                    }
                }
            };
            if (monitorListener != null) {
                bufferMonitor.addStateListener(monitorListener);
            }
            AsyncSocketOutputStream asyncSocketOutputStream = this;
            synchronized (asyncSocketOutputStream) {
                if (l >= this.q.getBytesRead()) {
                    bufferMonitor.trigger();
                } else if (this.closed) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                    } else {
                        bufferMonitor.close();
                    }
                } else {
                    this.alarms.add(bufferMonitor);
                }
            }
            return bufferMonitor;
        }

        @Override
        public synchronized long getFlushPosition() {
            return this.q.getBytesRead();
        }

        @Override
        public synchronized long getPosition() {
            return this.q.getBytesWritten();
        }

        @Override
        public void flush() throws IOException {
            BufferMonitor bufferMonitor = this.createMonitor(this.getPosition(), null);
            try {
                bufferMonitor.waitForState(BufferMonitorState.FINAL_STATES);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (BufferMonitor bufferMonitor : this.alarms) {
                if (bufferMonitor.triggerPos > this.q.getBytesRead()) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                        continue;
                    }
                    bufferMonitor.close();
                    continue;
                }
                log.error("AsyncSocketOutputStream.close(): unexpected untriggered monitor");
                bufferMonitor.trigger();
            }
            this.alarms.clear();
        }

        private synchronized void writeToChannel() {
            while (!this.q.isEmpty()) {
                try {
                    int n = AsyncSocketImpl.this.chan.write(this.q.getReadChunk());
                    if (n != 0 && n != -1) continue;
                    break;
                }
                catch (IOException iOException) {
                    AsyncSocketImpl.this.setError(iOException);
                    break;
                }
            }
            if (!this.alarms.isEmpty()) {
                BufferMonitor bufferMonitor;
                Iterator<BufferMonitor> iterator = this.alarms.iterator();
                while (iterator.hasNext() && (bufferMonitor = iterator.next()).getTriggerPos() <= this.q.getBytesRead()) {
                    iterator.remove();
                    AsyncSocketImpl.this.triggerExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            bufferMonitor.trigger();
                        }
                    });
                }
            }
        }

        @Override
        public synchronized long getUnflushedBytes() {
            return this.q.remaining();
        }
    }

    class AsyncSocketInputStream
    extends AsyncInputStream {
        TreeSet<BufferMonitor> alarms = new TreeSet();
        ByteQueue q = new ByteQueue(16384);
        long recvTargetPos;
        boolean closed;
        long bufSize = 65536L;

        AsyncSocketInputStream() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized int read() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = Math.min(this.available(), n2);
            if (n3 > 0) {
                this.q.get(byArray, n, n3);
                this.prepareToReadMore();
                return n3;
            }
            if (this.closed) {
                return -1;
            }
            return 0;
        }

        @Override
        public synchronized void read(ByteBuffer byteBuffer) {
            this.q.get(byteBuffer);
            this.prepareToReadMore();
        }

        @Override
        public synchronized void read(ByteBuffer byteBuffer, int n) {
            this.q.get(byteBuffer, n);
            this.prepareToReadMore();
        }

        @Override
        public synchronized ByteBuffer read(int n) {
            ByteBuffer byteBuffer = this.q.get(n);
            this.prepareToReadMore();
            return byteBuffer;
        }

        @Override
        public synchronized ByteBuffer[] readChunks(int n) {
            ByteBuffer[] byteBufferArray = this.q.getChunks(n);
            this.prepareToReadMore();
            return byteBufferArray;
        }

        @Override
        public synchronized void peek(byte[] byArray) {
            this.q.peek(byArray);
        }

        @Override
        public synchronized void peek(byte[] byArray, int n, int n2) {
            this.q.peek(byArray, n, n2);
        }

        @Override
        public synchronized ByteBuffer peek(int n) {
            return this.q.peek(n);
        }

        @Override
        public synchronized ByteBuffer[] peekChunks(int n) {
            return this.q.peekChunks(n);
        }

        @Override
        public synchronized int available() {
            long l = this.q.remaining();
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.upRecvTarget(this.q.getBytesWritten());
            long l = this.getMaxRecvSize();
            for (BufferMonitor bufferMonitor : this.alarms) {
                if (bufferMonitor.triggerPos > l) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                        continue;
                    }
                    bufferMonitor.close();
                    continue;
                }
                log.info("AsyncSocketInputStream.close(): unexpected untriggered monitor");
                bufferMonitor.trigger();
            }
            this.alarms.clear();
        }

        @Override
        public synchronized long getReceivedBytes() {
            return this.q.getBytesWritten();
        }

        @Override
        public synchronized long getPosition() {
            return this.q.getBytesRead();
        }

        private synchronized void readChannel() {
            try {
                int n = 0;
                do {
                    if ((n = AsyncSocketImpl.this.chan.read(this.q.getWriteChunk())) != -1) continue;
                    AsyncSocketImpl.this.setState(SocketState.Closed);
                    return;
                } while (n > 0);
            }
            catch (ClosedChannelException closedChannelException) {
                AsyncSocketImpl.this.setState(SocketState.Closed);
            }
            catch (IOException iOException) {
                AsyncSocketImpl.this.setError(iOException);
            }
            this.prepareToReadMore();
            if (!this.alarms.isEmpty()) {
                BufferMonitor bufferMonitor;
                Iterator<BufferMonitor> iterator = this.alarms.iterator();
                while (iterator.hasNext() && (bufferMonitor = iterator.next()).getTriggerPos() <= this.q.getBytesWritten()) {
                    iterator.remove();
                    AsyncSocketImpl.this.triggerExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            bufferMonitor.trigger();
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized BufferMonitor createMonitor(long l, MonitorListener monitorListener) {
            BufferMonitor bufferMonitor = new BufferMonitor(l, AsyncSocketImpl.this.triggerExecutor){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    AsyncSocketInputStream asyncSocketInputStream = AsyncSocketInputStream.this;
                    synchronized (asyncSocketInputStream) {
                        if (this.getState() != BufferMonitorState.Waiting) {
                            return;
                        }
                        AsyncSocketInputStream.this.alarms.remove(this);
                        this.setState(BufferMonitorState.Canceled, this.eventExecutor, null);
                    }
                }
            };
            if (monitorListener != null) {
                bufferMonitor.addStateListener(monitorListener);
            }
            AsyncSocketInputStream asyncSocketInputStream = this;
            synchronized (asyncSocketInputStream) {
                if (l <= this.q.getBytesWritten()) {
                    bufferMonitor.trigger();
                } else if (l > this.getMaxRecvSize()) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                    } else {
                        bufferMonitor.close();
                    }
                } else {
                    this.alarms.add(bufferMonitor);
                    this.upRecvTarget(l);
                }
            }
            return bufferMonitor;
        }

        synchronized void prepareToReadMore() {
            this.upRecvTarget(this.q.getBytesRead() + this.bufSize);
        }

        synchronized void upRecvTarget(long l) {
            if (this.closed) {
                this.recvTargetPos = this.q.getBytesWritten();
                AsyncSocketImpl.this.ls.setReadListener(null);
                return;
            }
            this.recvTargetPos = Math.max(l, this.recvTargetPos);
            AsyncSocketImpl.this.ls.setReadListener(this.q.getBytesWritten() < this.recvTargetPos ? AsyncSocketImpl.this.rl : null);
        }

        long getMaxRecvSize() {
            if (this.closed || SocketState.FINAL_STATES.contains(AsyncSocketImpl.this.getState())) {
                return this.getReceivedBytes();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public int getBufferSize() {
            return (int)this.bufSize;
        }

        @Override
        public void setBufferSize(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("buf size must be over 0");
            }
            this.bufSize = n;
            this.prepareToReadMore();
        }
    }
}

