/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.asyncsocket;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.opcfoundation.ua.utils.State;

public class AsyncSelector
implements Runnable {
    private static final EnumSet<SelectorState> ENABLED_STATE = EnumSet.of(SelectorState.Active);
    private final ThreadGroup THREAD_GROUP = new ThreadGroup("Async Selector");
    State<SelectorState> state = new State<SelectorState>(SelectorState.Active);
    Selector sel;
    Map<SelectionKey, SelectListener> map = new ConcurrentHashMap<SelectionKey, SelectListener>();
    Map<SelectionKey, Integer> supposedIOP = new ConcurrentHashMap<SelectionKey, Integer>();
    Thread thread;

    public AsyncSelector() throws IOException {
        this(Selector.open());
    }

    public AsyncSelector(Selector selector) throws IOException {
        this.sel = selector;
        this.thread = new Thread(this.THREAD_GROUP, this, "Selector");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public Selector getSelector() {
        return this.sel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestOps(SelectableChannel selectableChannel, int n) throws CancelledKeyException {
        if (selectableChannel != null) {
            SelectionKey selectionKey = selectableChannel.keyFor(this.sel);
            if (selectionKey == null) {
                throw new IllegalArgumentException("Key is not registered to channel");
            }
            if (!selectionKey.isValid()) {
                return;
            }
            if (ObjectUtils.objectEquals(this.supposedIOP.put(selectionKey, n), n)) {
                return;
            }
            try {
                this.disable();
                selectionKey.interestOps(n);
            }
            finally {
                this.enable();
            }
        }
    }

    private void enable() {
        this.state.setState(SelectorState.Active);
    }

    private void disable() {
        this.state.setState(SelectorState.Disabled);
        this.sel.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SelectableChannel selectableChannel, int n, SelectListener selectListener) throws ClosedChannelException {
        this.disable();
        try {
            SelectionKey selectionKey = selectableChannel.register(this.sel, n);
            this.supposedIOP.put(selectionKey, n);
            this.map.put(selectionKey, selectListener);
        }
        finally {
            this.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SelectableChannel selectableChannel) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.sel);
        if (selectionKey == null || !this.map.containsKey(selectionKey)) {
            return;
        }
        this.disable();
        try {
            selectionKey.cancel();
            this.map.remove(selectionKey);
            this.supposedIOP.remove(selectionKey);
        }
        finally {
            this.enable();
        }
    }

    public void close() throws IOException {
        this.sel.close();
        try {
            this.state.setState(SelectorState.Active);
            this.sel.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String toStr(int n) {
        String string = "[";
        if ((n & 1) != 0) {
            string = string + "read";
        }
        if ((n & 8) != 0) {
            string = string + "connect";
        }
        if ((n & 4) != 0) {
            string = string + "write";
        }
        if ((n & 0x10) != 0) {
            string = string + "accept";
        }
        return string + "]";
    }

    @Override
    public void run() {
        try {
            while (this.sel.isOpen()) {
                Integer n;
                this.state.waitForStateUninterruptibly(ENABLED_STATE);
                this.sel.select(1000L);
                Set<SelectionKey> set = this.sel.selectedKeys();
                for (SelectionKey selectionKey : set) {
                    try {
                        selectionKey.interestOps(0);
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
                for (SelectionKey selectionKey : set) {
                    try {
                        n = this.supposedIOP.get(selectionKey);
                        if (n == null) continue;
                        int n2 = selectionKey.readyOps();
                        SelectListener selectListener = this.map.get(selectionKey);
                        if (selectListener == null) continue;
                        selectListener.onSelected(this, selectionKey.channel(), n2, n);
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
                for (SelectionKey selectionKey : this.supposedIOP.keySet()) {
                    try {
                        n = this.supposedIOP.get(selectionKey);
                        if (n == null) continue;
                        selectionKey.interestOps(n);
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
                set.clear();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error(iOException);
        }
    }

    public static interface SelectListener {
        public void onSelected(AsyncSelector var1, SelectableChannel var2, int var3, int var4);
    }

    private static enum SelectorState {
        Active,
        Disabled;

    }
}

