/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class StreamUtil {
    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
            while (readableByteChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
                byteBuffer.compact();
            }
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                writableByteChannel.write(byteBuffer);
            }
        }
        finally {
            readableByteChannel.close();
            writableByteChannel.close();
        }
    }

    public static void read(InputStream inputStream, ByteBuffer byteBuffer, int n) throws IOException {
        while (n > 0 & byteBuffer.hasRemaining()) {
            int n2 = inputStream.read(byteBuffer.array(), byteBuffer.position(), n);
            if (n2 < 0) {
                throw new EOFException();
            }
            byteBuffer.position(byteBuffer.position() + n2);
            n -= n2;
        }
    }

    public static void readFully(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int n = inputStream.read(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            if (n < 0) {
                throw new EOFException();
            }
            byteBuffer.position(byteBuffer.position() + n);
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        StreamUtil.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }
}

