/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opcfoundation.ua.builtintypes.BuiltinsMap;

public class ReflectionUtils {
    public static Method[] getAllMethods(Class<?> clazz) {
        HashSet<Method> hashSet = new HashSet<Method>();
        ReflectionUtils._getAllMethods(clazz, hashSet);
        return hashSet.toArray(new Method[hashSet.size()]);
    }

    private static void _getAllMethods(Class<?> clazz, Collection<Method> collection) {
        for (Method method : clazz.getDeclaredMethods()) {
            collection.add(method);
        }
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ReflectionUtils._getAllFields(clazz, arrayList);
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    private static void _getAllFields(Class<?> clazz, Collection<Field> collection) {
        for (Field field : clazz.getDeclaredFields()) {
            collection.add(field);
        }
    }

    public static Class<?> getRespectiveArrayClass(Class<?> clazz) {
        Integer n = BuiltinsMap.ID_MAP.get(clazz);
        if (n != null) {
            return BuiltinsMap.ARRAY_LIST.get(n);
        }
        String string = "[L" + clazz.getCanonicalName() + ";";
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException);
        }
    }

    public static Class<?> getComponentClass(Class<?> clazz) {
        if (!clazz.isArray()) {
            return clazz;
        }
        return clazz.getComponentType();
    }
}

