/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.ReflectionUtils;

public class ObjectUtils {
    private static boolean printObjectIds = false;
    private static boolean showByteDataAsHex = true;
    private static boolean showFullClassName = true;
    private static boolean showDataType = false;

    public static boolean isShowDataType() {
        return showDataType;
    }

    public static void setShowDataType(boolean bl) {
        showDataType = bl;
    }

    public static boolean isShowFullClassName() {
        return showFullClassName;
    }

    public static void setShowFullClassName(boolean bl) {
        showFullClassName = bl;
    }

    public static boolean isShowByteDataAsHex() {
        return showByteDataAsHex;
    }

    public static void setShowByteDataAsHex(boolean bl) {
        showByteDataAsHex = bl;
    }

    public static boolean isPrintObjectIds() {
        return printObjectIds;
    }

    public static void setPrintObjectIds(boolean bl) {
        printObjectIds = bl;
    }

    public static boolean objectEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static boolean equals(Collection<?> collection, Collection<?> collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<?> iterator = collection.iterator();
        Iterator<?> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            if (ObjectUtils.objectEquals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static String toString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.toString((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return showByteDataAsHex ? CryptoUtil.toHex((byte[])object, 0) : Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        return object.toString();
    }

    public static String printFieldsDeep(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        ObjectUtils._printFieldsDeep(stringBuilder, object, "", hashSet);
        return stringBuilder.toString();
    }

    private static void _printFieldsDeep(StringBuilder stringBuilder, Object object, String string, Set<Object> set) {
        Class<?> clazz = object.getClass();
        stringBuilder.append(clazz.getSimpleName());
        if (ObjectUtils.isPrintObjectIds()) {
            stringBuilder.append(" (id=" + System.identityHashCode(object) + ")");
        }
        stringBuilder.append("\n");
        if (!set.add(object) && set.size() > 10000) {
            return;
        }
        string = string + "  ";
        while (!clazz.equals(Object.class)) {
            for (Field field : ReflectionUtils.getAllFields(clazz)) {
                boolean bl = (field.getModifiers() & 8) == 8;
                boolean bl2 = field.getType().isArray();
                if (bl) continue;
                field.setAccessible(true);
                stringBuilder.append(string + field.getName() + "=");
                try {
                    Object object2 = field.get(object);
                    if (object2 == null) {
                        stringBuilder.append("null\n");
                        continue;
                    }
                    if (bl2) {
                        if (object2 instanceof double[]) {
                            stringBuilder.append(Arrays.toString((double[])object2) + "\n");
                            continue;
                        }
                        if (object2 instanceof boolean[]) {
                            stringBuilder.append(Arrays.toString((boolean[])object2) + "\n");
                            continue;
                        }
                        if (object2 instanceof byte[]) {
                            stringBuilder.append((showByteDataAsHex ? CryptoUtil.toHex((byte[])object2, 0) : Arrays.toString((byte[])object2)) + "\n");
                            continue;
                        }
                        if (object2 instanceof char[]) {
                            stringBuilder.append(Arrays.toString((char[])object2) + "\n");
                            continue;
                        }
                        if (object2 instanceof float[]) {
                            stringBuilder.append(Arrays.toString((float[])object2) + "\n");
                            continue;
                        }
                        if (object2 instanceof int[]) {
                            stringBuilder.append(Arrays.toString((int[])object2) + "\n");
                            continue;
                        }
                        if (object2 instanceof long[]) {
                            stringBuilder.append(Arrays.toString((long[])object2) + "\n");
                            continue;
                        }
                        if (object2 instanceof short[]) {
                            stringBuilder.append(Arrays.toString((short[])object2) + "\n");
                            continue;
                        }
                        stringBuilder.append(ObjectUtils.getClassName(object2.getClass().getComponentType()) + "[" + Array.getLength(object2) + "]\n");
                        for (int i = 0; i < Array.getLength(object2); ++i) {
                            Object object3 = Array.get(object2, i);
                            stringBuilder.append(string + "  [" + i + "]=");
                            try {
                                if (object3 == null) {
                                    stringBuilder.append("null\n");
                                    continue;
                                }
                                if (ObjectUtils.isClassPrintable(object3)) {
                                    ObjectUtils.appendObjectAsString(stringBuilder, object3, string);
                                    continue;
                                }
                                ObjectUtils._printFieldsDeep(stringBuilder, object3, string, set);
                                continue;
                            }
                            catch (Exception exception) {
                                System.out.println("ERROR From ObjectUtils / _printfieldsDeep");
                                if (object3 != null) continue;
                                System.out.println("Subdada null");
                                System.out.println(stringBuilder.toString());
                            }
                        }
                        continue;
                    }
                    if (ObjectUtils.isClassPrintable(object2)) {
                        ObjectUtils.appendObjectAsString(stringBuilder, object2, string);
                        continue;
                    }
                    ObjectUtils._printFieldsDeep(stringBuilder, object2, string, set);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuilder.append("?");
                }
                catch (IllegalAccessException illegalAccessException) {
                    stringBuilder.append("?");
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static Serializable getClassName(Class<?> clazz) {
        return showFullClassName ? clazz : clazz.getSimpleName();
    }

    private static void appendObjectAsString(StringBuilder stringBuilder, Object object, String string) {
        String string2;
        if (ObjectUtils.showClassName(object)) {
            stringBuilder.append("{");
            stringBuilder.append(ObjectUtils.getClassName(object.getClass()));
            stringBuilder.append("}");
        }
        if ((string2 = MultiDimensionArrayUtils.toString(object)) != null) {
            string2 = string2.replace("\n", "\n  " + string);
        }
        stringBuilder.append(string2);
        stringBuilder.append("\n");
    }

    private static boolean showClassName(Object object) {
        return ObjectUtils.isShowDataType() && !object.getClass().getCanonicalName().startsWith("java");
    }

    private static boolean isClassPrintable(Object object) {
        return object.getClass().getCanonicalName().startsWith("java") || object.getClass().getCanonicalName().startsWith("org.opcfoundation.ua.builtintypes");
    }

    public static String printFields(Object object) {
        Class<?> clazz = object.getClass();
        StringBuilder stringBuilder = new StringBuilder();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean bl = (field.getModifiers() & 8) == 8;
                boolean bl2 = field.getType().isArray();
                if (bl) continue;
                field.setAccessible(true);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(field.getName() + "=");
                try {
                    Object object2 = field.get(object);
                    if (object2 == null) {
                        stringBuilder.append("null");
                        continue;
                    }
                    if (bl2) {
                        stringBuilder.append(ObjectUtils.toString(object2));
                        continue;
                    }
                    stringBuilder.append(object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuilder.append("?");
                }
                catch (IllegalAccessException illegalAccessException) {
                    stringBuilder.append("?");
                }
            }
            clazz = clazz.getSuperclass();
        }
        return stringBuilder.toString();
    }
}

