/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.utils.StackUtils;

public class MultiDimensionArrayUtils {
    public static String toString(Object object) {
        if (object == null) {
            return "" + null;
        }
        if (object instanceof ExtensionObject) {
            try {
                object = ((ExtensionObject)object).decode(StackUtils.getDefaultSerializer(), EncoderContext.getDefaultInstance(), null);
            }
            catch (DecodingException decodingException) {
                // empty catch block
            }
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        if (nArray.length == 1) {
            if (object instanceof ExtensionObject[]) {
                try {
                    Object[] objectArray = (Object[])EncoderContext.getDefaultInstance().decode((ExtensionObject[])object);
                    return Arrays.toString(objectArray);
                }
                catch (DecodingException decodingException) {
                    decodingException.printStackTrace();
                }
            }
            if (object instanceof Object[]) {
                return Arrays.toString((Object[])object);
            }
            if (object instanceof double[]) {
                return Arrays.toString((double[])object);
            }
            if (object instanceof boolean[]) {
                return Arrays.toString((boolean[])object);
            }
            if (object instanceof byte[]) {
                return Arrays.toString((byte[])object);
            }
            if (object instanceof char[]) {
                return Arrays.toString((char[])object);
            }
            if (object instanceof float[]) {
                return Arrays.toString((float[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            if (object instanceof long[]) {
                return Arrays.toString((long[])object);
            }
            if (object instanceof short[]) {
                return Arrays.toString((short[])object);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray[0]; ++i) {
            stringBuilder.append(MultiDimensionArrayUtils.toString(Array.get(object, i)));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static Object clone(Object object) {
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object.getClass());
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, clazz);
        return MultiDimensionArrayUtils.demuxArray((Object)objectArray, nArray, clazz);
    }

    public static Object deepClone(Object object) {
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object.getClass());
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, clazz);
        try {
            Object[] objectArray2 = new Object[]{};
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                try {
                    if (object2 == null) continue;
                    Method method = object2.getClass().getMethod("clone", new Class[0]);
                    method.setAccessible(true);
                    objectArray[i] = method.invoke(object2, objectArray2);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        return MultiDimensionArrayUtils.demuxArray((Object)objectArray, nArray, clazz);
    }

    public static void printArrayDeep(Object object, PrintStream printStream) {
        ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(object, MultiDimensionArrayUtils.getArrayLengths(object));
        while (arrayIterator.hasNext()) {
            System.out.println(Arrays.toString(arrayIterator.getIndices()) + " = " + arrayIterator.next());
        }
    }

    public static int[] getArrayLengths(Object object) {
        int n = MultiDimensionArrayUtils.getDimension(object);
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        Object object2 = object;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] = object2 == null ? 0 : Array.getLength(object2);
            if (nArray[i] == 0) break;
            object2 = Array.get(object2, 0);
        }
        return nArray;
    }

    public static int getDimension(Object object) {
        int n;
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        for (n = 0; n < string.length() && string.charAt(n) == '['; ++n) {
        }
        return n;
    }

    public static Object[] createMultiDimArray(Class<?> clazz, int[] nArray) {
        return (Object[])Array.newInstance(clazz, nArray);
    }

    public static int getLength(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n *= nArray[i];
        }
        return n;
    }

    public static Class<?> getComponentType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2;
    }

    public static Object demuxArray(Object object, int[] nArray) {
        return MultiDimensionArrayUtils.demuxArray(object, nArray, MultiDimensionArrayUtils.getComponentType(object.getClass()));
    }

    public static Object demuxArray(Object object, int[] nArray, Class<?> clazz) {
        Object object2 = null;
        if (clazz != Byte.TYPE) {
            object2 = Array.newInstance(clazz, nArray);
        } else {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = 1;
            object2 = Array.newInstance(clazz, nArray2);
        }
        MultiDimensionArrayUtils._fillDemux(0, nArray, object, 0, object2);
        return object2;
    }

    public static void demuxArray(Object object, int[] nArray, Object object2) {
        if (Array.getLength(object) != MultiDimensionArrayUtils.getLength(nArray)) {
            throw new IllegalArgumentException("The length of src does not match the length of dst");
        }
        MultiDimensionArrayUtils._fillDemux(0, nArray, object, 0, object2);
    }

    private static int _fillDemux(int n, int[] nArray, Object object, int n2, Object object2) {
        if (n == nArray.length - 1) {
            int n3 = nArray[nArray.length - 1];
            System.arraycopy(object, n2, object2, 0, n3);
            return n2 + n3;
        }
        for (int i = 0; i < nArray[n]; ++i) {
            n2 = MultiDimensionArrayUtils._fillDemux(n + 1, nArray, object, n2, Array.get(object2, i));
        }
        return n2;
    }

    public static Object muxArray(Object object) {
        return MultiDimensionArrayUtils.muxArray(object, MultiDimensionArrayUtils.getArrayLengths(object), MultiDimensionArrayUtils.getComponentType(object.getClass()));
    }

    public static Object muxArray(Object object, int[] nArray) {
        return MultiDimensionArrayUtils.muxArray(object, nArray, MultiDimensionArrayUtils.getComponentType(object.getClass()));
    }

    public static Object muxArray(Object object, int[] nArray, Class<?> clazz) {
        int n = MultiDimensionArrayUtils.getLength(nArray);
        Object object2 = Array.newInstance(clazz, n);
        MultiDimensionArrayUtils.muxArray(object, nArray, object2);
        return object2;
    }

    public static void muxArray(Object object, int[] nArray, Object object2) {
        int n = MultiDimensionArrayUtils.getLength(nArray);
        if (Array.getLength(object2) != n) {
            throw new IllegalArgumentException("The length of src does not match the length of dst");
        }
        MultiDimensionArrayUtils._fillMux(0, nArray, object, object2, 0);
    }

    private static int _fillMux(int n, int[] nArray, Object object, Object object2, int n2) {
        if (n == nArray.length - 1) {
            int n3 = nArray[n];
            System.arraycopy(object, 0, object2, n2, n3);
            return n2 + n3;
        }
        for (int i = 0; i < nArray[n]; ++i) {
            n2 += MultiDimensionArrayUtils._fillMux(n + 1, nArray, Array.get(object, i), object2, n2);
        }
        return 0;
    }

    public static <R> ArrayIterator<R> arrayIterator(Object object, int[] nArray) {
        return new ArrayIterator(object, nArray);
    }

    public static class ArrayIterator<T>
    implements Iterator<T> {
        Object v;
        int[] dims;
        int[] indices;
        Object[] arrays;
        int lastIndex;
        int len;
        boolean hasNext = true;

        ArrayIterator(Object object, int[] nArray) {
            int n;
            this.v = object;
            this.dims = nArray;
            this.indices = new int[nArray.length];
            this.arrays = new Object[nArray.length];
            this.lastIndex = nArray.length - 1;
            for (n = 0; n <= this.lastIndex; ++n) {
                if (nArray[n] != 0) continue;
                this.hasNext = false;
            }
            this.arrays[0] = (Object[])this.v;
            for (n = 1; n < nArray.length; ++n) {
                this.arrays[n] = ((Object[])this.arrays[n - 1])[0];
            }
        }

        public int[] getIndices() {
            return this.indices;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        private void _next() {
            int n = this.lastIndex;
            while (true) {
                int n2 = n;
                this.indices[n2] = this.indices[n2] + 1;
                if (this.indices[n2] < this.dims[n]) break;
                this.indices[n] = 0;
                if (--n < 0) {
                    this.hasNext = false;
                    return;
                }
                this.arrays[n + 1] = ((Object[])this.arrays[n])[this.indices[n]];
            }
            if (n < this.lastIndex) {
                for (int i = n + 1; i <= this.lastIndex; ++i) {
                    this.arrays[i] = ((Object[])this.arrays[i - 1])[this.indices[i - 1]];
                }
            }
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Object object = Array.get(Array.get(this.arrays, this.lastIndex), this.indices[this.lastIndex]);
            this._next();
            return (T)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove array element");
        }
    }
}

