/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class IncubationQueue<T> {
    Map<T, T> hatchMap;
    LinkedList<T> orderList = new LinkedList();

    public IncubationQueue() {
        this(false);
    }

    public IncubationQueue(boolean bl) {
        this.hatchMap = bl ? new IdentityHashMap() : new HashMap();
    }

    public synchronized void incubate(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.hatchMap.containsKey(t)) {
            throw new IllegalArgumentException(t + " is already incubating");
        }
        this.hatchMap.put(t, t);
        this.orderList.addLast(t);
        this.notifyAll();
    }

    public synchronized boolean hatch(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (!this.hatchMap.containsKey(t)) {
            throw new IllegalArgumentException(t + " is not incubating");
        }
        T t2 = this.hatchMap.get(t);
        this.hatchMap.put(t2, null);
        this.notifyAll();
        return t2 != null;
    }

    public synchronized T removeNextHatchedIfAvailable() {
        T t = this.getNextHatchedIfAvailable();
        if (t == null) {
            return null;
        }
        this.orderList.removeFirst();
        this.hatchMap.remove(t);
        this.notifyAll();
        return t;
    }

    public synchronized T removeNextHatched() throws InterruptedException {
        T t = this.getNextHatched();
        this.orderList.removeFirst();
        this.hatchMap.remove(t);
        this.notifyAll();
        return t;
    }

    public synchronized T removeNextHatchedUninterruptibly() {
        while (true) {
            try {
                return this.removeNextHatched();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized boolean nextIsHatched() {
        if (this.orderList.isEmpty()) {
            return false;
        }
        T t = this.orderList.getFirst();
        return this.hatchMap.get(t) == null;
    }

    public synchronized T getNextHatchedIfAvailable() {
        if (this.orderList.isEmpty()) {
            return null;
        }
        T t = this.orderList.getFirst();
        if (this.hatchMap.get(t) != null) {
            return null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNextHatched() throws InterruptedException {
        while (true) {
            T t = this.getNext();
            this.waitUntilIncubated(t);
            IncubationQueue incubationQueue = this;
            synchronized (incubationQueue) {
                if (this.orderList.getFirst() == t) {
                    return t;
                }
            }
        }
    }

    public synchronized T getNext() throws InterruptedException {
        while (this.orderList.isEmpty()) {
            this.wait();
        }
        return this.orderList.getFirst();
    }

    public synchronized boolean isEmpty() {
        return this.hatchMap.isEmpty();
    }

    public synchronized void clear() {
        this.orderList.clear();
        this.hatchMap.clear();
        this.notifyAll();
    }

    public synchronized int size() {
        return this.hatchMap.size();
    }

    public Iterator<T> iterator() {
        return this.orderList.iterator();
    }

    public synchronized boolean contains(T t) {
        return this.hatchMap.containsKey(t);
    }

    public synchronized boolean isHatched(T t) {
        if (!this.hatchMap.containsKey(t)) {
            return false;
        }
        return this.hatchMap.get(t) == null;
    }

    public synchronized boolean isIncubating(T t) {
        if (!this.hatchMap.containsKey(t)) {
            return false;
        }
        return this.hatchMap.get(t) != null;
    }

    public synchronized void waitUntilIncubated(T t) throws InterruptedException {
        while (this.isIncubating(t)) {
            this.wait();
        }
    }
}

