/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.BcCryptoProvider;
import org.opcfoundation.ua.transport.security.CryptoProvider;
import org.opcfoundation.ua.transport.security.ScCryptoProvider;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SunJceCryptoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    static Logger LOGGER = LoggerFactory.getLogger(CryptoUtil.class);
    private static final SecureRandom random;
    private static final char[] HEX_CHARS;
    private static CryptoProvider cryptoProvider;
    private static String securityProviderName;

    @Deprecated
    public static byte[] asymmEncrypt(byte[] byArray, Key key, SecurityAlgorithm securityAlgorithm) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ServiceResultException, NoSuchAlgorithmException, NoSuchPaddingException {
        return CryptoUtil.encryptAsymm(byArray, (PublicKey)key, securityAlgorithm);
    }

    public static byte[] base64Decode(String string) {
        return CryptoUtil.getCryptoProvider().base64Decode(string);
    }

    public static String base64Encode(byte[] byArray) {
        return CryptoUtil.getCryptoProvider().base64Encode(byArray);
    }

    public static Mac createMac(SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        return CryptoUtil.getCryptoProvider().createMac(securityAlgorithm, byArray);
    }

    public static byte[] createNonce(int n) {
        LOGGER.debug("createNonce: bytes={}", (Object)n);
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        return byArray;
    }

    public static byte[] createNonce(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        return CryptoUtil.createNonce(CryptoUtil.getNonceLength(securityAlgorithm));
    }

    public static void decryptAsymm(PrivateKey privateKey, SecurityConfiguration securityConfiguration, byte[] byArray, byte[] byArray2, int n) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().decryptAsymm(privateKey, securityConfiguration.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n);
    }

    public static byte[] encryptAsymm(byte[] byArray, PublicKey publicKey, SecurityAlgorithm securityAlgorithm) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ServiceResultException, NoSuchAlgorithmException, NoSuchPaddingException {
        int n = CryptoUtil.getCipherBlockSize(securityAlgorithm, publicKey);
        byte[] byArray2 = new byte[n];
        CryptoUtil.getCryptoProvider().encryptAsymm(publicKey, securityAlgorithm, byArray, byArray2, 0);
        return byArray2;
    }

    public static void encryptAsymm(Certificate certificate, SecurityConfiguration securityConfiguration, byte[] byArray, byte[] byArray2, int n) throws ServiceResultException {
        LOGGER.info("encryptAsymm called.");
        CryptoUtil.getCryptoProvider().encryptAsymm(certificate.getPublicKey(), securityConfiguration.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n);
    }

    public static String[] filterCipherSuiteList(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Pattern[] patternArray = new Pattern[stringArray2.length];
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            patternArray[i] = Pattern.compile(stringArray2[i]);
        }
        block1: for (String string : stringArray) {
            for (Pattern pattern : patternArray) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                arrayList.add(string);
                continue block1;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Cipher getAsymmetricCipher(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        if (securityAlgorithm == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
                return Cipher.getInstance("RSA");
            }
            if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
                return Cipher.getInstance("RSA/NONE/OAEPWithSHA1AndMGF1Padding", CryptoUtil.getSecurityProviderName());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchPaddingException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchProviderException);
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported asymmetric signature algorithm: " + (Object)((Object)securityAlgorithm));
    }

    public static int getAsymmInputBlockSize(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
            return 117;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
            return 86;
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported asymmetric signature algorithm: {0}, " + (Object)((Object)securityAlgorithm));
    }

    public static int getCipherBlockSize(SecurityAlgorithm securityAlgorithm, Key key) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 1;
        }
        SecurityAlgorithm.AlgorithmType algorithmType = securityAlgorithm.getType();
        if (algorithmType.equals((Object)SecurityAlgorithm.AlgorithmType.SymmetricEncryption)) {
            return 16;
        }
        if (algorithmType.equals((Object)SecurityAlgorithm.AlgorithmType.AsymmetricSignature)) {
            return securityAlgorithm.getKeySize() / 8;
        }
        if (algorithmType.equals((Object)SecurityAlgorithm.AlgorithmType.AsymmetricEncryption)) {
            if (key instanceof RSAPublicKey) {
                return ((RSAPublicKey)key).getModulus().bitLength() / 8;
            }
            if (key instanceof RSAPrivateKey) {
                return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
            }
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static String[] getCipherSuiteIntersection(String[] stringArray, String[] stringArray2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(Math.max(stringArray.length, stringArray2.length));
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : stringArray2) {
            treeSet.add(bl ? string.substring(3) : string);
        }
        for (String string : stringArray) {
            if (!treeSet.contains(bl ? string.substring(3) : string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static CryptoProvider getCryptoProvider() {
        if (cryptoProvider == null) {
            if ("SC".equals(CryptoUtil.getSecurityProviderName())) {
                cryptoProvider = new ScCryptoProvider();
            } else if ("BC".equals(CryptoUtil.getSecurityProviderName())) {
                cryptoProvider = new BcCryptoProvider();
            } else if ("SunJCE".equals(CryptoUtil.getSecurityProviderName())) {
                cryptoProvider = new SunJceCryptoProvider();
            } else {
                throw new RuntimeException("NO CRYPTO PROVIDER AVAILABLE!");
            }
        }
        return cryptoProvider;
    }

    public static int getNonceLength(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 0;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
            return 32;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
            return 32;
        }
        if (SecurityAlgorithm.AlgorithmType.SymmetricEncryption == securityAlgorithm.getType()) {
            return securityAlgorithm.getKeySize() / 8;
        }
        LOGGER.error("getNonceLength: Unsupported algorithm={}", (Object)securityAlgorithm);
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static int getPlainTextBlockSize(SecurityAlgorithm securityAlgorithm, Key key) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 1;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15) && key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength() / 8 - 11;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep) && key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength() / 8 - 42;
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static SecureRandom getRandom() {
        return random;
    }

    public static String getSecurityProviderName() {
        if (securityProviderName == null) {
            boolean bl;
            Provider provider = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Providers={}", (Object)Arrays.toString(Security.getProviders()));
            }
            if (bl = System.getProperty("java.runtime.name").toLowerCase().contains("android")) {
                if (Security.getProvider("SC") != null) {
                    securityProviderName = "SC";
                } else {
                    provider = CryptoUtil.hasClass("org.spongycastle.jce.provider.BouncyCastleProvider");
                    if (provider != null) {
                        securityProviderName = "SC";
                    }
                }
            } else if (Security.getProvider("BC") != null) {
                securityProviderName = "BC";
            } else {
                if (provider == null && (provider = CryptoUtil.hasClass("org.bouncycastle.jce.provider.BouncyCastleProvider")) != null) {
                    securityProviderName = "BC";
                }
                if (provider == null) {
                    provider = CryptoUtil.hasClass("com.sun.crypto.provider.SunJCE");
                }
                if (provider == null) {
                    Provider[] providerArray = Security.getProviders();
                    if (providerArray == null || providerArray.length == 0) {
                        throw new RuntimeException("No security providers available!");
                    }
                    provider = providerArray[0];
                }
                if (provider != null) {
                    securityProviderName = provider.getName();
                }
            }
            if (securityProviderName != null) {
                LOGGER.info("Using SecurityProvider {}", (Object)securityProviderName);
            } else {
                throw new RuntimeException("NO SECURITY PROVIDER AVAILABLE!");
            }
        }
        return securityProviderName;
    }

    public static String getSecurityProviderName(Class<?> clazz) {
        if ("SunJCE".equals(CryptoUtil.getSecurityProviderName())) {
            if (Signature.class.equals(clazz)) {
                return "SunRsaSign";
            }
            if (KeyStore.class.equals(clazz)) {
                return "SunJSSE";
            }
        }
        return CryptoUtil.getSecurityProviderName();
    }

    public static int getSignatureSize(SecurityAlgorithm securityAlgorithm, Key key) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 0;
        }
        if (securityAlgorithm.getType().equals((Object)SecurityAlgorithm.AlgorithmType.SymmetricSignature)) {
            return securityAlgorithm.getKeySize() / 8;
        }
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength() / 8;
        }
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaSha1)) {
            if (key instanceof RSAPublicKey) {
                return ((RSAPublicKey)key).getModulus().bitLength() / 8;
            }
            if (key instanceof RSAPrivateKey) {
                return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
            }
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaSha256)) {
            if (key instanceof RSAPublicKey) {
                return ((RSAPublicKey)key).getModulus().bitLength() / 8;
            }
            if (key instanceof RSAPrivateKey) {
                return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
            }
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static byte[] hexToBytes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static void setCryptoProvider(CryptoProvider cryptoProvider) {
        CryptoUtil.cryptoProvider = cryptoProvider;
    }

    public static void setSecurityProviderName(String string) {
        securityProviderName = string;
    }

    public static SignatureData signAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return new SignatureData(null, null);
        }
        return new SignatureData(securityAlgorithm.getUri(), CryptoUtil.getCryptoProvider().signAsymm(privateKey, securityAlgorithm, byArray));
    }

    public static String toHex(byte[] byArray) {
        return CryptoUtil.toHex(byArray, byArray != null && byArray.length > 64 ? 64 : 0);
    }

    public static String toHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + byArray.length + "] 0x");
        for (int i = 0; i < byArray.length; ++i) {
            if (n > 0 && i % n == 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(HEX_CHARS[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(HEX_CHARS[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static boolean verifyAsymm(X509Certificate x509Certificate, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        return CryptoUtil.getCryptoProvider().verifyAsymm(x509Certificate.getPublicKey(), securityAlgorithm, byArray, byArray2);
    }

    private static Provider hasClass(String string) {
        try {
            Class<?> clazz = CryptoUtil.class.getClassLoader().loadClass(string);
            try {
                Provider provider = (Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(provider);
                LOGGER.info("SecurityProvider initialized from {}", (Object)clazz.getName());
                return provider;
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot add Security provider class=" + clazz.getName(), exception);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static {
        try {
            LOGGER.debug("CryptoUtil init");
            random = SecureRandom.getInstance("SHA1PRNG");
            LOGGER.debug("CryptoUtil init: random={}", (Object)random);
            random.setSeed(System.currentTimeMillis());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        HEX_CHARS = "0123456789abcdef".toCharArray();
    }
}

