/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BijectionMap<L, R> {
    private Map<L, R> tableLeft = new HashMap<L, R>();
    private Map<R, L> tableRight = new HashMap<R, L>();

    public void addAll(BijectionMap<L, R> bijectionMap) {
        for (Map.Entry<L, R> entry : bijectionMap.getEntries()) {
            this.map(entry.getKey(), entry.getValue());
        }
    }

    public boolean retainAllLeft(Collection<L> collection) {
        boolean bl = false;
        for (L l : collection) {
            if (this.tableLeft.containsKey(l)) continue;
            this.removeWithLeft(l);
            bl = true;
        }
        return bl;
    }

    public boolean retainAllRight(Collection<R> collection) {
        boolean bl = false;
        for (R r : collection) {
            if (this.tableRight.containsKey(r)) continue;
            this.removeWithRight(r);
            bl = true;
        }
        return bl;
    }

    public Set<Map.Entry<L, R>> getEntries() {
        return this.tableLeft.entrySet();
    }

    public boolean containsLeft(L l) {
        return this.tableLeft.containsKey(l);
    }

    public boolean containsRight(R r) {
        return this.tableRight.containsKey(r);
    }

    public boolean contains(L l, R r) {
        if (l == r) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        R r2 = this.tableLeft.get(l);
        if (r2 == r) {
            return true;
        }
        return this.tableLeft.get(l).equals(r2);
    }

    public void map(L l, R r) {
        R r2 = this.tableLeft.remove(l);
        if (r2 != null) {
            this.tableRight.remove(r2);
        } else {
            L l2 = this.tableRight.remove(r);
            if (l2 != null) {
                this.tableLeft.remove(l2);
            }
        }
        this.tableLeft.put(l, r);
        this.tableRight.put(r, l);
    }

    public boolean isEmpty() {
        return this.tableLeft.isEmpty();
    }

    public int size() {
        return this.tableLeft.size();
    }

    public L getLeft(R r) {
        return this.tableRight.get(r);
    }

    public R getRight(L l) {
        return this.tableLeft.get(l);
    }

    public R removeWithLeft(L l) {
        R r = this.tableLeft.remove(l);
        if (r != null) {
            this.tableRight.remove(r);
        }
        return r;
    }

    public L removeWithRight(R r) {
        L l = this.tableRight.remove(r);
        if (l != null) {
            this.tableLeft.remove(l);
        }
        return l;
    }

    public Set<L> getLeftSet() {
        return Collections.unmodifiableSet(this.tableLeft.keySet());
    }

    public Set<R> getRightSet() {
        return Collections.unmodifiableSet(this.tableRight.keySet());
    }

    public void clear() {
        this.tableLeft.clear();
        this.tableRight.clear();
    }

    public String toString() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Map.Entry<L, R> entry : this.tableLeft.entrySet()) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

